/*
 * Decompiled with CFR 0.152.
 */
package techguns.packets;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import techguns.TGPackets;
import techguns.packets.HandlerTemplate;
import techguns.tileentities.BasicInventoryTileEnt;

public class PacketGuiButtonClick
implements IMessage {
    private int x;
    private int y;
    private int z;
    private int buttonId;
    private String data;

    public PacketGuiButtonClick() {
    }

    public PacketGuiButtonClick(BasicInventoryTileEnt tileEnt, int buttonId) {
        this(tileEnt, buttonId, null);
    }

    public PacketGuiButtonClick(BasicInventoryTileEnt tileEnt, int buttonId, String data) {
        this.x = tileEnt.func_174877_v().func_177958_n();
        this.y = tileEnt.func_174877_v().func_177956_o();
        this.z = tileEnt.func_174877_v().func_177952_p();
        this.buttonId = buttonId;
        this.data = data;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.buttonId = buf.readInt();
        short len = buf.readShort();
        this.data = len > 0 ? buf.readCharSequence((int)len, StandardCharsets.UTF_8).toString() : null;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.buttonId);
        if (this.data == null) {
            buf.writeShort(0);
        } else {
            buf.writeShort(this.data.length());
            buf.writeCharSequence((CharSequence)this.data, StandardCharsets.UTF_8);
        }
    }

    public static class Handler
    extends HandlerTemplate<PacketGuiButtonClick> {
        @Override
        protected void handle(PacketGuiButtonClick message, MessageContext ctx) {
            BasicInventoryTileEnt tileent;
            EntityPlayer ply = TGPackets.getPlayerFromContext(ctx);
            TileEntity tile = ply.field_70170_p.func_175625_s(new BlockPos(message.x, message.y, message.z));
            if (tile != null && tile instanceof BasicInventoryTileEnt && (tileent = (BasicInventoryTileEnt)tile).isUseableByPlayer(ply)) {
                tileent.buttonClicked(message.buttonId, ply, message.data);
            }
        }
    }
}

