/*
 * Decompiled with CFR 0.152.
 */
package techguns.packets;

import io.netty.buffer.ByteBuf;
import java.util.BitSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import techguns.TGPackets;
import techguns.capabilities.TGExtendedPlayer;
import techguns.util.DataUtil;

public class PacketTGExtendedPlayerSync
implements IMessage {
    public int entityId;
    public NonNullList<ItemStack> inv = NonNullList.func_191197_a((int)15, (Object)ItemStack.field_190927_a);
    public int radlevel;
    public short foodLeft = 0;
    public boolean nightVisionEnabled = false;
    public boolean safemodeEnabled = true;
    public float lastSaturation = 0.0f;
    public boolean hovermodeEnabled = false;
    public byte size;
    public boolean stepAssist;
    public boolean showHUD;
    public boolean enableJetpack;
    private boolean allSlots = false;

    public PacketTGExtendedPlayerSync() {
    }

    public PacketTGExtendedPlayerSync(EntityPlayer ply, TGExtendedPlayer props, boolean allSlots) {
        this.entityId = ply.func_145782_y();
        this.nightVisionEnabled = props.enableNightVision;
        this.safemodeEnabled = props.enableSafemode;
        this.hovermodeEnabled = props.enableHovermode;
        this.inv = props.tg_inventory.inventory;
        if (allSlots) {
            this.radlevel = props.radlevel;
            this.foodLeft = props.foodleft;
            this.lastSaturation = props.lastSaturation;
            this.stepAssist = props.enableStepAssist;
            this.showHUD = props.showTGHudElements;
            this.enableJetpack = props.enableJetpack;
        }
        this.allSlots = allSlots;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = buf.readInt();
        byte dat = buf.readByte();
        BitSet states = DataUtil.uncompress(dat);
        this.enableJetpack = states.get(0);
        this.nightVisionEnabled = states.get(1);
        this.safemodeEnabled = states.get(2);
        this.stepAssist = states.get(3);
        this.showHUD = states.get(4);
        this.hovermodeEnabled = states.get(5);
        this.allSlots = buf.readBoolean();
        if (this.allSlots) {
            this.radlevel = buf.readInt();
            this.foodLeft = buf.readShort();
            this.lastSaturation = buf.readFloat();
            NBTTagCompound tags = DataUtil.readCompoundTag(buf);
            if (tags != null) {
                this.inv.clear();
                ItemStackHelper.func_191283_b((NBTTagCompound)tags, this.inv);
            }
        } else {
            this.inv.set(0, (Object)DataUtil.readItemStack(buf));
            this.inv.set(1, (Object)DataUtil.readItemStack(buf));
            this.inv.set(2, (Object)DataUtil.readItemStack(buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityId);
        byte states = DataUtil.compress(this.enableJetpack, this.nightVisionEnabled, this.safemodeEnabled, this.stepAssist, this.showHUD, this.hovermodeEnabled);
        buf.writeByte((int)states);
        buf.writeBoolean(this.allSlots);
        if (this.allSlots) {
            buf.writeInt(this.radlevel);
            buf.writeShort((int)this.foodLeft);
            buf.writeFloat(this.lastSaturation);
            NBTTagCompound tags = new NBTTagCompound();
            ItemStackHelper.func_191281_a((NBTTagCompound)tags, this.inv, (boolean)false);
            DataUtil.writeCompoundTag(buf, tags);
        } else {
            DataUtil.writeItemStack(buf, (ItemStack)this.inv.get(0));
            DataUtil.writeItemStack(buf, (ItemStack)this.inv.get(1));
            DataUtil.writeItemStack(buf, (ItemStack)this.inv.get(2));
        }
    }

    public static class Handler
    implements IMessageHandler<PacketTGExtendedPlayerSync, IMessage> {
        public IMessage onMessage(PacketTGExtendedPlayerSync message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketTGExtendedPlayerSync message, MessageContext ctx) {
            EntityPlayer local_ply = TGPackets.getPlayerFromContext(ctx);
            Entity ent = local_ply.field_70170_p.func_73045_a(message.entityId);
            if (ent != null && ent instanceof EntityPlayer) {
                EntityPlayer ply = (EntityPlayer)ent;
                TGExtendedPlayer props = TGExtendedPlayer.get(ply);
                props.radlevel = message.radlevel;
                props.lastSaturation = message.lastSaturation;
                props.foodleft = message.foodLeft;
                props.enableNightVision = message.nightVisionEnabled;
                props.enableSafemode = message.safemodeEnabled;
                props.enableHovermode = message.hovermodeEnabled;
                props.enableStepAssist = message.stepAssist;
                props.showTGHudElements = message.showHUD;
                props.enableJetpack = message.enableJetpack;
                int max = message.allSlots ? message.inv.size() : 3;
                for (int i = 0; i < max; ++i) {
                    props.tg_inventory.inventory.set(i, message.inv.get(i));
                }
            }
        }
    }
}

