/*
 * Decompiled with CFR 0.152.
 */
package techguns.packets;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import techguns.TGPackets;
import techguns.client.ShooterValues;

public class ReloadStartedMessage
implements IMessage {
    protected int entityID;
    protected int time;
    protected byte attackType;
    protected boolean offHand;

    public ReloadStartedMessage() {
    }

    public ReloadStartedMessage(EntityLivingBase shooter, EnumHand hand, int firetime, int attackType) {
        this.entityID = shooter.func_145782_y();
        this.time = firetime;
        this.attackType = (byte)attackType;
        this.offHand = hand == EnumHand.OFF_HAND;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityID = buf.readInt();
        this.time = buf.readInt();
        this.attackType = buf.readByte();
        this.offHand = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityID);
        buf.writeInt(this.time);
        buf.writeByte((int)this.attackType);
        buf.writeBoolean(this.offHand);
    }

    public static class Handler
    implements IMessageHandler<ReloadStartedMessage, IMessage> {
        public IMessage onMessage(ReloadStartedMessage message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(ReloadStartedMessage message, MessageContext ctx) {
            EntityPlayer ply = TGPackets.getPlayerFromContext(ctx);
            EntityLivingBase shooter = (EntityLivingBase)ply.field_70170_p.func_73045_a(message.entityID);
            if (shooter != null && shooter != Minecraft.func_71410_x().field_71439_g) {
                ShooterValues.setReloadtime(shooter, message.offHand, System.currentTimeMillis() + (long)message.time, message.time, message.attackType);
            }
        }
    }
}

