/*
 * Decompiled with CFR 0.152.
 */
package techguns.plugins.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import techguns.tileentities.operation.ChargingStationRecipe;
import techguns.util.ItemStackOreDict;

@ZenClass(value="mods.techguns.ChargingStation")
public class ChargingStationTweaker {
    private ChargingStationTweaker() {
    }

    @ZenMethod
    public static void addRecipe(IItemStack input, IItemStack output, int RFAmount) {
        CraftTweakerAPI.apply((IAction)new addInputAction(new ItemStackOreDict(CraftTweakerMC.getItemStack((IItemStack)input)), CraftTweakerMC.getItemStack((IItemStack)output), RFAmount));
    }

    @ZenMethod
    public static void addRecipe(String input, IItemStack output, int RFAmount) {
        CraftTweakerAPI.apply((IAction)new addInputAction(new ItemStackOreDict(input), CraftTweakerMC.getItemStack((IItemStack)output), RFAmount));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack input) {
        CraftTweakerAPI.apply((IAction)new removeInputAction(new ItemStackOreDict(CraftTweakerMC.getItemStack((IItemStack)input))));
    }

    @ZenMethod
    public static void removeRecipe(String input) {
        CraftTweakerAPI.apply((IAction)new removeInputAction(new ItemStackOreDict(input)));
    }

    private static class removeInputAction
    implements IAction {
        ItemStackOreDict input;

        public removeInputAction(ItemStackOreDict input) {
            this.input = input;
        }

        public void apply() {
            ArrayList<ChargingStationRecipe> recipes = ChargingStationRecipe.getRecipes();
            Iterator<ChargingStationRecipe> iter = recipes.iterator();
            while (iter.hasNext()) {
                ChargingStationRecipe rec = iter.next();
                if (!rec.input.matches(this.input)) continue;
                iter.remove();
            }
        }

        public String describe() {
            return "Remove " + this.input + " from ChargingStation.";
        }
    }

    private static class addInputAction
    implements IAction {
        ChargingStationRecipe added_recipe = null;
        ItemStackOreDict input;
        ItemStack output;
        int rf;

        public addInputAction(ItemStackOreDict input, ItemStack output, int RFAmount) {
            this.input = input;
            this.output = output;
            this.rf = RFAmount;
        }

        public void apply() {
            this.added_recipe = ChargingStationRecipe.addRecipe(this.input, this.output, this.rf);
        }

        public String describe() {
            return "Add " + this.input + " to ChargingStation";
        }
    }
}

