/*
 * Decompiled with CFR 0.152.
 */
package techguns.plugins.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import net.minecraft.entity.EntityLivingBase;
import techguns.deatheffects.EntityDeathUtils;

public class DeathEffectTweaker {
    public static void addEntity(String classname) {
        CraftTweakerAPI.apply((IAction)new addDeathEffect(classname));
    }

    public static void addEntityQuadruped(String classname, String modelname, int r, int g, int b) {
        CraftTweakerAPI.apply((IAction)new addGoreQuadrupedEffect(classname, modelname, r, g, b));
        CraftTweakerAPI.apply((IAction)new addDeathEffect(classname));
    }

    private static class addDeathEffect
    implements IAction {
        Class<? extends EntityLivingBase> clazz;
        Exception e = null;

        public addDeathEffect(String entity) {
            try {
                Class<?> c = Class.forName(entity);
                if (EntityLivingBase.class.isAssignableFrom(c)) {
                    this.clazz = c;
                } else {
                    this.e = new IllegalArgumentException("passed entity class must be subclass of EntityLivingBase");
                }
            }
            catch (Exception ex) {
                this.e = ex;
            }
        }

        public void apply() {
            if (this.e == null && this.clazz != null) {
                EntityDeathUtils.addEntityToDeathEffectList(this.clazz);
            }
        }

        public String describe() {
            if (this.e != null) {
                return "Can't add class to Entity Death Effects: " + this.e.getMessage();
            }
            return "Added class: " + this.clazz.getName() + " to Entity Death Effects";
        }
    }

    protected static class addGoreQuadrupedEffect
    implements IAction {
        protected String classname = null;
        protected String modelname = null;
        protected int r = 0;
        protected int g = 0;
        protected int b = 0;
        protected boolean success = false;

        public addGoreQuadrupedEffect(String classname, String modelname, int r, int g, int b) {
            this.classname = classname;
            this.modelname = modelname;
            this.r = r;
            this.g = g;
            this.b = b;
        }

        public void apply() {
        }

        public String describe() {
            return "Trying to add " + this.classname + " with model " + this.modelname + " to GoreData: " + (this.success ? "SUCCESS" : "FAILED");
        }
    }
}

