/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities;

import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import techguns.Techguns;
import techguns.api.machines.ITGTileEntSecurity;
import techguns.factions.TGNpcFactions;
import techguns.tileentities.BasicInventoryTileEnt;

public class BasicOwnedTileEnt
extends BasicInventoryTileEnt
implements ITGTileEntSecurity {
    protected byte security = 0;
    protected UUID owner;

    public BasicOwnedTileEnt(int inventorySize, boolean hasRotation) {
        super(inventorySize, hasRotation);
    }

    @Override
    public void setOwner(EntityPlayer ply) {
        UUID id = ply.func_146103_bH().getId();
        if (id != null) {
            this.owner = id;
            this.security = 0;
        }
    }

    @Override
    public boolean isOwnedByPlayer(EntityPlayer ply) {
        if (this.owner == null) {
            return false;
        }
        return this.owner.equals(ply.func_146103_bH().getId());
    }

    @Override
    public UUID getOwner() {
        return this.owner;
    }

    @Override
    public byte getSecurity() {
        return this.security;
    }

    @Override
    public void readClientDataFromNBT(NBTTagCompound tags) {
        super.readClientDataFromNBT(tags);
        this.security = tags.func_74771_c("security");
        String own = tags.func_74779_i("owner");
        if (own != null && !own.equals("")) {
            try {
                this.owner = UUID.fromString(own);
            }
            catch (IllegalArgumentException e) {
                this.owner = null;
            }
        }
    }

    @Override
    public void writeClientDataToNBT(NBTTagCompound tags) {
        super.writeClientDataToNBT(tags);
        if (this.owner != null) {
            tags.func_74774_a("security", this.security);
            tags.func_74778_a("owner", this.owner.toString());
        }
    }

    @Override
    public void writeNBTforDismantling(NBTTagCompound compound) {
        super.writeNBTforDismantling(compound);
        compound.func_82580_o("owner");
    }

    @Override
    public void buttonClicked(int id, EntityPlayer ply, String data) {
        if (id == 1 && this.isOwnedByPlayer(ply)) {
            if (Techguns.instance.FTBLIB_ENABLED) {
                this.security = (byte)(this.security + 1);
                this.security = (byte)(this.security % 4);
            } else {
                this.security = this.security == 0 ? (byte)3 : (byte)0;
            }
            if (!this.field_145850_b.field_72995_K) {
                this.needUpdate();
            }
        } else {
            super.buttonClicked(id, ply, data);
        }
    }

    @Override
    public boolean isUseableByPlayer(EntityPlayer player) {
        if (super.isUseableByPlayer(player)) {
            if (this.owner == null || this.security == 0) {
                return true;
            }
            if (this.isOwnedByPlayer(player)) {
                return true;
            }
            return TGNpcFactions.canAccess(this.owner, player.func_146103_bH().getId(), this.security);
        }
        return false;
    }

    public void setSecurity(byte security) {
        this.security = security;
    }
}

