/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities;

import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import techguns.TGBlocks;
import techguns.TGItems;
import techguns.TGSounds;
import techguns.Techguns;
import techguns.blocks.machines.SimpleMachine;
import techguns.tileentities.BasicMachineTileEnt;
import techguns.tileentities.operation.ChargingStationRecipe;
import techguns.tileentities.operation.ItemStackHandlerPlus;
import techguns.tileentities.operation.MachineOperation;
import techguns.tileentities.operation.MachineSlotItem;

public class ChargingStationTileEnt
extends BasicMachineTileEnt {
    protected static final float SOUND_VOLUME = 0.35f;
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_OUTPUT = 1;
    public static final int SLOT_UPGRADE = 2;
    protected int lastsound = 0;
    MachineSlotItem input = new MachineSlotItem(this, 0);
    public static final int CHARGERATE = 800;
    public static final int ITEMCHARGERATE = 1600;
    public boolean charging = false;

    public ChargingStationTileEnt() {
        super(3, false, 100000);
        this.inventory = new ItemStackHandlerPlus(3){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                ChargingStationTileEnt.this.setContentsChanged(true);
            }

            @Override
            protected boolean allowItemInSlot(int slot, ItemStack stack) {
                switch (slot) {
                    case 0: {
                        return ChargingStationTileEnt.this.isItemValidForSlot(slot, stack);
                    }
                    case 1: {
                        return false;
                    }
                    case 2: {
                        return TGItems.isMachineUpgrade(stack);
                    }
                }
                return false;
            }

            @Override
            protected boolean allowExtractFromSlot(int slot, int amount) {
                return slot == 1;
            }
        };
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation("techguns.container.chargingstation", new Object[0]);
    }

    public boolean isItemValidForSlot(int slot, ItemStack item) {
        return slot == this.getValidSlotForItemInMachine(item);
    }

    public int getValidSlotForItemInMachine(ItemStack item) {
        if (TGItems.isMachineUpgrade(item)) {
            return 2;
        }
        if (!item.func_190926_b() && item.hasCapability(CapabilityEnergy.ENERGY, null)) {
            return 0;
        }
        if (ChargingStationRecipe.getRecipeFor(item) != null) {
            return 0;
        }
        return -1;
    }

    @Override
    protected int getNeededPower() {
        if (this.currentOperation != null) {
            return this.currentOperation.getPowerPerTick();
        }
        return 0;
    }

    @Override
    protected void checkAndStartOperation() {
        ChargingStationRecipe rec;
        this.contentsChanged = false;
        if (!this.input.get().func_190926_b() && (rec = ChargingStationRecipe.getRecipeFor(this.input.get())) != null) {
            int stackMultiplier = this.getMaxMachineUpgradeMultiplier(2);
            stackMultiplier = Math.min(stackMultiplier, this.input.get().func_190916_E() / rec.input.stackSize);
            if ((stackMultiplier = this.getMaxOutputAmount(rec.output, stackMultiplier)) > 0) {
                ItemStack input = this.input.get().func_77946_l();
                input.func_190920_e(rec.input.stackSize);
                MachineOperation op = new MachineOperation(rec.output.func_77946_l(), input);
                op.setStackMultiplier(stackMultiplier);
                op.setPowerPerTick(this.getChargeRate());
                this.input.consume(rec.input.stackSize * stackMultiplier);
                this.currentOperation = op;
                this.totaltime = (int)((double)rec.chargeAmount / (double)this.getChargeRate());
                this.progress = 0;
                if (!this.field_145850_b.field_72995_K) {
                    this.needUpdate();
                }
            }
        }
    }

    protected int getChargeRate() {
        return 800;
    }

    protected int getItemChargeRate() {
        return 1600;
    }

    protected int getMaxOutputAmount(ItemStack item, int maxMulti) {
        if (this.inventory.getStackInSlot(1).func_190926_b()) {
            return Math.min(item.func_77976_d(), item.func_190916_E() * maxMulti);
        }
        if (this.inventory.getStackInSlot(1).func_77973_b() == item.func_77973_b() && this.inventory.getStackInSlot(1).func_77952_i() == item.func_77952_i()) {
            int multi;
            for (multi = maxMulti; multi > 0 && this.inventory.getStackInSlot(1).func_190916_E() + item.func_190916_E() * multi > this.inventory.getStackInSlot(1).func_77976_d(); --multi) {
            }
            return multi;
        }
        return 0;
    }

    @Override
    protected void finishedOperation() {
        if (this.inventory.getStackInSlot(1).func_190926_b()) {
            this.inventory.setStackInSlot(1, this.currentOperation.getItemOutput0());
        } else {
            this.inventory.insertItemNoCheck(1, this.currentOperation.getItemOutput0(), false);
        }
    }

    @Override
    protected void playAmbientSound() {
        if (this.field_145850_b.field_72995_K) {
            EntityPlayer ply = Techguns.proxy.getPlayerClient();
            Double distSq = this.func_145835_a(ply.field_70165_t, ply.field_70163_u, ply.field_70161_v);
            if (distSq < 100.0) {
                int blockrot = ((EnumFacing)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((IProperty)SimpleMachine.FACING)).func_176736_b();
                if (blockrot != 2) {
                    Techguns.proxy.createFX("ChargeFlare2", this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.3, 0.0, 0.0, 0.0);
                }
                if (blockrot != 0) {
                    Techguns.proxy.createFX("ChargeFlare2", this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.7, 0.0, 0.0, 0.0);
                }
                if (blockrot != 1) {
                    Techguns.proxy.createFX("ChargeFlare2", this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.3, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, 0.0, 0.0, 0.0);
                }
                if (blockrot != 3) {
                    Techguns.proxy.createFX("ChargeFlare2", this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.7, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, 0.0, 0.0, 0.0);
                }
            }
            if (this.lastsound > 0) {
                --this.lastsound;
            }
            if (this.lastsound <= 0) {
                this.lastsound = 20;
                this.field_145850_b.func_184134_a((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), TGSounds.CHARGING_STATION_WORK, SoundCategory.BLOCKS, 0.35f, 1.0f, false);
            }
        }
    }

    @Override
    public void readClientDataFromNBT(NBTTagCompound tags) {
        super.readClientDataFromNBT(tags);
        this.charging = tags.func_74767_n("charging");
    }

    @Override
    public void writeClientDataToNBT(NBTTagCompound tags) {
        super.writeClientDataToNBT(tags);
        tags.func_74757_a("charging", this.charging);
    }

    @Override
    public void func_73660_a() {
        if (this.isRedstoneEnabled()) {
            if (this.currentOperation != null) {
                if (this.consumePower(this.currentOperation.getPowerPerTick())) {
                    ++this.progress;
                    this.playAmbientSound();
                    if (!this.field_145850_b.field_72995_K && this.progress >= this.totaltime) {
                        this.finishedOperation();
                        this.progress = 0;
                        this.totaltime = 0;
                        this.currentOperation = null;
                        this.checkAndStartOperation();
                        this.needUpdate();
                    }
                }
            } else if (!this.input.get().func_190926_b() && this.input.get().hasCapability(CapabilityEnergy.ENERGY, null)) {
                IEnergyStorage itm = (IEnergyStorage)this.input.get().getCapability(CapabilityEnergy.ENERGY, null);
                if (itm.receiveEnergy(this.getItemChargeRate(), true) > 0) {
                    int maxcharge = Math.min(this.energy.getEnergyStored(), this.getItemChargeRate());
                    int pwr = itm.receiveEnergy(maxcharge, false);
                    this.energy.extractEnergy(pwr, false);
                    if (!this.field_145850_b.field_72995_K) {
                        if (!this.charging) {
                            this.charging = true;
                            this.needUpdate();
                        }
                    } else {
                        this.playAmbientSound();
                    }
                } else if (!this.field_145850_b.field_72995_K) {
                    if (this.inventory.getStackInSlot(1).func_190926_b()) {
                        this.inventory.setStackInSlot(1, this.inventory.getStackInSlot(0));
                        this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
                    }
                    this.charging = false;
                    this.needUpdate();
                }
            } else if (!this.field_145850_b.field_72995_K) {
                if (this.charging) {
                    this.charging = false;
                    this.needUpdate();
                }
                if (this.contentsChanged) {
                    this.checkAndStartOperation();
                }
            }
        }
    }

    @Override
    protected SimpleMachine getMachineBlockType() {
        return TGBlocks.SIMPLE_MACHINE;
    }
}

