/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities;

import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankPropertiesWrapper;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;
import techguns.TGItems;
import techguns.TGSounds;
import techguns.tileentities.BasicMachineTileEnt;
import techguns.tileentities.operation.ChemLabRecipes;
import techguns.tileentities.operation.FluidTankPlus;
import techguns.tileentities.operation.ITileEntityFluidTanks;
import techguns.tileentities.operation.ItemStackHandlerPlus;
import techguns.tileentities.operation.MachineOperation;
import techguns.tileentities.operation.MachineSlotFluid;
import techguns.tileentities.operation.MachineSlotItem;
import techguns.util.ItemUtil;

public class ChemLabTileEnt
extends BasicMachineTileEnt
implements ITileEntityFluidTanks {
    private Random rng = new Random();
    protected static final float SOUND_VOLUME = 0.65f;
    public static final int BUTTON_ID_DUMP_INPUT = 3;
    public static final int BUTTON_ID_DUMP_OUTPUT = 4;
    public static final int BUTTON_ID_TOGGLE_DRAIN = 5;
    public ChemLabFluidHandler fluidHandler;
    public FluidTank inputTank = new FluidTankPlus(this, 8000);
    public FluidTank outputTank;
    protected boolean drainInput = false;
    public static final int SLOT_INPUT1 = 0;
    public static final int SLOT_INPUT2 = 1;
    public static final int SLOT_BOTTLE = 2;
    public static final int SLOT_OUTPUT = 3;
    public static final int SLOT_UPGRADE = 4;
    public MachineSlotItem input1;
    public MachineSlotItem input2;
    public MachineSlotItem input_bottle;
    public MachineSlotFluid input_fluid;
    public static final int CAPACITY_INPUT_TANK = 8000;
    public static final int CAPACITY_OUTPUT_TANK = 16000;

    public ChemLabTileEnt() {
        super(5, true, 20000);
        this.inputTank.setTileEntity((TileEntity)this);
        this.outputTank = new FluidTankPlus(this, 16000);
        this.outputTank.setTileEntity((TileEntity)this);
        this.fluidHandler = new ChemLabFluidHandler(this);
        this.input1 = new MachineSlotItem(this, 0);
        this.input2 = new MachineSlotItem(this, 1);
        this.input_bottle = new MachineSlotItem(this, 2);
        this.input_fluid = new MachineSlotFluid(this.inputTank);
        this.inventory = new ItemStackHandlerPlus(5){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                ChemLabTileEnt.this.setContentsChanged(true);
            }

            @Override
            protected boolean allowItemInSlot(int slot, ItemStack stack) {
                switch (slot) {
                    case 0: 
                    case 1: 
                    case 2: {
                        return ChemLabTileEnt.this.isItemValidForSlot(slot, stack);
                    }
                    case 3: {
                        return false;
                    }
                    case 4: {
                        return TGItems.isMachineUpgrade(stack);
                    }
                }
                return false;
            }

            @Override
            protected boolean allowExtractFromSlot(int slot, int amount) {
                return slot == 3;
            }
        };
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation("techguns.container.chemlab", new Object[0]);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY ? this.fluidHandler : super.getCapability(capability, facing));
    }

    public boolean isItemValidForSlot(int slot, ItemStack item) {
        if (slot == 2) {
            return ChemLabRecipes.allowInFlaskSlot(item);
        }
        if (slot == 0 && this.input1.get().func_190926_b() && this.input2.get().func_190926_b()) {
            return !ChemLabRecipes.allowInFlaskSlot(item) && ChemLabRecipes.hasRecipeUsing(item);
        }
        if (slot == 0 && this.input1.get().func_190926_b() && !this.input2.get().func_190926_b()) {
            return !ChemLabRecipes.allowInFlaskSlot(item) && ChemLabRecipes.allowAsInput2(this.input2.get(), item);
        }
        if (slot == 0 && !this.input1.get().func_190926_b()) {
            return ItemUtil.isItemEqual(this.input1.get(), item);
        }
        if (slot == 1 && !this.input1.get().func_190926_b()) {
            return !ChemLabRecipes.allowInFlaskSlot(item) && ChemLabRecipes.allowAsInput2(this.input1.get(), item);
        }
        if (slot == 1 && !this.input2.get().func_190926_b()) {
            return ItemUtil.isItemEqual(this.input2.get(), item);
        }
        return false;
    }

    @Override
    public void readClientDataFromNBT(NBTTagCompound tags) {
        super.readClientDataFromNBT(tags);
        this.drainInput = tags.func_74767_n("drainInput");
        NBTTagCompound inputTankTags = tags.func_74775_l("inputTank");
        this.inputTank.readFromNBT(inputTankTags);
        NBTTagCompound outputTankTags = tags.func_74775_l("outputTank");
        this.outputTank.readFromNBT(outputTankTags);
    }

    @Override
    public void writeClientDataToNBT(NBTTagCompound tags) {
        super.writeClientDataToNBT(tags);
        tags.func_74757_a("drainInput", this.drainInput);
        NBTTagCompound inputTankTags = new NBTTagCompound();
        this.inputTank.writeToNBT(inputTankTags);
        tags.func_74782_a("inputTank", (NBTBase)inputTankTags);
        NBTTagCompound outputTankTags = new NBTTagCompound();
        this.outputTank.writeToNBT(outputTankTags);
        tags.func_74782_a("outputTank", (NBTBase)outputTankTags);
    }

    @Override
    protected int getNeededPower() {
        if (this.currentOperation != null) {
            return this.currentOperation.getPowerPerTick();
        }
        return 0;
    }

    protected boolean canOutput(MachineOperation output) {
        if (this.canOutput(output.getItemOutput0(), 3)) {
            FluidStack out = output.getFluidOutput0();
            if (out == null) {
                return true;
            }
            return this.outputTank.canFillFluidType(out) && this.outputTank.fill(out, false) == out.amount;
        }
        return false;
    }

    protected boolean canConsume(MachineOperation output) {
        int multi = output.getStackMultiplier();
        ItemStack in1 = output.getInputs().get(0);
        ItemStack in2 = output.getInputs().get(1);
        ItemStack bottle = output.getInputs().get(2);
        FluidStack fluidIn = null;
        int amount = 0;
        if (!output.getFluid_inputs().isEmpty() && (fluidIn = output.getFluid_inputs().get(0)) != null) {
            amount = fluidIn.amount;
        }
        return this.input1.canConsumeWithMultiplier(in1, multi) && this.input2.canConsumeWithMultiplier(in2, multi) && this.input_bottle.canConsumeWithMultiplier(bottle, multi) && this.input_fluid.canConsume(amount * multi);
    }

    protected void consume(MachineOperation output) {
        this.input1.consume(output.getNeededAmountItem(0));
        this.input2.consume(output.getNeededAmountItem(1));
        this.input_bottle.consume(output.getNeededAmountItem(2));
        this.input_fluid.consume(output.getNeededAmountFluid(0));
    }

    @Override
    protected void checkAndStartOperation() {
        this.setContentsChanged(false);
        MachineOperation op = ChemLabRecipes.getOutputFor(this);
        if (op != null && this.canOutput(op)) {
            int maxStack = this.getMaxMachineUpgradeMultiplier(4);
            int multiplier = 1;
            for (int i = maxStack; i > 1; --i) {
                op.setStackMultiplier(i);
                if (!this.canOutput(op) || !this.canConsume(op)) continue;
                multiplier = i;
                break;
            }
            op.setStackMultiplier(multiplier);
            this.consume(op);
            this.currentOperation = op;
            this.progress = 0;
            this.totaltime = 100;
            if (!this.field_145850_b.field_72995_K) {
                this.needUpdate();
            }
        }
    }

    @Override
    protected void finishedOperation() {
        FluidStack fluidOut;
        ItemStack itemOut = this.currentOperation.getItemOutput0();
        if (!itemOut.func_190926_b()) {
            if (!this.inventory.getStackInSlot(3).func_190926_b()) {
                this.inventory.insertItemNoCheck(3, itemOut, false);
            } else {
                this.inventory.setStackInSlot(3, itemOut);
            }
        }
        if ((fluidOut = this.currentOperation.getFluidOutput0()) != null) {
            this.outputTank.fillInternal(fluidOut, true);
        }
    }

    @Override
    protected void playAmbientSound() {
        int delay;
        int soundTick1 = 1;
        int halfTime = Math.round((float)this.totaltime * 0.5f);
        if (this.progress == soundTick1 || this.progress == soundTick1 + halfTime) {
            this.field_145850_b.func_184134_a((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), TGSounds.CHEM_LAB_WORK, SoundCategory.BLOCKS, 0.65f, 1.0f, true);
        }
        if (this.field_145850_b.field_72995_K && this.progress % (delay = 10) == 0) {
            this.field_145850_b.func_175688_a(EnumParticleTypes.SPELL, (double)this.func_174877_v().func_177958_n() + 0.5 + (double)this.rng.nextFloat(), (double)this.func_174877_v().func_177956_o() + 0.5 + (double)this.rng.nextFloat(), (double)this.func_174877_v().func_177952_p() + 0.5 + (double)this.rng.nextFloat(), 0.0, 1.0, 0.0, new int[0]);
        }
    }

    public FluidStack getCurrentInputFluid() {
        return this.inputTank.getFluid();
    }

    public FluidStack getCurrentOutputFluid() {
        return this.outputTank.getFluid();
    }

    public int getValidSlotForItemInMachine(ItemStack item) {
        if (ChemLabRecipes.allowInFlaskSlot(item)) {
            if (this.input_bottle.get().func_190926_b()) {
                return 2;
            }
            if (OreDictionary.itemMatches((ItemStack)this.input_bottle.get(), (ItemStack)item, (boolean)true)) {
                return 2;
            }
        } else {
            if (!this.input1.get().func_190926_b() && OreDictionary.itemMatches((ItemStack)this.input1.get(), (ItemStack)item, (boolean)true)) {
                return 0;
            }
            if (!this.input2.get().func_190926_b() && OreDictionary.itemMatches((ItemStack)this.input2.get(), (ItemStack)item, (boolean)true)) {
                return 1;
            }
            if (this.input1.get().func_190926_b() && ChemLabRecipes.hasRecipeUsing(item)) {
                return 0;
            }
            if (!this.input1.get().func_190926_b() && this.input2.get().func_190926_b() && ChemLabRecipes.allowAsInput2(this.input1.get(), item)) {
                return 1;
            }
            if (TGItems.isMachineUpgrade(item)) {
                return 4;
            }
        }
        return -1;
    }

    @Override
    public void saveTanksToNBT(NBTTagCompound tags) {
        NBTTagCompound inputTankTags = new NBTTagCompound();
        this.inputTank.writeToNBT(inputTankTags);
        tags.func_74782_a("inputTank", (NBTBase)inputTankTags);
        NBTTagCompound outputTankTags = new NBTTagCompound();
        this.outputTank.writeToNBT(outputTankTags);
        tags.func_74782_a("outputTank", (NBTBase)outputTankTags);
    }

    @Override
    public void loadTanksFromNBT(NBTTagCompound tags) {
        NBTTagCompound inputTank = tags.func_74775_l("inputTank");
        this.inputTank.readFromNBT(inputTank);
        NBTTagCompound outputTank = tags.func_74775_l("outputTank");
        this.outputTank.readFromNBT(outputTank);
    }

    public byte getDrainMode() {
        return (byte)(this.drainInput ? 1 : 0);
    }

    @Override
    public void buttonClicked(int id, EntityPlayer ply, String data) {
        if (id < 3) {
            super.buttonClicked(id, ply, data);
        } else if (this.isUseableByPlayer(ply)) {
            switch (id) {
                case 3: {
                    this.inputTank.setFluid(null);
                    this.needUpdate();
                    break;
                }
                case 4: {
                    this.outputTank.setFluid(null);
                    this.needUpdate();
                    break;
                }
                case 5: {
                    this.drainInput = !this.drainInput;
                    this.needUpdate();
                }
            }
        }
    }

    @Override
    public boolean onFluidContainerInteract(EntityPlayer player, EnumHand hand, IFluidHandlerItem fluidhandleritem, ItemStack stack) {
        if (!this.isUseableByPlayer(player)) {
            return false;
        }
        boolean interacted = false;
        if (this.drainInput) {
            interacted = FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)this.inputTank);
        } else {
            IItemHandler playerInventory = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            if (playerInventory != null) {
                FluidActionResult fluidActionResult = FluidUtil.tryFillContainerAndStow((ItemStack)stack, (IFluidHandler)this.outputTank, (IItemHandler)playerInventory, (int)Integer.MAX_VALUE, (EntityPlayer)player, (boolean)true);
                if (!fluidActionResult.isSuccess()) {
                    fluidActionResult = FluidUtil.tryEmptyContainerAndStow((ItemStack)stack, (IFluidHandler)this.inputTank, (IItemHandler)playerInventory, (int)Integer.MAX_VALUE, (EntityPlayer)player, (boolean)true);
                }
                if (fluidActionResult.isSuccess()) {
                    player.func_184611_a(hand, fluidActionResult.getResult());
                    interacted = true;
                }
            }
        }
        return interacted;
    }

    public static class ChemLabFluidHandler
    implements IFluidHandler {
        private ChemLabTileEnt tile;
        protected IFluidTankProperties[] tankProperties;

        public ChemLabFluidHandler(ChemLabTileEnt tile) {
            this.tile = tile;
        }

        public IFluidTankProperties[] getTankProperties() {
            if (this.tankProperties == null) {
                this.tankProperties = new IFluidTankProperties[]{new FluidTankPropertiesWrapper(this.tile.inputTank), new FluidTankPropertiesWrapper(this.tile.outputTank)};
            }
            return this.tankProperties;
        }

        public int fill(FluidStack resource, boolean doFill) {
            return this.tile.inputTank.fill(resource, doFill);
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (!this.tile.drainInput) {
                return this.tile.outputTank.drain(resource, doDrain);
            }
            return this.tile.inputTank.drain(resource, doDrain);
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (!this.tile.drainInput) {
                return this.tile.outputTank.drain(maxDrain, doDrain);
            }
            return this.tile.inputTank.drain(maxDrain, doDrain);
        }
    }
}

