/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import techguns.tileentities.BasicOwnedTileEnt;
import techguns.world.dungeon.DungeonSegment;
import techguns.world.dungeon.DungeonTemplate;
import techguns.world.dungeon.TemplateSegment;

public class DungeonScannerTileEnt
extends BasicOwnedTileEnt {
    public static final int BUTTON_ID_GHOST = 2;
    public static final int BUTTON_ID_SIZE_XZ_PLUS = 3;
    public static final int BUTTON_ID_SIZE_XZ_MINUS = 4;
    public static final int BUTTON_ID_SIZE_Y_PLUS = 5;
    public static final int BUTTON_ID_SIZE_Y_MINUS = 6;
    public static final int BUTTON_ID_SCAN = 7;
    public static final int BUTTON_ID_PLACE = 8;
    public static final int BUTTON_ID_CLEAR = 9;
    public static final int BUTTON_ID_COPY_FIRST = 10;
    public static final int SPACING = 1;
    public int sizeXZ = 5;
    public int sizeY = 4;
    public boolean showGhost = true;
    public HashMap<TemplateSegment.SegmentType, Boolean> template_filter = new HashMap();

    public DungeonScannerTileEnt() {
        super(0, false);
        for (TemplateSegment.SegmentType type : TemplateSegment.templateSegments.keySet()) {
            this.template_filter.put(type, true);
        }
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation("techguns.container.dungeonscanner", new Object[0]);
    }

    @Override
    public void readClientDataFromNBT(NBTTagCompound tags) {
        super.readClientDataFromNBT(tags);
        this.sizeXZ = tags.func_74762_e("sizeXZ");
        this.sizeY = tags.func_74762_e("sizeY");
        this.showGhost = tags.func_74767_n("showGhost");
    }

    @Override
    public void writeClientDataToNBT(NBTTagCompound tags) {
        super.writeClientDataToNBT(tags);
        tags.func_74768_a("sizeXZ", this.sizeXZ);
        tags.func_74768_a("sizeY", this.sizeY);
        tags.func_74757_a("showGhost", this.showGhost);
    }

    @Override
    public void buttonClicked(int id, EntityPlayer ply, String data) {
        if (!this.isUseableByPlayer(ply)) {
            return;
        }
        switch (id) {
            case 2: {
                this.showGhost = !this.showGhost;
                break;
            }
            case 4: {
                this.sizeXZ = Math.max(1, this.sizeXZ - 1);
                break;
            }
            case 3: {
                ++this.sizeXZ;
                break;
            }
            case 6: {
                this.sizeY = Math.max(1, this.sizeY - 1);
                break;
            }
            case 5: {
                ++this.sizeY;
                break;
            }
            case 7: {
                this.scanTemplate(data);
                break;
            }
            case 8: {
                this.placeTemplate(data);
                break;
            }
            case 9: {
                this.clearBlocks();
                break;
            }
            case 10: {
                this.copyFirstSegment();
                break;
            }
            default: {
                super.buttonClicked(id, ply, data);
            }
        }
        this.needUpdate();
    }

    private void copyFirstSegment() {
        DungeonTemplate template = new DungeonTemplate(this.sizeXZ, this.sizeY);
        DungeonSegment firstSegment = new DungeonSegment(template, TemplateSegment.SegmentType.STRAIGHT);
        firstSegment.scanBlocks(this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
        for (TemplateSegment.SegmentType type : TemplateSegment.templateSegments.keySet()) {
            if (type == TemplateSegment.SegmentType.STRAIGHT) continue;
            firstSegment.type = type;
            firstSegment.placeTemplateSegment(this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), 0);
        }
    }

    private void clearBlocks() {
        Vec3i max = TemplateSegment.getMaxExtents(this.sizeXZ, this.sizeY);
        for (int x = 1; x < max.func_177958_n(); ++x) {
            for (int y = 0; y < max.func_177956_o(); ++y) {
                for (int z = 1; z < max.func_177952_p(); ++z) {
                    BlockPos bpos = this.field_174879_c.func_177982_a(x, y, z);
                    this.field_145850_b.func_175698_g(bpos);
                }
            }
        }
    }

    private void scanTemplate(String name) {
        if (name == null || name.equals("") || name.length() == 0) {
            return;
        }
        DungeonTemplate template = DungeonTemplate.scanTemplate(this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.sizeXZ, this.sizeY, name);
        try {
            FileOutputStream fout = new FileOutputStream(new File("./templates/" + name + ".ser"));
            ObjectOutputStream oos = new ObjectOutputStream(fout);
            oos.writeObject(template);
            fout.close();
            oos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void placeTemplate(String name) {
        if (name == null || name.equals("") || name.length() == 0) {
            return;
        }
        DungeonTemplate template = DungeonTemplate.dungeonTemplates.get(name);
        if (template != null) {
            template.placeTemplate(this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        int renderbounds = 1 + (this.sizeXZ + 1) * 30;
        return new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(renderbounds, this.sizeY, renderbounds));
    }
}

