/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.oredict.OreDictionary;
import techguns.TGItems;
import techguns.TGSounds;
import techguns.tileentities.BasicMachineTileEnt;
import techguns.tileentities.operation.ItemStackHandlerPlus;
import techguns.tileentities.operation.MachineOperation;
import techguns.tileentities.operation.MachineSlotItem;
import techguns.tileentities.operation.MetalPressRecipes;

public class MetalPressTileEnt
extends BasicMachineTileEnt {
    protected static final float SOUND_VOLUME = 0.5f;
    public static final int SLOT_INPUT1 = 0;
    public static final int SLOT_INPUT2 = 1;
    public static final int SLOT_OUTPUT = 2;
    public static final int SLOT_UPGRADE = 3;
    public static final int BUTTON_ID_AUTOSPLIT = 3;
    int minSoundDelay = 0;
    byte autoSlitMode = 0;
    public static final int POWER_PER_TICK = 20;
    public MachineSlotItem input1 = new MachineSlotItem(this, 0);
    public MachineSlotItem input2 = new MachineSlotItem(this, 1);

    public MetalPressTileEnt() {
        super(4, true, 20000);
        this.inventory = new ItemStackHandlerPlus(4){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                MetalPressTileEnt.this.setContentsChanged(true);
            }

            @Override
            protected boolean allowItemInSlot(int slot, ItemStack stack) {
                switch (slot) {
                    case 0: 
                    case 1: {
                        return MetalPressTileEnt.this.isItemValidForSlot(slot, stack);
                    }
                    case 2: {
                        return false;
                    }
                    case 3: {
                        return TGItems.isMachineUpgrade(stack);
                    }
                }
                return false;
            }

            @Override
            protected boolean allowExtractFromSlot(int slot, int amount) {
                return slot == 2;
            }
        };
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation("techguns.container.metalpress", new Object[0]);
    }

    @Override
    public void readClientDataFromNBT(NBTTagCompound tags) {
        super.readClientDataFromNBT(tags);
        this.autoSlitMode = tags.func_74771_c("autoSplitMode");
    }

    @Override
    public void writeClientDataToNBT(NBTTagCompound tags) {
        super.writeClientDataToNBT(tags);
        tags.func_74774_a("autoSplitMode", this.autoSlitMode);
    }

    @Override
    protected int getNeededPower() {
        if (this.currentOperation != null) {
            return 20 * this.currentOperation.getStackMultiplier();
        }
        return 0;
    }

    protected void splitSlot(MachineSlotItem src, MachineSlotItem target) {
        int amount = src.get().func_190916_E();
        int amount2 = amount / 2;
        int amount1 = amount - amount2;
        ItemStack targetStack = src.get().func_77946_l();
        src.get().func_190920_e(amount1);
        targetStack.func_190920_e(amount2);
        target.setStackInSlot(targetStack);
    }

    @Override
    protected void checkAndStartOperation() {
        if (this.autoSlitMode > 0) {
            if (!this.input1.get().func_190926_b() && this.input2.get().func_190926_b() && this.input1.get().func_190916_E() > 1) {
                if (!MetalPressRecipes.getOutputFor(this.input1.get(), this.input1.get()).func_190926_b()) {
                    this.splitSlot(this.input1, this.input2);
                }
            } else if (this.input1.get().func_190926_b() && !this.input2.get().func_190926_b() && this.input2.get().func_190916_E() > 1 && !MetalPressRecipes.getOutputFor(this.input2.get(), this.input2.get()).func_190926_b()) {
                this.splitSlot(this.input2, this.input1);
            }
        }
        ItemStack output = MetalPressRecipes.getOutputFor(this.input1.get(), this.input2.get());
        this.setContentsChanged(false);
        if (!output.func_190926_b() && this.canOutput(output, 2)) {
            ItemStack outputStack = TGItems.newStack(output, output.func_190916_E());
            int maxStack = this.getMaxMachineUpgradeMultiplier(3);
            int originalStacksize = output.func_190916_E();
            int multiplier = 1;
            for (int i = maxStack; i > 1; --i) {
                outputStack.func_190920_e(output.func_190916_E() * i);
                if (!this.canOutput(outputStack, 2) || this.input1.get().func_190916_E() < i || this.input2.get().func_190916_E() < i) continue;
                multiplier = i;
                break;
            }
            this.input1.consume(multiplier);
            this.input2.consume(multiplier);
            this.progress = 0;
            this.totaltime = 100;
            ItemStack input1 = this.input1.getTypeWithSize(1);
            ItemStack input2 = this.input2.getTypeWithSize(1);
            this.currentOperation = new MachineOperation(output, input1, input2);
            this.currentOperation.setStackMultiplier(multiplier);
            if (!this.field_145850_b.field_72995_K) {
                this.needUpdate();
            }
        }
    }

    @Override
    protected void finishedOperation() {
        if (this.inventory.getStackInSlot(2).func_190926_b()) {
            this.inventory.setStackInSlot(2, this.currentOperation.getItemOutput0());
        } else {
            this.inventory.insertItemNoCheck(2, this.currentOperation.getItemOutput0(), false);
        }
    }

    @Override
    protected void playAmbientSound() {
        float prog = (float)this.progress / (float)this.totaltime;
        int soundTick1 = Math.round((float)this.totaltime * 0.075f);
        int halfTime = Math.round((float)this.totaltime * 0.5f);
        if (this.progress == soundTick1 || this.progress == soundTick1 + halfTime) {
            this.field_145850_b.func_184134_a((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), TGSounds.METAL_PRESS_WORK, SoundCategory.BLOCKS, 0.5f, 1.0f, true);
        }
    }

    public byte getAutoSplitMode() {
        return this.autoSlitMode;
    }

    public void setAutoSplitMode(byte mode) {
        this.autoSlitMode = mode;
    }

    public boolean isItemValidForSlot(int slot, ItemStack item) {
        boolean empty1 = this.input1.get().func_190926_b();
        boolean empty2 = this.input2.get().func_190926_b();
        if (empty1 && empty2) {
            return MetalPressRecipes.hasRecipeUsing(item);
        }
        if (empty1 && slot == 0) {
            return !MetalPressRecipes.getOutputFor(item, this.input2.get()).func_190926_b();
        }
        if (empty2 && slot == 1) {
            return !MetalPressRecipes.getOutputFor(this.input1.get(), item).func_190926_b();
        }
        return this.getInventory().getStackInSlot(slot).func_77969_a(item);
    }

    public int getValidSlotForItemInMachine(ItemStack item) {
        if (!this.input1.get().func_190926_b() && OreDictionary.itemMatches((ItemStack)this.input1.get(), (ItemStack)item, (boolean)true)) {
            return 0;
        }
        if (!this.input2.get().func_190926_b() && OreDictionary.itemMatches((ItemStack)this.input2.get(), (ItemStack)item, (boolean)true)) {
            return 1;
        }
        if (this.input1.get().func_190926_b() && MetalPressRecipes.hasRecipeUsing(item)) {
            return 0;
        }
        if (!this.input1.get().func_190926_b() && this.input2.get().func_190926_b() && !MetalPressRecipes.getOutputFor(this.input1.get(), item).func_190926_b()) {
            return 1;
        }
        if (!item.func_190926_b() && item.func_77973_b() == TGItems.MACHINE_UPGRADE_STACK.func_77973_b() && item.func_77952_i() == TGItems.MACHINE_UPGRADE_STACK.func_77952_i()) {
            return 3;
        }
        return -1;
    }

    @Override
    public void buttonClicked(int id, EntityPlayer ply, String data) {
        if (id == 3) {
            if (this.isUseableByPlayer(ply)) {
                this.changeAutoSplitMode();
            }
        } else {
            super.buttonClicked(id, ply, data);
        }
    }

    protected void changeAutoSplitMode() {
        this.autoSlitMode = this.autoSlitMode == 0 ? (byte)1 : 0;
        this.setContentsChanged(true);
    }
}

