/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import techguns.TGItems;
import techguns.TGPackets;
import techguns.Techguns;
import techguns.api.guns.IGenericGun;
import techguns.api.tginventory.ITGSpecialSlot;
import techguns.api.tginventory.TGSlotType;
import techguns.entities.npcs.NPCTurret;
import techguns.items.guns.GenericGun;
import techguns.packets.PacketRequestTileEntitySync;
import techguns.tileentities.BasicPoweredTileEnt;
import techguns.tileentities.operation.ItemStackHandlerPlus;
import techguns.util.InventoryUtil;
import techguns.util.ItemUtil;

public class TurretTileEnt
extends BasicPoweredTileEnt
implements ITickable {
    public static final int SLOT_INPUT1 = 0;
    public static final int INPUTS_SIZE = 9;
    public static final int SLOT_OUTPUT1 = 9;
    public static final int OUTPUTS_SIZE = 9;
    public static final int SLOT_WEAPON = 18;
    public static final int SLOT_ARMOR = 19;
    public static final int BUTTON_ID_TARGET_ANIMALS = 3;
    public static final int BUTTON_ID_PVP_SETTING = 4;
    public NPCTurret mountedTurret = null;
    private long lastRequest = 0L;
    public boolean turretDeath = false;
    public int repairTime = 0;
    public int turretHealTime = 0;
    public boolean attackAnimals = false;
    protected EnumFacing facing = EnumFacing.UP;
    protected byte pvpsetting = 0;

    public TurretTileEnt() {
        super(20, false, 5000);
        this.inventory = new ItemStackHandlerPlus(20){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                if (slot == 18) {
                    TurretTileEnt.this.updateWeapon();
                }
            }

            @Override
            protected boolean allowItemInSlot(int slot, ItemStack stack) {
                if (slot == 18) {
                    return stack.func_77973_b() instanceof IGenericGun;
                }
                if (slot == 19) {
                    return stack.func_77973_b() instanceof ITGSpecialSlot && ((ITGSpecialSlot)stack.func_77973_b()).getSlot(stack) == TGSlotType.TURRETARMOR;
                }
                return slot >= 0 && slot < 9;
            }

            @Override
            protected boolean allowExtractFromSlot(int slot, int amount) {
                return slot >= 9 && slot < 18;
            }
        };
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation("techguns.container.turretbase", new Object[0]);
    }

    public int getRepairTimeScaled(int max) {
        int totaltime = this.getRepairTimeMax();
        return max - this.repairTime * max / totaltime;
    }

    @Override
    public void readClientDataFromNBT(NBTTagCompound tags) {
        NBTTagCompound tagsArmor;
        Entity ent;
        super.readClientDataFromNBT(tags);
        if (tags.func_74764_b("mountedTurret") && this.field_145850_b != null && (ent = this.field_145850_b.func_73045_a(tags.func_74762_e("mountedTurret"))) != null && ent instanceof NPCTurret) {
            this.mountedTurret = (NPCTurret)ent;
            this.mountedTurret.setTileEnt(this);
        }
        this.facing = EnumFacing.func_82600_a((int)tags.func_74771_c("facing"));
        this.turretDeath = tags.func_74767_n("turretDeath");
        this.repairTime = tags.func_74762_e("repairTime");
        this.turretHealTime = tags.func_74762_e("turretHealTime");
        this.attackAnimals = tags.func_74767_n("attackAnimals");
        this.pvpsetting = tags.func_74771_c("pvpsetting");
        NBTTagCompound tagsWeapon = tags.func_74775_l("weapon");
        if (tagsWeapon != null && !tagsWeapon.func_82582_d()) {
            this.inventory.setStackInSlot(18, new ItemStack(tagsWeapon));
        }
        if ((tagsArmor = tags.func_74775_l("armor")) != null && !tagsArmor.func_82582_d()) {
            this.inventory.setStackInSlot(19, new ItemStack(tagsArmor));
        }
    }

    @Override
    public boolean hasRotation() {
        return true;
    }

    @Override
    public void rotateTile(EnumFacing sideHit) {
        if (this.facing != sideHit && (sideHit == EnumFacing.UP || sideHit == EnumFacing.DOWN)) {
            this.facing = sideHit;
            if (this.mountedTurret != null) {
                float health = this.mountedTurret.func_110143_aJ();
                this.mountedTurret.func_70606_j(0.0f);
                this.mountedTurret.func_70106_y();
                this.spawnTurret(this.field_145850_b, this.func_174877_v(), health);
            }
            if (!this.field_145850_b.field_72995_K) {
                this.needUpdate();
            }
        }
    }

    @Override
    public void writeClientDataToNBT(NBTTagCompound tags) {
        super.writeClientDataToNBT(tags);
        if (this.mountedTurret != null) {
            tags.func_74768_a("mountedTurret", this.mountedTurret.func_145782_y());
        }
        tags.func_74774_a("facing", (byte)this.facing.func_176745_a());
        tags.func_74757_a("turretDeath", this.turretDeath);
        tags.func_74768_a("repairTime", this.repairTime);
        tags.func_74768_a("turretHealTime", this.turretHealTime);
        tags.func_74757_a("attackAnimals", this.attackAnimals);
        tags.func_74774_a("pvpsetting", this.pvpsetting);
        NBTTagCompound tagsWeapon = new NBTTagCompound();
        this.inventory.getStackInSlot(18).func_77955_b(tagsWeapon);
        NBTTagCompound tagsArmor = new NBTTagCompound();
        this.inventory.getStackInSlot(19).func_77955_b(tagsArmor);
        tags.func_74782_a("weapon", (NBTBase)tagsWeapon);
        tags.func_74782_a("armor", (NBTBase)tagsArmor);
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    public ItemStack getWeapon() {
        return this.inventory.getStackInSlot(18);
    }

    public boolean consumeAmmo() {
        ItemStack gunstack = this.getWeapon();
        if (!gunstack.func_190926_b()) {
            GenericGun gun = (GenericGun)gunstack.func_77973_b();
            if (gun.getCurrentAmmo(gunstack) <= 0) {
                this.doReload(gunstack);
            }
            if (gun.getCurrentAmmo(gunstack) >= 1) {
                gun.useAmmo(gunstack, 1);
                return true;
            }
        }
        return false;
    }

    protected void doReload(ItemStack gunstack) {
        int i;
        GenericGun gun = (GenericGun)gunstack.func_77973_b();
        ItemStack[] ammo = gun.getAmmoType().getAmmo(gun.getCurrentAmmoVariant(gunstack));
        ItemStack[] emptyMag = gun.getAmmoType().getEmptyMag();
        boolean canConsume = true;
        for (i = 0; i < emptyMag.length; ++i) {
            if (InventoryUtil.canConsumeItem(this.inventory, ammo[i], 0, 9) <= 0) continue;
            canConsume = false;
            break;
        }
        if (canConsume) {
            for (i = 0; i < emptyMag.length; ++i) {
                if (!InventoryUtil.consumeAmmo(this.inventory, ammo[i], 0, 9)) continue;
                if (!emptyMag[i].func_190926_b()) {
                    int tooMuch = InventoryUtil.addItemToInventory(this.inventory, TGItems.newStack(emptyMag[i], 1), 9, 18);
                    if (!this.field_145850_b.field_72995_K) {
                        this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p(), TGItems.newStack(emptyMag[i], tooMuch)));
                    }
                }
                if (gun.getAmmoCount() > 1) {
                    int j;
                    for (j = 1; j < gun.getAmmoCount() && InventoryUtil.consumeAmmo(this.inventory, ammo[i], 0, 9); ++j) {
                    }
                    if (i == 0) {
                        gun.reloadAmmo(gunstack, j);
                    }
                } else if (i == 0) {
                    gun.reloadAmmo(gunstack);
                }
                if (this.field_145850_b.field_72995_K) continue;
                this.needUpdate();
            }
        }
    }

    protected int getRepairTimeMax() {
        return 200;
    }

    protected int getRepairPowerAmount() {
        return 50;
    }

    protected int getOperationPowerAmount() {
        return 5;
    }

    protected int getPowerAmountHealTick() {
        return 500;
    }

    protected int getHealTickDelay() {
        return 60;
    }

    public void setMountedTurret(NPCTurret mountedTurret) {
        this.mountedTurret = mountedTurret;
    }

    public int getTurretArmorValue() {
        ItemStack armor = this.inventory.getStackInSlot(19);
        if (!armor.func_190926_b()) {
            if (ItemUtil.isItemEqual(armor, TGItems.TURRET_ARMOR_IRON)) {
                return 5;
            }
            if (ItemUtil.isItemEqual(armor, TGItems.TURRET_ARMOR_STEEL)) {
                return 10;
            }
            if (ItemUtil.isItemEqual(armor, TGItems.TURRET_ARMOR_OBSIDIAN_STEEL)) {
                return 15;
            }
            if (ItemUtil.isItemEqual(armor, TGItems.TURRET_ARMOR_CARBON)) {
                return 20;
            }
        }
        return 0;
    }

    public void breakTurret() {
        if (this.mountedTurret != null) {
            this.mountedTurret.func_70606_j(0.0f);
            this.mountedTurret.func_70106_y();
        }
    }

    public void onTurretDeath() {
        if (!this.field_145850_b.field_72995_K) {
            this.mountedTurret = null;
            this.turretDeath = true;
            this.repairTime = this.getRepairTimeMax();
            this.needUpdate();
        }
    }

    @Override
    public void buttonClicked(int id, EntityPlayer ply, String data) {
        if (id < 3) {
            super.buttonClicked(id, ply, data);
        } else if (id == 3 && this.isUseableByPlayer(ply)) {
            boolean bl = this.attackAnimals = !this.attackAnimals;
            if (!this.field_145850_b.field_72995_K) {
                this.needUpdate();
            }
        } else if (id == 4 && this.isOwnedByPlayer(ply)) {
            if (Techguns.instance.FTBLIB_ENABLED) {
                this.pvpsetting = (byte)(this.pvpsetting + 1);
                this.pvpsetting = (byte)(this.pvpsetting % 5);
            } else {
                this.pvpsetting = this.pvpsetting == 0 ? (byte)4 : (byte)0;
            }
            if (!this.field_145850_b.field_72995_K) {
                this.needUpdate();
            }
        }
    }

    public void updateWeapon() {
        if (this.mountedTurret != null) {
            this.mountedTurret.setCombatTask();
            if (!this.field_145850_b.field_72995_K) {
                this.needUpdate();
            }
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.turretDeath) {
                if (this.isRedstoneEnabled()) {
                    if (this.consumePower(this.getRepairPowerAmount())) {
                        --this.repairTime;
                    }
                    if (this.repairTime <= 0) {
                        this.repairTime = 0;
                        this.turretDeath = false;
                        if (!this.field_145850_b.field_72995_K) {
                            this.spawnTurret(this.field_145850_b, this.field_174879_c, 10.0f);
                            this.needUpdate();
                        }
                    }
                }
            } else if (this.mountedTurret != null && this.mountedTurret.field_70128_L) {
                this.onTurretDeath();
            } else if (this.mountedTurret != null) {
                if (this.isRedstoneEnabled()) {
                    if (!this.consumePower(this.getOperationPowerAmount())) {
                        if (this.mountedTurret.active) {
                            this.mountedTurret.disable();
                            this.mountedTurret.active = false;
                        }
                    } else if (!this.mountedTurret.active) {
                        this.mountedTurret.active = true;
                        this.mountedTurret.setAITasks();
                        this.mountedTurret.setCombatTask();
                    }
                    if (this.turretHealTime <= 0) {
                        if (this.mountedTurret.func_110143_aJ() < this.mountedTurret.func_110138_aP() && this.consumePower(this.getPowerAmountHealTick())) {
                            this.mountedTurret.func_70691_i(1.0f);
                            this.turretHealTime = this.getHealTickDelay();
                        }
                    } else {
                        --this.turretHealTime;
                    }
                } else if (this.mountedTurret.active) {
                    this.mountedTurret.disable();
                    this.mountedTurret.active = false;
                }
            }
        } else if (this.mountedTurret == null && !this.turretDeath) {
            if (System.currentTimeMillis() - this.lastRequest > 1000L) {
                TGPackets.network.sendToServer((IMessage)new PacketRequestTileEntitySync(this.func_174877_v()));
                this.lastRequest = System.currentTimeMillis();
            }
        } else if (this.mountedTurret != null && this.mountedTurret.mountedTileEnt == null) {
            this.mountedTurret.setTileEnt(this);
        }
    }

    public int getTurretTier() {
        ItemStack armorstack = this.inventory.getStackInSlot(19);
        if (!armorstack.func_190926_b() && armorstack.func_77973_b() == TGItems.SHARED_ITEM) {
            int meta = armorstack.func_77952_i();
            if (meta == TGItems.TURRET_ARMOR_IRON.func_77952_i()) {
                return 1;
            }
            if (meta == TGItems.TURRET_ARMOR_STEEL.func_77952_i()) {
                return 2;
            }
            if (meta == TGItems.TURRET_ARMOR_OBSIDIAN_STEEL.func_77952_i()) {
                return 3;
            }
            if (meta == TGItems.TURRET_ARMOR_CARBON.func_77952_i()) {
                return 4;
            }
        }
        return 0;
    }

    public ResourceLocation getTurretBaseTexture() {
        return NPCTurret.getTexture(this.getTurretTier());
    }

    public void setTurretPosition() {
        double x = (double)this.field_174879_c.func_177958_n() + 0.5;
        double y = (double)this.field_174879_c.func_177956_o() + 0.5;
        double z = (double)this.field_174879_c.func_177952_p() + 0.5;
        switch (this.facing) {
            case DOWN: {
                y -= 0.5;
                y -= (double)this.mountedTurret.field_70131_O;
                break;
            }
            case EAST: {
                x += 0.5;
                break;
            }
            case NORTH: {
                z -= 0.5;
                break;
            }
            case SOUTH: {
                z += 0.5;
                break;
            }
            case UP: {
                y += 0.5;
                break;
            }
            case WEST: {
                x -= 0.5;
                break;
            }
        }
        this.mountedTurret.func_70107_b(x, y, z);
    }

    public void spawnTurret(World w, BlockPos p, float health) {
        if (!w.field_72995_K) {
            this.mountedTurret = new NPCTurret(w, this);
            this.setTurretPosition();
            this.mountedTurret.func_70606_j(health);
            this.mountedTurret.setTurretFacing(this.facing);
            this.turretDeath = false;
            w.func_72838_d((Entity)this.mountedTurret);
        }
    }

    public void spawnTurret(World w, BlockPos p) {
        if (!w.field_72995_K) {
            this.mountedTurret = new NPCTurret(w, this);
            this.setTurretPosition();
            this.mountedTurret.setTurretFacing(this.facing);
            this.turretDeath = false;
            w.func_72838_d((Entity)this.mountedTurret);
        }
    }

    @Override
    public void onBlockBreak() {
        super.onBlockBreak();
        if (this.mountedTurret != null) {
            this.mountedTurret.func_70606_j(0.0f);
            this.mountedTurret.func_70106_y();
        }
    }

    public byte getPvpSetting() {
        return this.pvpsetting;
    }
}

