/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities.operation;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import techguns.tileentities.operation.IMachineRecipe;
import techguns.tileentities.operation.ReactionBeamFocus;
import techguns.util.ItemStackOreDict;
import techguns.util.ItemUtil;
import techguns.util.TextUtil;

public class ReactionChamberRecipe
implements IMachineRecipe {
    public String ID;
    public ItemStackOreDict input;
    public ReactionBeamFocus beamFocus;
    public Fluid liquidIn;
    public ArrayList<ItemStack> outputs;
    public byte ticks;
    public byte requiredCompletion;
    public byte preferredIntensity;
    public byte intensityMargin;
    public byte liquidLevel;
    public int liquidConsumtion;
    public float instability;
    public RiskType risk;
    public int RFTick;
    private static HashMap<String, ReactionChamberRecipe> recipes = new HashMap();

    public static ReactionChamberRecipe getByKey(String key) {
        ReactionChamberRecipe rec = recipes.get(key);
        return rec;
    }

    public static HashMap<String, ReactionChamberRecipe> getRecipes() {
        return recipes;
    }

    public static ReactionChamberRecipe addRecipe(String ID, ItemStackOreDict input, ItemStack beamFocus, Fluid liquidIn, ItemStack output, int ticks, int requiredCompletion, int preferredIntensity, int intensityMargin, int liquidLevel, int liquidConsumtion, float instability, RiskType risk, int RFTick) {
        ReactionChamberRecipe rec = new ReactionChamberRecipe(ID, input, beamFocus, liquidIn, output, ticks, requiredCompletion, preferredIntensity, intensityMargin, liquidLevel, (short)liquidConsumtion, instability, risk, RFTick);
        recipes.put(rec.ID, rec);
        return rec;
    }

    public static ReactionChamberRecipe addRecipe(String ID, ItemStackOreDict input, ItemStack beamFocus, Fluid liquidIn, ItemStack[] outputs, int ticks, int requiredCompletion, int preferredIntensity, int intensityMargin, int liquidLevel, int liquidConsumtion, float instability, RiskType risk, int RFTick) {
        ReactionChamberRecipe rec = new ReactionChamberRecipe(ID, input, beamFocus, liquidIn, outputs, ticks, requiredCompletion, preferredIntensity, intensityMargin, liquidLevel, (short)liquidConsumtion, instability, risk, RFTick);
        recipes.put(rec.ID, rec);
        return rec;
    }

    private ReactionChamberRecipe(String ID, ItemStackOreDict input, ItemStack beamFocus, Fluid liquidIn, ItemStack output, int ticks, int requiredCompletion, int preferredIntensity, int intensityMargin, int liquidLevel, short liquidConsumtion, float instability, RiskType risk, int RFTick) {
        this.input = input;
        this.beamFocus = ReactionBeamFocus.getBeamFocus(beamFocus);
        this.liquidIn = liquidIn;
        this.outputs = new ArrayList();
        this.outputs.add(output);
        this.ticks = (byte)ticks;
        this.requiredCompletion = (byte)requiredCompletion;
        this.preferredIntensity = (byte)preferredIntensity;
        this.intensityMargin = (byte)intensityMargin;
        this.liquidLevel = (byte)liquidLevel;
        this.liquidConsumtion = liquidConsumtion;
        this.instability = instability;
        this.risk = risk;
        this.RFTick = RFTick;
        this.ID = ID;
    }

    private ReactionChamberRecipe(String ID, ItemStackOreDict input, ItemStack beamFocus, Fluid liquidIn, ItemStack[] outputs, int ticks, int requiredCompletion, int preferredIntensity, int intensityMargin, int liquidLevel, short liquidConsumtion, float instability, RiskType risk, int RFTick) {
        this.input = input;
        this.beamFocus = ReactionBeamFocus.getBeamFocus(beamFocus);
        this.liquidIn = liquidIn;
        this.outputs = new ArrayList();
        for (ItemStack item : outputs) {
            this.outputs.add(item);
        }
        this.ticks = (byte)ticks;
        this.requiredCompletion = (byte)requiredCompletion;
        this.preferredIntensity = (byte)preferredIntensity;
        this.intensityMargin = (byte)intensityMargin;
        this.liquidLevel = (byte)liquidLevel;
        this.liquidConsumtion = liquidConsumtion;
        this.instability = instability;
        this.risk = risk;
        this.RFTick = RFTick;
        this.ID = ID;
    }

    public static ReactionChamberRecipe getMatchingRecipe(ItemStack input, ItemStack focus, FluidStack tank, byte liquidLevel, byte intensity) {
        Iterator<String> it = recipes.keySet().iterator();
        while (it.hasNext()) {
            ReactionChamberRecipe rec = recipes.get(it.next());
            if (!rec.matches(input, focus, tank, liquidLevel, intensity)) continue;
            return rec;
        }
        return null;
    }

    public boolean matches(ItemStack input, ItemStack focus, FluidStack tank, byte liquidLevel, byte intensity) {
        ReactionBeamFocus f;
        return !input.func_190926_b() && this.input.isEqualWithOreDict(input) && (f = ReactionBeamFocus.getBeamFocus(focus)) != null && f == this.beamFocus && tank != null && tank.getFluid() == this.liquidIn && liquidLevel == this.liquidLevel && tank.amount == this.liquidLevel * 1000 && intensity == this.preferredIntensity;
    }

    public String getID() {
        return this.ID;
    }

    public void addOutput(ItemStack output) {
        this.outputs.add(output);
    }

    public boolean hasResult(ItemStack result) {
        for (int i = 0; i < this.outputs.size(); ++i) {
            if (!ItemUtil.isItemEqual(result, this.outputs.get(i))) continue;
            return true;
        }
        return false;
    }

    public boolean usesItem(ItemStack itm) {
        return this.input.isEqualWithOreDict(itm);
    }

    public boolean isStable() {
        return this.instability == 0.0f || this.intensityMargin == 0;
    }

    @Override
    public List<List<ItemStack>> getItemInputs() {
        ArrayList<List<ItemStack>> list = new ArrayList<List<ItemStack>>();
        list.add(this.input.getItemStacks());
        ArrayList<ItemStack> focus = new ArrayList<ItemStack>();
        focus.add(this.beamFocus.item);
        list.add(focus);
        return list;
    }

    @Override
    public List<List<ItemStack>> getItemOutputs() {
        ArrayList<List<ItemStack>> list = new ArrayList<List<ItemStack>>();
        this.outputs.forEach(s -> {
            ArrayList<ItemStack> list2 = new ArrayList<ItemStack>();
            list2.add((ItemStack)s);
            list.add(list2);
        });
        return list;
    }

    @Override
    public List<List<FluidStack>> getFluidInputs() {
        ArrayList<List<FluidStack>> list = new ArrayList<List<FluidStack>>();
        ArrayList<FluidStack> list2 = new ArrayList<FluidStack>();
        list2.add(new FluidStack(this.liquidIn, this.liquidLevel * 1000));
        list.add(list2);
        return list;
    }

    public static enum RiskType {
        NONE,
        BREAK_ITEM,
        RAD_LOW,
        RAD_MEDIUM,
        RAD_HIGH,
        EXPLOSION_LOW,
        EXPLOSION_MEDIUM,
        EXPLOSION_HIGH,
        UNFORSEEN_CONSEQUENCES;


        public String toString() {
            switch (this) {
                case BREAK_ITEM: {
                    return ChatFormatting.GREEN + TextUtil.trans("techguns.reactionChamber.RiskType.breakItem");
                }
                case EXPLOSION_LOW: {
                    return ChatFormatting.YELLOW + TextUtil.trans("techguns.reactionChamber.RiskType.expLow");
                }
                case EXPLOSION_MEDIUM: {
                    return ChatFormatting.RED + TextUtil.trans("techguns.reactionChamber.RiskType.expMed");
                }
                case RAD_LOW: 
                case RAD_MEDIUM: 
                case RAD_HIGH: 
                case EXPLOSION_HIGH: 
                case UNFORSEEN_CONSEQUENCES: {
                    return "NOT_YET_IMPLEMENTED";
                }
            }
            return ChatFormatting.WHITE + TextUtil.trans("techguns.reactionChamber.RiskType.none");
        }

        public static boolean isFatal(RiskType type) {
            return type != EXPLOSION_LOW && type != EXPLOSION_HIGH && type != EXPLOSION_MEDIUM && type != UNFORSEEN_CONSEQUENCES;
        }
    }
}

