/*
 * Decompiled with CFR 0.152.
 */
package techguns.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.handler.codec.EncoderException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.BitSet;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;

public class DataUtil {
    public static byte compress(boolean ... args) {
        if (args.length > 8) {
            throw new RuntimeException(new UnsupportedOperationException("Can't store more than 8 booleans into 1 byte!"));
        }
        byte b = 0;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i]) continue;
            b = (byte)(b | 1 << i);
        }
        return b;
    }

    public static BitSet uncompress(byte data) {
        BitSet b = BitSet.valueOf(new byte[]{data});
        return b;
    }

    public static void writeCompoundTag(ByteBuf buffer, NBTTagCompound nbt) {
        try {
            CompressedStreamTools.func_74800_a((NBTTagCompound)nbt, (DataOutput)new ByteBufOutputStream(buffer));
        }
        catch (IOException ioexception) {
            throw new EncoderException((Throwable)ioexception);
        }
    }

    public static NBTTagCompound readCompoundTag(ByteBuf buffer) {
        int i = buffer.readerIndex();
        byte b0 = buffer.readByte();
        if (b0 == 0) {
            return null;
        }
        buffer.readerIndex(i);
        try {
            return CompressedStreamTools.func_152456_a((DataInput)new ByteBufInputStream(buffer), (NBTSizeTracker)new NBTSizeTracker(0x200000L));
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
            return null;
        }
    }

    public static void writeItemStack(ByteBuf buf, ItemStack stack) {
        if (stack.func_190926_b()) {
            buf.writeShort(-1);
        } else {
            buf.writeShort(Item.func_150891_b((Item)stack.func_77973_b()));
            buf.writeByte(stack.func_190916_E());
            buf.writeShort(stack.func_77960_j());
            NBTTagCompound nbttagcompound = null;
            if (stack.func_77973_b().func_77645_m() || stack.func_77973_b().func_77651_p()) {
                nbttagcompound = stack.func_77973_b().getNBTShareTag(stack);
            }
            DataUtil.writeCompoundTag(buf, nbttagcompound);
        }
    }

    public static ItemStack readItemStack(ByteBuf buf) {
        short i = buf.readShort();
        if (i < 0) {
            return ItemStack.field_190927_a;
        }
        byte j = buf.readByte();
        short k = buf.readShort();
        ItemStack itemstack = new ItemStack(Item.func_150899_d((int)i), (int)j, (int)k);
        itemstack.func_77982_d(DataUtil.readCompoundTag(buf));
        return itemstack;
    }
}

