/*
 * Decompiled with CFR 0.152.
 */
package techguns.util;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.oredict.OreDictionary;
import techguns.TGItems;
import techguns.capabilities.TGExtendedPlayer;
import techguns.gui.player.TGPlayerInventory;
import techguns.tileentities.operation.ItemStackHandlerPlus;

public class InventoryUtil {
    public static int addAmmoToPlayerInventory(EntityPlayer ply, ItemStack ammo) {
        TGExtendedPlayer props = TGExtendedPlayer.get(ply);
        if (props != null) {
            TGPlayerInventory cfr_ignored_0 = props.tg_inventory;
            TGPlayerInventory cfr_ignored_1 = props.tg_inventory;
            int amount = InventoryUtil.addItemToInventory(props.tg_inventory.inventory, ammo, 7, 14 + 1);
            if (amount > 0) {
                return InventoryUtil.addItemToInventory((NonNullList<ItemStack>)ply.field_71071_by.field_70462_a, ammo, 0, ply.field_71071_by.field_70462_a.size());
            }
            return 0;
        }
        return InventoryUtil.addItemToInventory((NonNullList<ItemStack>)ply.field_71071_by.field_70462_a, ammo, 0, ply.field_71071_by.field_70462_a.size());
    }

    public static int addAmmoToAmmoInventory(EntityPlayer ply, ItemStack ammo) {
        TGExtendedPlayer props = TGExtendedPlayer.get(ply);
        if (props != null) {
            TGPlayerInventory cfr_ignored_0 = props.tg_inventory;
            TGPlayerInventory cfr_ignored_1 = props.tg_inventory;
            int amount = InventoryUtil.addItemToInventory(props.tg_inventory.inventory, ammo, 7, 14 + 1);
            return amount;
        }
        return ammo.func_190916_E();
    }

    public static int addItemToInventory(NonNullList<ItemStack> mainInventory, ItemStack item2, int startIndex, int endIndex) {
        int i;
        ItemStack item = item2.func_77946_l();
        for (i = startIndex; i < endIndex; ++i) {
            if (!OreDictionary.itemMatches((ItemStack)((ItemStack)mainInventory.get(i)), (ItemStack)item, (boolean)true) || ((ItemStack)mainInventory.get(i)).func_190916_E() >= item.func_77976_d()) continue;
            int diff = ((ItemStack)mainInventory.get(i)).func_190916_E() + item.func_190916_E() - item.func_77976_d();
            if (diff < 0) {
                int c = ((ItemStack)mainInventory.get(i)).func_190916_E();
                ((ItemStack)mainInventory.get(i)).func_190920_e(c + item.func_190916_E());
                item.func_190920_e(0);
                return 0;
            }
            ((ItemStack)mainInventory.get(i)).func_190920_e(item.func_77976_d());
            item.func_190920_e(diff);
        }
        if (item.func_190916_E() > 0) {
            for (i = startIndex; i < endIndex; ++i) {
                if (!((ItemStack)mainInventory.get(i)).func_190926_b()) continue;
                mainInventory.set(i, (Object)item.func_77946_l());
                item.func_190920_e(0);
                return 0;
            }
        }
        return item.func_190916_E();
    }

    public static int addItemToInventory(ItemStackHandlerPlus mainInventory, ItemStack item2, int startIndex, int endIndex) {
        int i;
        ItemStack item = item2.func_77946_l();
        for (i = startIndex; i < endIndex; ++i) {
            if (!OreDictionary.itemMatches((ItemStack)mainInventory.getStackInSlot(i), (ItemStack)item, (boolean)true) || mainInventory.getStackInSlot(i).func_190916_E() >= item.func_77976_d()) continue;
            int diff = mainInventory.getStackInSlot(i).func_190916_E() + item.func_190916_E() - item.func_77976_d();
            if (diff < 0) {
                mainInventory.insertItemNoCheck(i, item, false);
                return 0;
            }
            item = mainInventory.insertItemNoCheck(i, item, false);
        }
        if (item.func_190916_E() > 0) {
            for (i = startIndex; i < endIndex; ++i) {
                if (!mainInventory.getStackInSlot(i).func_190926_b()) continue;
                mainInventory.insertItemNoCheck(i, item, false);
                return 0;
            }
        }
        return item.func_190916_E();
    }

    public static boolean consumeAmmoPlayer(EntityPlayer ply, ItemStack[] ammo) {
        int i;
        if (ammo.length == 1) {
            return InventoryUtil.consumeAmmoPlayer(ply, ammo[0]);
        }
        boolean canconsume = true;
        for (i = 0; i < ammo.length; ++i) {
            if (InventoryUtil.canConsumeAmmoPlayer(ply, ammo[i])) continue;
            canconsume = false;
            break;
        }
        if (canconsume) {
            for (i = 0; i < ammo.length; ++i) {
                InventoryUtil.consumeAmmoPlayer(ply, ammo[i]);
            }
            return true;
        }
        return false;
    }

    public static boolean consumeAmmoPlayer(EntityPlayer ply, ItemStack ammo) {
        TGExtendedPlayer props = TGExtendedPlayer.get(ply);
        if (props != null) {
            int needed2;
            int amount = ammo.func_190916_E();
            if (amount == 1) {
                if (InventoryUtil.consumeAmmo(props.tg_inventory.inventory, ammo, 7, 15)) {
                    return true;
                }
                return InventoryUtil.consumeAmmo((NonNullList<ItemStack>)ply.field_71071_by.field_70462_a, ammo, 0, ply.field_71071_by.field_70462_a.size());
            }
            int needed = InventoryUtil.canConsumeItem(props.tg_inventory.inventory, ammo, 7, 15);
            if (needed + (needed2 = InventoryUtil.canConsumeItem((NonNullList<ItemStack>)ply.field_71071_by.field_70462_a, ammo, 0, ply.field_71071_by.field_70462_a.size())) <= amount) {
                int missing = InventoryUtil.consumeItem(props.tg_inventory.inventory, ammo, 7, 15);
                if (missing > 0) {
                    return InventoryUtil.consumeItem((NonNullList<ItemStack>)ply.field_71071_by.field_70462_a, TGItems.newStack(ammo, missing), 0, ply.field_71071_by.field_70462_a.size()) <= 0;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean canConsumeAmmoPlayer(EntityPlayer ply, ItemStack ammo) {
        TGExtendedPlayer props = TGExtendedPlayer.get(ply);
        if (props != null) {
            int needed2;
            int amount = ammo.func_190916_E();
            if (amount == 1) {
                if (InventoryUtil.canConsumeItem(props.tg_inventory.inventory, ammo, 7, 15) <= 0) {
                    return true;
                }
                return InventoryUtil.canConsumeItem((NonNullList<ItemStack>)ply.field_71071_by.field_70462_a, ammo, 0, ply.field_71071_by.field_70462_a.size()) <= 0;
            }
            int needed = InventoryUtil.canConsumeItem(props.tg_inventory.inventory, ammo, 7, 15);
            return needed + (needed2 = InventoryUtil.canConsumeItem((NonNullList<ItemStack>)ply.field_71071_by.field_70462_a, ammo, 0, ply.field_71071_by.field_70462_a.size())) <= amount;
        }
        return false;
    }

    public static int canConsumeItem(NonNullList<ItemStack> inv, ItemStack item, int startIndex, int endIndex) {
        int needed = item.func_190916_E();
        for (int i = startIndex; i < endIndex; ++i) {
            if (((ItemStack)inv.get(i)).func_190926_b() || ((ItemStack)inv.get(i)).func_77973_b() != item.func_77973_b() || ((ItemStack)inv.get(i)).func_77952_i() != item.func_77952_i() || (needed -= ((ItemStack)inv.get(i)).func_190916_E()) > 0) continue;
            return 0;
        }
        return needed;
    }

    public static int canConsumeItem(ItemStackHandler inv, ItemStack item, int startIndex, int endIndex) {
        int needed = item.func_190916_E();
        for (int i = startIndex; i < endIndex; ++i) {
            if (inv.getStackInSlot(i).func_190926_b() || inv.getStackInSlot(i).func_77973_b() != item.func_77973_b() || inv.getStackInSlot(i).func_77952_i() != item.func_77952_i() || (needed -= inv.getStackInSlot(i).func_190916_E()) > 0) continue;
            return 0;
        }
        return needed;
    }

    public static int consumeItem(NonNullList<ItemStack> inv, ItemStack item, int startIndex, int endIndex) {
        int needed = item.func_190916_E();
        for (int i = startIndex; i < endIndex; ++i) {
            if (((ItemStack)inv.get(i)).func_190926_b() || ((ItemStack)inv.get(i)).func_77973_b() != item.func_77973_b() || ((ItemStack)inv.get(i)).func_77952_i() != item.func_77952_i()) continue;
            if (((ItemStack)inv.get(i)).func_190916_E() <= needed) {
                needed -= ((ItemStack)inv.get(i)).func_190916_E();
                inv.set(i, (Object)ItemStack.field_190927_a);
                continue;
            }
            ((ItemStack)inv.get(i)).func_190920_e(((ItemStack)inv.get(i)).func_190916_E() - needed);
            return 0;
        }
        return needed;
    }

    public static int consumeItem(ItemStackHandler inv, ItemStack item, int startIndex, int endIndex) {
        int needed = item.func_190916_E();
        for (int i = startIndex; i < endIndex; ++i) {
            if (inv.getStackInSlot(i).func_190926_b() || inv.getStackInSlot(i).func_77973_b() != item.func_77973_b() || inv.getStackInSlot(i).func_77952_i() != item.func_77952_i()) continue;
            if (inv.getStackInSlot(i).func_190916_E() <= needed) {
                needed -= inv.getStackInSlot(i).func_190916_E();
                inv.setStackInSlot(i, ItemStack.field_190927_a);
                continue;
            }
            inv.getStackInSlot(i).func_190920_e(inv.getStackInSlot(i).func_190916_E() - needed);
            return 0;
        }
        return needed;
    }

    private static int searchItem(NonNullList<ItemStack> inv, ItemStack stack, int startIndex, int endIndex) {
        for (int i = startIndex; i < endIndex; ++i) {
            if (((ItemStack)inv.get(i)).func_190926_b() || ((ItemStack)inv.get(i)).func_77973_b() != stack.func_77973_b() || ((ItemStack)inv.get(i)).func_77952_i() != stack.func_77952_i()) continue;
            return i;
        }
        return -1;
    }

    private static int searchItem(ItemStackHandler inv, ItemStack stack, int startIndex, int endIndex) {
        for (int i = startIndex; i < endIndex; ++i) {
            if (inv.getStackInSlot(i).func_190926_b() || inv.getStackInSlot(i).func_77973_b() != stack.func_77973_b() || inv.getStackInSlot(i).func_77952_i() != stack.func_77952_i()) continue;
            return i;
        }
        return -1;
    }

    public static boolean consumeAmmo(NonNullList<ItemStack> inv, ItemStack ammo, int startIndex, int endIndex) {
        int i = InventoryUtil.searchItem(inv, ammo, startIndex, endIndex);
        if (i < 0) {
            return false;
        }
        ((ItemStack)inv.get(i)).func_190920_e(((ItemStack)inv.get(i)).func_190916_E() - 1);
        if (((ItemStack)inv.get(i)).func_190916_E() <= 0) {
            inv.set(i, (Object)ItemStack.field_190927_a);
        }
        return true;
    }

    public static boolean consumeAmmo(ItemStackHandlerPlus inv, ItemStack ammo, int startIndex, int endIndex) {
        int i = InventoryUtil.searchItem(inv, ammo, startIndex, endIndex);
        if (i < 0) {
            return false;
        }
        inv.extractWithoutCheck(i, 1, false);
        return true;
    }

    public static ItemStack consumeFood(NonNullList<ItemStack> inv, int startIndex, int endIndex) {
        for (int i = startIndex; i < endIndex; ++i) {
            if (((ItemStack)inv.get(i)).func_190926_b() || !(((ItemStack)inv.get(i)).func_77973_b() instanceof ItemFood)) continue;
            ItemStack food = TGItems.newStack((ItemStack)inv.get(i), 1);
            ((ItemStack)inv.get(i)).func_190920_e(((ItemStack)inv.get(i)).func_190916_E() - 1);
            if (((ItemStack)inv.get(i)).func_190916_E() <= 0) {
                inv.set(i, (Object)ItemStack.field_190927_a);
            }
            return food;
        }
        return ItemStack.field_190927_a;
    }

    public static int countItemInInv(NonNullList<ItemStack> inv, ItemStack stackToSearchFor, int startIndex, int endIndex) {
        int count = 0;
        for (int i = startIndex; i < endIndex; ++i) {
            if (((ItemStack)inv.get(i)).func_190926_b() || ((ItemStack)inv.get(i)).func_77973_b() != stackToSearchFor.func_77973_b() || ((ItemStack)inv.get(i)).func_77952_i() != stackToSearchFor.func_77952_i()) continue;
            count += ((ItemStack)inv.get(i)).func_190916_E();
        }
        return count;
    }

    public static void dropInventoryItems(World worldIn, BlockPos pos, ItemStackHandler inventory) {
        double x = (double)pos.func_177958_n() + 0.5;
        double y = (double)pos.func_177956_o() + 0.5;
        double z = (double)pos.func_177952_p() + 0.5;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack itemstack = inventory.getStackInSlot(i);
            if (itemstack.func_190926_b()) continue;
            InventoryHelper.func_180173_a((World)worldIn, (double)x, (double)y, (double)z, (ItemStack)itemstack);
        }
    }
}

