/*
 * Decompiled with CFR 0.152.
 */
package techguns.world.structures;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import techguns.util.BlockUtils;
import techguns.util.MBlock;
import techguns.world.structures.WorldgenStructure;

public class Containers
extends WorldgenStructure {
    int containerWidth = 2;
    int containerHeight = 2;
    int containerMinLength = 2;
    IBlockState containerBlock = null;

    public Containers(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, int containerWidth, int containerHeight, int containerMinLength, MBlock containerBlock) {
        super(minX, minY, minZ, maxX, maxY, maxZ);
        this.containerWidth = containerWidth;
        this.containerHeight = containerHeight;
        this.containerMinLength = containerMinLength;
        this.containerBlock = containerBlock.getState();
    }

    public Containers(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, MBlock containerBlock) {
        super(minX, minY, minZ, maxX, maxY, maxZ);
        this.containerBlock = containerBlock.getState();
    }

    @Override
    public void setBlocks(World world, int posX, int posY, int posZ, int sizeX, int sizeY, int sizeZ, int direction, WorldgenStructure.BiomeColorType colorType, Random rnd) {
        int offset = 0;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        if (sizeX > sizeZ) {
            int count = (int)(((float)sizeZ + 1.0f) / ((float)this.containerWidth + 1.0f));
            for (int i = 0; i < count; ++i) {
                BlockUtils.fillBlocks(world, pos.func_181079_c(posX, posY + 1, posZ + offset), sizeX, this.containerHeight, this.containerWidth, this.containerBlock);
                offset += this.containerWidth + 1;
            }
        } else {
            int count = (int)(((float)sizeX + 1.0f) / ((float)this.containerWidth + 1.0f));
            for (int i = 0; i < count; ++i) {
                BlockUtils.fillBlocks(world, pos.func_181079_c(posX + offset, posY + 1, posZ), this.containerWidth, this.containerHeight, sizeZ, this.containerBlock);
                offset += this.containerWidth + 1;
            }
        }
    }
}

