/*
 * Decompiled with CFR 0.152.
 */
package techguns.world.structures;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import techguns.blocks.EnumMonsterSpawnerType;
import techguns.entities.npcs.ZombieMiner;
import techguns.util.BlockUtils;
import techguns.util.MBlock;
import techguns.util.MultiMBlock;
import techguns.world.dungeon.presets.specialblocks.MBlockChestLoottable;
import techguns.world.dungeon.presets.specialblocks.MBlockTGSpawner;
import techguns.world.structures.MBlockRegister;
import techguns.world.structures.WorldgenStructure;

public class SmallTrainstation
extends WorldgenStructure {
    private static final ResourceLocation CHEST_LOOT = new ResourceLocation("techguns", "chests/small_trainstation");
    static ArrayList<MBlock> blockList = new ArrayList();
    static short[][] blocks;

    public SmallTrainstation(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        super(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Override
    public void setBlocks(World world, int posX, int posY, int posZ, int sizeX, int sizeY, int sizeZ, int direction, WorldgenStructure.BiomeColorType colorType, Random rnd) {
        int centerX;
        int centerZ;
        if (sizeX < this.minX && sizeZ > this.minX && sizeX >= this.minZ || sizeZ < this.minZ && sizeX > this.minZ && sizeZ >= this.minX) {
            direction = (direction + 1) % 4;
            centerZ = (int)((float)sizeX / 2.0f);
            centerX = (int)((float)sizeZ / 2.0f);
        } else {
            centerX = (int)((float)sizeX / 2.0f);
            centerZ = (int)((float)sizeZ / 2.0f);
        }
        BlockUtils.cleanUpwards(world, blocks, blockList, posX, posY, posZ, centerX, centerZ, direction, 0, 7);
        BlockUtils.placeFoundation(world, blocks, blockList, posX, posY, posZ, centerX, centerZ, direction, 0, 1);
        BlockUtils.placeScannedStructure(world, blocks, blockList, posX, posY, posZ, centerX, centerZ, direction, 0, this.lootTier, colorType);
        BlockUtils.placeScannedStructure(world, blocks, blockList, posX, posY, posZ, centerX, centerZ, direction, 1, this.lootTier, colorType);
    }

    static {
        blockList.add(new MBlock(Blocks.field_150351_n, 0));
        blockList.add(new MultiMBlock(new Block[]{Blocks.field_150448_aq, Blocks.field_150350_a}, new int[]{0, 0}, new int[]{2, 1}));
        blockList.add(MBlockRegister.COBBLESTONE_MOSSY_RND);
        blockList.add(MBlockRegister.STONEBRICK_STAIRS_EAST_CRACKED_RND);
        blockList.add(MBlockRegister.COBBLESTONE_FLOOR);
        blockList.add(MBlockRegister.BRICKS_CRACKED_RND);
        blockList.add(new MBlock(Blocks.field_150350_a, 0));
        blockList.add(new MultiMBlock(new Block[]{Blocks.field_150410_aZ, Blocks.field_150350_a}, new int[]{4, 0}, new int[]{1, 1}));
        blockList.add(MBlockRegister.STONEBRICK_STAIRS_WEST_CRACKED_INV_RND);
        blockList.add(MBlockRegister.STONEBRICK_CRACKED_RND);
        blockList.add(new MBlock(Blocks.field_180407_aO, 0));
        blockList.add(new MBlock(Blocks.field_150452_aw, 0));
        blockList.add(new MBlock((Block)Blocks.field_150376_bx, 8));
        blockList.add(new MBlock(Blocks.field_150468_ap, 3));
        blockList.add(new MBlockChestLoottable((Block)Blocks.field_150486_ae, 2, CHEST_LOOT));
        blockList.add(MBlockRegister.STONEBRICK_STAIRS_SOUTH_INV);
        blockList.add(MBlockRegister.STONEBRICK_STAIRS_NORTH_INV);
        blockList.add(new MBlock(Blocks.field_150460_al, 4));
        blockList.add(new MBlock(Blocks.field_150462_ai, 0));
        blockList.add(MBlockRegister.STONEBRICK_STAIRS_EAST_CRACKED_INV_RND);
        blockList.add(MBlockRegister.STONEBRICK_STAIRS_WEST_CRACKED_RND);
        blockList.add(new MBlockTGSpawner(EnumMonsterSpawnerType.HOLE, 3, 2, 200, 1).addMobType(ZombieMiner.class, 1));
        blocks = BlockUtils.loadStructureFromFile("small_trainstation");
    }
}

