/*
 * Decompiled with CFR 0.152.
 */
package dynamictreesbop.trees.species;

import biomesoplenty.api.biome.BOPBiomes;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.treedata.IDropCreator;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import dynamictreesbop.ModContent;
import dynamictreesbop.dropcreators.DropCreatorInvoluntarySeed;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class SpeciesMapleTwiglet
extends Species {
    public SpeciesMapleTwiglet(TreeFamily treeFamily) {
        super(new ResourceLocation("dynamictreesbop", "mapletwiglet"), treeFamily, ModContent.leaves.get("mapletwiglet"));
        this.setBasicGrowingParameters(0.3f, 2.5f, 1, 2, 1.0f);
        this.envFactor(BiomeDictionary.Type.SNOWY, 1.1f);
        this.envFactor(BiomeDictionary.Type.DRY, 0.75f);
        this.envFactor(BiomeDictionary.Type.HOT, 0.9f);
        this.addDropCreator((IDropCreator)new DropCreatorInvoluntarySeed());
        this.setRequiresTileEntity(true);
        this.leavesProperties.setTree(treeFamily);
    }

    public Species.LogsAndSticks getLogsAndSticks(float volume) {
        return super.getLogsAndSticks(1.0f + volume);
    }

    public boolean isBiomePerfect(Biome biome) {
        return SpeciesMapleTwiglet.isOneOfBiomes((Biome)biome, (Biome[])new Biome[]{(Biome)BOPBiomes.tundra.orNull(), (Biome)BOPBiomes.snowy_tundra.orNull()});
    }

    private Species getMapleSpecies() {
        return TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesbop", "maple"));
    }

    public ItemStack getSeedStack(int qty) {
        return this.getMapleSpecies().getSeedStack(qty);
    }

    public Seed getSeed() {
        return this.getMapleSpecies().getSeed();
    }
}

