/*
 * Decompiled with CFR 0.152.
 */
package dynamictreesbop.trees.species;

import biomesoplenty.api.item.BOPItems;
import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.treedata.IDropCreator;
import com.ferreusveritas.dynamictrees.entities.EntityFallingTree;
import com.ferreusveritas.dynamictrees.models.ModelEntityFallingTree;
import com.ferreusveritas.dynamictrees.seasons.SeasonHelper;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenFruit;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import dynamictreesbop.ModConfigs;
import dynamictreesbop.ModContent;
import dynamictreesbop.dropcreators.DropCreatorFruit;
import dynamictreesbop.trees.species.SpeciesFloweringOak;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class SpeciesPeach
extends SpeciesFloweringOak {
    public static final int PEACH_FLOWER_COLOR = 16759020;
    public static float fruitingOffset = 0.0f;

    public SpeciesPeach(TreeFamily treeFamily) {
        super(new ResourceLocation("dynamictreesbop", "peach"), treeFamily, ModContent.peachLeavesProperties[0]);
        this.addValidLeavesBlocks(ModContent.peachLeavesProperties);
        ModContent.peachLeavesProperties[0].setTree(treeFamily);
        ModContent.peachLeavesProperties[1].setTree(treeFamily);
        this.generateSeed();
        this.setFlowerSeasonHold(fruitingOffset - 0.5f, fruitingOffset + 0.5f);
        this.addDropCreator((IDropCreator)new DropCreatorFruit(BOPItems.peach));
        this.addGenFeature((IGenFeature)new FeatureGenFruit(ModContent.peachFruit).setRayDistance(4.0f));
    }

    public boolean generate(World world, BlockPos rootPos, Biome biome, Random random, int radius, SafeChunkBounds safeBounds) {
        if (ModConfigs.enablePeachTrees) {
            return super.generate(world, rootPos, biome, random, radius, safeBounds);
        }
        Species def = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesbop", "floweringoak"));
        return def.generate(world, rootPos, biome, random, radius, safeBounds);
    }

    public float seasonalFruitProductionFactor(World world, BlockPos pos) {
        float offset = fruitingOffset;
        return SeasonHelper.globalSeasonalFruitProductionFactor((World)world, (BlockPos)pos, (float)offset);
    }

    public boolean testFlowerSeasonHold(World world, BlockPos pos, float seasonValue) {
        return SeasonHelper.isSeasonBetween((float)seasonValue, (float)this.flowerSeasonHoldMin, (float)this.flowerSeasonHoldMax);
    }

    @Override
    public int colorTreeQuads(int defaultColor, ModelEntityFallingTree.TreeQuadData treeQuad, @Nullable EntityFallingTree entity) {
        return treeQuad.bakedQuad.func_178211_c() != 0 ? 16759020 : defaultColor;
    }

    @Override
    public int saplingColorMultiplier(IBlockState state, IBlockAccess access, BlockPos pos, int tintIndex) {
        return tintIndex != 0 ? 16759020 : this.getLeavesProperties().foliageColorMultiplier(state, access, pos);
    }
}

