/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.item;

import java.text.NumberFormat;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sonar.fluxnetworks.api.translate.FluxTranslate;
import sonar.fluxnetworks.api.utils.EnergyType;
import sonar.fluxnetworks.client.FluxColorHandler;
import sonar.fluxnetworks.common.core.FluxUtils;
import sonar.fluxnetworks.common.data.FluxNetworkData;

public class ItemFluxConnector
extends ItemBlock {
    public static String CUSTOM_NAME = "customName";
    public static String PRIORITY = "priority";
    public static String SURGE_MODE = "surgeMode";
    public static String LIMIT = "limit";
    public static String DISABLE_LIMIT = "disableLimit";

    public ItemFluxConnector(Block block) {
        super(block);
    }

    public String func_77653_i(ItemStack stack) {
        NBTTagCompound tag = stack.func_179543_a("FluxData");
        if (tag != null && tag.func_74764_b(CUSTOM_NAME)) {
            return tag.func_74779_i(CUSTOM_NAME);
        }
        return super.func_77653_i(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        NBTTagCompound tag = stack.func_179543_a("FluxData");
        if (tag != null) {
            tooltip.add(FluxTranslate.NETWORK_FULL_NAME.t() + ": " + TextFormatting.WHITE + FluxColorHandler.getOrRequestNetworkName(tag.func_74762_e(FluxNetworkData.NETWORK_ID)));
            tooltip.add(FluxTranslate.TRANSFER_LIMIT.t() + ": " + TextFormatting.WHITE + FluxUtils.format(tag.func_74763_f(LIMIT), FluxUtils.TypeNumberFormat.COMMAS, EnergyType.RF.getStorageSuffix()));
            tooltip.add(FluxTranslate.PRIORITY.t() + ": " + TextFormatting.WHITE + tag.func_74762_e(PRIORITY));
            if (tag.func_74764_b("energy")) {
                tooltip.add(FluxTranslate.ENERGY_STORED.t() + ": " + TextFormatting.WHITE + NumberFormat.getInstance().format(tag.func_74763_f("energy")) + "RF");
            } else {
                tooltip.add(FluxTranslate.INTERNAL_BUFFER.t() + ": " + TextFormatting.WHITE + FluxUtils.format(tag.func_74763_f("buffer"), FluxUtils.TypeNumberFormat.COMMAS, "RF"));
            }
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }
}

