/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees;

import com.ferreusveritas.dynamictrees.ModConfigs;
import com.ferreusveritas.dynamictrees.ModTrees;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.blocks.BlockBonsaiPot;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicSapling;
import com.ferreusveritas.dynamictrees.blocks.BlockFruit;
import com.ferreusveritas.dynamictrees.blocks.BlockFruitCocoa;
import com.ferreusveritas.dynamictrees.blocks.BlockLeavesSnow;
import com.ferreusveritas.dynamictrees.blocks.BlockRooty;
import com.ferreusveritas.dynamictrees.blocks.BlockRootyDirt;
import com.ferreusveritas.dynamictrees.blocks.BlockRootyDirtFake;
import com.ferreusveritas.dynamictrees.blocks.BlockRootySand;
import com.ferreusveritas.dynamictrees.blocks.BlockTrunkShell;
import com.ferreusveritas.dynamictrees.blocks.LeavesPaging;
import com.ferreusveritas.dynamictrees.blocks.LeavesProperties;
import com.ferreusveritas.dynamictrees.systems.DirtHelper;
import com.ferreusveritas.dynamictrees.util.LazyValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="dynamictrees")
public class ModBlocks {
    public static BlockRooty blockRootyDirt;
    public static BlockRooty blockRootySand;
    public static BlockRooty blockRootyDirtSpecies;
    public static Block blockRootyDirtFake;
    public static BlockDynamicSapling blockDynamicSapling;
    public static BlockFruit blockApple;
    public static BlockFruitCocoa blockFruitCocoa;
    public static BlockBonsaiPot blockBonsaiPot;
    public static BlockTrunkShell blockTrunkShell;
    public static LazyValue<BlockSnow> blockLeavesSnow;
    public static Map<String, ILeavesProperties> leaves;
    public static CommonBlockStates blockStates;

    public static void preInit() {
        BlockDynamicLeaves.passableLeavesModLoaded = Loader.isModLoaded((String)"passableleaves");
        blockRootyDirt = new BlockRootyDirt(false);
        blockRootySand = new BlockRootySand(false);
        blockRootyDirtSpecies = new BlockRootyDirt(true);
        blockRootyDirtFake = new BlockRootyDirtFake("rootydirtfake");
        blockDynamicSapling = new BlockDynamicSapling("sapling");
        blockBonsaiPot = new BlockBonsaiPot();
        blockFruitCocoa = new BlockFruitCocoa();
        blockApple = new BlockFruit().setDroppedItem(new ItemStack(Items.field_151034_e));
        blockTrunkShell = new BlockTrunkShell();
        blockLeavesSnow = ModConfigs.enableAltLeavesSnow ? LazyValue.of(new BlockLeavesSnow()) : LazyValue.supplied(() -> (BlockSnow)Block.func_149684_b((String)"snow_layer"));
        blockStates = new CommonBlockStates();
        ModBlocks.setupLeavesProperties();
    }

    public static void setupLeavesProperties() {
        leaves = LeavesPaging.build(new ResourceLocation("dynamictrees", "leaves/common.json"));
        leaves.put("cactus", new LeavesProperties(null, ItemStack.field_190927_a, TreeRegistry.findCellKit("bare")));
    }

    @SubscribeEvent
    public static void register(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        ArrayList<Block> treeBlocks = new ArrayList<Block>();
        ModTrees.baseFamilies.forEach(tree -> tree.getRegisterableBlocks(treeBlocks));
        ModTrees.dynamicCactus.getRegisterableBlocks(treeBlocks);
        treeBlocks.addAll(LeavesPaging.getLeavesMapForModId("dynamictrees").values());
        registry.registerAll((IForgeRegistryEntry[])new Block[]{blockRootyDirt, blockRootySand, blockRootyDirtSpecies, blockRootyDirtFake, blockDynamicSapling, blockBonsaiPot, blockFruitCocoa, blockApple, blockTrunkShell});
        if (ModConfigs.enableAltLeavesSnow) {
            registry.register((IForgeRegistryEntry)blockLeavesSnow.get());
        }
        registry.registerAll((IForgeRegistryEntry[])treeBlocks.toArray(new Block[0]));
        DirtHelper.registerSoil(Blocks.field_150346_d, "dirtlike");
        DirtHelper.registerSoil((Block)Blocks.field_150349_c, "dirtlike");
        DirtHelper.registerSoil((Block)Blocks.field_150391_bh, "dirtlike");
        DirtHelper.registerSoil(blockRootyDirt, "dirtlike");
        DirtHelper.registerSoil(blockRootyDirtFake, "dirtlike");
        DirtHelper.registerSoil(blockRootyDirtSpecies, "dirtlike");
        DirtHelper.registerSoil((Block)Blocks.field_150354_m, "sandlike");
        DirtHelper.registerSoil(blockRootySand, "sandlike");
        DirtHelper.registerSoil(Blocks.field_150351_n, "gravellike");
        DirtHelper.registerSoil((Block)Blocks.field_150355_j, "waterlike");
        DirtHelper.registerSoil(Blocks.field_150405_ch, "hardclaylike");
        DirtHelper.registerSoil(Blocks.field_150406_ce, "hardclaylike");
        DirtHelper.registerSoil((Block)Blocks.field_150391_bh, "funguslike");
        DirtHelper.registerSoil(Blocks.field_150424_aL, "netherlike");
        DirtHelper.registerSoil(Blocks.field_150425_aM, "netherlike");
    }

    static {
        leaves = new HashMap<String, ILeavesProperties>();
    }

    public static class CommonBlockStates {
        public final IBlockState air = Blocks.field_150350_a.func_176223_P();
        public final IBlockState dirt = Blocks.field_150346_d.func_176223_P();
        public final IBlockState sand = Blocks.field_150354_m.func_176223_P();
        public final IBlockState grass = Blocks.field_150349_c.func_176223_P();
        public final IBlockState podzol = this.dirt.func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.PODZOL);
        public final IBlockState redMushroom = Blocks.field_150337_Q.func_176223_P();
        public final IBlockState brownMushroom = Blocks.field_150338_P.func_176223_P();
        public final LazyValue<IBlockState> snowLayer = LazyValue.supplied(() -> blockLeavesSnow.get().func_176223_P());
    }
}

