/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.blocks;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.ModTabs;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.blocks.BlockBranchThick;
import com.ferreusveritas.dynamictrees.entities.EntityFallingTree;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;

public class BlockSurfaceRoot
extends Block {
    public static final int RADMAX_NORMAL = 8;
    protected static final PropertyInteger RADIUS = PropertyInteger.func_177719_a((String)"radius", (int)1, (int)8);
    public static final IUnlistedProperty GROUNDED = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"grounded"));
    public static final IUnlistedProperty[] CONNECTIONS = new IUnlistedProperty[]{new Properties.PropertyAdapter((IProperty)PropertyInteger.func_177719_a((String)"radiuss", (int)0, (int)8)), new Properties.PropertyAdapter((IProperty)PropertyInteger.func_177719_a((String)"radiusw", (int)0, (int)8)), new Properties.PropertyAdapter((IProperty)PropertyInteger.func_177719_a((String)"radiusn", (int)0, (int)8)), new Properties.PropertyAdapter((IProperty)PropertyInteger.func_177719_a((String)"radiuse", (int)0, (int)8))};
    public static final IUnlistedProperty[] LEVELS = new IUnlistedProperty[]{new Properties.PropertyAdapter((IProperty)PropertyEnum.func_177709_a((String)"levels", ConnectionLevel.class)), new Properties.PropertyAdapter((IProperty)PropertyEnum.func_177709_a((String)"levelw", ConnectionLevel.class)), new Properties.PropertyAdapter((IProperty)PropertyEnum.func_177709_a((String)"leveln", ConnectionLevel.class)), new Properties.PropertyAdapter((IProperty)PropertyEnum.func_177709_a((String)"levele", ConnectionLevel.class))};
    public static final CoordUtils.Surround[] sidesFirst = new CoordUtils.Surround[]{CoordUtils.Surround.N, CoordUtils.Surround.S, CoordUtils.Surround.W, CoordUtils.Surround.E, CoordUtils.Surround.NW, CoordUtils.Surround.NE, CoordUtils.Surround.SW, CoordUtils.Surround.SE};

    public BlockSurfaceRoot(Material material, String name) {
        super(material);
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)RADIUS, (Comparable)Integer.valueOf(1)));
        this.setHarvestLevel("axe", 0);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149711_c(2.5f);
        this.func_149752_b(1.0f);
        this.func_149647_a(ModTabs.dynamicTreesTab);
    }

    protected BlockStateContainer func_180661_e() {
        IProperty[] listedProperties = new IProperty[]{RADIUS};
        IUnlistedProperty[] unlistedProperties = new IUnlistedProperty[]{CONNECTIONS[0], CONNECTIONS[1], CONNECTIONS[2], CONNECTIONS[3], LEVELS[0], LEVELS[1], LEVELS[2], LEVELS[3], GROUNDED};
        return new ExtendedBlockState((Block)this, listedProperties, unlistedProperties);
    }

    public IProperty<?>[] getIgnorableProperties() {
        return new IProperty[]{RADIUS};
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)RADIUS, (Comparable)Integer.valueOf((meta & 7) + 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)RADIUS) - 1;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state instanceof IExtendedBlockState) {
            IExtendedBlockState retval = (IExtendedBlockState)state;
            int thisRadius = this.getRadius(state);
            retval = retval.withProperty(GROUNDED, (Object)world.isSideSolid(pos.func_177977_b(), EnumFacing.UP, false));
            for (EnumFacing dir : EnumFacing.field_176754_o) {
                RootConnection conn = this.getSideConnectionRadius(world, pos, thisRadius, dir);
                if (conn == null) continue;
                int horIndex = dir.func_176736_b();
                retval = retval.withProperty(CONNECTIONS[horIndex], (Object)conn.radius).withProperty(LEVELS[horIndex], (Object)conn.level);
            }
            return retval;
        }
        return state;
    }

    public int getRadius(IBlockState blockState) {
        return blockState.func_177230_c() == this ? (Integer)blockState.func_177229_b((IProperty)RADIUS) : 0;
    }

    public int setRadius(World world, BlockPos pos, int radius, EnumFacing originDir, int flags) {
        world.func_180501_a(pos, this.getStateForRadius(radius), flags);
        return radius;
    }

    public IBlockState getStateForRadius(int radius) {
        return this.func_176223_P().func_177226_a((IProperty)RADIUS, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)radius, (int)0, (int)this.getMaxRadius())));
    }

    public int getMaxRadius() {
        return 8;
    }

    public int getRadialHeight(int radius) {
        return radius * 2;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos) {
        if (state.func_177230_c() != this) {
            return field_185506_k;
        }
        AxisAlignedBB trunkBB = null;
        for (CoordUtils.Surround dir : sidesFirst) {
            BlockPos dPos = pos.func_177971_a(dir.getOffset());
            IBlockState testState = blockAccess.func_180495_p(dPos);
            if (!(testState.func_177230_c() instanceof BlockBranchThick)) continue;
            BlockBranchThick trunk = (BlockBranchThick)testState.func_177230_c();
            trunkBB = trunk.func_185496_a(testState, blockAccess, dPos).func_186670_a(dir.getOffsetPos()).func_191500_a(field_185505_j);
            break;
        }
        int thisRadius = this.getRadius(state);
        int radialHeight = this.getRadialHeight(thisRadius);
        double radius = (double)thisRadius / 16.0;
        double gap = 0.5 - radius;
        AxisAlignedBB aabb = new AxisAlignedBB(-radius, 0.0, -radius, radius, (double)radialHeight / 16.0, radius);
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            RootConnection conn = this.getSideConnectionRadius(blockAccess, pos, thisRadius, dir);
            if (conn == null) continue;
            aabb = aabb.func_72321_a((double)dir.func_82601_c() * gap, (double)dir.func_96559_d() * gap, (double)dir.func_82599_e() * gap);
            if (conn.level != ConnectionLevel.HIGH) continue;
            aabb = aabb.func_186666_e(1.0 + (double)radialHeight / 16.0);
        }
        aabb = aabb.func_72317_d(0.5, 0.0, 0.5);
        return trunkBB != null ? trunkBB.func_111270_a(aabb) : aabb;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean p_185477_7_) {
        if (entityIn instanceof EntityFallingTree) {
            return;
        }
        boolean connectionMade = false;
        int thisRadius = this.getRadius(state);
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            RootConnection conn = this.getSideConnectionRadius((IBlockAccess)world, pos, thisRadius, dir);
            if (conn == null) continue;
            connectionMade = true;
            int r = MathHelper.func_76125_a((int)conn.radius, (int)1, (int)thisRadius);
            double radius = (double)r / 16.0;
            double radialHeight = (double)this.getRadialHeight(r) / 16.0;
            double gap = 0.5 - radius;
            AxisAlignedBB aabb = new AxisAlignedBB(-radius, 0.0, -radius, radius, radialHeight, radius);
            aabb = aabb.func_72321_a((double)dir.func_82601_c() * gap, 0.0, (double)dir.func_82599_e() * gap).func_72317_d(0.5, 0.0, 0.5);
            BlockSurfaceRoot.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)aabb);
        }
        if (!connectionMade) {
            double radius = (double)thisRadius / 16.0;
            double radialHeight = (double)this.getRadialHeight(thisRadius) / 16.0;
            AxisAlignedBB aabb = new AxisAlignedBB(0.5 - radius, 0.0, 0.5 - radius, 0.5 + radius, radialHeight, 0.5 + radius);
            BlockSurfaceRoot.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)aabb);
        }
    }

    protected RootConnection getSideConnectionRadius(IBlockAccess blockAccess, BlockPos pos, int radius, EnumFacing side) {
        if (side.func_176740_k().func_176722_c()) {
            ConnectionLevel level;
            BlockPos dPos = pos.func_177972_a(side);
            IBlockState blockState = blockAccess.func_180495_p(dPos);
            IBlockState upState = blockAccess.func_180495_p(pos.func_177984_a());
            ConnectionLevel connectionLevel = upState.func_177230_c() == Blocks.field_150350_a && blockState.func_185915_l() ? ConnectionLevel.HIGH : (level = blockState.func_177230_c() == Blocks.field_150350_a ? ConnectionLevel.LOW : ConnectionLevel.MID);
            if (level != ConnectionLevel.MID) {
                dPos = dPos.func_177981_b(level.yOffset);
                blockState = blockAccess.func_180495_p(dPos);
            }
            if (blockState.func_177230_c() instanceof BlockSurfaceRoot) {
                return new RootConnection(level, ((BlockSurfaceRoot)blockState.func_177230_c()).getRadius(blockState));
            }
            if (level == ConnectionLevel.MID && TreeHelper.isBranch(blockState) && TreeHelper.getTreePart(blockState).getRadius(blockState) >= 8) {
                return new RootConnection(ConnectionLevel.MID, 8);
            }
        }
        return null;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        IBlockState upstate = worldIn.func_180495_p(pos.func_177984_a());
        if (upstate.func_177230_c() == ModBlocks.blockTrunkShell) {
            worldIn.func_175656_a(pos, upstate);
        }
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            BlockPos dPos = pos.func_177972_a(dir).func_177977_b();
            worldIn.func_180495_p(dPos).func_189546_a(worldIn, dPos, (Block)this, pos);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos neighbor) {
        if (!this.canBlockStay(world, pos, state)) {
            world.func_175698_g(pos);
        }
    }

    protected boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        BlockPos below = pos.func_177977_b();
        IBlockState belowState = world.func_180495_p(below);
        int thisRadius = this.getRadius(state);
        if (belowState.func_185915_l()) {
            for (EnumFacing dir : EnumFacing.field_176754_o) {
                RootConnection conn = this.getSideConnectionRadius((IBlockAccess)world, pos, thisRadius, dir);
                if (conn == null || conn.radius <= thisRadius) continue;
                return true;
            }
        } else {
            boolean connections = false;
            for (EnumFacing dir : EnumFacing.field_176754_o) {
                RootConnection conn = this.getSideConnectionRadius((IBlockAccess)world, pos, thisRadius, dir);
                if (conn == null) continue;
                if (conn.level == ConnectionLevel.MID) {
                    return false;
                }
                if (conn.radius <= thisRadius) continue;
                connections = true;
            }
            return connections;
        }
        return false;
    }

    public class RootConnection {
        public ConnectionLevel level;
        public int radius;

        public RootConnection(ConnectionLevel level, int radius) {
            this.level = level;
            this.radius = radius;
        }
    }

    public static enum ConnectionLevel implements IStringSerializable
    {
        MID(0),
        LOW(-1),
        HIGH(1);

        private final int yOffset;

        private ConnectionLevel(int y) {
            this.yOffset = y;
        }

        public String func_176610_l() {
            return this.toString().toLowerCase();
        }

        public int getYOffset() {
            return this.yOffset;
        }
    }
}

