/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces;

import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftGenerator;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.MineshaftVariantSettings;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.MineshaftPiece;
import java.util.List;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockRail;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;

public class LayeredIntersection4
extends MineshaftPiece {
    private static final int SECONDARY_AXIS_LEN = 7;
    private static final int Y_AXIS_LEN = 9;
    private static final int MAIN_AXIS_LEN = 7;
    private static final int LOCAL_X_END = 6;
    private static final int LOCAL_Y_END = 8;
    private static final int LOCAL_Z_END = 6;

    public LayeredIntersection4() {
    }

    public LayeredIntersection4(int i, int pieceChainLen, Random random, StructureBoundingBox blockBox, EnumFacing direction, MineshaftVariantSettings settings) {
        super(i, pieceChainLen, settings);
        this.func_186164_a(direction);
        this.field_74887_e = blockBox;
    }

    public static StructureBoundingBox determineBoxPosition(List<StructureComponent> list, Random random, int x, int y, int z, EnumFacing direction) {
        StructureBoundingBox blockBox = new StructureBoundingBox(x, y - 3, z, x, y - 3 + 9 - 1, z);
        switch (direction) {
            default: {
                blockBox.field_78893_d = x + 5;
                blockBox.field_78897_a = x - 1;
                blockBox.field_78896_c = z - 6;
                break;
            }
            case SOUTH: {
                blockBox.field_78893_d = x + 1;
                blockBox.field_78897_a = x - 5;
                blockBox.field_78892_f = z + 6;
                break;
            }
            case WEST: {
                blockBox.field_78897_a = x - 6;
                blockBox.field_78892_f = z;
                blockBox.field_78896_c = z - 5;
                break;
            }
            case EAST: {
                blockBox.field_78893_d = x + 6;
                blockBox.field_78892_f = z + 4;
                blockBox.field_78896_c = z - 1;
            }
        }
        StructureComponent intersectingPiece = StructureComponent.func_74883_a(list, (StructureBoundingBox)blockBox);
        return intersectingPiece != null ? null : blockBox;
    }

    @Override
    public void func_74861_a(StructureComponent structurePiece, List<StructureComponent> list, Random random) {
        EnumFacing direction = this.func_186165_e();
        if (direction == null) {
            return;
        }
        switch (direction) {
            default: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c(), this.pieceChainLen);
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78892_f - 5, EnumFacing.EAST, this.func_74877_c(), this.pieceChainLen);
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78892_f - 1, EnumFacing.WEST, this.func_74877_c(), this.pieceChainLen);
                break;
            }
            case SOUTH: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c(), this.pieceChainLen);
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78896_c + 1, EnumFacing.EAST, this.func_74877_c(), this.pieceChainLen);
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78896_c + 5, EnumFacing.WEST, this.func_74877_c(), this.pieceChainLen);
                break;
            }
            case WEST: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78892_f, EnumFacing.WEST, this.func_74877_c(), this.pieceChainLen);
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78893_d - 5, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c(), this.pieceChainLen);
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c(), this.pieceChainLen);
                break;
            }
            case EAST: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78896_c + 1, EnumFacing.EAST, this.func_74877_c(), this.pieceChainLen);
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78897_a + 5, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c(), this.pieceChainLen);
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c(), this.pieceChainLen);
            }
        }
    }

    @ParametersAreNonnullByDefault
    public boolean func_74875_a(World world, Random random, StructureBoundingBox box) {
        if (this.func_74860_a(world, box)) {
            return false;
        }
        if (this.isInOcean(world, 0, 0) || this.isInOcean(world, 6, 6)) {
            return false;
        }
        this.chanceReplaceNonAir(world, box, random, this.settings.replacementRate, 0, 1, 0, 6, 8, 6, this.getMainSelector());
        this.chanceReplaceNonAir(world, box, random, this.settings.replacementRate, 0, 0, 0, 6, 0, 6, this.getFloorSelector());
        this.fill(world, box, 2, 1, 2, 4, 1, 4, AIR);
        this.fill(world, box, 2, 2, 1, 4, 2, 5, AIR);
        this.fill(world, box, 2, 3, 0, 4, 6, 6, AIR);
        this.fill(world, box, 0, 3, 2, 6, 6, 4, AIR);
        this.replaceNonAir(world, box, 2, 0, 0, 4, 2, 6, this.getMainBlock());
        this.fill(world, box, 2, 2, 0, 2, 3, 1, this.getMainBlock());
        this.chanceReplaceNonAir(world, box, random, 0.1f, 2, 2, 0, 2, 3, 1, this.getBrickSelector());
        this.fill(world, box, 4, 2, 0, 4, 3, 1, this.getMainBlock());
        this.chanceReplaceNonAir(world, box, random, 0.1f, 4, 2, 0, 4, 3, 1, this.getBrickSelector());
        this.fill(world, box, 2, 2, 5, 2, 3, 6, this.getMainBlock());
        this.chanceReplaceNonAir(world, box, random, 0.1f, 2, 2, 5, 2, 3, 6, this.getBrickSelector());
        this.fill(world, box, 4, 2, 5, 4, 3, 6, this.getMainBlock());
        this.chanceReplaceNonAir(world, box, random, 0.1f, 4, 2, 5, 4, 3, 6, this.getBrickSelector());
        this.chanceAddBlock(world, random, 0.5f, Blocks.field_150448_aq.func_176223_P().func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_SOUTH), 3, 3, 0, box);
        this.chanceAddBlock(world, random, 0.5f, Blocks.field_150448_aq.func_176223_P().func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_SOUTH), 3, 2, 1, box);
        this.chanceAddBlock(world, random, 0.5f, Blocks.field_150448_aq.func_176223_P().func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_SOUTH), 3, 1, 2, box);
        this.chanceAddBlock(world, random, 0.5f, Blocks.field_150448_aq.func_176223_P().func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_NORTH), 3, 1, 4, box);
        this.chanceAddBlock(world, random, 0.5f, Blocks.field_150448_aq.func_176223_P().func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_NORTH), 3, 2, 5, box);
        this.chanceAddBlock(world, random, 0.5f, Blocks.field_150448_aq.func_176223_P().func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_NORTH), 3, 3, 6, box);
        this.func_175811_a(world, this.getMainBlock(), 3, 2, 0, box);
        this.func_175811_a(world, this.getMainBlock(), 3, 1, 1, box);
        this.func_175811_a(world, this.getMainBlock(), 3, 0, 2, box);
        this.func_175811_a(world, this.getMainBlock(), 3, 0, 3, box);
        this.func_175811_a(world, this.getMainBlock(), 3, 0, 4, box);
        this.func_175811_a(world, this.getMainBlock(), 3, 1, 5, box);
        this.func_175811_a(world, this.getMainBlock(), 3, 2, 6, box);
        this.fill(world, box, 0, 3, 2, 1, 3, 4, this.getMainBlock());
        this.fill(world, box, 2, 4, 2, 4, 4, 4, this.getMainBlock());
        this.fill(world, box, 5, 3, 2, 6, 3, 4, this.getMainBlock());
        this.chanceAddBlock(world, random, 0.5f, Blocks.field_150448_aq.func_176223_P().func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)BlockRailBase.EnumRailDirection.EAST_WEST), 0, 4, 3, box);
        this.chanceAddBlock(world, random, 0.5f, Blocks.field_150448_aq.func_176223_P().func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_EAST), 1, 4, 3, box);
        this.chanceFill(world, box, random, 0.5f, 2, 5, 3, 4, 5, 3, Blocks.field_150448_aq.func_176223_P().func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)BlockRailBase.EnumRailDirection.EAST_WEST));
        this.chanceAddBlock(world, random, 0.5f, Blocks.field_150448_aq.func_176223_P().func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_WEST), 5, 4, 3, box);
        this.chanceAddBlock(world, random, 0.5f, Blocks.field_150448_aq.func_176223_P().func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)BlockRailBase.EnumRailDirection.EAST_WEST), 6, 4, 3, box);
        this.addBiomeDecorations(world, box, random, 0, 0, 0, 6, 7, 6);
        this.addVines(world, box, random, 1, 0, 1, 5, 8, 5);
        return true;
    }
}

