/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces;

import com.google.common.collect.Lists;
import com.yungnickyoung.minecraft.bettermineshafts.config.Configuration;
import com.yungnickyoung.minecraft.bettermineshafts.integration.Integrations;
import com.yungnickyoung.minecraft.bettermineshafts.util.BoxUtil;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftGenerator;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.MineshaftVariantSettings;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.MineshaftPiece;
import java.util.List;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockWall;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecartChest;
import net.minecraft.entity.item.EntityMinecartTNT;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraft.world.storage.loot.LootTableList;

public class SmallTunnel
extends MineshaftPiece {
    private final List<Integer> supports = Lists.newLinkedList();
    private static final int SECONDARY_AXIS_LEN = 5;
    private static final int Y_AXIS_LEN = 5;
    private static final int MAIN_AXIS_LEN = 8;
    private static final int LOCAL_X_END = 4;
    private static final int LOCAL_Y_END = 4;
    private static final int LOCAL_Z_END = 7;

    public SmallTunnel() {
    }

    public SmallTunnel(int i, int chunkPieceLen, Random random, StructureBoundingBox blockBox, EnumFacing direction, MineshaftVariantSettings settings) {
        super(i, chunkPieceLen, settings);
        this.func_186164_a(direction);
        this.field_74887_e = blockBox;
    }

    @Override
    @ParametersAreNonnullByDefault
    protected void func_143012_a(NBTTagCompound tag) {
        super.func_143012_a(tag);
        NBTTagList listTag1 = new NBTTagList();
        this.supports.forEach(z -> listTag1.func_74742_a((NBTBase)new NBTTagInt(z.intValue())));
        tag.func_74782_a("Supports", (NBTBase)listTag1);
    }

    @Override
    @ParametersAreNonnullByDefault
    protected void func_143011_b(NBTTagCompound tag, TemplateManager templateManager) {
        super.func_143011_b(tag, templateManager);
        NBTTagList listTag1 = tag.func_150295_c("Supports", 3);
        for (int i = 0; i < listTag1.func_74745_c(); ++i) {
            this.supports.add(listTag1.func_186858_c(i));
        }
    }

    public static StructureBoundingBox determineBoxPosition(List<StructureComponent> list, Random random, int x, int y, int z, EnumFacing direction) {
        StructureBoundingBox blockBox = BoxUtil.boxFromCoordsWithRotation(x, y, z, 5, 5, 8, direction);
        StructureComponent intersectingPiece = StructureComponent.func_74883_a(list, (StructureBoundingBox)blockBox);
        return intersectingPiece != null ? null : blockBox;
    }

    @Override
    @ParametersAreNonnullByDefault
    public void func_74861_a(StructureComponent structurePiece, List<StructureComponent> list, Random random) {
        EnumFacing direction = this.func_186165_e();
        if (direction == null) {
            return;
        }
        switch (direction) {
            default: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, direction, this.func_74877_c(), this.pieceChainLen);
                break;
            }
            case SOUTH: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, direction, this.func_74877_c(), this.pieceChainLen);
                break;
            }
            case WEST: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f, direction, this.func_74877_c(), this.pieceChainLen);
                break;
            }
            case EAST: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, direction, this.func_74877_c(), this.pieceChainLen);
            }
        }
        this.buildSupports(random);
    }

    @ParametersAreNonnullByDefault
    public boolean func_74875_a(World world, Random random, StructureBoundingBox box) {
        if (this.func_74860_a(world, box)) {
            return false;
        }
        if (this.isInOcean(world, 0, 0) || this.isInOcean(world, 4, 7)) {
            return false;
        }
        this.chanceReplaceNonAir(world, box, random, this.settings.replacementRate, 0, 1, 0, 4, 4, 7, this.getMainSelector());
        this.chanceReplaceNonAir(world, box, random, this.settings.replacementRate, 0, 0, 0, 4, 0, 7, this.getFloorSelector());
        this.fill(world, box, 1, 1, 0, 3, 3, 7, AIR);
        this.replaceAir(world, box, 1, 0, 0, 3, 0, 7, this.getMainBlock());
        this.generateSupports(world, box, random);
        this.generateRails(world, box, random);
        this.generateCobwebs(world, box, random);
        this.generateChestCarts(world, box, random, LootTableList.field_186424_f);
        this.generateTntCarts(world, box, random);
        this.addVines(world, box, random, 1, 0, 1, 3, 4, 6);
        this.addBiomeDecorations(world, box, random, 1, 0, 0, 3, 3, 7);
        this.generateTorches(world, box, random);
        return true;
    }

    private void generateCobwebs(World world, StructureBoundingBox box, Random random) {
        this.supports.forEach(z -> {
            this.chanceReplaceAir(world, box, random, Configuration.spawnRates.cobwebSpawnRate, 1, 3, z - 1, 1, 3, z + 1, Blocks.field_150321_G.func_176223_P());
            this.chanceReplaceAir(world, box, random, Configuration.spawnRates.cobwebSpawnRate, 3, 3, z - 1, 3, 3, z + 1, Blocks.field_150321_G.func_176223_P());
        });
    }

    private void generateChestCarts(World world, StructureBoundingBox box, Random random, ResourceLocation lootTableId) {
        for (int z = 0; z <= 7; ++z) {
            BlockPos blockPos;
            if (!(random.nextFloat() < Configuration.spawnRates.smallShaftChestMinecartSpawnRate) || !box.func_175898_b((Vec3i)(blockPos = new BlockPos(this.func_74865_a(2, z), this.func_74862_a(1), this.func_74873_b(2, z)))) || world.func_180495_p(blockPos.func_177977_b()) == AIR) continue;
            EntityMinecartChest chestMinecartEntity = new EntityMinecartChest(world, (double)((float)blockPos.func_177958_n() + 0.5f), (double)((float)blockPos.func_177956_o() + 0.5f), (double)((float)blockPos.func_177952_p() + 0.5f));
            chestMinecartEntity.func_184289_a(lootTableId, random.nextLong());
            world.func_72838_d((Entity)chestMinecartEntity);
        }
    }

    private void generateSupports(World world, StructureBoundingBox box, Random random) {
        IBlockState supportBlock = this.getSupportBlock();
        if (supportBlock.func_177230_c() instanceof BlockFence) {
            supportBlock = supportBlock.func_177226_a((IProperty)BlockFence.field_176528_N, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BlockFence.field_176525_b, (Comparable)Boolean.valueOf(true));
        } else if (supportBlock.func_177230_c() instanceof BlockWall) {
            supportBlock = supportBlock.func_177226_a((IProperty)BlockWall.field_176259_O, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BlockWall.field_176257_M, (Comparable)Boolean.valueOf(true));
        }
        for (int z : this.supports) {
            this.fill(world, box, 1, 1, z, 1, 2, z, this.getSupportBlock());
            this.fill(world, box, 3, 1, z, 3, 2, z, this.getSupportBlock());
            this.fill(world, box, 1, 3, z, 3, 3, z, this.getMainBlock());
            this.chanceReplaceNonAir(world, box, random, 0.25f, 1, 3, z, 3, 3, z, supportBlock);
        }
    }

    private void generateRails(World world, StructureBoundingBox box, Random random) {
        for (int z = 0; z <= 7; ++z) {
            if (!(random.nextFloat() < 0.3f)) continue;
            this.fill(world, box, 2, 1, z, 2, 1, z + 1, Blocks.field_150448_aq.func_176223_P());
            ++z;
        }
    }

    private void generateTntCarts(World world, StructureBoundingBox box, Random random) {
        for (int z = 0; z <= 7; ++z) {
            BlockPos blockPos;
            if (!(random.nextFloat() < Configuration.spawnRates.smallShaftTntMinecartSpawnRate) || !box.func_175898_b((Vec3i)(blockPos = new BlockPos(this.func_74865_a(2, z), this.func_74862_a(1), this.func_74873_b(2, z)))) || world.func_180495_p(blockPos.func_177977_b()) == AIR) continue;
            EntityMinecartTNT tntMinecartEntity = new EntityMinecartTNT(world, (double)((float)blockPos.func_177958_n() + 0.5f), (double)((float)blockPos.func_177956_o() + 0.5f), (double)((float)blockPos.func_177952_p() + 0.5f));
            world.func_72838_d((Entity)tntMinecartEntity);
        }
    }

    private void generateTorches(World world, StructureBoundingBox box, Random random) {
        IBlockState leftTorch = Integrations.getLeftTorch(random);
        IBlockState rightTorch = Integrations.getRightTorch(random);
        for (int z = 0; z <= 7; ++z) {
            int rotation;
            EnumFacing direction;
            boolean canPlace;
            BlockPos adjPos;
            BlockPos pos;
            if (this.supports.contains(z)) continue;
            float r = random.nextFloat();
            if (r < Configuration.spawnRates.torchSpawnRate / 2.0f) {
                pos = new BlockPos(this.func_74865_a(1, z), this.func_74862_a(2), this.func_74873_b(1, z));
                adjPos = new BlockPos(this.func_74865_a(0, z), this.func_74862_a(2), this.func_74873_b(0, z));
                boolean bl = canPlace = leftTorch != null && leftTorch.func_177230_c().func_176196_c(world, pos) && world.func_180495_p(adjPos) != AIR;
                if (!canPlace) continue;
                this.replaceAir(world, box, 1, 2, z, 1, 2, z, leftTorch);
                if (!Integrations.VARIED_COMMODITIES.isTorchVariedCommoditiesCandle(leftTorch)) continue;
                direction = this.func_186165_e();
                if (direction == null) {
                    direction = EnumFacing.NORTH;
                }
                switch (direction) {
                    case WEST: 
                    case EAST: {
                        rotation = 4;
                        break;
                    }
                    default: {
                        rotation = 2;
                    }
                }
                Integrations.VARIED_COMMODITIES.spawnCandleTorchEntity(world, this.func_74865_a(1, z), this.func_74862_a(2), this.func_74873_b(1, z), rotation);
                continue;
            }
            if (!(r < Configuration.spawnRates.torchSpawnRate)) continue;
            pos = new BlockPos(this.func_74865_a(3, z), this.func_74862_a(2), this.func_74873_b(3, z));
            adjPos = new BlockPos(this.func_74865_a(4, z), this.func_74862_a(2), this.func_74873_b(4, z));
            boolean bl = canPlace = rightTorch != null && rightTorch.func_177230_c().func_176196_c(world, pos) && world.func_180495_p(adjPos) != AIR;
            if (!canPlace) continue;
            this.replaceAir(world, box, 3, 2, z, 3, 2, z, rightTorch);
            if (!Integrations.VARIED_COMMODITIES.isTorchVariedCommoditiesCandle(rightTorch)) continue;
            direction = this.func_186165_e();
            if (direction == null) {
                direction = EnumFacing.NORTH;
            }
            switch (direction) {
                case WEST: 
                case EAST: {
                    rotation = 0;
                    break;
                }
                default: {
                    rotation = 6;
                }
            }
            Integrations.VARIED_COMMODITIES.spawnCandleTorchEntity(world, this.func_74865_a(3, z), this.func_74862_a(2), this.func_74873_b(3, z), rotation);
        }
    }

    private void buildSupports(Random random) {
        for (int z = 0; z <= 7; ++z) {
            int r = random.nextInt(7);
            if (r != 0) continue;
            this.supports.add(z);
            z += 5;
        }
    }
}

