/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.networking;

import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.block.AEBaseItemBlockChargeable;
import appeng.bootstrap.BlockRenderingCustomizer;
import appeng.bootstrap.IBlockRendering;
import appeng.bootstrap.IItemRendering;
import appeng.tile.networking.TileEnergyCell;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class BlockEnergyCellRendering
extends BlockRenderingCustomizer {
    private final ResourceLocation baseModel;

    public BlockEnergyCellRendering(ResourceLocation baseModel) {
        this.baseModel = baseModel;
    }

    @Override
    public void customize(IBlockRendering rendering, IItemRendering itemRendering) {
        itemRendering.meshDefinition(this::getItemModel);
    }

    private ModelResourceLocation getItemModel(ItemStack is) {
        double fillFactor = BlockEnergyCellRendering.getFillFactor(is);
        int storageLevel = TileEnergyCell.getStorageLevelFromFillFactor(fillFactor);
        return new ModelResourceLocation(this.baseModel, "fullness=" + storageLevel);
    }

    private static double getFillFactor(ItemStack is) {
        if (!(is.func_77973_b() instanceof IAEItemPowerStorage)) {
            return 0.0;
        }
        AEBaseItemBlockChargeable itemChargeable = (AEBaseItemBlockChargeable)is.func_77973_b();
        double curPower = itemChargeable.getAECurrentPower(is);
        double maxPower = itemChargeable.getAEMaxPower(is);
        return curPower / maxPower;
    }
}

