/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.server.net;

import me.paulf.wings.server.net.Message;
import me.paulf.wings.server.net.clientbound.MessageSetWingSettings;
import me.paulf.wings.server.net.clientbound.MessageSyncFlight;
import me.paulf.wings.server.net.serverbound.MessageControlFlying;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public final class Network
implements IMessageHandler<Message, IMessage> {
    private final SimpleNetworkWrapper network = NetworkRegistry.INSTANCE.newSimpleChannel("wings");

    public Network() {
        this.register(MessageControlFlying.class, 0, Side.SERVER);
        this.register(MessageSyncFlight.class, 1, Side.CLIENT);
        this.register(MessageSetWingSettings.class, 2, Side.CLIENT);
    }

    public void sendToServer(IMessage message) {
        this.network.sendToServer(message);
    }

    public void sendToPlayer(IMessage message, EntityPlayerMP player) {
        this.network.sendTo(message, player);
    }

    public void sendToAllTracking(IMessage message, Entity entity) {
        this.network.sendToAllTracking(message, entity);
    }

    public IMessage onMessage(Message message, MessageContext ctx) {
        FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> message.process(ctx));
        return null;
    }

    public Packet<?> createPacket(IMessage message) {
        return this.network.getPacketFrom(message);
    }

    private void register(Class<? extends Message> cls, int id, Side side) {
        this.network.registerMessage((IMessageHandler)this, cls, id, side);
    }
}

