/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.util;

import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;

public final class SimpleStorage<T>
implements Capability.IStorage<T> {
    private final Function<T, NBTTagCompound> serializer;
    private final Consumer<NBTTagCompound> deserializer;

    private SimpleStorage(Function<T, NBTTagCompound> serializer, Consumer<NBTTagCompound> deserializer) {
        this.serializer = serializer;
        this.deserializer = deserializer;
    }

    public NBTBase writeNBT(Capability<T> capability, T instance, EnumFacing side) {
        return (NBTBase)this.serializer.apply(instance);
    }

    public void readNBT(Capability<T> capability, T instance, EnumFacing side, NBTBase tag) {
        this.deserializer.accept(tag instanceof NBTTagCompound ? (NBTTagCompound)tag : new NBTTagCompound());
    }

    public static <T> SimpleStorage<T> ofVoid() {
        return new SimpleStorage<Object>(instance -> null, tag -> {});
    }

    public static <T> SimpleStorage<T> of(Function<T, NBTTagCompound> serializer, Consumer<NBTTagCompound> deserializer) {
        return new SimpleStorage<T>(serializer, deserializer);
    }
}

