/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.gui;

import com.zuxelus.energycontrol.containers.ContainerRemoteThermalMonitor;
import com.zuxelus.energycontrol.gui.controls.CompactButton;
import com.zuxelus.energycontrol.gui.controls.GuiThermoInvertRedstone;
import com.zuxelus.energycontrol.network.NetworkHelper;
import com.zuxelus.energycontrol.tileentities.TileEntityRemoteThermalMonitor;
import com.zuxelus.energycontrol.tileentities.TileEntityThermalMonitor;
import com.zuxelus.zlib.gui.GuiContainerBase;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiRemoteThermalMonitor
extends GuiContainerBase {
    private static final ResourceLocation TEXTURE = new ResourceLocation("energycontrol", "textures/gui/gui_remote_thermo.png");
    private ContainerRemoteThermalMonitor container;
    private GuiTextField textboxHeat;

    public GuiRemoteThermalMonitor(ContainerRemoteThermalMonitor container) {
        super(container, "tile.remote_thermo.name", TEXTURE);
        this.container = container;
        this.field_146999_f = 178;
        this.field_147000_g = 166;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.func_189646_b(new CompactButton(0, this.field_147003_i + 40, this.field_147009_r - 5 + 20, 22, 12, "-1"));
        this.func_189646_b(new CompactButton(1, this.field_147003_i + 40, this.field_147009_r - 5 + 31, 22, 12, "-10"));
        this.func_189646_b(new CompactButton(2, this.field_147003_i + 5, this.field_147009_r - 5 + 20, 36, 12, "-100"));
        this.func_189646_b(new CompactButton(3, this.field_147003_i + 5, this.field_147009_r - 5 + 31, 36, 12, "-1000"));
        this.func_189646_b(new CompactButton(4, this.field_147003_i + 5, this.field_147009_r - 5 + 42, 57, 12, "-10000"));
        this.func_189646_b(new CompactButton(5, this.field_147003_i + 115, this.field_147009_r - 5 + 20, 22, 12, "+1"));
        this.func_189646_b(new CompactButton(6, this.field_147003_i + 115, this.field_147009_r - 5 + 31, 22, 12, "+10"));
        this.func_189646_b(new CompactButton(7, this.field_147003_i + 136, this.field_147009_r - 5 + 20, 36, 12, "+100"));
        this.func_189646_b(new CompactButton(8, this.field_147003_i + 136, this.field_147009_r - 5 + 31, 36, 12, "+1000"));
        this.func_189646_b(new CompactButton(9, this.field_147003_i + 115, this.field_147009_r - 5 + 42, 57, 12, "+10000"));
        this.func_189646_b(new GuiThermoInvertRedstone(10, this.field_147003_i + 63, this.field_147009_r + 33, (TileEntityThermalMonitor)this.container.te));
        this.textboxHeat = new GuiTextField(10, this.field_146289_q, 63, 16, 51, 12);
        this.textboxHeat.func_146195_b(true);
        this.textboxHeat.func_146180_a(Integer.toString(((TileEntityRemoteThermalMonitor)this.container.te).getHeatLevel()));
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    private void updateHeat(int delta) {
        if (this.textboxHeat != null) {
            int heat = 0;
            try {
                String value = this.textboxHeat.func_146179_b();
                if (!"".equals(value)) {
                    heat = Integer.parseInt(value);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if ((heat += delta) <= 0) {
                heat = 0;
            }
            if (heat >= 1000000) {
                heat = 1000000;
            }
            if (((TileEntityRemoteThermalMonitor)this.container.te).func_145831_w().field_72995_K && ((TileEntityRemoteThermalMonitor)this.container.te).getHeatLevel() != heat) {
                NetworkHelper.updateSeverTileEntity(((TileEntityRemoteThermalMonitor)this.container.te).func_174877_v(), 1, heat);
                ((TileEntityRemoteThermalMonitor)this.container.te).setHeatLevel(heat);
            }
            this.textboxHeat.func_146180_a(Integer.toString(heat));
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.textboxHeat != null) {
            this.textboxHeat.func_146178_a();
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.drawCenteredText(this.name, this.field_146999_f, 6);
        this.drawLeftAlignedText(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.field_147000_g - 96 + 2);
        if (this.textboxHeat != null) {
            this.textboxHeat.func_146194_f();
        }
    }

    public void func_146281_b() {
        this.updateHeat(0);
        super.func_146281_b();
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k >= 10) {
            return;
        }
        int delta = Integer.parseInt(button.field_146126_j.replace("+", ""));
        this.updateHeat(delta);
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        if (keyCode == 1) {
            this.field_146297_k.field_71439_g.func_71053_j();
        } else if (typedChar == '\r') {
            this.updateHeat(0);
        } else if (this.textboxHeat != null && this.textboxHeat.func_146206_l() && (Character.isDigit(typedChar) || typedChar == '\u0000' || typedChar == '\b')) {
            this.textboxHeat.func_146201_a(typedChar, keyCode);
        }
    }
}

