/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.hooks;

import com.hbm.inventory.HeatRecipes;
import com.hbm.inventory.MachineRecipes;
import com.hbm.tileentity.machine.TileEntityChungus;
import com.hbm.tileentity.machine.TileEntityMachineBattery;
import com.hbm.tileentity.machine.TileEntityMachineBoilerElectric;
import com.hbm.tileentity.machine.TileEntityMachineLargeTurbine;
import com.hbm.tileentity.machine.TileEntityMachineTurbine;
import com.hbm.tileentity.machine.TileEntitySolarBoiler;
import com.hbm.tileentity.machine.TileEntityTowerLarge;
import com.hbm.tileentity.machine.TileEntityTowerSmall;
import com.hbm.tileentity.machine.rbmk.RBMKDials;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKBoiler;
import com.zuxelus.hooklib.asm.Hook;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class HBMHooks {
    public static Map<TileEntity, ArrayList> map = new HashMap<TileEntity, ArrayList>();

    @Hook
    public static void update(TileEntityChungus te) {
        if (!map.containsKey(te) || te.func_145831_w().field_72995_K) {
            return;
        }
        ArrayList<Integer> values = new ArrayList<Integer>();
        Object[] outs = MachineRecipes.getTurbineOutput((Fluid)te.types[0]);
        if (outs != null) {
            int processMax = (int)Math.ceil(te.tanks[0].getFluidAmount() / (Integer)outs[2]);
            int processSteam = te.tanks[0].getFluidAmount() / (Integer)outs[2];
            int processWater = (te.tanks[1].getCapacity() - te.tanks[1].getFluidAmount()) / (Integer)outs[1];
            int cycles = Math.min(processMax, Math.min(processSteam, processWater));
            values.add((Integer)outs[2] * cycles);
            values.add((Integer)outs[1] * cycles);
            values.add((Integer)outs[3] * cycles);
        } else {
            values.add(0);
            values.add(0);
            values.add(0);
        }
        map.put((TileEntity)te, values);
    }

    @Hook
    public static void update(TileEntityTowerLarge te) {
        if (!map.containsKey(te) || te.func_145831_w().field_72995_K) {
            return;
        }
        int convert = Math.min(te.tanks[0].getFluidAmount(), te.tanks[1].getCapacity() - te.tanks[1].getFluidAmount());
        ArrayList<Integer> values = new ArrayList<Integer>();
        values.add(convert);
        map.put((TileEntity)te, values);
    }

    @Hook
    public static void update(TileEntityTowerSmall te) {
        if (!map.containsKey(te) || te.func_145831_w().field_72995_K) {
            return;
        }
        int convert = Math.min(te.tanks[0].getFluidAmount(), te.tanks[1].getCapacity() - te.tanks[1].getFluidAmount());
        ArrayList<Integer> values = new ArrayList<Integer>();
        values.add(convert);
        map.put((TileEntity)te, values);
    }

    @Hook
    public static void update(TileEntityRBMKBoiler te) {
        if (!map.containsKey(te) || te.func_145831_w().field_72995_K) {
            return;
        }
        int consumption = 0;
        int output = 0;
        double heatCap = te.getHeatFromSteam(te.steamType);
        double heatProvided = te.heat - heatCap;
        if (heatProvided > 0.0) {
            int waterUsed = (int)Math.floor(heatProvided / RBMKDials.getBoilerHeatConsumption((World)te.func_145831_w()));
            consumption = Math.min(waterUsed, te.feed.getFluidAmount());
            if (te.getFactorFromSteam(te.steamType) != 0.0) {
                output = (int)Math.floor((double)(waterUsed * 100) / te.getFactorFromSteam(te.steamType));
            }
        }
        ArrayList<Integer> values = new ArrayList<Integer>();
        values.add(consumption);
        values.add(output);
        map.put((TileEntity)te, values);
    }

    @Hook
    public static void update(TileEntityMachineTurbine te) {
        int i;
        ArrayList values;
        if (!map.containsKey(te) || te.func_145831_w().field_72995_K) {
            return;
        }
        int cycles = 0;
        Object[] outs = MachineRecipes.getTurbineOutput(te.tanks[0].getFluid() == null ? null : te.tanks[0].getFluid().getFluid());
        if (outs != null) {
            int processMax = 1200;
            int processSteam = te.tanks[0].getFluidAmount() / (Integer)outs[2];
            int processWater = (te.tanks[1].getCapacity() - te.tanks[1].getFluidAmount()) / (Integer)outs[1];
            cycles = Math.min(processMax, Math.min(processSteam, processWater));
        }
        if ((values = map.get(te)) != null && values.size() > 0) {
            for (i = 20; i > 0; --i) {
                values.set(i, values.get(i - 1));
            }
            values.set(0, cycles);
        } else {
            values = new ArrayList();
            for (i = 0; i < 21; ++i) {
                values.add(cycles);
            }
            map.put((TileEntity)te, values);
        }
    }

    @Hook
    public static void update(TileEntityMachineLargeTurbine te) {
        if (!map.containsKey(te) || te.func_145831_w().field_72995_K) {
            return;
        }
        ArrayList<Integer> values = new ArrayList<Integer>();
        Object[] outs = MachineRecipes.getTurbineOutput((Fluid)te.types[0]);
        if (outs != null) {
            int processMax = (int)Math.ceil(Math.ceil((float)te.tanks[0].getFluidAmount() / 10.0f) / (double)((Integer)outs[2]).intValue());
            int processSteam = te.tanks[0].getFluidAmount() / (Integer)outs[2];
            int processWater = (te.tanks[1].getCapacity() - te.tanks[1].getFluidAmount()) / (Integer)outs[1];
            int cycles = Math.min(processMax, Math.min(processSteam, processWater));
            values.add((Integer)outs[2] * cycles);
            values.add((Integer)outs[1] * cycles);
            values.add((Integer)outs[3] * cycles);
        } else {
            values.add(0);
            values.add(0);
            values.add(0);
        }
        map.put((TileEntity)te, values);
    }

    @Hook
    public static void update(TileEntityMachineBattery te) {
        if (!map.containsKey(te) || te.func_145831_w().field_72995_K) {
            return;
        }
        ArrayList values = map.get(te);
        if (values != null && values.size() > 0) {
            for (int i = 20; i > 0; --i) {
                values.set(i, values.get(i - 1));
            }
            values.set(0, te.power);
        } else {
            values = new ArrayList();
            for (int i = 0; i < 21; ++i) {
                values.add(te.power);
            }
            map.put((TileEntity)te, values);
        }
    }

    @Hook
    public static void update(TileEntitySolarBoiler te) {
        if (!map.containsKey(te) || te.func_145831_w().field_72995_K) {
            return;
        }
        int water = 0;
        int steam = 0;
        IFluidTankProperties[] tanks = te.getTankProperties();
        FluidStack stack = tanks[0].getContents();
        if (stack != null) {
            water = stack.amount;
        }
        if ((stack = tanks[1].getContents()) != null) {
            steam = stack.amount;
        }
        int process = te.heat / 10;
        process = Math.min(process, water);
        process = Math.min(process, (tanks[1].getCapacity() - steam) / 100);
        ArrayList<Integer> values = new ArrayList<Integer>();
        values.add(te.heat);
        values.add(process);
        map.put((TileEntity)te, values);
    }

    @Hook
    public static void update(TileEntityMachineBoilerElectric te) {
        if (!map.containsKey(te) || te.func_145831_w().field_72995_K) {
            return;
        }
        Object[] outs = te.tanks[0].getFluid() != null ? HeatRecipes.getBoilerOutput((Fluid)te.tanks[0].getFluid().getFluid()) : null;
        int heat = te.heat;
        if (heat > 2000) {
            heat -= 30;
        }
        heat = te.power > 0L ? (int)((double)heat + Math.min((double)te.power / 10000.0 * 300.0, 150.0)) : (heat -= 100);
        if (heat > 80000) {
            heat = 80000;
        }
        int consumption = 0;
        int output = 0;
        if (outs != null) {
            for (int i = 0; i < heat / (Integer)outs[3]; ++i) {
                if (te.tanks[0].getFluidAmount() < (Integer)outs[2] || te.tanks[1].getFluidAmount() + (Integer)outs[1] > te.tanks[1].getCapacity()) continue;
                consumption += ((Integer)outs[2]).intValue();
                output += ((Integer)outs[1]).intValue();
                if (i == 0) {
                    heat -= 35;
                    continue;
                }
                heat -= 50;
            }
        }
        ArrayList<Integer> values = new ArrayList<Integer>();
        values.add(consumption);
        values.add(output);
        map.put((TileEntity)te, values);
    }
}

