/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.utils;

import ic2.api.crops.ICropSeed;
import java.util.Comparator;
import net.minecraft.item.ItemStack;

public class SeedLibrarySort
implements Comparator<ItemStack> {
    public static final int NO_SORT = -1;
    public static final int GROWTH = 0;
    public static final int GAIN = 1;
    public static final int RESISTANCE = 2;
    public static final int TOTAL = 3;
    public static final SeedLibrarySort NONE = new SeedLibrarySort(-1, false);
    public static final SeedLibrarySort GROWTH_ASC = new SeedLibrarySort(0, false);
    public static final SeedLibrarySort GROWTH_DESC = new SeedLibrarySort(0, true);
    public static final SeedLibrarySort GAIN_ASC = new SeedLibrarySort(1, false);
    public static final SeedLibrarySort GAIN_DESC = new SeedLibrarySort(1, true);
    public static final SeedLibrarySort RESISTANCE_ASC = new SeedLibrarySort(2, false);
    public static final SeedLibrarySort RESISTANCE_DESC = new SeedLibrarySort(2, true);
    public static final SeedLibrarySort TOTAL_ASC = new SeedLibrarySort(3, false);
    public static final SeedLibrarySort TOTAL_DESC = new SeedLibrarySort(3, true);
    public final int sort_type;
    public final boolean descending;

    public SeedLibrarySort(int type, boolean desc) {
        this.sort_type = type;
        this.descending = desc;
    }

    public static SeedLibrarySort getSort(int type, boolean desc) {
        if (type == -1) {
            return NONE;
        }
        if (type == 0) {
            if (desc) {
                return GROWTH_DESC;
            }
            return GROWTH_ASC;
        }
        if (type == 1) {
            if (desc) {
                return GAIN_DESC;
            }
            return GAIN_ASC;
        }
        if (type == 2) {
            if (desc) {
                return RESISTANCE_DESC;
            }
            return RESISTANCE_ASC;
        }
        if (desc) {
            return TOTAL_DESC;
        }
        return TOTAL_ASC;
    }

    @Override
    public int compare(ItemStack seed_1, ItemStack seed_2) {
        int value_2;
        int value_1;
        int scan_2;
        if (this.sort_type == -1) {
            return 0;
        }
        ICropSeed seed = (ICropSeed)seed_1.func_77973_b();
        int scan_1 = seed.getScannedFromStack(seed_1);
        if (scan_1 != (scan_2 = seed.getScannedFromStack(seed_2))) {
            return scan_1 - scan_2;
        }
        if (scan_1 < 4) {
            return 0;
        }
        if (this.sort_type == 0) {
            value_1 = seed.getGrowthFromStack(seed_1);
            value_2 = seed.getGrowthFromStack(seed_2);
        } else if (this.sort_type == 1) {
            value_1 = seed.getGainFromStack(seed_1);
            value_2 = seed.getGainFromStack(seed_2);
        } else if (this.sort_type == 2) {
            value_1 = seed.getResistanceFromStack(seed_1);
            value_2 = seed.getResistanceFromStack(seed_2);
        } else {
            value_1 = seed.getGrowthFromStack(seed_1) + seed.getGainFromStack(seed_1) + seed.getResistanceFromStack(seed_1);
            value_2 = seed.getGrowthFromStack(seed_2) + seed.getGainFromStack(seed_2) + seed.getResistanceFromStack(seed_2);
        }
        if (this.descending) {
            return value_1 - value_2;
        }
        return value_2 - value_1;
    }
}

