/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.extrarails.tileentity;

import java.util.Collection;
import java.util.Optional;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.shadowfacts.extrarails.ExtraRails;
import net.shadowfacts.extrarails.TeleportingManager;
import net.shadowfacts.extrarails.block.base.BlockExtraRail;
import net.shadowfacts.shadowmc.ShadowMC;
import net.shadowfacts.shadowmc.network.PacketRequestTEUpdate;
import net.shadowfacts.shadowmc.tileentity.BaseTileEntity;

public class TileEntityRailTeleporting
extends BaseTileEntity {
    private int color;

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("color", this.color);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.color = tag.func_74762_e("color");
    }

    public void handle(Entity e) {
        if (e instanceof EntityMinecart) {
            EntityMinecart entity = (EntityMinecart)e;
            Collection<TeleportingManager.Pos> positions = TeleportingManager.get(this.color);
            Optional<TeleportingManager.Pos> pos = positions.stream().filter(p -> p.dim != this.field_145850_b.field_73011_w.getDimension() || !p.pos.equals((Object)this.field_174879_c)).findFirst();
            if (pos.isPresent()) {
                TeleportingManager.Pos dest = pos.get();
                if (entity.field_71093_bK != dest.dim) {
                    return;
                }
                WorldServer newWorld = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(dest.dim);
                IBlockState state = newWorld.func_180495_p(dest.pos);
                if (state.func_177230_c() != ExtraRails.blocks.teleportingRail) {
                    return;
                }
                EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockExtraRail.FACING);
                BlockPos teleportTo = dest.pos.func_177972_a(facing);
                entity.func_70107_b((double)teleportTo.func_177958_n() + 0.5, (double)teleportTo.func_177956_o(), (double)teleportTo.func_177952_p() + 0.5);
                entity.func_70012_b((double)teleportTo.func_177958_n() + 0.5, (double)teleportTo.func_177956_o(), (double)teleportTo.func_177952_p() + 0.5, facing.func_185119_l(), entity.field_70125_A);
                TileEntityRailTeleporting.propelMinecart(facing, entity);
            }
        }
    }

    private static void propelMinecart(EnumFacing direction, EntityMinecart minecart) {
        if (direction == EnumFacing.EAST) {
            minecart.field_70159_w = 0.2;
        } else if (direction == EnumFacing.WEST) {
            minecart.field_70159_w = -0.2;
        } else if (direction == EnumFacing.SOUTH) {
            minecart.field_70179_y = 0.2;
        } else if (direction == EnumFacing.NORTH) {
            minecart.field_70179_y = -0.2;
        }
    }

    public void setColor(int color) {
        TeleportingManager.remove(this.color, this.field_145850_b.field_73011_w.getDimension(), this.field_174879_c);
        TeleportingManager.add(color, this.field_145850_b.field_73011_w.getDimension(), this.field_174879_c);
        this.color = color;
        this.func_70296_d();
    }

    public void onLoad() {
        if (!this.field_145850_b.field_72995_K) {
            TeleportingManager.add(this.color, this.field_145850_b.field_73011_w.getDimension(), this.field_174879_c);
        } else {
            ShadowMC.network.sendToServer((IMessage)new PacketRequestTEUpdate((BaseTileEntity)this));
        }
    }

    public void onChunkUnload() {
        this.remove();
    }

    public void remove() {
        TeleportingManager.remove(this.color, this.field_145850_b.field_73011_w.getDimension(), this.field_174879_c);
    }

    public int getColor() {
        return this.color;
    }
}

