/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.difficulty.buffs;

import CoroUtil.difficulty.EquipmentForDifficulty;
import CoroUtil.difficulty.UtilEntityBuffs;
import CoroUtil.difficulty.buffs.BuffBase;
import CoroUtil.difficulty.data.cmods.CmodInventory;
import CoroUtil.difficulty.data.cmods.CmodInventoryDifficultyScaled;
import CoroUtil.difficulty.data.cmods.CmodInventoryEntry;
import CoroUtil.forge.CULog;
import java.util.Iterator;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;

public class BuffInventoryDifficultyScaled
extends BuffBase {
    @Override
    public String getTagName() {
        return UtilEntityBuffs.dataEntityBuffed_InventoryDifficultyScaled;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean applyBuff(EntityCreature ent, float difficulty) {
        CmodInventoryDifficultyScaled cmod = (CmodInventoryDifficultyScaled)UtilEntityBuffs.getCmodData(ent, this.getTagName());
        if (cmod == null) {
            CULog.err("error, couldnt find cmod data for entity, name: " + this.getTagName());
            return false;
        }
        CmodInventory cmodInventory = null;
        for (CmodInventoryEntry entry : cmod.listInventories) {
            if (!((double)difficulty >= entry.min) || !((double)difficulty <= entry.max)) continue;
            cmodInventory = entry.inventory;
            break;
        }
        if (cmodInventory == null) {
            CULog.log("warning, couldnt find an inventory to use given the difficulty of :" + difficulty);
            return false;
        }
        EquipmentForDifficulty equipment = UtilEntityBuffs.getEquipmentItemsFromData(cmodInventory);
        if (equipment.getWeapon() != null) {
            UtilEntityBuffs.setEquipment(ent, EntityEquipmentSlot.MAINHAND, equipment.getWeapon());
        }
        if (equipment.getWeaponOffhand() != null) {
            UtilEntityBuffs.setEquipment(ent, EntityEquipmentSlot.OFFHAND, equipment.getWeaponOffhand());
        }
        Iterator<ItemStack> iterator = equipment.getListArmor().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                if (!(ent instanceof AbstractSkeleton)) return super.applyBuff(ent, difficulty);
                ((AbstractSkeleton)ent).func_85036_m();
                return super.applyBuff(ent, difficulty);
            }
            ItemStack itemStack = iterator.next();
            if (!(itemStack.func_77973_b() instanceof ItemArmor)) continue;
            ItemArmor itemArmor = (ItemArmor)itemStack.func_77973_b();
            UtilEntityBuffs.setEquipment(ent, itemArmor.field_77881_a, itemStack);
        }
    }
}

