/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.forge;

import CoroUtil.ai.IInvasionControlledTask;
import CoroUtil.block.TileEntityRepairingBlock;
import CoroUtil.client.debug.DebugRenderEntry;
import CoroUtil.client.debug.DebugRenderer;
import CoroUtil.config.ConfigCoroUtilAdvanced;
import CoroUtil.config.ConfigHWMonsters;
import CoroUtil.difficulty.DynamicDifficulty;
import CoroUtil.difficulty.UtilEntityBuffs;
import CoroUtil.difficulty.buffs.BuffBase;
import CoroUtil.forge.CULog;
import CoroUtil.forge.CoroUtil;
import CoroUtil.packet.PacketHelper;
import CoroUtil.quest.PlayerQuestManager;
import CoroUtil.test.Headshots;
import CoroUtil.util.CoroUtilCompatibility;
import CoroUtil.util.CoroUtilCrossMod;
import CoroUtil.util.CoroUtilPlayer;
import CoroUtil.util.UtilMining;
import CoroUtil.util.Vec3;
import CoroUtil.world.WorldDirector;
import CoroUtil.world.WorldDirectorManager;
import CoroUtil.world.grid.block.BlockDataPoint;
import CoroUtil.world.grid.chunk.ChunkDataPoint;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EventHandlerForge {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void deathEvent(LivingDeathEvent event) {
        if (event.isCanceled()) {
            return;
        }
        PlayerQuestManager.i().onEvent((Event)event);
        if (CoroUtilCompatibility.isHWInvasionsInstalled() && !event.getEntity().field_70170_p.field_72995_K) {
            if (event.getEntity() instanceof EntityPlayer) {
                DynamicDifficulty.deathPlayer((EntityPlayer)event.getEntity());
                DynamicDifficulty.setInvasionSkipBuff((EntityPlayer)event.getEntity(), 0.0f);
            }
            UtilEntityBuffs.onDeath(event);
        }
    }

    @SubscribeEvent
    public void pickupEvent(EntityItemPickupEvent event) {
        PlayerQuestManager.i().onEvent((Event)event);
    }

    @SubscribeEvent
    public void worldSave(WorldEvent.Save event) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && ((WorldServer)event.getWorld()).field_73011_w.getDimension() == 0) {
            CoroUtil.writeOutData(false);
        }
    }

    @SubscribeEvent
    public void worldLoad(WorldEvent.Load event) {
        if (!event.getWorld().field_72995_K && ((WorldServer)event.getWorld()).field_73011_w.getDimension() == 0 && WorldDirectorManager.instance().getWorldDirector("coroutil", event.getWorld()) == null) {
            WorldDirectorManager.instance().registerWorldDirector(new WorldDirector(true), "coroutil", event.getWorld());
        }
    }

    @SubscribeEvent
    public void breakBlockHarvest(BlockEvent.HarvestDropsEvent event) {
        PlayerQuestManager.i().onEvent((Event)event);
        DynamicDifficulty.handleHarvest(event);
    }

    @SubscribeEvent
    public void breakBlockPlayer(BlockEvent.BreakEvent event) {
        PlayerQuestManager.i().onEvent((Event)event);
    }

    @SubscribeEvent
    public void blockPlayerInteract(PlayerInteractEvent event) {
        if (!event.getWorld().field_72995_K) {
            try {
                if (event instanceof PlayerInteractEvent.RightClickEmpty) {
                    return;
                }
                if (ConfigCoroUtilAdvanced.trackPlayerData) {
                    ChunkDataPoint cdp = WorldDirectorManager.instance().getChunkDataGrid(event.getWorld()).getChunkData(event.getPos().func_177958_n() / 16, event.getPos().func_177952_p() / 16);
                    cdp.addToPlayerActivityInteract(event.getEntityPlayer().func_146103_bH().getId(), 1L);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void entityHurt(LivingHurtEvent event) {
        Headshots.hookLivingHurt(event);
        DynamicDifficulty.logDamage(event);
    }

    @SubscribeEvent
    public void entityKilled(LivingDeathEvent event) {
        DynamicDifficulty.logDeath(event);
    }

    @SubscribeEvent
    public void entityTick(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase ent = event.getEntityLiving();
        if (!ent.field_70170_p.field_72995_K && ent instanceof EntityPlayer) {
            CoroUtilPlayer.trackPlayerForSpeed((EntityPlayer)ent);
        }
        if (ConfigCoroUtilAdvanced.enableDebugRenderer) {
            int rate = 10;
            int range = 10;
            if (ent.field_70170_p.field_72995_K && ent.field_70170_p.func_82737_E() % (long)rate == 0L && ent instanceof EntityPlayer) {
                for (int x = -range; x <= range; ++x) {
                    for (int y = -range; y <= range; ++y) {
                        for (int z = -range; z <= range; ++z) {
                            boolean cantMineTileEntity;
                            BlockPos pos = ent.func_180425_c().func_177982_a(x, y - 1, z);
                            if (ent.field_70170_p.func_175623_d(pos)) continue;
                            boolean collision = UtilMining.blockHasCollision(ent.field_70170_p, pos);
                            boolean isTileEntity = ent.field_70170_p.func_175625_s(pos) != null;
                            boolean cantConvertToRepairing_RegularBlock = !isTileEntity && !UtilMining.canConvertToRepairingBlockNew(ent.field_70170_p, pos, true);
                            boolean bl = cantMineTileEntity = isTileEntity && !UtilMining.canBreakBlockOrTileEntity(ent.field_70170_p, pos, true);
                            if (collision) {
                                if (isTileEntity) {
                                    if (cantMineTileEntity) {
                                        DebugRenderer.addRenderable(new DebugRenderEntry(pos, ent.field_70170_p.func_82737_E() + (long)rate, 0xAA0000));
                                        continue;
                                    }
                                    DebugRenderer.addRenderable(new DebugRenderEntry(pos, ent.field_70170_p.func_82737_E() + (long)rate, 255));
                                    continue;
                                }
                                if (cantConvertToRepairing_RegularBlock) {
                                    DebugRenderer.addRenderable(new DebugRenderEntry(pos, ent.field_70170_p.func_82737_E() + (long)rate, 0xFFFF00));
                                    continue;
                                }
                                DebugRenderer.addRenderable(new DebugRenderEntry(pos, ent.field_70170_p.func_82737_E() + (long)rate, 65280));
                                continue;
                            }
                            if (ent.field_70170_p.func_175623_d(pos)) continue;
                            DebugRenderer.addRenderable(new DebugRenderEntry(pos, ent.field_70170_p.func_82737_E() + (long)rate, 0xFFFFFF));
                        }
                    }
                }
            }
        }
        if (ConfigCoroUtilAdvanced.desirePathDerp) {
            int walkOnRate = 5;
            if (!ent.field_70170_p.field_72995_K && ent.field_70170_p.func_82737_E() % (long)walkOnRate == 0L) {
                int newZ;
                int newY;
                int newX;
                IBlockState state;
                Block id;
                double speed = Math.sqrt(ent.field_70159_w * ent.field_70159_w + ent.field_70181_x * ent.field_70181_x + ent.field_70179_y * ent.field_70179_y);
                if (ent instanceof EntityPlayer) {
                    Vec3 vec = CoroUtilPlayer.getPlayerSpeedCapped((EntityPlayer)ent, 0.1f);
                    speed = Math.sqrt(vec.xCoord * vec.xCoord + vec.yCoord * vec.yCoord + vec.zCoord * vec.zCoord);
                }
                if (speed > 0.08 && (id = (state = ent.field_70170_p.func_180495_p(new BlockPos(newX = MathHelper.func_76128_c((double)ent.field_70165_t), newY = MathHelper.func_76128_c((double)(ent.func_174813_aQ().field_72338_b - 1.0)), newZ = MathHelper.func_76128_c((double)ent.field_70161_v)))).func_177230_c()) == Blocks.field_150349_c) {
                    BlockDataPoint bdp = WorldDirectorManager.instance().getBlockDataGrid(ent.field_70170_p).getBlockData(newX, newY, newZ);
                    bdp.walkedOnAmount += 0.25f;
                    if (bdp.walkedOnAmount > 5.0f) {
                        if (ent.field_70170_p.func_180495_p(new BlockPos(newX, newY + 1, newZ)).func_177230_c() == Blocks.field_150350_a) {
                            ent.field_70170_p.func_175656_a(new BlockPos(newX, newY, newZ), Blocks.field_185774_da.func_176223_P());
                        }
                        bdp.walkedOnAmount = 0.0f;
                        WorldDirectorManager.instance().getBlockDataGrid(ent.field_70170_p).removeBlockDataIfRemovable(newX, newY, newZ);
                    }
                }
            }
        }
        if (!ent.field_70170_p.field_72995_K) {
            if ((ent.field_70170_p.func_82737_E() + (long)ent.func_145782_y()) % 20L == 0L && ConfigCoroUtilAdvanced.removeInvasionAIWhenInvasionDone && ent.getEntityData().func_74767_n(UtilEntityBuffs.dataEntityBuffed) && ent instanceof EntityLiving) {
                EntityLiving entL = (EntityLiving)ent;
                Iterator it = entL.field_70714_bg.field_75782_a.iterator();
                while (it.hasNext()) {
                    EntityAITasks.EntityAITaskEntry task = (EntityAITasks.EntityAITaskEntry)it.next();
                    if (!(task.field_75733_a instanceof IInvasionControlledTask) || !((IInvasionControlledTask)task.field_75733_a).shouldBeRemoved()) continue;
                    task.field_75733_a.func_75251_c();
                    it.remove();
                }
                it = entL.field_70715_bh.field_75782_a.iterator();
                while (it.hasNext()) {
                    EntityAITasks.EntityAITaskEntry task = (EntityAITasks.EntityAITaskEntry)it.next();
                    if (!(task.field_75733_a instanceof IInvasionControlledTask) || !((IInvasionControlledTask)task.field_75733_a).shouldBeRemoved()) continue;
                    task.field_75733_a.func_75251_c();
                    it.remove();
                }
            }
            if (ent.getEntityData().func_74775_l(UtilEntityBuffs.dataEntityBuffed_Data).func_74767_n(UtilEntityBuffs.dataEntityBuffed_AI_Digging)) {
                boolean waterFixLeapOut;
                boolean waterFixCancelPush;
                List list;
                boolean pushMobsAwayForMiners = ConfigCoroUtilAdvanced.minersPushAwayOtherNonMinerMobsWhileMining;
                if (pushMobsAwayForMiners && !(list = ent.field_70170_p.func_175674_a((Entity)ent, ent.func_174813_aQ().func_72314_b(0.5, 0.5, 0.5), EntitySelectors.func_188442_a((Entity)ent))).isEmpty()) {
                    for (int l = 0; l < list.size(); ++l) {
                        double d1;
                        double d0;
                        double d2;
                        boolean canPush;
                        Entity entityIn = (Entity)list.get(l);
                        NBTTagCompound data2 = entityIn.getEntityData().func_74775_l(UtilEntityBuffs.dataEntityBuffed_Data);
                        boolean bl = canPush = !ConfigCoroUtilAdvanced.minersPushAwayOnlyOtherBuffedMobs || ent.getEntityData().func_74767_n(UtilEntityBuffs.dataEntityBuffed);
                        if (!(entityIn instanceof EntityLiving) || ent.func_184223_x(entityIn) || data2.func_74767_n(UtilEntityBuffs.dataEntityBuffed_AI_Digging) || !canPush || entityIn.field_70145_X || ent.field_70145_X || !((d2 = MathHelper.func_76132_a((double)(d0 = entityIn.field_70165_t - ent.field_70165_t), (double)(d1 = entityIn.field_70161_v - ent.field_70161_v))) >= (double)0.01f)) continue;
                        d2 = MathHelper.func_76133_a((double)d2);
                        d0 /= d2;
                        d1 /= d2;
                        double d3 = 1.0 / d2;
                        if (d3 > 1.0) {
                            d3 = 1.0;
                        }
                        d0 *= d3;
                        d1 *= d3;
                        d0 *= 0.1;
                        d1 *= 0.1;
                        d0 *= (double)(1.0f - ent.field_70144_Y);
                        d1 *= (double)(1.0f - ent.field_70144_Y);
                        if (!ent.func_184207_aI()) {
                            entityIn.func_70024_g(d0, 0.0, d1);
                        }
                        if (entityIn.func_184207_aI()) continue;
                        entityIn.func_70024_g(d0, 0.0, d1);
                    }
                }
                if ((waterFixCancelPush = true) && ent.func_70090_H()) {
                    double motionXOld = ent.field_70159_w;
                    double motionYOld = ent.field_70181_x;
                    double motionZOld = ent.field_70179_y;
                    ent.field_70159_w = 0.0;
                    ent.field_70181_x = 0.0;
                    ent.field_70179_y = 0.0;
                    ent.field_70170_p.func_72918_a(ent.func_174813_aQ(), Material.field_151586_h, (Entity)ent);
                    double motionXChange = ent.field_70159_w;
                    double motionYChange = ent.field_70181_x;
                    double motionZChange = ent.field_70179_y;
                    ent.field_70159_w = motionXOld + motionXChange * -1.0;
                    ent.field_70181_x = motionYOld + motionYChange * -1.0;
                    ent.field_70179_y = motionZOld + motionZChange * -1.0;
                }
                if (waterFixLeapOut = true) {
                    String nbtID = "CoroUtil_wasInWater";
                    if (ent.getEntityData().func_74767_n(nbtID) && !ent.func_70090_H() && ent.field_70123_F) {
                        ent.field_70181_x += (double)0.4f;
                    }
                    ent.getEntityData().func_74757_a(nbtID, ent.func_70090_H());
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void entityCreated(EntityJoinWorldEvent event) {
        EntityCreature ent;
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        CoroUtilCrossMod.processSpawnOverride(event);
        if (event.getEntity() instanceof EntityCreature && (ent = (EntityCreature)event.getEntity()).getEntityData().func_74767_n(UtilEntityBuffs.dataEntityBuffed) && !ent.getEntityData().func_74767_n(UtilEntityBuffs.dataEntityInitialSpawn)) {
            float difficultySpawnedIn = 0.0f;
            if (ent.getEntityData().func_74764_b(UtilEntityBuffs.dataEntityBuffed_Difficulty)) {
                difficultySpawnedIn = ent.getEntityData().func_74760_g(UtilEntityBuffs.dataEntityBuffed_Difficulty);
            } else if (ent.field_70170_p.func_175667_e(ent.func_180425_c())) {
                difficultySpawnedIn = DynamicDifficulty.getDifficultyAveragedForArea(ent);
            }
            List<String> buffs = UtilEntityBuffs.getAllBuffNames();
            NBTTagCompound data = ent.getEntityData().func_74775_l(UtilEntityBuffs.dataEntityBuffed_Data);
            for (String buff : buffs) {
                if (!data.func_74767_n(buff)) continue;
                BuffBase buffObj = UtilEntityBuffs.getBuff(buff);
                if (buffObj != null) {
                    CULog.dbg("applyBuffFromReload: " + buff);
                    buffObj.applyBuffFromReload(ent, difficultySpawnedIn);
                    continue;
                }
                CoroUtil.dbg("warning: unable to find buff by name of " + buff);
            }
            UtilEntityBuffs.applyBuffPostAll(ent, difficultySpawnedIn);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void explosionEvent(ExplosionEvent.Detonate event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (ConfigHWMonsters.explosionsTurnIntoRepairingBlocks || ConfigHWMonsters.explosionsDontDestroyTileEntities) {
            boolean protectTileEntities = true;
            List listPos = event.getExplosion().func_180343_e();
            Iterator it = listPos.iterator();
            while (it.hasNext()) {
                BlockPos pos = (BlockPos)it.next();
                if (ConfigHWMonsters.explosionsDontDestroyTileEntities && event.getWorld().func_175625_s(pos) != null) {
                    it.remove();
                    continue;
                }
                if (!ConfigHWMonsters.explosionsTurnIntoRepairingBlocks) continue;
                IBlockState state = event.getWorld().func_180495_p(pos);
                if (UtilMining.canMineBlock(event.getWorld(), pos, state.func_177230_c()) && UtilMining.canConvertToRepairingBlock(event.getWorld(), state)) {
                    TileEntityRepairingBlock.replaceBlockAndBackup(event.getWorld(), pos);
                }
                it.remove();
            }
        }
    }

    @SubscribeEvent
    public void playerCloneEvent(PlayerEvent.Clone event) {
        NBTTagCompound nbtOld = event.getOriginal().getEntityData();
        NBTTagCompound nbtNew = event.getEntityPlayer().getEntityData();
        nbtNew.func_74772_a(DynamicDifficulty.dataPlayerServerTicks, nbtOld.func_74763_f(DynamicDifficulty.dataPlayerServerTicks));
        nbtNew.func_74772_a(DynamicDifficulty.dataPlayerHarvestOre, nbtOld.func_74763_f(DynamicDifficulty.dataPlayerHarvestOre));
        nbtNew.func_74772_a(DynamicDifficulty.dataPlayerHarvestLog, nbtOld.func_74763_f(DynamicDifficulty.dataPlayerHarvestLog));
        nbtNew.func_74772_a(DynamicDifficulty.dataPlayerHarvestRating, nbtOld.func_74763_f(DynamicDifficulty.dataPlayerHarvestRating));
        nbtNew.func_74772_a(DynamicDifficulty.dataPlayerInvasionSkipping, nbtOld.func_74763_f(DynamicDifficulty.dataPlayerInvasionSkipping));
        nbtNew.func_74772_a(DynamicDifficulty.dataPlayerInvasionSkippingTooSoon, nbtOld.func_74763_f(DynamicDifficulty.dataPlayerInvasionSkippingTooSoon));
        nbtNew.func_74772_a(DynamicDifficulty.dataPlayerInvasionSkipCount, nbtOld.func_74763_f(DynamicDifficulty.dataPlayerInvasionSkipCount));
        nbtNew.func_74772_a(DynamicDifficulty.dataPlayerInvasionSkipCountForMultiplier, nbtOld.func_74763_f(DynamicDifficulty.dataPlayerInvasionSkipCountForMultiplier));
        nbtNew.func_74772_a(DynamicDifficulty.dataPlayerInvasionSkipBuff, nbtOld.func_74763_f(DynamicDifficulty.dataPlayerInvasionSkipBuff));
        nbtNew.func_74772_a(DynamicDifficulty.dataPlayerServerTicks, nbtOld.func_74763_f(DynamicDifficulty.dataPlayerServerTicks));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void worldRender(RenderWorldLastEvent event) {
        DebugRenderer.renderDebug(event);
    }

    @SubscribeEvent
    public void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        PacketHelper.syncBlockLists();
    }
}

