/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.gui;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.eventbus.Subscribe;
import java.util.Set;
import net.malisis.core.client.gui.Anchor;
import net.malisis.core.client.gui.ComponentPosition;
import net.malisis.core.client.gui.GuiTexture;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.IKeyListener;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.UISlot;
import net.malisis.core.client.gui.component.container.UIContainer;
import net.malisis.core.client.gui.component.container.UIPlayerInventory;
import net.malisis.core.client.gui.component.container.UITabGroup;
import net.malisis.core.client.gui.component.container.UIWindow;
import net.malisis.core.client.gui.component.decoration.UIImage;
import net.malisis.core.client.gui.component.decoration.UILabel;
import net.malisis.core.client.gui.component.decoration.UITooltip;
import net.malisis.core.client.gui.component.interaction.UIButton;
import net.malisis.core.client.gui.component.interaction.UICheckBox;
import net.malisis.core.client.gui.component.interaction.UIRadioButton;
import net.malisis.core.client.gui.component.interaction.UISelect;
import net.malisis.core.client.gui.component.interaction.UITab;
import net.malisis.core.client.gui.component.interaction.UITextField;
import net.malisis.core.client.gui.event.ComponentEvent;
import net.malisis.core.client.gui.event.component.StateChangeEvent;
import net.malisis.core.inventory.MalisisInventoryContainer;
import net.malisis.core.renderer.icon.Icon;
import net.malisis.core.util.TileEntityUtils;
import net.malisis.doors.DoorDescriptor;
import net.malisis.doors.DoorRegistry;
import net.malisis.doors.gui.Digicode;
import net.malisis.doors.network.DoorFactoryMessage;
import net.malisis.doors.tileentity.DoorFactoryTileEntity;
import net.minecraft.client.resources.I18n;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

public class DoorFactoryGui
extends MalisisGui {
    public static ResourceLocation tabIconsRl = new ResourceLocation("malisisdoors", "textures/gui/doorfactory_tabicons.png");
    public static GuiTexture tabTexture = new GuiTexture(tabIconsRl, 128, 128);
    public static Icon propIcon = tabTexture.getIcon(0, 0, 64, 64);
    public static Icon matIcon = tabTexture.getIcon(64, 0, 64, 64);
    public static Icon dcIcon = tabTexture.getIcon(0, 64, 64, 64);
    private DoorFactoryTileEntity tileEntity;
    private UISelect<String> selDoorMovement;
    private UITextField tfOpenTime;
    private UITextField tfAutoCloseTime;
    private UICheckBox cbDoubleDoor;
    private UICheckBox cbProximity;
    private UISelect<DoorDescriptor.RedstoneBehavior> selRedstone;
    private UISelect<String> selDoorSound;
    private UIRadioButton rbCreate;
    private UIRadioButton rbEdit;
    private UIContainer<?> contCreate;
    private UIContainer<?> contEdit;
    private UIButton btnCreate;
    private Digicode digicode;
    private static String activeTab;

    public DoorFactoryGui(DoorFactoryTileEntity te, MalisisInventoryContainer container) {
        this.setInventoryContainer(container);
        this.tileEntity = te;
    }

    public void construct() {
        UIWindow window = new UIWindow((MalisisGui)this, "tile.door_factory.name", 242, 255);
        UIContainer<?> propContainer = this.getPropertiesContainer();
        UIContainer<?> matContainer = this.getMaterialsContainer();
        UIContainer<?> dcContainer = this.getDigicodeContainer();
        UITabGroup tabGroup = (UITabGroup)new UITabGroup((MalisisGui)this, ComponentPosition.LEFT).setPosition(0, 10);
        int a = 16;
        UITab tabProp = (UITab)new UITab((MalisisGui)this, new UIImage((MalisisGui)this, tabTexture, propIcon).setSize(a, a)).setName("tab_prop");
        ((UITab)tabProp.setTooltip(new UITooltip((MalisisGui)this, "gui.door_factory.tab_properties"))).register((Object)this);
        UITab tabMat = (UITab)new UITab((MalisisGui)this, new UIImage((MalisisGui)this, tabTexture, matIcon).setSize(a, a)).setName("tab_mat");
        ((UITab)tabMat.setTooltip(new UITooltip((MalisisGui)this, "gui.door_factory.tab_materials"))).register((Object)this);
        UITab tabDc = (UITab)new UITab((MalisisGui)this, new UIImage((MalisisGui)this, tabTexture, dcIcon).setSize(a, a)).setName("tab_dc");
        ((UITab)tabDc.setTooltip(new UITooltip((MalisisGui)this, "gui.door_factory.tab_digicode"))).register((Object)this);
        tabGroup.addTab(tabProp, propContainer);
        tabGroup.addTab(tabMat, matContainer);
        tabGroup.addTab(tabDc, dcContainer);
        tabGroup.setActiveTab(activeTab != null ? activeTab : "tab_prop");
        tabGroup.attachTo((UIContainer)window, false);
        this.btnCreate = (UIButton)((UIButton)new UIButton((MalisisGui)this, "gui.door_factory.create_door").setSize(80).setPosition(0, 110, Anchor.CENTER)).register((Object)this);
        UISlot outputSlot = (UISlot)new UISlot((MalisisGui)this, this.tileEntity.outputSlot).setPosition(0, 132, Anchor.CENTER);
        UIPlayerInventory playerInv = new UIPlayerInventory((MalisisGui)this, this.inventoryContainer.getPlayerInventory());
        window.add(new UIComponent[]{playerInv});
        window.add(new UIComponent[]{propContainer});
        window.add(new UIComponent[]{matContainer});
        window.add(new UIComponent[]{dcContainer});
        window.add(new UIComponent[]{this.btnCreate});
        window.add(new UIComponent[]{outputSlot});
        this.addToScreen((UIComponent)tabGroup);
        this.addToScreen((UIComponent)window);
        TileEntityUtils.linkTileEntityToGui((TileEntity)this.tileEntity, (MalisisGui)this);
    }

    private UIContainer<?> getPropertiesContainer() {
        UIContainer propContainer = (UIContainer)new UIContainer((MalisisGui)this, 0, 95).setPosition(0, 15);
        int y = 2;
        this.selDoorMovement = new UISelect((MalisisGui)this, 100, this.getSortedList(DoorRegistry.listMovements().keySet(), "door_movement."));
        this.selDoorMovement.setPosition(0, y, Anchor.RIGHT);
        this.selDoorMovement.setLabelPattern("door_movement.%s").register((Object)this);
        propContainer.add(new UIComponent[]{new UILabel((MalisisGui)this, "gui.door_factory.door_movement").setPosition(0, y + 2)});
        propContainer.add(new UIComponent[]{this.selDoorMovement});
        this.tfOpenTime = (UITextField)((UITextField)new UITextField((MalisisGui)this, null).setSize(30, 0).setPosition(-5, y += 12, Anchor.RIGHT)).register((Object)this);
        propContainer.add(new UIComponent[]{new UILabel((MalisisGui)this, "gui.door_factory.door_open_time").setPosition(0, y + 2)});
        propContainer.add(new UIComponent[]{this.tfOpenTime});
        this.tfAutoCloseTime = (UITextField)((UITextField)new UITextField((MalisisGui)this, null).setSize(30, 0).setPosition(-5, y += 12, Anchor.RIGHT)).register((Object)this);
        propContainer.add(new UIComponent[]{new UILabel((MalisisGui)this, "gui.door_factory.door_auto_close_time").setPosition(0, y + 2)});
        propContainer.add(new UIComponent[]{this.tfAutoCloseTime});
        this.cbDoubleDoor = (UICheckBox)((UICheckBox)new UICheckBox((MalisisGui)this).setPosition(-15, y += 12, Anchor.RIGHT)).register((Object)this);
        propContainer.add(new UIComponent[]{new UILabel((MalisisGui)this, "gui.door_factory.door_double_door").setPosition(0, y + 2)});
        propContainer.add(new UIComponent[]{this.cbDoubleDoor});
        this.cbProximity = (UICheckBox)((UICheckBox)new UICheckBox((MalisisGui)this).setPosition(-15, y += 12, Anchor.RIGHT)).register((Object)this);
        propContainer.add(new UIComponent[]{new UILabel((MalisisGui)this, "gui.door_factory.proximity_detection").setPosition(0, y + 2)});
        propContainer.add(new UIComponent[]{this.cbProximity});
        this.selRedstone = new UISelect((MalisisGui)this, 100, (Iterable)Lists.newArrayList((Object[])DoorDescriptor.RedstoneBehavior.values()));
        this.selRedstone.setPosition(0, y += 12, Anchor.RIGHT);
        this.selRedstone.setLabelPattern("gui.door_factory.redstone_behavior.%s").register((Object)this);
        propContainer.add(new UIComponent[]{new UILabel((MalisisGui)this, "gui.door_factory.redstone_behavior").setPosition(0, y + 2)});
        propContainer.add(new UIComponent[]{this.selRedstone});
        this.selDoorSound = new UISelect((MalisisGui)this, 100, this.getSortedList(DoorRegistry.listSounds().keySet(), "gui.door_factory.door_sound."));
        this.selDoorSound.setPosition(0, y += 12, Anchor.RIGHT);
        this.selDoorSound.setLabelPattern("gui.door_factory.door_sound.%s").register((Object)this);
        propContainer.add(new UIComponent[]{new UILabel((MalisisGui)this, "gui.door_factory.door_sound").setPosition(0, y + 2)});
        propContainer.add(new UIComponent[]{this.selDoorSound});
        return propContainer;
    }

    private ImmutableList<String> getSortedList(Set<String> set, String prefix) {
        return FluentIterable.from(set).toSortedList((s1, s2) -> I18n.func_135052_a((String)(prefix + s1), (Object[])new Object[0]).compareTo(I18n.func_135052_a((String)(prefix + s2), (Object[])new Object[0])));
    }

    private UIContainer<?> getMaterialsContainer() {
        UIContainer matContainer = (UIContainer)new UIContainer((MalisisGui)this, 0, 80).setPosition(0, 15);
        this.rbCreate = (UIRadioButton)((UIRadioButton)new UIRadioButton((MalisisGui)this, "rbDoor", "gui.door_factory.rb_create").setPosition(30, 0)).register((Object)this);
        this.rbEdit = (UIRadioButton)((UIRadioButton)new UIRadioButton((MalisisGui)this, "rbDoor", "gui.door_factory.rb_edit").setPosition(100, 0)).register((Object)this);
        matContainer.add(new UIComponent[]{this.rbCreate});
        matContainer.add(new UIComponent[]{this.rbEdit});
        this.contCreate = (UIContainer)new UIContainer((MalisisGui)this).setPosition(0, 14);
        int y = 0;
        UISlot frameSlot = (UISlot)new UISlot((MalisisGui)this, this.tileEntity.frameSlot).setPosition(-10, y, Anchor.RIGHT);
        UISlot topMaterialSlot = (UISlot)new UISlot((MalisisGui)this, this.tileEntity.topMaterialSlot).setPosition(-10, y + 18, Anchor.RIGHT);
        UISlot bottomMaterialSlot = (UISlot)new UISlot((MalisisGui)this, this.tileEntity.bottomMaterialSlot).setPosition(-10, y + 36, Anchor.RIGHT);
        this.contCreate.add(new UIComponent[]{new UILabel((MalisisGui)this, "gui.door_factory.frame_type").setPosition(0, y + 5)});
        this.contCreate.add(new UIComponent[]{new UILabel((MalisisGui)this, "gui.door_factory.top_material").setPosition(0, y + 23)});
        this.contCreate.add(new UIComponent[]{new UILabel((MalisisGui)this, "gui.door_factory.bottom_material").setPosition(0, y + 41)});
        this.contCreate.add(new UIComponent[]{frameSlot});
        this.contCreate.add(new UIComponent[]{topMaterialSlot});
        this.contCreate.add(new UIComponent[]{bottomMaterialSlot});
        this.contEdit = (UIContainer)new UIContainer((MalisisGui)this).setPosition(0, 14);
        UISlot doorEditSlotSlot = (UISlot)new UISlot((MalisisGui)this, this.tileEntity.doorEditSlot).setPosition(-10, 18, Anchor.RIGHT);
        this.contEdit.add(new UIComponent[]{new UILabel((MalisisGui)this, "gui.door_factory.door_edit_slot").setPosition(0, 23)});
        this.contEdit.add(new UIComponent[]{doorEditSlotSlot});
        matContainer.add(new UIComponent[]{this.contCreate});
        matContainer.add(new UIComponent[]{this.contEdit});
        return matContainer;
    }

    private UIContainer<?> getDigicodeContainer() {
        UIContainer dcContainer = (UIContainer)new UIContainer((MalisisGui)this, 0, 80).setPosition(0, 15);
        this.digicode = (Digicode)((Digicode)new Digicode(this).setAnchor(Anchor.CENTER)).register((Object)this);
        dcContainer.add(new UIComponent[]{this.digicode});
        return dcContainer;
    }

    public void updateGui() {
        boolean isCreate = this.tileEntity.isCreate();
        if (isCreate) {
            this.rbCreate.setSelected();
        } else {
            this.rbEdit.setSelected();
        }
        this.contCreate.setVisible(isCreate);
        this.contEdit.setVisible(!isCreate);
        this.btnCreate.setText(isCreate ? "gui.door_factory.create_door" : "gui.door_factory.edit_door");
        this.selDoorMovement.setSelectedOption((Object)DoorRegistry.getId(this.tileEntity.getDoorMovement()));
        this.tfOpenTime.setText(Integer.toString(this.tileEntity.getOpeningTime()));
        this.tfAutoCloseTime.setText(Integer.toString(this.tileEntity.getAutoCloseTime()));
        this.cbDoubleDoor.setChecked(this.tileEntity.isDoubleDoor());
        this.cbProximity.setChecked(this.tileEntity.hasProximityDetection());
        this.selRedstone.select((Object)this.tileEntity.getRedstoneBehavior());
        this.selDoorSound.setSelectedOption((Object)DoorRegistry.getId(this.tileEntity.getDoorSound()));
    }

    @Subscribe
    public void onCheckedEvent(UICheckBox.CheckEvent event) {
        if (event.getComponent() == this.cbDoubleDoor) {
            this.tileEntity.setDoubleDoor(event.isChecked());
        } else if (event.getComponent() == this.cbProximity) {
            this.tileEntity.setProximityDetection(event.isChecked());
        }
        DoorFactoryMessage.sendDoorInformations(this.tileEntity);
    }

    @Subscribe
    public void onSelectEvent(UISelect.SelectEvent<?> event) {
        if (event.getNewValue() == null) {
            return;
        }
        if (event.getComponent() == this.selRedstone) {
            this.tileEntity.setRedstoneBehavior((DoorDescriptor.RedstoneBehavior)((Object)event.getNewValue()));
        } else if (event.getComponent() == this.selDoorMovement) {
            this.tileEntity.setDoorMovement(DoorRegistry.getMovement((String)event.getNewValue()));
        } else if (event.getComponent() == this.selDoorSound) {
            this.tileEntity.setDoorSound(DoorRegistry.getSound((String)event.getNewValue()));
        }
        DoorFactoryMessage.sendDoorInformations(this.tileEntity);
    }

    @Subscribe
    public void onRbSelectEvent(UIRadioButton.SelectEvent event) {
        boolean isCreate = event.getNewValue() == this.rbCreate;
        this.tileEntity.setCreate(isCreate);
        this.contCreate.setVisible(isCreate);
        this.contEdit.setVisible(!isCreate);
        this.btnCreate.setText(isCreate ? "gui.door_factory.create_door" : "gui.door_factory.edit_door");
        DoorFactoryMessage.sendDoorInformations(this.tileEntity);
    }

    @Subscribe
    public void onGuiChangeEvent(ComponentEvent.ValueChange<?, ?> event) {
        if (event.getComponent() != this.tfOpenTime && event.getComponent() != this.tfAutoCloseTime) {
            return;
        }
        try {
            int value = Integer.decode((String)event.getNewValue());
            if (event.getComponent() == this.tfOpenTime) {
                this.tileEntity.setOpeningTime(value);
            }
            if (event.getComponent() == this.tfAutoCloseTime) {
                this.tileEntity.setAutoCloseTime(value);
            }
            DoorFactoryMessage.sendDoorInformations(this.tileEntity);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Subscribe
    public void onDigicodeChange(Digicode.CodeChangeEvent event) {
        this.tileEntity.setCode(event.getCode());
        DoorFactoryMessage.sendDoorInformations(this.tileEntity);
    }

    @Subscribe
    public void onCreateDoor(UIButton.ClickEvent event) {
        DoorFactoryMessage.sendCreateDoor(this.tileEntity);
    }

    @Subscribe
    public void onTabActivation(StateChangeEvent.ActiveStateChange<UITab> event) {
        if (event.getState()) {
            activeTab = ((UITab)event.getComponent()).getName();
            if ("tab_dc".equals(activeTab)) {
                this.registerKeyListener((IKeyListener)this.digicode);
            } else {
                this.unregisterKeyListener((IKeyListener)this.digicode);
            }
        }
    }
}

