/*
 * Decompiled with CFR 0.152.
 */
package com.setycz.chickens.handler;

import com.setycz.chickens.registry.LiquidEggRegistry;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class LiquidEggFluidWrapper
implements IFluidHandler,
ICapabilityProvider {
    private final ItemStack container;

    public LiquidEggFluidWrapper(ItemStack container) {
        this.container = container;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return null;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new FluidTankProperties[]{new FluidTankProperties(this.getFluid(), 1000)};
    }

    public int fill(FluidStack resource, boolean doFill) {
        return 0;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        FluidStack fluidStack = this.getFluid();
        if (!resource.isFluidEqual(fluidStack)) {
            return null;
        }
        return this.drain(resource.amount, doDrain);
    }

    private FluidStack getFluid() {
        Fluid fluid = LiquidEggRegistry.findById(this.container.func_77960_j()).getFluid();
        return new FluidStack(fluid, 1000);
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.container.func_190916_E() < 1 || maxDrain < 1000) {
            return null;
        }
        FluidStack fluidStack = this.getFluid();
        if (doDrain) {
            this.container.func_190918_g(1);
        }
        return fluidStack;
    }
}

