/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.render;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.block.BlockShape;
import com.supermartijn642.core.render.RenderConfiguration;
import com.supermartijn642.core.render.RenderStateConfiguration;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;

public class RenderUtils {
    private static final RenderConfiguration LINES = RenderConfiguration.create("supermartijn642corelib", "lines", DefaultVertexFormats.field_181706_f, RenderConfiguration.PrimitiveType.LINES, RenderStateConfiguration.builder().useDefaultLineWidth().useTranslucentTransparency().useViewOffsetZLayering().disableCulling().useLessThanOrEqualDepthTest().disableDepthMask().disableLighting().build());
    private static final RenderConfiguration LINES_NO_DEPTH = RenderConfiguration.create("supermartijn642corelib", "lines_no_depth", DefaultVertexFormats.field_181706_f, RenderConfiguration.PrimitiveType.LINES, RenderStateConfiguration.builder().useDefaultLineWidth().useTranslucentTransparency().useViewOffsetZLayering().disableCulling().disableDepthTest().disableDepthMask().disableLighting().build());
    private static final RenderConfiguration QUADS = RenderConfiguration.create("supermartijn642corelib", "quads", DefaultVertexFormats.field_181706_f, RenderConfiguration.PrimitiveType.QUADS, RenderStateConfiguration.builder().useTranslucentTransparency().disableTexture().disableCulling().useLessThanOrEqualDepthTest().disableDepthMask().disableLighting().build());
    private static final RenderConfiguration QUADS_NO_DEPTH = RenderConfiguration.create("supermartijn642corelib", "quads_no_depth", DefaultVertexFormats.field_181706_f, RenderConfiguration.PrimitiveType.QUADS, RenderStateConfiguration.builder().useTranslucentTransparency().disableTexture().disableCulling().disableDepthTest().disableDepthMask().disableLighting().build());

    public static Vec3d getCameraPosition() {
        RenderManager renderManager = ClientUtils.getMinecraft().func_175598_ae();
        return new Vec3d(renderManager.field_78730_l, renderManager.field_78731_m, renderManager.field_78728_n);
    }

    public static void renderShape(BlockShape shape, float red, float green, float blue, float alpha, boolean depthTest) {
        RenderConfiguration renderConfiguration = depthTest ? LINES : LINES_NO_DEPTH;
        BufferBuilder builder = renderConfiguration.begin();
        shape.forEachEdge((x1, y1, z1, x2, y2, z2) -> {
            builder.func_181662_b(x1, y1, z1).func_181666_a(red, green, blue, alpha).func_181675_d();
            builder.func_181662_b(x2, y2, z2).func_181666_a(red, green, blue, alpha).func_181675_d();
        });
        renderConfiguration.end();
    }

    public static void renderShapeSides(BlockShape shape, float red, float green, float blue, float alpha, boolean depthTest) {
        RenderConfiguration renderConfiguration = depthTest ? QUADS : QUADS_NO_DEPTH;
        BufferBuilder builder = renderConfiguration.begin();
        shape.forEachBox(box -> {
            float minX = (float)box.field_72340_a;
            float maxX = (float)box.field_72336_d;
            float minY = (float)box.field_72338_b;
            float maxY = (float)box.field_72337_e;
            float minZ = (float)box.field_72339_c;
            float maxZ = (float)box.field_72334_f;
            builder.func_181662_b((double)minX, (double)minY, (double)minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
            builder.func_181662_b((double)minX, (double)maxY, (double)minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
            builder.func_181662_b((double)maxX, (double)maxY, (double)minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
            builder.func_181662_b((double)maxX, (double)minY, (double)minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
            builder.func_181662_b((double)minX, (double)minY, (double)maxZ).func_181666_a(red, green, blue, alpha).func_181675_d();
            builder.func_181662_b((double)maxX, (double)minY, (double)maxZ).func_181666_a(red, green, blue, alpha).func_181675_d();
            builder.func_181662_b((double)maxX, (double)maxY, (double)maxZ).func_181666_a(red, green, blue, alpha).func_181675_d();
            builder.func_181662_b((double)minX, (double)maxY, (double)maxZ).func_181666_a(red, green, blue, alpha).func_181675_d();
            builder.func_181662_b((double)minX, (double)minY, (double)minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
            builder.func_181662_b((double)maxX, (double)minY, (double)minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
            builder.func_181662_b((double)maxX, (double)minY, (double)maxZ).func_181666_a(red, green, blue, alpha).func_181675_d();
            builder.func_181662_b((double)minX, (double)minY, (double)maxZ).func_181666_a(red, green, blue, alpha).func_181675_d();
            builder.func_181662_b((double)minX, (double)maxY, (double)minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
            builder.func_181662_b((double)minX, (double)maxY, (double)maxZ).func_181666_a(red, green, blue, alpha).func_181675_d();
            builder.func_181662_b((double)maxX, (double)maxY, (double)maxZ).func_181666_a(red, green, blue, alpha).func_181675_d();
            builder.func_181662_b((double)maxX, (double)maxY, (double)minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
            builder.func_181662_b((double)minX, (double)minY, (double)minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
            builder.func_181662_b((double)minX, (double)minY, (double)maxZ).func_181666_a(red, green, blue, alpha).func_181675_d();
            builder.func_181662_b((double)minX, (double)maxY, (double)maxZ).func_181666_a(red, green, blue, alpha).func_181675_d();
            builder.func_181662_b((double)minX, (double)maxY, (double)minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
            builder.func_181662_b((double)maxX, (double)minY, (double)minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
            builder.func_181662_b((double)maxX, (double)maxY, (double)minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
            builder.func_181662_b((double)maxX, (double)maxY, (double)maxZ).func_181666_a(red, green, blue, alpha).func_181675_d();
            builder.func_181662_b((double)maxX, (double)minY, (double)maxZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        });
        renderConfiguration.end();
    }

    public static void renderBox(AxisAlignedBB box, float red, float green, float blue, float alpha, boolean depthTest) {
        RenderUtils.renderShape(BlockShape.create(box), red, green, blue, alpha, depthTest);
    }

    public static void renderBoxSides(AxisAlignedBB box, float red, float green, float blue, float alpha, boolean depthTest) {
        RenderUtils.renderShapeSides(BlockShape.create(box), red, green, blue, alpha, depthTest);
    }

    public static void renderShape(BlockShape shape, float red, float green, float blue, boolean depthTest) {
        RenderUtils.renderShape(shape, red, green, blue, 1.0f, depthTest);
    }

    public static void renderShapeSides(BlockShape shape, float red, float green, float blue, boolean depthTest) {
        RenderUtils.renderShapeSides(shape, red, green, blue, 1.0f, depthTest);
    }

    public static void renderBox(AxisAlignedBB box, float red, float green, float blue, boolean depthTest) {
        RenderUtils.renderShape(BlockShape.create(box), red, green, blue, 1.0f, depthTest);
    }

    public static void renderBoxSides(AxisAlignedBB box, float red, float green, float blue, boolean depthTest) {
        RenderUtils.renderShapeSides(BlockShape.create(box), red, green, blue, 1.0f, depthTest);
    }
}

