/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.gui;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.vecmath.Camera;
import com.enderio.core.common.vecmath.Matrix4d;
import com.enderio.core.common.vecmath.Vector3d;
import com.enderio.core.common.vecmath.Vertex;
import info.loenwind.autoconfig.util.NullHelper;
import java.awt.Rectangle;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;

public class BlockSceneRenderer {
    private final float pitch;
    private final double distance;
    @Nonnull
    private Minecraft mc = Minecraft.func_71410_x();
    @Nonnull
    private final Vector3d origin = new Vector3d();
    @Nonnull
    private final Vector3d eye = new Vector3d();
    @Nonnull
    private final Camera camera = new Camera();
    @Nonnull
    private final Matrix4d pitchRot = new Matrix4d();
    @Nonnull
    private final Matrix4d yawRot = new Matrix4d();
    @Nonnull
    private final NNList<Pair<BlockPos, IBlockState>> blocks = new NNList();

    public BlockSceneRenderer(@Nonnull NNList<Pair<BlockPos, IBlockState>> blocks) {
        this.blocks.addAll(blocks);
        Vector3d min = new Vector3d(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        Vector3d max = new Vector3d(-1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308);
        for (Pair pair : blocks) {
            BlockPos bc = (BlockPos)pair.getKey();
            min.set(Math.min((double)bc.func_177958_n(), min.x), Math.min((double)bc.func_177956_o(), min.y), Math.min((double)bc.func_177952_p(), min.z));
            max.set(Math.max((double)bc.func_177958_n(), max.x), Math.max((double)bc.func_177956_o(), max.y), Math.max((double)bc.func_177952_p(), max.z));
        }
        Vector3d size = new Vector3d(max);
        size.sub(min);
        size.scale(0.5);
        Vector3d c = new Vector3d(min.x + size.x + 0.5, min.y + size.y + 0.5, min.z + size.z + 0.5);
        size.scale(2.0);
        this.origin.set(c);
        this.pitchRot.setIdentity();
        this.yawRot.setIdentity();
        this.pitch = -22.5f;
        this.distance = Math.max(Math.max(size.x, size.y), size.z) + 4.0;
    }

    public void drawScreen(int x, int y, int w, int h) {
        int vph;
        int vpw;
        int vpy;
        ScaledResolution scaledresolution = new ScaledResolution(this.mc);
        int vpx = x * scaledresolution.func_78325_e();
        if (this.updateCamera(vpx, vpy = (scaledresolution.func_78328_b() - h - y) * scaledresolution.func_78325_e(), vpw = w * scaledresolution.func_78325_e(), vph = h * scaledresolution.func_78325_e())) {
            this.applyCamera();
            this.renderScene();
            this.resetCamera();
        }
    }

    private void renderScene() {
        GlStateManager.func_179089_o();
        GlStateManager.func_179091_B();
        RenderHelper.func_74518_a();
        this.mc.field_71460_t.func_175072_h();
        RenderUtil.bindBlockTexture();
        GlStateManager.func_179140_f();
        GlStateManager.func_179098_w();
        GlStateManager.func_179141_d();
        LayerRenderer layerRenderer = new LayerRenderer(new Vector3d(-this.origin.x + this.eye.x, -this.origin.y + this.eye.y, -this.origin.z + this.eye.z));
        BlockRenderLayer oldRenderLayer = MinecraftForgeClient.getRenderLayer();
        try {
            NNList.of(BlockRenderLayer.class).apply((NNList.Callback)layerRenderer);
        }
        finally {
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)oldRenderLayer);
            GlStateManager.func_179132_a((boolean)true);
        }
    }

    private static void setGlStateForPass(@Nonnull BlockRenderLayer layer) {
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        if (layer != BlockRenderLayer.TRANSLUCENT) {
            GlStateManager.func_179126_j();
            GlStateManager.func_179084_k();
            GlStateManager.func_179132_a((boolean)true);
        } else {
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179132_a((boolean)false);
        }
    }

    private boolean updateCamera(int vpx, int vpy, int vpw, int vph) {
        if (vpw <= 0 || vph <= 0) {
            return false;
        }
        this.camera.setViewport(vpx, vpy, vpw, vph);
        this.camera.setProjectionMatrixAsPerspective(30.0, 0.05, 50.0, vpw, vph);
        this.eye.set(0.0, 0.0, this.distance);
        this.pitchRot.makeRotationX(Math.toRadians(this.pitch));
        this.yawRot.makeRotationY(Math.toRadians(Minecraft.func_71386_F() / 16L));
        this.pitchRot.transform(this.eye);
        this.yawRot.transform(this.eye);
        this.camera.setViewMatrixAsLookAt(this.eye, RenderUtil.ZERO_V, RenderUtil.UP_V);
        return this.camera.isValid();
    }

    private void applyCamera() {
        Rectangle vp = this.camera.getViewport();
        GL11.glViewport((int)vp.x, (int)vp.y, (int)vp.width, (int)vp.height);
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        Matrix4d camaraViewMatrix = this.camera.getTransposeProjectionMatrix();
        if (camaraViewMatrix != null) {
            RenderUtil.loadMatrix((Matrix4d)camaraViewMatrix);
        }
        GL11.glMatrixMode((int)5888);
        Matrix4d cameraViewMatrix = this.camera.getTransposeViewMatrix();
        if (cameraViewMatrix != null) {
            RenderUtil.loadMatrix((Matrix4d)cameraViewMatrix);
        }
        GL11.glTranslatef((float)(-((float)this.eye.x)), (float)(-((float)this.eye.y)), (float)(-((float)this.eye.z)));
    }

    protected void resetCamera() {
        ScaledResolution scaledresolution = new ScaledResolution(this.mc);
        GL11.glViewport((int)0, (int)0, (int)this.mc.field_71443_c, (int)this.mc.field_71440_d);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)scaledresolution.func_78327_c(), (double)scaledresolution.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
    }

    private static final class BlockRenderer
    implements NNList.Callback<Pair<BlockPos, IBlockState>> {
        @Nonnull
        private final BlockRenderLayer layer;

        private BlockRenderer(@Nonnull BlockRenderLayer layer) {
            this.layer = layer;
        }

        public void apply(@Nonnull Pair<BlockPos, IBlockState> entry) {
            BlockPos pos = (BlockPos)entry.getKey();
            IBlockState bs = (IBlockState)entry.getValue();
            if (bs.func_177230_c().canRenderInLayer(bs, this.layer) && pos != null) {
                final BufferBuilder worldRendererIn = Tessellator.func_178181_a().func_178180_c();
                try {
                    BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
                    EnumBlockRenderType type = bs.func_185901_i();
                    Fluid fluidForBlock = FluidRegistry.lookupFluidForBlock((Block)bs.func_177230_c());
                    if (fluidForBlock != null && bs.func_177228_b().containsKey((Object)BlockLiquid.field_176367_b)) {
                        type = EnumBlockRenderType.LIQUID;
                    }
                    switch (type) {
                        case MODEL: {
                            IBakedModel ibakedmodel = blockrendererdispatcher.func_184389_a(bs);
                            bs = bs.func_177230_c().getExtendedState(bs, (IBlockAccess)Minecraft.func_71410_x().field_71441_e, pos);
                            blockrendererdispatcher.func_175019_b().func_178267_a((IBlockAccess)Minecraft.func_71410_x().field_71441_e, ibakedmodel, bs, pos, worldRendererIn, false);
                            break;
                        }
                        case LIQUID: {
                            if (fluidForBlock != null) {
                                TextureAtlasSprite tex1 = RenderUtil.getStillTexture((Fluid)fluidForBlock);
                                ResourceLocation iconKey = fluidForBlock.getFlowing();
                                TextureAtlasSprite tex = (TextureAtlasSprite)NullHelper.first((Object[])new TextureAtlasSprite[]{Minecraft.func_71410_x().func_147117_R().getTextureExtry(iconKey.toString()), tex1});
                                float level = ((Integer)bs.func_177229_b((IProperty)BlockLiquid.field_176367_b)).intValue();
                                if (level == 0.0f) {
                                    level = Math.abs((float)Minecraft.func_71386_F() / 128.0f % 30.0f - 15.0f);
                                }
                                final BoundingBox bb = new BoundingBox(pos).setMaxY((double)pos.func_177956_o() + (double)level / 15.0);
                                float minU1 = tex1.func_94209_e();
                                float maxU1 = tex1.func_94214_a(8.0);
                                float minV1 = tex1.func_94206_g();
                                float maxV1 = tex1.func_94207_b(8.0);
                                for (Vertex v : bb.getCornersWithUvForFace(EnumFacing.DOWN, minU1, maxU1, minV1, maxV1)) {
                                    worldRendererIn.func_181662_b(v.x(), v.y(), v.z()).func_181666_a(0.5f, 0.5f, 0.5f, 1.0f).func_187315_a((double)v.u(), (double)v.v()).func_187314_a(240, 240).func_181675_d();
                                }
                                for (Vertex v : bb.getCornersWithUvForFace(EnumFacing.UP, minU1, maxU1, minV1, maxV1)) {
                                    worldRendererIn.func_181662_b(v.x(), v.y(), v.z()).func_181666_a(0.5f, 0.5f, 0.5f, 1.0f).func_187315_a((double)v.u(), (double)v.v()).func_187314_a(240, 240).func_181675_d();
                                }
                                final float minU = tex.func_94209_e();
                                final float maxU = tex.func_94214_a(8.0);
                                final float minV = tex.func_94206_g();
                                final float maxV = tex.func_94207_b(8.0);
                                NNList.FACING_HORIZONTAL.apply((NNList.Callback)new NNList.Callback<EnumFacing>(){

                                    public void apply(@Nonnull EnumFacing e) {
                                        for (Vertex v : bb.getCornersWithUvForFace(e, minU, maxU, maxV, minV)) {
                                            worldRendererIn.func_181662_b(v.x(), v.y(), v.z()).func_181666_a(0.5f, 0.5f, 0.5f, 1.0f).func_187315_a((double)v.u(), (double)v.v()).func_187314_a(240, 240).func_181675_d();
                                        }
                                    }
                                });
                                break;
                            }
                        }
                        default: {
                            blockrendererdispatcher.func_175018_a(bs, pos, (IBlockAccess)Minecraft.func_71410_x().field_71441_e, worldRendererIn);
                            break;
                        }
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }

    private final class LayerRenderer
    implements NNList.Callback<BlockRenderLayer> {
        @Nonnull
        private final Vector3d translation;

        private LayerRenderer(Vector3d translation) {
            this.translation = translation;
        }

        public void apply(@Nonnull BlockRenderLayer layer) {
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
            BlockSceneRenderer.setGlStateForPass(layer);
            BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
            wr.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            wr.func_178969_c(this.translation.x, this.translation.y, this.translation.z);
            BlockSceneRenderer.this.blocks.apply((NNList.Callback)new BlockRenderer(layer));
            Tessellator.func_178181_a().func_78381_a();
            wr.func_178969_c(0.0, 0.0, 0.0);
        }
    }
}

