/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.invpanel.remote;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import com.enderio.core.common.MappedCapabilityProvider;
import com.enderio.core.common.interfaces.IOverlayRenderAware;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.EnderIOTab;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.gui.handler.IEioGuiHandler;
import crazypants.enderio.base.init.ModObjectRegistry;
import crazypants.enderio.base.lang.LangFluid;
import crazypants.enderio.base.lang.LangPower;
import crazypants.enderio.base.power.forge.item.IInternalPoweredItem;
import crazypants.enderio.base.render.IHaveRenderers;
import crazypants.enderio.base.render.itemoverlay.PowerBarOverlayRenderHelper;
import crazypants.enderio.invpanel.init.InvpanelObject;
import crazypants.enderio.invpanel.invpanel.GuiInventoryPanel;
import crazypants.enderio.invpanel.invpanel.InventoryPanelContainer;
import crazypants.enderio.invpanel.invpanel.TileInventoryPanel;
import crazypants.enderio.invpanel.network.PacketHandler;
import crazypants.enderio.invpanel.remote.ItemRemoteInvAccessType;
import crazypants.enderio.invpanel.remote.PacketPrimeInventoryPanelRemote;
import crazypants.enderio.invpanel.remote.Ticker;
import crazypants.enderio.util.ClientUtil;
import crazypants.enderio.util.NbtValue;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemRemoteInvAccess
extends Item
implements IAdvancedTooltipProvider,
IOverlayRenderAware,
IInternalPoweredItem,
IHaveRenderers,
IEioGuiHandler.WithPos {
    static TileInventoryPanel targetTE;
    static long targetTEtime;

    public static ItemRemoteInvAccess create(@Nonnull IModObject modObject, @Nullable Block block) {
        ItemRemoteInvAccess result = new ItemRemoteInvAccess(modObject);
        return result;
    }

    protected ItemRemoteInvAccess(@Nonnull IModObject modObject) {
        this.func_77637_a(EnderIOTab.tabEnderIOInvpanel);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77625_d(1);
        modObject.apply(this);
    }

    @Override
    public void registerRenderers(@Nonnull IModObject modObject) {
        for (ItemRemoteInvAccessType type : ItemRemoteInvAccessType.values()) {
            ResourceLocation resourceLocation = new ResourceLocation("enderio", type.getUnlocalizedName(modObject.getUnlocalisedName()));
            ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{resourceLocation});
            ClientUtil.regRenderer((Item)this, type.toMetadata(), resourceLocation);
        }
    }

    @Nonnull
    public String func_77667_c(@Nonnull ItemStack stack) {
        return ItemRemoteInvAccessType.fromStack(stack).getUnlocalizedName(this.func_77658_a());
    }

    public void func_150895_a(@Nonnull CreativeTabs par2CreativeTabs, @Nonnull NonNullList<ItemStack> par3List) {
        if (par2CreativeTabs.equals(EnderIOTab.tabEnderIOInvpanel)) {
            for (ItemRemoteInvAccessType type : ItemRemoteInvAccessType.values()) {
                if (!type.isVisible()) continue;
                par3List.add((Object)new ItemStack((Item)this, 1, type.toMetadata()));
                ItemStack full = new ItemStack((Item)this, 1, type.toMetadata());
                this.setFull(full);
                par3List.add((Object)full);
            }
        }
    }

    public boolean func_77636_d(@Nonnull ItemStack stack) {
        return super.func_77636_d(stack) || NbtValue.GLINT.hasTag(stack);
    }

    @Nonnull
    public EnumActionResult onItemUseFirst(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ, @Nonnull EnumHand hand) {
        if (world.field_72995_K || !player.func_70093_af()) {
            return EnumActionResult.PASS;
        }
        TileEntity te = world.func_175625_s(pos);
        ItemStack stack = player.func_184586_b(hand);
        if (te instanceof TileInventoryPanel) {
            NbtValue.REMOTE_X.setInt(stack, te.func_174877_v().func_177958_n());
            NbtValue.REMOTE_Y.setInt(stack, te.func_174877_v().func_177956_o());
            NbtValue.REMOTE_Z.setInt(stack, te.func_174877_v().func_177952_p());
            NbtValue.REMOTE_D.setInt(stack, te.func_145831_w().field_73011_w.getDimension());
            player.func_146105_b((ITextComponent)new TextComponentString(EnderIO.lang.localize("remoteinv.chat.set")), true);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, @Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        if (!world.field_72995_K) {
            ItemStack equipped = player.func_184586_b(hand);
            if (!(NbtValue.REMOTE_X.hasTag(equipped) && NbtValue.REMOTE_Y.hasTag(equipped) && NbtValue.REMOTE_Z.hasTag(equipped) && NbtValue.REMOTE_D.hasTag(equipped))) {
                player.func_146105_b((ITextComponent)new TextComponentString(EnderIO.lang.localize("remoteinv.chat.notarget")), true);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)equipped);
            }
            int x = NbtValue.REMOTE_X.getInt(equipped);
            int y = NbtValue.REMOTE_Y.getInt(equipped);
            int z = NbtValue.REMOTE_Z.getInt(equipped);
            int d = NbtValue.REMOTE_D.getInt(equipped);
            ItemRemoteInvAccessType type = ItemRemoteInvAccessType.fromStack(equipped);
            if (!type.inRange(d, x, y, z, world.field_73011_w.getDimension(), (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v)) {
                player.func_146105_b((ITextComponent)new TextComponentString(EnderIO.lang.localize("remoteinv.chat.outofrange")), true);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)equipped);
            }
            World targetWorld = world;
            if (world.field_73011_w.getDimension() != d && (targetWorld = DimensionManager.getWorld((int)d)) == null) {
                player.func_146105_b((ITextComponent)new TextComponentString(EnderIO.lang.localize("remoteinv.chat.invalidtargetworld")), true);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)equipped);
            }
            BlockPos pos = new BlockPos(x, y, z);
            if (!targetWorld.func_175667_e(pos)) {
                player.func_146105_b((ITextComponent)new TextComponentString(EnderIO.lang.localize("remoteinv.chat.notloaded")), true);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)equipped);
            }
            if (targetWorld.func_180495_p(pos).func_177230_c() != InvpanelObject.blockInventoryPanel.getBlock()) {
                player.func_146105_b((ITextComponent)new TextComponentString(EnderIO.lang.localize("remoteinv.chat.invalidtarget")), true);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)equipped);
            }
            if (!(targetWorld instanceof WorldServer) || !(player instanceof EntityPlayerMP)) {
                Log.warn("Unexpected world or player: " + world + " " + player);
                player.func_146105_b((ITextComponent)new TextComponentString(EnderIO.lang.localize("remoteinv.chat.error")), true);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)equipped);
            }
            if (this.getEnergyStored(equipped) < type.getRfPerTick() * 10) {
                player.func_146105_b((ITextComponent)new TextComponentString(EnderIO.lang.localize("remoteinv.chat.outofpower")), true);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)equipped);
            }
            if (!this.drain(equipped, type.getMbPerOpen())) {
                Fluid fluid = type.getFluidType();
                String fluidname = fluid.getLocalizedName(new FluidStack(fluid, 1));
                player.func_146105_b((ITextComponent)new TextComponentString(EnderIO.lang.localize("remoteinv.chat.outoffluid").replace("{FLUIDNAME}", fluidname)), true);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)equipped);
            }
            TileEntity te = targetWorld.func_175625_s(pos);
            if (te instanceof TileInventoryPanel) {
                PacketHandler.INSTANCE.sendTo((IMessage)new PacketPrimeInventoryPanelRemote((TileInventoryPanel)te), (EntityPlayerMP)player);
            }
            ModObjectRegistry.getModObjectNN(this).openGui(player.field_70170_p, pos, player, null, d);
            Ticker.create();
            return new ActionResult(EnumActionResult.SUCCESS, (Object)equipped);
        }
        return super.func_77659_a(world, player, hand);
    }

    public boolean canInteractWith(@Nonnull ItemStack stack, @Nonnull EntityPlayer player) {
        if (this.getEnergyStored(stack) > 0) {
            return true;
        }
        player.func_146105_b((ITextComponent)new TextComponentString(EnderIO.lang.localize("remoteinv.chat.outofpower")), true);
        return false;
    }

    public void tick(@Nonnull ItemStack stack, @Nonnull EntityPlayer player) {
        if (EnderIO.proxy.getServerTickCount() % 10L == 0L) {
            ItemRemoteInvAccessType type = ItemRemoteInvAccessType.fromStack(stack);
            this.extractInternal(stack, type.getRfPerTick() * 10);
        }
    }

    private boolean extractInternal(@Nonnull ItemStack item, int powerUse) {
        int stored = this.getEnergyStored(item);
        if (stored >= powerUse) {
            this.setEnergyStored(item, stored - powerUse);
            return true;
        }
        if (stored > 0) {
            this.setEnergyStored(item, 0);
        }
        return false;
    }

    @Override
    public void setFull(@Nonnull ItemStack container) {
        this.setEnergyStored(container, this.getMaxEnergyStored(container));
        NbtValue.FLUIDAMOUNT.setInt(container, this.getCapacity(container));
    }

    public void func_77622_d(@Nonnull ItemStack itemStack, @Nonnull World world, @Nonnull EntityPlayer entityPlayer) {
        this.setEnergyStored(itemStack, 0);
    }

    public void renderItemOverlayIntoGUI(@Nonnull ItemStack stack, int xPosition, int yPosition) {
        PowerBarOverlayRenderHelper.instance_fluid.render(stack, xPosition, yPosition, PowerBarOverlayRenderHelper.instance.render(stack, xPosition, yPosition) ? 1 : 0);
    }

    public boolean shouldCauseReequipAnimation(@Nonnull ItemStack oldStack, @Nonnull ItemStack newStack, boolean slotChanged) {
        return slotChanged ? super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged) : oldStack.func_190926_b() || newStack.func_190926_b() || !ItemStack.func_179545_c((ItemStack)oldStack, (ItemStack)newStack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(LangPower.RF(this.getEnergyStored(stack), this.getMaxEnergyStored(stack)));
        tooltip.add(LangFluid.MB(NbtValue.FLUIDAMOUNT.getInt(stack, 0), this.getFluidType(stack)));
    }

    @Nullable
    private FluidStack getFluid(@Nonnull ItemStack container) {
        int amount = NbtValue.FLUIDAMOUNT.getInt(container, 0);
        if (amount > 0) {
            return new FluidStack(this.getFluidType(container), amount);
        }
        return null;
    }

    private int getCapacity(@Nonnull ItemStack container) {
        return ItemRemoteInvAccessType.fromStack(container).getFluidCapacity();
    }

    @Nonnull
    public Fluid getFluidType(@Nonnull ItemStack stack) {
        return ItemRemoteInvAccessType.fromStack(stack).getFluidType();
    }

    private boolean drain(@Nonnull ItemStack container, int toDrain) {
        int amount = NbtValue.FLUIDAMOUNT.getInt(container, 0);
        if (toDrain > amount) {
            return false;
        }
        NbtValue.FLUIDAMOUNT.setInt(container, amount - toDrain);
        return true;
    }

    @Override
    public int getMaxEnergyStored(@Nonnull ItemStack container) {
        return ItemRemoteInvAccessType.fromStack(container).getRfCapacity();
    }

    @Override
    public void setEnergyStored(@Nonnull ItemStack container, int energy) {
        NbtValue.ENERGY.setInt(container, energy);
    }

    @Override
    public int getEnergyStored(@Nonnull ItemStack stack) {
        return NbtValue.ENERGY.getInt(stack);
    }

    @Override
    public int getMaxInput(@Nonnull ItemStack stack) {
        return ItemRemoteInvAccessType.fromStack(stack).getRfCapacity() / 100;
    }

    @Override
    public int getMaxOutput(@Nonnull ItemStack stack) {
        return 0;
    }

    @Override
    @Nonnull
    public MappedCapabilityProvider initCapabilities(@Nonnull ItemStack stack, @Nullable NBTTagCompound nbt, @Nonnull MappedCapabilityProvider capProv) {
        return capProv.add(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, (Object)new CapabilityProvider(stack));
    }

    @Override
    @Nullable
    public Object getGuiElement(boolean server, @Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing facing, int param1, int param2, int param3) {
        if (server) {
            return this.getServerGuiElement(player, world, pos, facing, param1);
        }
        return this.getClientGuiElement(player, world, pos, facing, param1);
    }

    @Override
    @Nullable
    public Container getServerGuiElement(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing facing, int param1) {
        World targetWorld = world;
        if (world.field_73011_w.getDimension() != param1 && (targetWorld = DimensionManager.getWorld((int)param1)) == null) {
            Log.warn("Unexpected failure to get dimension " + param1 + " for the Inventory Panel Remote");
            return null;
        }
        targetWorld.func_180495_p(pos);
        TileEntity te = targetWorld.func_175625_s(pos);
        if (te instanceof TileInventoryPanel) {
            return new InventoryPanelContainer(player.field_71071_by, (TileInventoryPanel)te);
        }
        Log.warn("Unexpected failure to get tileentity at " + pos + " in dimension " + param1 + " for the Inventory Panel Remote. Got: " + te);
        return null;
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getClientGuiElement(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing facing, int param1) {
        if (targetTE != null && targetTEtime >= EnderIO.proxy.getTickCount()) {
            return new GuiInventoryPanel(targetTE, (Container)new InventoryPanelContainer(player.field_71071_by, targetTE));
        }
        return null;
    }

    public void addCommonEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        SpecialTooltipHandler.addCommonTooltipFromResources(list, (String)this.func_77667_c(itemstack));
    }

    public void addBasicEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        SpecialTooltipHandler.addBasicTooltipFromResources(list, (String)this.func_77667_c(itemstack));
    }

    public void addDetailedEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        ArrayList list0 = new ArrayList();
        SpecialTooltipHandler.addDetailedTooltipFromResources(list0, (String)this.func_77667_c(itemstack));
        Fluid fluid = this.getFluidType(itemstack);
        String fluidname = fluid.getLocalizedName(new FluidStack(fluid, 1));
        for (String string : list0) {
            list.add(string.replace("{FLUIDNAME}", fluidname));
        }
    }

    private class CapabilityProvider
    implements IFluidHandlerItem {
        @Nonnull
        protected final ItemStack container;

        private CapabilityProvider(ItemStack container) {
            this.container = container;
        }

        public IFluidTankProperties[] getTankProperties() {
            return new IFluidTankProperties[]{new IFluidTankProperties(){

                @Nullable
                public FluidStack getContents() {
                    return ItemRemoteInvAccess.this.getFluid(CapabilityProvider.this.container);
                }

                public int getCapacity() {
                    return ItemRemoteInvAccess.this.getCapacity(CapabilityProvider.this.container);
                }

                public boolean canFill() {
                    return true;
                }

                public boolean canDrain() {
                    return false;
                }

                public boolean canFillFluidType(FluidStack fluidStack) {
                    return fluidStack != null && fluidStack.getFluid() == ItemRemoteInvAccess.this.getFluidType(CapabilityProvider.this.container);
                }

                public boolean canDrainFluidType(FluidStack fluidStack) {
                    return false;
                }
            }};
        }

        public int fill(@Nullable FluidStack resource, boolean doFill) {
            if (this.container.func_190926_b() || this.container.func_77973_b() != ItemRemoteInvAccess.this || resource == null || resource.amount <= 0 || resource.getFluid() == null || resource.getFluid() != ItemRemoteInvAccess.this.getFluidType(this.container)) {
                return 0;
            }
            int amount = NbtValue.FLUIDAMOUNT.getInt(this.container, 0);
            int capacity = ItemRemoteInvAccess.this.getCapacity(this.container);
            int free = capacity - amount;
            int toFill = Math.min(resource.amount, free);
            if (toFill > 0 && doFill) {
                NbtValue.FLUIDAMOUNT.setInt(this.container, amount + toFill);
            }
            return toFill;
        }

        @Nullable
        public FluidStack drain(@Nullable FluidStack resource, boolean doDrain) {
            return null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return null;
        }

        @Nonnull
        public ItemStack getContainer() {
            return this.container;
        }
    }
}

