/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.ui.util.factory;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import net.shadowfacts.shadowmc.ui.util.factory.ValueFactory;

public class ColorFactory
implements ValueFactory<Color> {
    public static final ColorFactory INSTANCE = new ColorFactory();
    private static final Map<String, Color> keywords = new HashMap<String, Color>();

    @Override
    public Color create(String s, Color defaultVal) {
        if (s != null && !s.isEmpty()) {
            if (s.startsWith("#")) {
                if ((s = s.substring(1)).length() == 3) {
                    s = "" + s.charAt(0) + s.charAt(0) + s.charAt(1) + s.charAt(1) + s.charAt(2) + s.charAt(2);
                }
                try {
                    return new Color(Integer.parseInt(s, 16));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            } else {
                String keyword = s.toLowerCase();
                Color color = keywords.get(keyword);
                if (color != null) {
                    return color;
                }
            }
        }
        return defaultVal;
    }

    private ColorFactory() {
    }

    static {
        keywords.put("transparent", new Color(0, 0, 0, 0));
        keywords.put("black", new Color(0));
        keywords.put("silver", new Color(0xC0C0C0));
        keywords.put("gray", new Color(0x808080));
        keywords.put("grey", new Color(0x808080));
        keywords.put("white", new Color(0xFFFFFF));
        keywords.put("maroon", new Color(0x800000));
        keywords.put("red", new Color(0xFF0000));
        keywords.put("purple", new Color(0x800080));
        keywords.put("fuchsia", new Color(0xFF00FF));
        keywords.put("green", new Color(32768));
        keywords.put("lime", new Color(65280));
        keywords.put("olive", new Color(0x808000));
        keywords.put("yellow", new Color(0xFFFF00));
        keywords.put("navy", new Color(128));
        keywords.put("blue", new Color(255));
        keywords.put("teal", new Color(32896));
        keywords.put("aqua", new Color(65535));
        keywords.put("orange", new Color(16753920));
        keywords.put("aliceblue", new Color(0xF0F8FF));
        keywords.put("antiquewhite", new Color(16444375));
        keywords.put("aquamarine", new Color(8388564));
        keywords.put("azure", new Color(0xF0FFFF));
        keywords.put("beige", new Color(16119260));
        keywords.put("bisque", new Color(16770244));
        keywords.put("blanchedalmond", new Color(16772045));
        keywords.put("blueviolet", new Color(9055202));
        keywords.put("brown", new Color(0xA52A2A));
        keywords.put("burlywood", new Color(14596231));
        keywords.put("cadetblue", new Color(6266528));
        keywords.put("chartreuse", new Color(0x7FFF00));
        keywords.put("chocolate", new Color(13789470));
        keywords.put("coral", new Color(16744272));
        keywords.put("cornflowerblue", new Color(6591981));
        keywords.put("cornsilk", new Color(16775388));
        keywords.put("crimson", new Color(14423100));
        keywords.put("darkblue", new Color(139));
        keywords.put("darkcyan", new Color(35723));
        keywords.put("darkgoldenrod", new Color(12092939));
        keywords.put("darkgray", new Color(0xA9A9A9));
        keywords.put("darkgrey", new Color(0xA9A9A9));
        keywords.put("darkgreen", new Color(25600));
        keywords.put("darkkhaki", new Color(12433259));
        keywords.put("darkmagenta", new Color(0x8B008B));
        keywords.put("darkolivegreen", new Color(5597999));
        keywords.put("darkorange", new Color(16747520));
        keywords.put("darkorchid", new Color(10040012));
        keywords.put("darkred", new Color(0x8B0000));
        keywords.put("darksalmon", new Color(15308410));
        keywords.put("darkseagreen", new Color(9419919));
        keywords.put("darkslateblue", new Color(4734347));
        keywords.put("darkslategray", new Color(0x2F4F4F));
        keywords.put("darkslategrey", new Color(0x2F4F4F));
        keywords.put("darkturquoise", new Color(52945));
        keywords.put("darkviolet", new Color(9699539));
        keywords.put("deeppink", new Color(16716947));
        keywords.put("deepskyblue", new Color(49151));
        keywords.put("dimgray", new Color(0x696969));
        keywords.put("dimgrey", new Color(0x696969));
        keywords.put("dodgerblue", new Color(2003199));
        keywords.put("firebrick", new Color(0xB22222));
        keywords.put("floralwhite", new Color(0xFFFAF0));
        keywords.put("forestgreen", new Color(0x228B22));
        keywords.put("gainsboro", new Color(0xDCDCDC));
        keywords.put("ghostwhite", new Color(0xF8F8FF));
        keywords.put("gold", new Color(16766720));
        keywords.put("goldenrod", new Color(14329120));
        keywords.put("greenyellow", new Color(11403055));
        keywords.put("honeydew", new Color(0xF0FFF0));
        keywords.put("hotpink", new Color(16738740));
        keywords.put("indianred", new Color(0xCD5C5C));
        keywords.put("indigo", new Color(4915330));
        keywords.put("ivory", new Color(0xFFFFF0));
        keywords.put("khaki", new Color(15787660));
        keywords.put("levender", new Color(15132410));
        keywords.put("levenderblush", new Color(0xFFF0F5));
        keywords.put("lawngreen", new Color(8190976));
        keywords.put("lemonchiffon", new Color(16775885));
        keywords.put("lightblue", new Color(11393254));
        keywords.put("lightcoral", new Color(0xF08080));
        keywords.put("lightcyan", new Color(0xE0FFFF));
        keywords.put("lightgoldenrodyellow", new Color(16448210));
        keywords.put("lightgray", new Color(0xD3D3D3));
        keywords.put("lightgrey", new Color(0xD3D3D3));
        keywords.put("lightgreen", new Color(0x90EE90));
        keywords.put("lightpink", new Color(16758465));
        keywords.put("lightsalmon", new Color(16752762));
        keywords.put("lightseagreen", new Color(2142890));
        keywords.put("lightskyblue", new Color(8900346));
        keywords.put("lightslategray", new Color(0x778899));
        keywords.put("lightslategrey", new Color(0x778899));
        keywords.put("lightsteelblue", new Color(11584734));
        keywords.put("lightyellow", new Color(0xFFFFE0));
        keywords.put("limegreen", new Color(3329330));
        keywords.put("linen", new Color(16445670));
        keywords.put("mediumaquamarine", new Color(6737322));
        keywords.put("mediumblue", new Color(205));
        keywords.put("mediumorchid", new Color(12211667));
        keywords.put("mediumpurple", new Color(9662683));
        keywords.put("mediumseagreen", new Color(3978097));
        keywords.put("mediumslateblue", new Color(8087790));
        keywords.put("mediumspringgreen", new Color(64154));
        keywords.put("mediumturquoise", new Color(4772300));
        keywords.put("mediumvioletred", new Color(13047173));
        keywords.put("midnightblue", new Color(1644912));
        keywords.put("mintcream", new Color(0xF5FFFA));
        keywords.put("mistyrose", new Color(16770273));
        keywords.put("moccasin", new Color(16770229));
        keywords.put("navajowhite", new Color(16768685));
        keywords.put("oldlace", new Color(16643558));
        keywords.put("olivedrab", new Color(7048754));
        keywords.put("orangered", new Color(16729344));
        keywords.put("orchid", new Color(14315734));
        keywords.put("palegoldenrod", new Color(0xEEE8AA));
        keywords.put("palegreen", new Color(10025880));
        keywords.put("paleturquoise", new Color(0xAFEEEE));
        keywords.put("palevioletred", new Color(14381203));
        keywords.put("papayawhip", new Color(16773077));
        keywords.put("peachpuff", new Color(16767673));
        keywords.put("peru", new Color(13468991));
        keywords.put("pink", new Color(16761035));
        keywords.put("plum", new Color(0xDDA0DD));
        keywords.put("powderblue", new Color(11591910));
        keywords.put("rosybrown", new Color(12357519));
        keywords.put("royalblue", new Color(4286945));
        keywords.put("saddlebrown", new Color(9127187));
        keywords.put("salmon", new Color(16416882));
        keywords.put("sandybrown", new Color(16032864));
        keywords.put("seagreen", new Color(3050327));
        keywords.put("seashell", new Color(0xFFF5EE));
        keywords.put("sienna", new Color(10506797));
        keywords.put("skyblue", new Color(8900331));
        keywords.put("slateblue", new Color(6970061));
        keywords.put("slategray", new Color(7372944));
        keywords.put("slategrey", new Color(7372944));
        keywords.put("snow", new Color(0xFFFAFA));
        keywords.put("springgreen", new Color(65407));
        keywords.put("steelblue", new Color(4620980));
        keywords.put("tan", new Color(13808780));
        keywords.put("thistle", new Color(14204888));
        keywords.put("tomato", new Color(16737095));
        keywords.put("turquoise", new Color(4251856));
        keywords.put("violet", new Color(0xEE82EE));
        keywords.put("wheat", new Color(16113331));
        keywords.put("whitesmoke", new Color(0xF5F5F5));
        keywords.put("yellowgreen", new Color(10145074));
        keywords.put("rebeccapurple", new Color(0x663399));
    }
}

