/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.network;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BasePacket
implements IMessage {
    public static final String CHANNEL = "advancedRocketry";
    private static final BiMap<Integer, Class<? extends BasePacket>> idMap;

    public static BasePacket constructPacket(int packetId) throws ProtocolException, InstantiationException, IllegalAccessException {
        Class clazz = (Class)idMap.get((Object)packetId);
        if (clazz == null) {
            throw new ProtocolException("Protocol Exception!  Unknown Packet Id!");
        }
        return (BasePacket)clazz.newInstance();
    }

    public final int getPacketId() {
        if (idMap.inverse().containsKey(this.getClass())) {
            return (Integer)idMap.inverse().get(this.getClass());
        }
        throw new RuntimeException("Packet " + this.getClass().getSimpleName() + " is a missing mapping!");
    }

    public abstract void write(ByteBuf var1);

    public abstract void readClient(ByteBuf var1);

    public abstract void read(ByteBuf var1);

    @SideOnly(value=Side.CLIENT)
    public abstract void executeClient(EntityPlayer var1);

    public abstract void executeServer(EntityPlayerMP var1);

    public void fromBytes(ByteBuf buf) {
        switch (FMLCommonHandler.instance().getSide()) {
            case CLIENT: {
                this.readClient(buf);
                break;
            }
            case SERVER: {
                this.read(buf);
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        this.write(buf);
    }

    static {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        idMap = builder.build();
    }

    public static class ProtocolException
    extends Exception {
        public ProtocolException() {
        }

        public ProtocolException(String message, Throwable cause) {
            super(message, cause);
        }

        public ProtocolException(String message) {
            super(message);
        }

        public ProtocolException(Throwable cause) {
            super(cause);
        }
    }

    public static class BasePacketHandlerClient
    implements IMessageHandler<BasePacket, IMessage> {
        public IMessage onMessage(BasePacket message, MessageContext ctx) {
            switch (ctx.side) {
                case CLIENT: {
                    Minecraft.func_71410_x().func_152344_a((Runnable)new executor(message, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, ctx.side));
                    break;
                }
                case SERVER: {
                    ((WorldServer)ctx.getServerHandler().field_147369_b.field_70170_p).func_152344_a((Runnable)new executor(message, (EntityPlayer)ctx.getServerHandler().field_147369_b, ctx.side));
                }
            }
            return null;
        }

        public static class executor
        implements Runnable {
            final Side side;
            final BasePacket packet;
            final EntityPlayer player;

            public executor(BasePacket packet, EntityPlayer player, Side side) {
                this.packet = packet;
                this.player = player;
                this.side = side;
            }

            @Override
            public void run() {
                if (this.side.isClient()) {
                    this.packet.executeClient(this.player);
                } else {
                    this.packet.executeServer((EntityPlayerMP)this.player);
                }
            }
        }
    }

    public static class BasePacketHandlerServer
    implements IMessageHandler<BasePacket, IMessage> {
        public IMessage onMessage(BasePacket message, MessageContext ctx) {
            ((WorldServer)ctx.getServerHandler().field_147369_b.field_70170_p).func_152344_a((Runnable)new executor(message, (EntityPlayer)ctx.getServerHandler().field_147369_b, ctx.side));
            return null;
        }

        public static class executor
        implements Runnable {
            final Side side;
            final BasePacket packet;
            final EntityPlayer player;

            public executor(BasePacket packet, EntityPlayer player, Side side) {
                this.packet = packet;
                this.player = player;
                this.side = side;
            }

            @Override
            public void run() {
                this.packet.executeServer((EntityPlayerMP)this.player);
            }
        }
    }
}

