/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimensions.world.terrain;

import java.util.Random;
import mcjty.rftoolsdim.config.WorldgenConfiguration;
import mcjty.rftoolsdim.dimensions.types.TerrainType;
import mcjty.rftoolsdim.dimensions.world.GenericChunkGenerator;
import mcjty.rftoolsdim.dimensions.world.terrain.BaseTerrainGenerator;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.ChunkGeneratorEvent;
import net.minecraftforge.event.terraingen.InitNoiseGensEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;

public class CavernTerrainGenerator
implements BaseTerrainGenerator {
    private World world;
    private GenericChunkGenerator provider;
    private CavernHeight heightsetting;
    private static int[] cavernheight = new int[]{8, 16, 24, 32};
    private NoiseGeneratorOctaves netherNoiseGen1;
    private NoiseGeneratorOctaves netherNoiseGen2;
    private NoiseGeneratorOctaves netherNoiseGen3;
    private NoiseGeneratorOctaves netherrackExculsivityNoiseGen;
    private NoiseGeneratorOctaves netherNoiseGen6;
    private NoiseGeneratorOctaves netherNoiseGen7;
    private double[] noiseField;
    private double[] baseBlockExclusivityNoise = new double[256];
    private double[] noiseData1;
    private double[] noiseData2;
    private double[] noiseData3;
    private double[] noiseData4;
    private double[] noiseData5;

    public CavernTerrainGenerator(CavernHeight heightsetting) {
        if (heightsetting == null) {
            int hs = WorldgenConfiguration.cavernHeightLimit;
            if (hs < 0) {
                hs = 0;
            } else if (hs > 3) {
                hs = 3;
            }
            this.heightsetting = CavernHeight.values()[hs];
        } else {
            this.heightsetting = heightsetting;
        }
    }

    @Override
    public void setup(World world, GenericChunkGenerator provider) {
        this.world = world;
        this.provider = provider;
        this.netherNoiseGen1 = new NoiseGeneratorOctaves(provider.rand, 16);
        this.netherNoiseGen2 = new NoiseGeneratorOctaves(provider.rand, 16);
        this.netherNoiseGen3 = new NoiseGeneratorOctaves(provider.rand, 8);
        NoiseGeneratorOctaves slowsandGravelNoiseGen = new NoiseGeneratorOctaves(provider.rand, 4);
        this.netherrackExculsivityNoiseGen = new NoiseGeneratorOctaves(provider.rand, 4);
        this.netherNoiseGen6 = new NoiseGeneratorOctaves(provider.rand, 10);
        this.netherNoiseGen7 = new NoiseGeneratorOctaves(provider.rand, 16);
        InitNoiseGensEvent.ContextHell ctx = new InitNoiseGensEvent.ContextHell(this.netherNoiseGen1, this.netherNoiseGen2, this.netherNoiseGen3, slowsandGravelNoiseGen, this.netherrackExculsivityNoiseGen, this.netherNoiseGen6, this.netherNoiseGen7);
        ctx = (InitNoiseGensEvent.ContextHell)TerrainGen.getModdedNoiseGenerators((World)world, (Random)provider.rand, (InitNoiseGensEvent.Context)ctx);
        this.netherNoiseGen1 = ctx.getLPerlin1();
        this.netherNoiseGen2 = ctx.getLPerlin2();
        this.netherNoiseGen3 = ctx.getPerlin();
        slowsandGravelNoiseGen = ctx.getPerlin2();
        this.netherrackExculsivityNoiseGen = ctx.getPerlin3();
        this.netherNoiseGen6 = ctx.getScale();
        this.netherNoiseGen7 = ctx.getDepth();
    }

    private double[] initializeNoiseField(double[] noiseField, int x, int y, int z, int sx, int sy, int sz) {
        int i2;
        ChunkGeneratorEvent.InitNoiseField event = new ChunkGeneratorEvent.InitNoiseField((IChunkGenerator)this.provider, noiseField, x, y, z, sx, sy, sz);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return event.getNoisefield();
        }
        int syr = cavernheight[this.heightsetting.ordinal()];
        if (noiseField == null) {
            noiseField = new double[sx * sy * sz];
        }
        double d0 = 684.412;
        double d1 = 2053.236;
        this.noiseData4 = this.netherNoiseGen6.func_76304_a(this.noiseData4, x, y, z, sx, 1, sz, 1.0, 0.0, 1.0);
        this.noiseData5 = this.netherNoiseGen7.func_76304_a(this.noiseData5, x, y, z, sx, 1, sz, 100.0, 0.0, 100.0);
        this.noiseData1 = this.netherNoiseGen3.func_76304_a(this.noiseData1, x, y, z, sx, sy, sz, d0 / 80.0, d1 / 60.0, d0 / 80.0);
        this.noiseData2 = this.netherNoiseGen1.func_76304_a(this.noiseData2, x, y, z, sx, sy, sz, d0, d1, d0);
        this.noiseData3 = this.netherNoiseGen2.func_76304_a(this.noiseData3, x, y, z, sx, sy, sz, d0, d1, d0);
        int k1 = 0;
        double[] adouble1 = new double[sy];
        for (i2 = 0; i2 < sy; ++i2) {
            adouble1[i2] = Math.cos((double)i2 * Math.PI * 6.0 / (double)syr) * 2.0;
            double d2 = i2;
            if (i2 > syr) {
                d2 = 0.0;
            } else if (i2 > syr / 2) {
                d2 = syr - 1 - i2;
            }
            if (!(d2 < 4.0)) continue;
            d2 = 4.0 - d2;
            int n = i2;
            adouble1[n] = adouble1[n] - d2 * d2 * d2 * 10.0;
        }
        for (i2 = 0; i2 < sx; ++i2) {
            for (int k2 = 0; k2 < sz; ++k2) {
                double d4 = 0.0;
                for (int j2 = 0; j2 < sy; ++j2) {
                    double d11;
                    double d7 = adouble1[j2];
                    double d8 = this.noiseData2[k1] / 512.0;
                    double d9 = this.noiseData3[k1] / 512.0;
                    double d10 = (this.noiseData1[k1] / 10.0 + 1.0) / 2.0;
                    double d6 = d10 < 0.0 ? d8 : (d10 > 1.0 ? d9 : d8 + (d9 - d8) * d10);
                    d6 -= d7;
                    if (j2 > sy - 4) {
                        d11 = (float)(j2 - (sy - 4)) / 3.0f;
                        d6 = d6 * (1.0 - d11) + -10.0 * d11;
                    }
                    if ((double)j2 < d4) {
                        d11 = (d4 - (double)j2) / 4.0;
                        if (d11 < 0.0) {
                            d11 = 0.0;
                        }
                        if (d11 > 1.0) {
                            d11 = 1.0;
                        }
                        d6 = d6 * (1.0 - d11) + -10.0 * d11;
                    }
                    noiseField[k1] = d6;
                    ++k1;
                }
            }
        }
        return noiseField;
    }

    @Override
    public void generate(int chunkX, int chunkZ, ChunkPrimer primer) {
        IBlockState baseBlock = this.provider.dimensionInformation.getBaseBlockForTerrain();
        Block baseLiquid = this.provider.dimensionInformation.getFluidForTerrain();
        int b0 = 4;
        int liquidlevel = 32;
        if (this.provider.dimensionInformation.getTerrainType() == TerrainType.TERRAIN_FLOODED_CAVERN) {
            liquidlevel = 127;
        }
        int k = b0 + 1;
        int b2 = 33;
        int l = b0 + 1;
        this.noiseField = this.initializeNoiseField(this.noiseField, chunkX * b0, 0, chunkZ * b0, k, b2, l);
        for (int x4 = 0; x4 < b0; ++x4) {
            for (int z4 = 0; z4 < b0; ++z4) {
                for (int height32 = 0; height32 < cavernheight[this.heightsetting.ordinal()]; ++height32) {
                    double d0 = 0.125;
                    double d1 = this.noiseField[((x4 + 0) * l + z4 + 0) * b2 + height32 + 0];
                    double d2 = this.noiseField[((x4 + 0) * l + z4 + 1) * b2 + height32 + 0];
                    double d3 = this.noiseField[((x4 + 1) * l + z4 + 0) * b2 + height32 + 0];
                    double d4 = this.noiseField[((x4 + 1) * l + z4 + 1) * b2 + height32 + 0];
                    double d5 = (this.noiseField[((x4 + 0) * l + z4 + 0) * b2 + height32 + 1] - d1) * d0;
                    double d6 = (this.noiseField[((x4 + 0) * l + z4 + 1) * b2 + height32 + 1] - d2) * d0;
                    double d7 = (this.noiseField[((x4 + 1) * l + z4 + 0) * b2 + height32 + 1] - d3) * d0;
                    double d8 = (this.noiseField[((x4 + 1) * l + z4 + 1) * b2 + height32 + 1] - d4) * d0;
                    for (int h = 0; h < 8; ++h) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        int height = height32 * 8 + h;
                        for (int x = 0; x < 4; ++x) {
                            int index = x + x4 * 4 << 12 | 0 + z4 * 4 << 8 | height;
                            int maxheight = 256;
                            double d14 = 0.25;
                            double d15 = d10;
                            double d16 = (d11 - d10) * d14;
                            for (int z = 0; z < 4; ++z) {
                                if (d15 > 0.0) {
                                    BaseTerrainGenerator.setBlockState(primer, index, baseBlock);
                                } else if (height < liquidlevel) {
                                    BaseTerrainGenerator.setBlockState(primer, index, baseLiquid.func_176223_P());
                                } else {
                                    BaseTerrainGenerator.setBlockState(primer, index, Blocks.field_150350_a.func_176223_P());
                                }
                                index += maxheight;
                                d15 += d16;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    @Override
    public void replaceBlocksForBiome(int chunkX, int chunkZ, ChunkPrimer primer, Biome[] Biomes2) {
        ChunkGeneratorEvent.ReplaceBiomeBlocks event = new ChunkGeneratorEvent.ReplaceBiomeBlocks((IChunkGenerator)this.provider, chunkX, chunkZ, primer, this.world);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return;
        }
        IBlockState baseBlock = this.provider.dimensionInformation.getBaseBlockForTerrain();
        Block baseLiquid = this.provider.dimensionInformation.getFluidForTerrain();
        int b0 = 64;
        double d0 = 0.03125;
        this.baseBlockExclusivityNoise = this.netherrackExculsivityNoiseGen.func_76304_a(this.baseBlockExclusivityNoise, chunkX * 16, chunkZ * 16, 0, 16, 16, 1, d0 * 2.0, d0 * 2.0, d0 * 2.0);
        for (int k = 0; k < 16; ++k) {
            for (int l = 0; l < 16; ++l) {
                int i1 = (int)(this.baseBlockExclusivityNoise[k + l * 16] / 3.0 + 3.0 + this.provider.rand.nextDouble() * 0.25);
                int j1 = -1;
                IBlockState block = baseBlock;
                for (int k1 = 255; k1 >= 0; --k1) {
                    int l1 = (l * 16 + k) * 256 + k1;
                    if (k1 < WorldgenConfiguration.bedrockLayer) {
                        BaseTerrainGenerator.setBlockState(primer, l1, Blocks.field_150357_h.func_176223_P());
                        continue;
                    }
                    if (k1 < 255 - this.provider.rand.nextInt(5) && k1 > this.provider.rand.nextInt(5)) {
                        IBlockState block2 = BaseTerrainGenerator.getBlockState(primer, l1);
                        if (block2 != null && block2.func_177230_c().func_149688_o(block2) != Material.field_151579_a) {
                            if (block2 != baseBlock) continue;
                            if (j1 == -1) {
                                if (i1 <= 0) {
                                    block = null;
                                } else if (k1 >= b0 - 4 && k1 <= b0 + 1) {
                                    block = baseBlock;
                                }
                                if (k1 < b0 && (block == null || block.func_177230_c().func_149688_o(block) == Material.field_151579_a)) {
                                    block = baseLiquid.func_176223_P();
                                }
                                j1 = i1;
                                if (k1 >= b0 - 1) {
                                    BaseTerrainGenerator.setBlockState(primer, l1, block);
                                    continue;
                                }
                                BaseTerrainGenerator.setBlockState(primer, l1, baseBlock);
                                continue;
                            }
                            if (j1 <= 0) continue;
                            --j1;
                            BaseTerrainGenerator.setBlockState(primer, l1, baseBlock);
                            continue;
                        }
                        j1 = -1;
                        continue;
                    }
                    if (this.heightsetting != CavernHeight.HEIGHT_256) continue;
                    BaseTerrainGenerator.setBlockState(primer, l1, Blocks.field_150357_h.func_176223_P());
                }
            }
        }
    }

    public static enum CavernHeight {
        HEIGHT_64,
        HEIGHT_128,
        HEIGHT_196,
        HEIGHT_256;

    }
}

