/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.client.render;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.chunk.IRenderChunkFactory;
import net.minecraft.client.renderer.chunk.ListChunkFactory;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import org.lwjgl.opengl.GL11;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.IInfrastructure;
import zmaster587.advancedRocketry.entity.EntityRocket;
import zmaster587.advancedRocketry.util.StorageChunk;

public class RendererRocket
extends Render
implements IRenderFactory<EntityRocket> {
    private static BlockRendererDispatcher renderBlocks = Minecraft.func_71410_x().func_175602_ab();
    Class tileEntityBlockChiseled;
    Method getState;
    private IRenderChunkFactory factory = new ListChunkFactory();

    public RendererRocket(@Nonnull RenderManager manager) {
        super(manager);
        try {
            this.tileEntityBlockChiseled = Class.forName("mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled");
            this.getState = this.tileEntityBlockChiseled.getMethod("getRenderState", IBlockAccess.class);
            AdvancedRocketry.logger.info("Chisel and bits support HAS BEEN loaded");
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            AdvancedRocketry.logger.info("Chisel and bits support NOT loaded");
        }
    }

    public void func_76986_a(@Nonnull Entity entity, double x, double y, double z, float f1, float f2) {
        StorageChunk storage = ((EntityRocket)entity).storage;
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        if (storage == null || !storage.finalized) {
            return;
        }
        float halfx = (float)storage.getSizeX() / 2.0f;
        float halfy = (float)storage.getSizeY() / 2.0f;
        float halfz = (float)storage.getSizeZ() / 2.0f;
        if (Minecraft.func_71410_x().field_71439_g != null && entity.func_184188_bt().contains(Minecraft.func_71410_x().field_71439_g)) {
            y = -((EntityRocket)entity).stats.getSeatY();
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)1, (int)1);
        GlStateManager.func_179131_c((float)0.5f, (float)1.0f, (float)0.5f, (float)0.2f);
        GlStateManager.func_179090_x();
        GL11.glEnable((int)2852);
        GL11.glLineWidth((float)1.0f);
        GL11.glLineStipple((int)5, (short)8738);
        if (!((EntityRocket)entity).isInFlight()) {
            for (IInfrastructure inf : ((EntityRocket)entity).getConnectedInfrastructure()) {
                if (!inf.canRenderConnection()) continue;
                TileEntity tile = (TileEntity)inf;
                buffer.func_181668_a(2, DefaultVertexFormats.field_181705_e);
                buffer.func_181662_b(0.0, (double)((float)storage.getSizeY() / 2.0f), 0.0).func_181675_d();
                buffer.func_181662_b(((double)tile.func_174877_v().func_177958_n() - entity.field_70165_t + 0.5) / 2.0, (double)((float)storage.getSizeY() / 2.0f), ((double)tile.func_174877_v().func_177952_p() - entity.field_70161_v + 0.5) / 2.0).func_181675_d();
                buffer.func_181662_b((double)tile.func_174877_v().func_177958_n() - entity.field_70165_t + 0.5, (double)tile.func_174877_v().func_177956_o() - entity.field_70163_u + 0.5, (double)tile.func_174877_v().func_177952_p() - entity.field_70161_v + 0.5).func_181675_d();
                buffer.func_181662_b(((double)tile.func_174877_v().func_177958_n() - entity.field_70165_t + 0.5) / 2.0, (double)((float)storage.getSizeY() / 2.0f), ((double)tile.func_174877_v().func_177952_p() - entity.field_70161_v + 0.5) / 2.0).func_181675_d();
                Tessellator.func_178181_a().func_78381_a();
            }
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GL11.glDisable((int)2852);
        GlStateManager.func_179098_w();
        GL11.glPopMatrix();
        if (storage.world.displayListIndex == -1) {
            storage.world.displayListIndex = GLAllocation.func_74526_a((int)1);
            GL11.glPushMatrix();
            GL11.glNewList((int)storage.world.displayListIndex, (int)4864);
            RenderHelper.func_74518_a();
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)BlockRenderLayer.SOLID);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            for (int xx = 0; xx < storage.getSizeX(); ++xx) {
                for (int zz = 0; zz < storage.getSizeZ(); ++zz) {
                    for (int yy = 0; yy < storage.getSizeY(); ++yy) {
                        IBlockState block = storage.func_180495_p(new BlockPos(xx, yy, zz));
                        if (block.func_177230_c().getRegistryName().func_110624_b().equals("chiselsandbits")) continue;
                        buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
                        try {
                            Minecraft.func_71410_x().func_175602_ab().func_175018_a(block, new BlockPos(xx, yy, zz), (IBlockAccess)storage.world, buffer);
                        }
                        catch (NullPointerException e) {
                            System.out.println(block.func_177230_c().func_149739_a() + " cannot be rendered on rocket at " + entity.func_180425_c());
                        }
                        Tessellator.func_178181_a().func_78381_a();
                    }
                }
            }
            ForgeHooksClient.setRenderLayer(null);
            RenderHelper.func_74519_b();
            GL11.glEndList();
            GL11.glPopMatrix();
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y + halfy), (float)((float)z));
        GL11.glRotatef((float)((float)((EntityRocket)entity).getRCSRotateProgress() * 0.9f), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)entity.field_70177_z, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)(-halfx), (float)(0.0f - halfy), (float)(-halfz));
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GL11.glCallList((int)storage.world.displayListIndex);
        for (TileEntity tile : storage.getTileEntityList()) {
            TileEntitySpecialRenderer renderer = (TileEntitySpecialRenderer)TileEntityRendererDispatcher.field_147556_a.field_147559_m.get(tile.getClass());
            if (renderer == null || this.tileEntityBlockChiseled != null && this.tileEntityBlockChiseled.isInstance(tile)) continue;
            TileEntityRendererDispatcher.field_147556_a.func_147549_a(tile, (double)tile.func_174877_v().func_177958_n(), (double)tile.func_174877_v().func_177956_o(), (double)tile.func_174877_v().func_177952_p(), f1);
        }
        if (this.getState != null) {
            TileEntityRendererDispatcher.field_147556_a.preDrawBatch();
            for (TileEntity tile : storage.getTileEntityList()) {
                TileEntitySpecialRenderer renderer = (TileEntitySpecialRenderer)TileEntityRendererDispatcher.field_147556_a.field_147559_m.get(tile.getClass());
                if (renderer == null || !this.tileEntityBlockChiseled.isInstance(tile) || this.getState == null) continue;
                GL11.glPushMatrix();
                try {
                    this.getState.invoke((Object)tile, new Object[]{storage.world});
                    GL11.glTranslated((double)TileEntityRendererDispatcher.field_147554_b, (double)TileEntityRendererDispatcher.field_147555_c, (double)TileEntityRendererDispatcher.field_147552_d);
                    TileEntityRendererDispatcher.field_147556_a.func_147549_a(tile, (double)tile.func_174877_v().func_177958_n(), (double)tile.func_174877_v().func_177956_o(), (double)tile.func_174877_v().func_177952_p(), f1);
                    GL11.glPopMatrix();
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            TileEntityRendererDispatcher.field_147556_a.drawBatch(0);
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_179117_G();
        GL11.glPopMatrix();
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)0, (int)0);
    }

    protected ResourceLocation func_110775_a(@Nullable Entity p_110775_1_) {
        return null;
    }

    public Render<? super EntityRocket> createRenderFor(RenderManager manager) {
        return new RendererRocket(manager);
    }
}

