/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.client.render.planet;

import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.Project;
import zmaster587.advancedRocketry.api.dimension.IDimensionProperties;
import zmaster587.advancedRocketry.api.dimension.solar.StellarBody;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.backwardCompat.ModelFormatException;
import zmaster587.advancedRocketry.backwardCompat.WavefrontObject;
import zmaster587.advancedRocketry.client.render.planet.RenderPlanetarySky;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.entity.EntityRocket;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.stations.SpaceStationObject;
import zmaster587.advancedRocketry.util.SpacePosition;
import zmaster587.libVulpes.render.RenderHelper;
import zmaster587.libVulpes.util.Vector3F;

public class RenderSpaceTravelSky
extends RenderPlanetarySky {
    private static final double SIZE_SCALE = 0.01;
    public static ResourceLocation planetUIBG = new ResourceLocation("advancedrocketry:textures/gui/planetUIOverlay.png");
    public static ResourceLocation planetUIFG = new ResourceLocation("advancedrocketry:textures/gui/planetUIOverlayFG.png");
    private static WavefrontObject sphere;
    ResourceLocation currentlyBoundTex = null;
    float celestialAngle;
    Vector3F<Float> axis;
    Minecraft mc = Minecraft.func_71410_x();
    private int starGLCallList;
    private int glSkyList;
    private int glSkyList2;

    public RenderSpaceTravelSky() {
        int k;
        int j;
        this.axis = new Vector3F((Object)Float.valueOf(1.0f), (Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
        this.starGLCallList = GLAllocation.func_74526_a((int)3);
        GL11.glPushMatrix();
        GL11.glNewList((int)this.starGLCallList, (int)4864);
        this.renderStars();
        GL11.glEndList();
        GL11.glPopMatrix();
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        this.glSkyList = this.starGLCallList + 1;
        GL11.glNewList((int)this.glSkyList, (int)4864);
        int b2 = 64;
        int i = 256 / b2 + 2;
        float f = 16.0f;
        for (j = -b2 * i; j <= b2 * i; j += b2) {
            for (k = -b2 * i; k <= b2 * i; k += b2) {
                buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
                buffer.func_181662_b((double)j, (double)f, (double)k).func_181675_d();
                buffer.func_181662_b((double)(j + b2), (double)f, (double)k).func_181675_d();
                buffer.func_181662_b((double)(j + b2), (double)f, (double)(k + b2)).func_181675_d();
                buffer.func_181662_b((double)j, (double)f, (double)(k + b2)).func_181675_d();
                Tessellator.func_178181_a().func_78381_a();
            }
        }
        GL11.glEndList();
        this.glSkyList2 = this.starGLCallList + 2;
        GL11.glNewList((int)this.glSkyList2, (int)4864);
        f = -16.0f;
        buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (j = -b2 * i; j <= b2 * i; j += b2) {
            for (k = -b2 * i; k <= b2 * i; k += b2) {
                buffer.func_181662_b((double)j, (double)f, (double)k).func_181675_d();
                buffer.func_181662_b((double)(j + b2), (double)f, (double)k).func_181675_d();
                buffer.func_181662_b((double)(j + b2), (double)f, (double)(k + b2)).func_181675_d();
                buffer.func_181662_b((double)j, (double)f, (double)(k + b2)).func_181675_d();
            }
        }
        Tessellator.func_178181_a().func_78381_a();
        GL11.glEndList();
    }

    public static void renderPlanetPubHelper(BufferBuilder buffer, ResourceLocation icon, int locationX, int locationY, double zLevel, float size, float alphaMultiplier, double shadowAngle, boolean hasAtmosphere, float[] skyColor, float[] ringColor, boolean gasGiant, boolean hasRing, boolean hasDecorators) {
        GlStateManager.func_179147_l();
        float f14 = 1.0f;
        float f15 = 0.0f;
        GL11.glPushMatrix();
        GL11.glTranslated((double)locationX, (double)zLevel, (double)locationY);
        if (hasDecorators) {
            GL11.glPushMatrix();
            GL11.glRotated((double)(90.0 - shadowAngle * 180.0 / Math.PI), (double)0.0, (double)1.0, (double)0.0);
            if (hasRing) {
                GlStateManager.func_179112_b((int)770, (int)771);
                GlStateManager.func_179131_c((float)ringColor[0], (float)ringColor[1], (float)ringColor[2], (float)(alphaMultiplier * 0.2f));
                float ringSize = size * 1.4f;
                Minecraft.func_71410_x().field_71446_o.func_110577_a(DimensionProperties.planetRings);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                buffer.func_181662_b((double)(-ringSize), zLevel - (double)0.01f, (double)ringSize).func_187315_a((double)f15, (double)f14).func_181675_d();
                buffer.func_181662_b((double)ringSize, zLevel - (double)0.01f, (double)ringSize).func_187315_a((double)f14, (double)f14).func_181675_d();
                buffer.func_181662_b((double)ringSize, zLevel - (double)0.01f, (double)(-ringSize)).func_187315_a((double)f14, (double)f15).func_181675_d();
                buffer.func_181662_b((double)(-ringSize), zLevel - (double)0.01f, (double)(-ringSize)).func_187315_a((double)f15, (double)f15).func_181675_d();
                Tessellator.func_178181_a().func_78381_a();
                GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)alphaMultiplier);
                Minecraft.func_71410_x().field_71446_o.func_110577_a(DimensionProperties.planetRingShadow);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                buffer.func_181662_b((double)(-ringSize), zLevel - (double)0.01f, (double)ringSize).func_187315_a((double)f15, (double)f14).func_181675_d();
                buffer.func_181662_b((double)ringSize, zLevel - (double)0.01f, (double)ringSize).func_187315_a((double)f14, (double)f14).func_181675_d();
                buffer.func_181662_b((double)ringSize, zLevel - (double)0.01f, (double)(-ringSize)).func_187315_a((double)f14, (double)f15).func_181675_d();
                buffer.func_181662_b((double)(-ringSize), zLevel - (double)0.01f, (double)(-ringSize)).func_187315_a((double)f15, (double)f15).func_181675_d();
                Tessellator.func_178181_a().func_78381_a();
            }
            GlStateManager.func_179112_b((int)770, (int)1);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(DimensionProperties.atmGlow);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alphaMultiplier);
            buffer.func_181662_b((double)(-size), zLevel + (double)0.01f, (double)size).func_187315_a((double)f15, (double)f14).func_181675_d();
            buffer.func_181662_b((double)size, zLevel + (double)0.01f, (double)size).func_187315_a((double)f14, (double)f14).func_181675_d();
            buffer.func_181662_b((double)size, zLevel + (double)0.01f, (double)(-size)).func_187315_a((double)f14, (double)f15).func_181675_d();
            buffer.func_181662_b((double)(-size), zLevel + (double)0.01f, (double)(-size)).func_187315_a((double)f15, (double)f15).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
            GL11.glPopMatrix();
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(icon);
        GlStateManager.func_179112_b((int)770, (int)771);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alphaMultiplier);
        buffer.func_181662_b((double)(-size), zLevel, (double)size).func_187315_a((double)f15, (double)f14).func_181675_d();
        buffer.func_181662_b((double)size, zLevel, (double)size).func_187315_a((double)f14, (double)f14).func_181675_d();
        buffer.func_181662_b((double)size, zLevel, (double)(-size)).func_187315_a((double)f14, (double)f15).func_181675_d();
        buffer.func_181662_b((double)(-size), zLevel, (double)(-size)).func_187315_a((double)f15, (double)f15).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        if (hasDecorators) {
            if (hasAtmosphere) {
                GlStateManager.func_179112_b((int)770, (int)1);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                Minecraft.func_71410_x().field_71446_o.func_110577_a(DimensionProperties.getAtmosphereResource());
                GlStateManager.func_179131_c((float)skyColor[0], (float)skyColor[1], (float)skyColor[2], (float)alphaMultiplier);
                buffer.func_181662_b((double)(-size), zLevel, (double)size).func_187315_a((double)f15, (double)f14).func_181675_d();
                buffer.func_181662_b((double)size, zLevel, (double)size).func_187315_a((double)f14, (double)f14).func_181675_d();
                buffer.func_181662_b((double)size, zLevel, (double)(-size)).func_187315_a((double)f14, (double)f15).func_181675_d();
                buffer.func_181662_b((double)(-size), zLevel, (double)(-size)).func_187315_a((double)f15, (double)f15).func_181675_d();
                Tessellator.func_178181_a().func_78381_a();
            }
            GL11.glRotated((double)(90.0 - shadowAngle * 180.0 / Math.PI), (double)0.0, (double)1.0, (double)0.0);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(DimensionProperties.getShadowResource());
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alphaMultiplier);
            buffer.func_181662_b((double)(-size * 1.05f), zLevel - (double)0.01f, (double)(size * 1.05f)).func_187315_a((double)f15, (double)f14).func_181675_d();
            buffer.func_181662_b((double)(size * 1.05f), zLevel - (double)0.01f, (double)(size * 1.05f)).func_187315_a((double)f14, (double)f14).func_181675_d();
            buffer.func_181662_b((double)(size * 1.05f), zLevel - (double)0.01f, (double)(-size * 1.05f)).func_187315_a((double)f14, (double)f15).func_181675_d();
            buffer.func_181662_b((double)(-size * 1.05f), zLevel - (double)0.01f, (double)(-size * 1.05f)).func_187315_a((double)f15, (double)f15).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
        }
        GL11.glPopMatrix();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void renderPlanet(IDimensionProperties properties, SpacePosition position, SpacePosition playerPosition, float sizeOverride) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)position.x), (float)((float)position.y), (float)((float)position.z));
        GlStateManager.func_179152_a((float)sizeOverride, (float)sizeOverride, (float)sizeOverride);
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)true);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(properties.getPlanetIconLEO());
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        sphere.renderAll();
        GlStateManager.func_179121_F();
        GlStateManager.func_179112_b((int)1, (int)770);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)1.1f, (float)1.1f, (float)1.1f);
        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)((float)(-(properties.getOrbitTheta() * 180.0 / Math.PI))), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179112_b((int)770, (int)771);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(DimensionProperties.shadow3);
        GlStateManager.func_179131_c((float)0.1f, (float)0.1f, (float)0.1f, (float)0.75f);
        sphere.renderAll();
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        if (properties.hasRings()) {
            GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            float[] ringColor = properties.getRingColor();
            GlStateManager.func_179131_c((float)ringColor[0], (float)ringColor[1], (float)ringColor[2], (float)0.5f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(DimensionProperties.planetRings);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            RenderHelper.renderBottomFaceWithUV((BufferBuilder)buffer, (double)0.0, (double)-1.0, (double)-1.0, (double)1.0, (double)1.0, (double)0.0, (double)1.0, (double)0.0, (double)1.0);
            Tessellator.func_178181_a().func_78381_a();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(DimensionProperties.planetRingShadow);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            RenderHelper.renderTopFaceWithUV((BufferBuilder)buffer, (double)0.0, (double)-1.0, (double)-1.0, (double)1.0, (double)1.0, (double)0.0, (double)1.0, (double)0.0, (double)1.0);
            RenderHelper.renderBottomFaceWithUV((BufferBuilder)buffer, (double)0.0, (double)-1.0, (double)-1.0, (double)1.0, (double)1.0, (double)0.0, (double)1.0, (double)0.0, (double)1.0);
            Tessellator.func_178181_a().func_78381_a();
        }
        GL11.glPopMatrix();
        if (properties.hasAtmosphere()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)((float)(-(properties.getOrbitTheta() * 180.0 / Math.PI))), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)1.1f, (float)1.1f, (float)1.1f);
            GlStateManager.func_179090_x();
            GlStateManager.func_179112_b((int)770, (int)771);
            float[] skyColor = properties.getSkyColor();
            GlStateManager.func_179131_c((float)skyColor[0], (float)skyColor[1], (float)skyColor[2], (float)0.04f);
            for (int i = 0; i < 10; ++i) {
                GlStateManager.func_179152_a((float)1.01f, (float)1.01f, (float)1.01f);
                sphere.renderAll();
            }
            GlStateManager.func_179098_w();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179121_F();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179112_b((int)770, (int)771);
    }

    private double getDistance(SpacePosition a, SpacePosition b) {
        double deltaX = a.x - b.x;
        double deltaY = a.y - b.y;
        double deltaZ = a.z - b.z;
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
    }

    public void renderStar(StellarBody entity, SpacePosition position, SpacePosition playerSpacePosition) {
        if (entity == null) {
            return;
        }
        if (entity.isBlackHole()) {
            float sunSize = (float)entity.getDisplayRadius() / 50.0f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)position.x, (double)position.y, (double)position.z);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureResources.locationBlackHole);
            BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179147_l();
            GlStateManager.func_179141_d();
            GlStateManager.func_179092_a((int)516, (float)0.01f);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            GlStateManager.func_179131_c((float)1.0f, (float)0.5f, (float)0.4f, (float)1.0f);
            GlStateManager.func_179094_E();
            float phase = (float)(-(System.currentTimeMillis() % 3600L)) / 3600.0f;
            float scale = 1.0f + (float)Math.sin((double)phase * 3.14) * 0.1f;
            scale = (float)((double)scale * 0.1);
            GL11.glRotatef((float)(phase *= 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glScaled((double)scale, (double)scale, (double)scale);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            RenderHelper.renderNorthFaceWithUV((BufferBuilder)buffer, (double)0.0, (double)-5.0, (double)-5.0, (double)5.0, (double)5.0, (double)0.0, (double)1.0, (double)0.0, (double)1.0);
            RenderHelper.renderEastFaceWithUV((BufferBuilder)buffer, (double)0.0, (double)-5.0, (double)-5.0, (double)5.0, (double)5.0, (double)0.0, (double)1.0, (double)0.0, (double)1.0);
            RenderHelper.renderTopFaceWithUV((BufferBuilder)buffer, (double)0.0, (double)-5.0, (double)-5.0, (double)5.0, (double)5.0, (double)0.0, (double)1.0, (double)0.0, (double)1.0);
            Tessellator.func_178181_a().func_78381_a();
            GlStateManager.func_179121_F();
            this.mc.field_71446_o.func_110577_a(TextureResources.locationAccretionDisk);
            GlStateManager.func_179132_a((boolean)false);
            for (int i = 0; i < 3; ++i) {
                float speedMult = (float)i * 1.01f + 1.0f;
                GL11.glPushMatrix();
                GL11.glRotatef((float)80.0f, (float)-1.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)((float)(System.currentTimeMillis() % (long)((int)(speedMult * 36000.0f))) / (100.0f * speedMult)), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179131_c((float)1.0f, (float)0.5f, (float)0.4f, (float)1.0f);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                float f10 = sunSize * 40.0f;
                buffer.func_181662_b((double)(-f10), 0.0, (double)(-f10)).func_187315_a(0.0, 0.0).func_181675_d();
                buffer.func_181662_b((double)f10, 0.0, (double)(-f10)).func_187315_a(1.0, 0.0).func_181675_d();
                buffer.func_181662_b((double)f10, 0.0, (double)f10).func_187315_a(1.0, 1.0).func_181675_d();
                buffer.func_181662_b((double)(-f10), 0.0, (double)f10).func_187315_a(0.0, 1.0).func_181675_d();
                Tessellator.func_178181_a().func_78381_a();
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glTranslatef((float)0.0f, (float)-0.1f, (float)0.0f);
                GL11.glRotatef((float)80.0f, (float)-1.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)((float)(System.currentTimeMillis() % (long)((int)(speedMult * 360.0f * 50.0f))) / (50.0f * speedMult)), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179131_c((float)0.8f, (float)0.7f, (float)0.4f, (float)1.0f);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                f10 = sunSize * 30.0f;
                buffer.func_181662_b((double)(-f10), 0.0, (double)(-f10)).func_187315_a(0.0, 0.0).func_181675_d();
                buffer.func_181662_b((double)f10, 0.0, (double)(-f10)).func_187315_a(1.0, 0.0).func_181675_d();
                buffer.func_181662_b((double)f10, 0.0, (double)f10).func_187315_a(1.0, 1.0).func_181675_d();
                buffer.func_181662_b((double)(-f10), 0.0, (double)f10).func_187315_a(0.0, 1.0).func_181675_d();
                Tessellator.func_178181_a().func_78381_a();
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glTranslatef((float)0.0f, (float)-0.2f, (float)0.0f);
                GL11.glRotatef((float)80.0f, (float)-1.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)((float)(System.currentTimeMillis() % (long)((int)(speedMult * 360.0f * 25.0f))) / (25.0f * speedMult)), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179131_c((float)0.2f, (float)0.4f, (float)1.0f, (float)1.0f);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                f10 = sunSize * 15.0f;
                buffer.func_181662_b((double)(-f10), 0.0, (double)(-f10)).func_187315_a(0.0, 0.0).func_181675_d();
                buffer.func_181662_b((double)f10, 0.0, (double)(-f10)).func_187315_a(1.0, 0.0).func_181675_d();
                buffer.func_181662_b((double)f10, 0.0, (double)f10).func_187315_a(1.0, 1.0).func_181675_d();
                buffer.func_181662_b((double)(-f10), 0.0, (double)f10).func_187315_a(0.0, 1.0).func_181675_d();
                Tessellator.func_178181_a().func_78381_a();
                GL11.glPopMatrix();
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179126_j();
        } else {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)position.x, (double)position.y, (double)position.z);
            GlStateManager.func_179152_a((float)10.0f, (float)10.0f, (float)10.0f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureResources.locationSunNew);
            BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179147_l();
            GlStateManager.func_179141_d();
            GlStateManager.func_179092_a((int)516, (float)0.01f);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            GlStateManager.func_179124_c((float)entity.getColor()[0], (float)entity.getColor()[1], (float)entity.getColor()[2]);
            GlStateManager.func_179092_a((int)516, (float)0.0f);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            RenderHelper.renderNorthFaceWithUV((BufferBuilder)buffer, (double)0.0, (double)-5.0, (double)-5.0, (double)5.0, (double)5.0, (double)0.0, (double)1.0, (double)0.0, (double)1.0);
            RenderHelper.renderEastFaceWithUV((BufferBuilder)buffer, (double)0.0, (double)-5.0, (double)-5.0, (double)5.0, (double)5.0, (double)0.0, (double)1.0, (double)0.0, (double)1.0);
            RenderHelper.renderTopFaceWithUV((BufferBuilder)buffer, (double)0.0, (double)-5.0, (double)-5.0, (double)5.0, (double)5.0, (double)0.0, (double)1.0, (double)0.0, (double)1.0);
            RenderHelper.renderNorthFaceWithUV((BufferBuilder)buffer, (double)0.0, (double)-5.0, (double)-5.0, (double)5.0, (double)5.0, (double)0.0, (double)1.0, (double)0.0, (double)1.0);
            RenderHelper.renderEastFaceWithUV((BufferBuilder)buffer, (double)0.0, (double)-5.0, (double)-5.0, (double)5.0, (double)5.0, (double)0.0, (double)1.0, (double)0.0, (double)1.0);
            RenderHelper.renderTopFaceWithUV((BufferBuilder)buffer, (double)0.0, (double)-5.0, (double)-5.0, (double)5.0, (double)5.0, (double)0.0, (double)1.0, (double)0.0, (double)1.0);
            Tessellator.func_178181_a().func_78381_a();
            GlStateManager.func_179094_E();
            GlStateManager.func_179090_x();
            GlStateManager.func_179112_b((int)770, (int)1);
            float[] skyColor = entity.getColor();
            GlStateManager.func_179131_c((float)(skyColor[0] * 0.02f), (float)(skyColor[1] * 0.02f), (float)(skyColor[2] * 0.02f), (float)1.0f);
            GlStateManager.func_179152_a((float)7.1f, (float)7.1f, (float)7.1f);
            for (int i = 0; i < 10; ++i) {
                GlStateManager.func_179152_a((float)1.05f, (float)1.05f, (float)1.05f);
                sphere.renderAll();
            }
            GlStateManager.func_179098_w();
            GlStateManager.func_179121_F();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179112_b((int)770, (int)771);
    }

    private void renderStars() {
        Random random = new Random(10842L);
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (int i = 0; i < 2000; ++i) {
            double d0 = random.nextFloat() * 2.0f - 1.0f;
            double d1 = random.nextFloat() * 2.0f - 1.0f;
            double d2 = random.nextFloat() * 2.0f - 1.0f;
            double d3 = 0.15f + random.nextFloat() * 0.1f;
            double d4 = d0 * d0 + d1 * d1 + d2 * d2;
            if (!(d4 < 1.0) || !(d4 > 0.01)) continue;
            d4 = 1.0 / Math.sqrt(d4);
            double d5 = (d0 *= d4) * 100.0;
            double d6 = (d1 *= d4) * 100.0;
            double d7 = (d2 *= d4) * 100.0;
            double d8 = Math.atan2(d0, d2);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = random.nextDouble() * Math.PI * 2.0;
            double d15 = Math.sin(d14);
            double d16 = Math.cos(d14);
            for (int j = 0; j < 4; ++j) {
                double d17 = 0.0;
                double d18 = (double)((j & 2) - 1) * d3;
                double d19 = (double)((j + 1 & 2) - 1) * d3;
                double d20 = d18 * d16 - d19 * d15;
                double d21 = d19 * d16 + d18 * d15;
                double d22 = d20 * d12 + d17 * d13;
                double d23 = d17 * d12 - d20 * d13;
                double d24 = d23 * d9 - d21 * d10;
                double d25 = d21 * d9 + d23 * d10;
                buffer.func_181662_b(d5 + d24, d6 + d22, d7 + d25).func_181675_d();
            }
        }
        Tessellator.func_178181_a().func_78381_a();
    }

    private void getAllPlanets(List<IDimensionProperties> allPlanets, IDimensionProperties planet) {
        for (int i : planet.getChildPlanets()) {
            DimensionProperties childProps = DimensionManager.getInstance().getDimensionProperties(i);
            allPlanets.add(DimensionManager.getInstance().getDimensionProperties(i));
            this.getAllPlanets(allPlanets, childProps);
        }
    }

    private void buildSolarSystem(SpacePosition playerPosition) {
        List<IDimensionProperties> planets = playerPosition.star.getPlanets();
        if (playerPosition.world != null) {
            float sizeScale = playerPosition.world.getRenderSizePlanetView();
            SpacePosition newSpacePos = new SpacePosition();
            this.renderPlanet(playerPosition.world, newSpacePos, playerPosition, sizeScale);
            LinkedList<IDimensionProperties> subPlanets = new LinkedList<IDimensionProperties>();
            this.getAllPlanets(subPlanets, playerPosition.world);
            for (IDimensionProperties iDimensionProperties : subPlanets) {
                SpacePosition subPlanetPos = iDimensionProperties.getSpacePosition();
                sizeScale = iDimensionProperties.getRenderSizePlanetView();
                subPlanetPos.x += newSpacePos.x;
                subPlanetPos.y += newSpacePos.y;
                subPlanetPos.z += newSpacePos.z;
                this.renderPlanet(iDimensionProperties, subPlanetPos, playerPosition, sizeScale);
            }
            subPlanets.add(playerPosition.world);
            this.mc.field_71446_o.func_110577_a(TextureResources.locationReticle);
            GlStateManager.func_179112_b((int)770, (int)1);
            GlStateManager.func_179131_c((float)1.0f, (float)0.5f, (float)0.5f, (float)1.0f);
            BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            for (IDimensionProperties subPlanet : subPlanets) {
                List<ISpaceObject> stations = SpaceObjectManager.getSpaceManager().getSpaceStationsOrbitingPlanet(subPlanet.getId());
                if (stations == null) continue;
                for (ISpaceObject property : stations) {
                    SpacePosition spacePos = ((SpaceStationObject)property).getSpacePosition();
                    this.renderCrossHair(buffer, spacePos, 50.0f);
                }
            }
            Tessellator.func_178181_a().func_78381_a();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)3.0f, (float)0.0f);
            for (IDimensionProperties subPlanet : subPlanets) {
                SpacePosition spacePos = subPlanet.getId() == playerPosition.world.getId() ? new SpacePosition() : subPlanet.getSpacePosition();
                float distance = (float)this.getDistance(playerPosition, spacePos);
                RenderHelper.renderTag((double)distance, (String)String.format("%s : %dkm", subPlanet.getName(), (int)(distance - subPlanet.getRenderSizePlanetView())), (double)spacePos.x, (double)spacePos.y, (double)spacePos.z, (int)200, (float)(distance / 10.0f));
                List<ISpaceObject> stations = SpaceObjectManager.getSpaceManager().getSpaceStationsOrbitingPlanet(subPlanet.getId());
                if (stations == null) continue;
                for (ISpaceObject property : stations) {
                    spacePos = ((SpaceStationObject)property).getSpacePosition();
                    distance = (float)this.getDistance(playerPosition, spacePos);
                    RenderHelper.renderTag((double)distance, (String)String.format("Station - %d : %dkm", property.getId(), (int)distance), (double)spacePos.x, (double)spacePos.y, (double)spacePos.z, (int)200, (float)(distance / 10.0f));
                }
            }
        } else {
            SpacePosition spacePos;
            for (IDimensionProperties property : planets) {
                SpacePosition spacePos2 = property.getSpacePosition();
                float sizeScale = property.getRenderSizeSolarView();
                double d = this.getDistance(playerPosition, spacePos2);
                sizeScale = property.isMoon() ? sizeScale * 0.2f : sizeScale;
                this.renderPlanet(property, spacePos2, playerPosition, sizeScale);
                LinkedList<IDimensionProperties> subPlanets = new LinkedList<IDimensionProperties>();
                this.getAllPlanets(subPlanets, property);
                for (IDimensionProperties subproperty : subPlanets) {
                    SpacePosition subPlanetPos = subproperty.getSpacePosition();
                    sizeScale = subproperty.getRenderSizeSolarView();
                    subPlanetPos.x = subPlanetPos.x / 10.0 + spacePos2.x;
                    subPlanetPos.y = subPlanetPos.y / 10.0 + spacePos2.y;
                    subPlanetPos.z = subPlanetPos.z / 10.0 + spacePos2.z;
                    this.renderPlanet(subproperty, subPlanetPos, playerPosition, sizeScale);
                }
            }
            GlStateManager.func_179094_E();
            float adjustmentScale = 4.0f;
            GlStateManager.func_179152_a((float)adjustmentScale, (float)adjustmentScale, (float)adjustmentScale);
            List<StellarBody> subStars = playerPosition.star.getSubStars();
            StellarBody star = playerPosition.star;
            SpacePosition mainStarPos = star.getSpacePosition();
            this.renderStar(star, mainStarPos, playerPosition);
            if (subStars != null && !subStars.isEmpty()) {
                float f = 360.0f / (float)subStars.size();
                double phase = 0.0;
                for (StellarBody subStar : subStars) {
                    double theta = phase;
                    phase += (double)f;
                    SpacePosition subStarSpacePosition = mainStarPos.getFromSpherical(40.0f * subStar.getStarSeparation(), theta);
                    this.renderStar(subStar, subStarSpacePosition, playerPosition);
                }
            }
            GlStateManager.func_179121_F();
            this.mc.field_71446_o.func_110577_a(TextureResources.locationReticle);
            GlStateManager.func_179112_b((int)770, (int)1);
            GlStateManager.func_179124_c((float)0.0f, (float)1.0f, (float)0.0f);
            BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
            bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            for (IDimensionProperties property : planets) {
                spacePos = property.getSpacePosition();
                this.renderCrossHair(bufferBuilder, spacePos, 200.0f);
            }
            Tessellator.func_178181_a().func_78381_a();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)3.0f, (float)0.0f);
            for (IDimensionProperties property : planets) {
                spacePos = property.getSpacePosition();
                float distance = (float)this.getDistance(playerPosition, spacePos);
                int displayDist = 100 * (int)(distance - property.getRenderSizeSolarView());
                if (displayDist > 1000000) {
                    RenderHelper.renderTag((double)distance, (String)String.format("%s : FAR", property.getName()), (double)spacePos.x, (double)spacePos.y, (double)spacePos.z, (int)200, (float)(distance / 10.0f));
                    continue;
                }
                RenderHelper.renderTag((double)distance, (String)String.format("%s : %dkm", property.getName(), displayDist), (double)spacePos.x, (double)spacePos.y, (double)spacePos.z, (int)200, (float)(distance / 10.0f));
            }
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179147_l();
    }

    private void renderCrossHair(BufferBuilder buffer, SpacePosition spacePos, float size) {
        float f = 0.0f;
        float f1 = 1.0f;
        float f2 = 0.0f;
        float f3 = 1.0f;
        float f5 = (float)spacePos.x;
        float f6 = (float)spacePos.y;
        float f7 = (float)spacePos.z;
        float rotationX = ActiveRenderInfo.func_178808_b();
        float rotationZ = ActiveRenderInfo.func_178809_c();
        float rotationYZ = ActiveRenderInfo.func_178803_d();
        float rotationXY = ActiveRenderInfo.func_178805_e();
        float rotationXZ = ActiveRenderInfo.func_178807_f();
        Vec3d[] avec3d = new Vec3d[]{new Vec3d((double)(-rotationX * size - rotationXY * size), (double)(-rotationZ * size), (double)(-rotationYZ * size - rotationXZ * size)), new Vec3d((double)(-rotationX * size + rotationXY * size), (double)(rotationZ * size), (double)(-rotationYZ * size + rotationXZ * size)), new Vec3d((double)(rotationX * size + rotationXY * size), (double)(rotationZ * size), (double)(rotationYZ * size + rotationXZ * size)), new Vec3d((double)(rotationX * size - rotationXY * size), (double)(-rotationZ * size), (double)(rotationYZ * size - rotationXZ * size))};
        buffer.func_181662_b((double)f5 + avec3d[0].field_72450_a, (double)f6 + avec3d[0].field_72448_b, (double)f7 + avec3d[0].field_72449_c).func_187315_a((double)f1, (double)f3).func_181675_d();
        buffer.func_181662_b((double)f5 + avec3d[1].field_72450_a, (double)f6 + avec3d[1].field_72448_b, (double)f7 + avec3d[1].field_72449_c).func_187315_a((double)f1, (double)f2).func_181675_d();
        buffer.func_181662_b((double)f5 + avec3d[2].field_72450_a, (double)f6 + avec3d[2].field_72448_b, (double)f7 + avec3d[2].field_72449_c).func_187315_a((double)f, (double)f2).func_181675_d();
        buffer.func_181662_b((double)f5 + avec3d[3].field_72450_a, (double)f6 + avec3d[3].field_72448_b, (double)f7 + avec3d[3].field_72449_c).func_187315_a((double)f, (double)f3).func_181675_d();
    }

    private void setupSpaceCam(float partialTicks) {
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179096_D();
        float fov = this.mc.field_71474_y.field_74334_X;
        Project.gluPerspective((float)fov, (float)((float)this.mc.field_71443_c / (float)this.mc.field_71440_d), (float)10.0f, (float)1000000.0f);
        GlStateManager.func_179128_n((int)5888);
    }

    private void undoSpaceCam(float partialTicks) {
        float fov = this.mc.field_71474_y.field_74334_X;
        float farplane = this.mc.field_71474_y.field_151451_c * 16;
        Project.gluPerspective((float)fov, (float)((float)this.mc.field_71443_c / (float)this.mc.field_71440_d), (float)0.05f, (float)(farplane * MathHelper.field_180189_a));
    }

    @Override
    public void render(float partialTicks, WorldClient world, Minecraft mc) {
        this.setupSpaceCam(partialTicks);
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        Entity ridingEntity = player.func_184187_bx();
        if (!(ridingEntity instanceof EntityRocket)) {
            return;
        }
        SpacePosition spacePosition = ((EntityRocket)ridingEntity).getSpacePosition();
        this.celestialAngle = mc.field_71441_e.func_72826_c(partialTicks);
        GlStateManager.func_179098_w();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        GL11.glPushMatrix();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        if (spacePosition.world != null) {
            GlStateManager.func_179114_b((float)(-((float)(spacePosition.world.getOrbitTheta() * 180.0 / Math.PI))), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GL11.glScaled((double)100.0, (double)100.0, (double)100.0);
        GlStateManager.func_179090_x();
        GlStateManager.func_179106_n();
        float f18 = 1.0f;
        GlStateManager.func_179131_c((float)f18, (float)f18, (float)f18, (float)f18);
        GL11.glPushMatrix();
        GL11.glCallList((int)this.starGLCallList);
        GlStateManager.func_179131_c((float)f18, (float)f18, (float)f18, (float)(f18 / 2.0f));
        GL11.glPushMatrix();
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glCallList((int)this.starGLCallList);
        GL11.glPopMatrix();
        GlStateManager.func_179131_c((float)f18, (float)f18, (float)f18, (float)(f18 / 4.0f));
        GL11.glPushMatrix();
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glCallList((int)this.starGLCallList);
        GL11.glPopMatrix();
        GlStateManager.func_179131_c((float)f18, (float)f18, (float)f18, (float)f18);
        GL11.glPopMatrix();
        if (spacePosition.world != null) {
            GlStateManager.func_179147_l();
            GlStateManager.func_179098_w();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
            DimensionProperties properties = spacePosition.world;
            StellarBody sun = spacePosition.star;
            float[] suncolorfloat = sun.getColor();
            Vec3d color = new Vec3d((double)suncolorfloat[0], (double)suncolorfloat[1], (double)suncolorfloat[2]);
            this.drawStarAndSubStars(bufferBuilder, spacePosition.star, spacePosition.world, properties.getSolarOrbitalDistance(), sun.getSize(), color, 1.0f);
            GlStateManager.func_179084_k();
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GL11.glTranslated((double)(-spacePosition.x), (double)(-spacePosition.y), (double)(-spacePosition.z));
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179129_p();
        GlStateManager.func_179098_w();
        GlStateManager.func_179106_n();
        this.buildSolarSystem(spacePosition);
        GlStateManager.func_179127_m();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GL11.glPopMatrix();
        GlStateManager.func_179098_w();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179086_m((int)256);
    }

    @Override
    protected ResourceLocation getTextureForPlanet(DimensionProperties properties) {
        return properties.getPlanetIcon();
    }

    @Override
    protected ResourceLocation getTextureForPlanetLEO(DimensionProperties properties) {
        return properties.getPlanetIcon();
    }

    @Override
    protected EnumFacing getRotationAxis(DimensionProperties properties, BlockPos pos) {
        return EnumFacing.EAST;
    }

    protected void renderPlanet(BufferBuilder buffer, DimensionProperties properties, float planetOrbitalDistance, float alphaMultiplier, double shadowAngle, boolean hasAtmosphere, boolean hasRing) {
        this.renderPlanet2(buffer, properties, 10.0f * (200.0f - planetOrbitalDistance) / 100.0f, alphaMultiplier, shadowAngle, hasRing);
    }

    protected void renderPlanet2(BufferBuilder buffer, DimensionProperties properties, float size, float alphaMultiplier, double shadowAngle, boolean hasRing) {
        ResourceLocation icon = this.getTextureForPlanet(properties);
        boolean hasAtmosphere = properties.hasAtmosphere();
        boolean gasGiant = properties.isGasGiant();
        boolean hasDecorators = properties.hasDecorators();
        float[] skyColor = properties.skyColor;
        float[] ringColor = properties.skyColor;
        RenderSpaceTravelSky.renderPlanetPubHelper(buffer, icon, 0, 0, -20.0, size * 0.2f, alphaMultiplier, shadowAngle, hasAtmosphere, skyColor, ringColor, gasGiant, hasRing, hasDecorators);
    }

    @Override
    protected void rotateAroundAxis() {
        Vector3F<Float> axis = this.getRotateAxis();
        GL11.glRotatef((float)(this.getSkyRotationAmount() * 360.0f), (float)((Float)axis.x).floatValue(), (float)((Float)axis.y).floatValue(), (float)((Float)axis.z).floatValue());
    }

    @Override
    protected float getSkyRotationAmount() {
        return this.celestialAngle;
    }

    @Override
    protected Vector3F<Float> getRotateAxis() {
        return this.axis;
    }

    @Override
    protected void drawStar(BufferBuilder buffer, StellarBody sun, DimensionProperties properties, int solarOrbitalDistance, float sunSize, Vec3d sunColor, float multiplier) {
        if (sun != null && sun.isBlackHole()) {
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179141_d();
            GlStateManager.func_179092_a((int)516, (float)0.01f);
            this.mc.field_71446_o.func_110577_a(TextureResources.locationBlackHole);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)100.0f, (float)0.0f);
            float phase = (float)(-(System.currentTimeMillis() % 3600L)) / 3600.0f;
            float scale = 1.0f + (float)Math.sin((double)phase * 3.14) * 0.1f;
            GL11.glRotatef((float)(phase *= 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glScaled((double)scale, (double)scale, (double)scale);
            GlStateManager.func_179131_c((float)1.0f, (float)0.5f, (float)0.4f, (float)1.0f);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            float f10 = sunSize * 5.0f * (float)(202 - solarOrbitalDistance) / 100.0f;
            buffer.func_181662_b((double)(-f10), 0.0, (double)(-f10)).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b((double)f10, 0.0, (double)(-f10)).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b((double)f10, 0.0, (double)f10).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b((double)(-f10), 0.0, (double)f10).func_187315_a(0.0, 1.0).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
            GL11.glPopMatrix();
            this.mc.field_71446_o.func_110577_a(TextureResources.locationAccretionDisk);
            GlStateManager.func_179132_a((boolean)false);
            for (int i = 0; i < 3; ++i) {
                float speedMult = (float)i * 1.01f + 1.0f;
                GL11.glPushMatrix();
                GL11.glTranslatef((float)0.0f, (float)100.0f, (float)0.0f);
                GL11.glRotatef((float)80.0f, (float)-1.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)((float)(System.currentTimeMillis() % (long)((int)(speedMult * 36000.0f))) / (100.0f * speedMult)), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179131_c((float)1.0f, (float)0.5f, (float)0.4f, (float)1.0f);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                f10 = sunSize * 40.0f * (float)(202 - solarOrbitalDistance) / 100.0f;
                buffer.func_181662_b((double)(-f10), 0.0, (double)(-f10)).func_187315_a(0.0, 0.0).func_181675_d();
                buffer.func_181662_b((double)f10, 0.0, (double)(-f10)).func_187315_a(1.0, 0.0).func_181675_d();
                buffer.func_181662_b((double)f10, 0.0, (double)f10).func_187315_a(1.0, 1.0).func_181675_d();
                buffer.func_181662_b((double)(-f10), 0.0, (double)f10).func_187315_a(0.0, 1.0).func_181675_d();
                Tessellator.func_178181_a().func_78381_a();
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glTranslatef((float)0.0f, (float)99.99f, (float)0.0f);
                GL11.glRotatef((float)80.0f, (float)-1.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)((float)(System.currentTimeMillis() % (long)((int)(speedMult * 360.0f * 50.0f))) / (50.0f * speedMult)), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179131_c((float)0.8f, (float)0.7f, (float)0.4f, (float)1.0f);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                f10 = sunSize * 30.0f * (float)(202 - solarOrbitalDistance) / 100.0f;
                buffer.func_181662_b((double)(-f10), 0.0, (double)(-f10)).func_187315_a(0.0, 0.0).func_181675_d();
                buffer.func_181662_b((double)f10, 0.0, (double)(-f10)).func_187315_a(1.0, 0.0).func_181675_d();
                buffer.func_181662_b((double)f10, 0.0, (double)f10).func_187315_a(1.0, 1.0).func_181675_d();
                buffer.func_181662_b((double)(-f10), 0.0, (double)f10).func_187315_a(0.0, 1.0).func_181675_d();
                Tessellator.func_178181_a().func_78381_a();
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glTranslatef((float)0.0f, (float)99.98f, (float)0.0f);
                GL11.glRotatef((float)80.0f, (float)-1.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)((float)(System.currentTimeMillis() % (long)((int)(speedMult * 360.0f * 25.0f))) / (25.0f * speedMult)), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179131_c((float)0.2f, (float)0.4f, (float)1.0f, (float)1.0f);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                f10 = sunSize * 15.0f * (float)(202 - solarOrbitalDistance) / 100.0f;
                buffer.func_181662_b((double)(-f10), 0.0, (double)(-f10)).func_187315_a(0.0, 0.0).func_181675_d();
                buffer.func_181662_b((double)f10, 0.0, (double)(-f10)).func_187315_a(1.0, 0.0).func_181675_d();
                buffer.func_181662_b((double)f10, 0.0, (double)f10).func_187315_a(1.0, 1.0).func_181675_d();
                buffer.func_181662_b((double)(-f10), 0.0, (double)f10).func_187315_a(0.0, 1.0).func_181675_d();
                Tessellator.func_178181_a().func_78381_a();
                GL11.glPopMatrix();
            }
            GlStateManager.func_179132_a((boolean)true);
            GL11.glClear((int)256);
            GlStateManager.func_179132_a((boolean)false);
        } else {
            this.mc.field_71446_o.func_110577_a(TextureResources.locationSunPng);
            GlStateManager.func_179131_c((float)((float)sunColor.field_72450_a), (float)((float)sunColor.field_72448_b), (float)((float)sunColor.field_72449_c), (float)Math.min(multiplier * 2.0f, 1.0f));
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            float f10 = sunSize * 30.0f * (float)(202 - solarOrbitalDistance) / 100.0f;
            buffer.func_181662_b((double)(-f10), 100.0, (double)(-f10)).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b((double)f10, 100.0, (double)(-f10)).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b((double)f10, 100.0, (double)f10).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b((double)(-f10), 100.0, (double)f10).func_187315_a(0.0, 1.0).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
        }
    }

    static {
        try {
            sphere = new WavefrontObject(new ResourceLocation("advancedrocketry:models/atmosphere.obj"));
        }
        catch (ModelFormatException e) {
            throw new RuntimeException(e);
        }
    }
}

