/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.entity;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockSand;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.advancements.ARAdvancements;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.AdvancedRocketryItems;
import zmaster587.advancedRocketry.api.EntityRocketBase;
import zmaster587.advancedRocketry.api.IAtmosphere;
import zmaster587.advancedRocketry.api.IInfrastructure;
import zmaster587.advancedRocketry.api.RocketEvent;
import zmaster587.advancedRocketry.api.SatelliteRegistry;
import zmaster587.advancedRocketry.api.StatsRocket;
import zmaster587.advancedRocketry.api.dimension.IDimensionProperties;
import zmaster587.advancedRocketry.api.dimension.solar.StellarBody;
import zmaster587.advancedRocketry.api.fuel.FuelRegistry;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.atmosphere.AtmosphereHandler;
import zmaster587.advancedRocketry.block.BlockRegolith;
import zmaster587.advancedRocketry.client.SoundRocketEngine;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.event.PlanetEventHandler;
import zmaster587.advancedRocketry.inventory.IPlanetDefiner;
import zmaster587.advancedRocketry.inventory.modules.ModuleBrokenPart;
import zmaster587.advancedRocketry.inventory.modules.ModulePlanetSelector;
import zmaster587.advancedRocketry.inventory.modules.ModuleStellarBackground;
import zmaster587.advancedRocketry.item.ItemAsteroidChip;
import zmaster587.advancedRocketry.item.ItemPackedStructure;
import zmaster587.advancedRocketry.item.ItemPlanetIdentificationChip;
import zmaster587.advancedRocketry.item.ItemStationChip;
import zmaster587.advancedRocketry.mission.MissionOreMining;
import zmaster587.advancedRocketry.network.PacketSatellite;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.stations.SpaceStationObject;
import zmaster587.advancedRocketry.tile.TileBrokenPart;
import zmaster587.advancedRocketry.tile.TileGuidanceComputer;
import zmaster587.advancedRocketry.tile.TileRocketAssemblingMachine;
import zmaster587.advancedRocketry.tile.hatch.TileSatelliteHatch;
import zmaster587.advancedRocketry.util.Asteroid;
import zmaster587.advancedRocketry.util.AudioRegistry;
import zmaster587.advancedRocketry.util.PlanetaryTravelHelper;
import zmaster587.advancedRocketry.util.RocketInventoryHelper;
import zmaster587.advancedRocketry.util.SpacePosition;
import zmaster587.advancedRocketry.util.StationLandingLocation;
import zmaster587.advancedRocketry.util.StorageChunk;
import zmaster587.advancedRocketry.util.TransitionEntity;
import zmaster587.advancedRocketry.world.util.TeleporterNoPortal;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.client.util.ProgressBarImage;
import zmaster587.libVulpes.gui.CommonResources;
import zmaster587.libVulpes.interfaces.INetworkEntity;
import zmaster587.libVulpes.inventory.GuiHandler;
import zmaster587.libVulpes.inventory.TextureResources;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.IProgressBar;
import zmaster587.libVulpes.inventory.modules.ISelectionNotify;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.inventory.modules.ModuleContainerPan;
import zmaster587.libVulpes.inventory.modules.ModuleContainerPanYOnly;
import zmaster587.libVulpes.inventory.modules.ModuleImage;
import zmaster587.libVulpes.inventory.modules.ModuleProgress;
import zmaster587.libVulpes.inventory.modules.ModuleSlotButton;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.items.ItemLinker;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketEntity;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.util.FluidUtils;
import zmaster587.libVulpes.util.HashedBlockPosition;
import zmaster587.libVulpes.util.IconResource;
import zmaster587.libVulpes.util.Vector3F;
import zmaster587.libVulpes.util.ZUtils;

public class EntityRocket
extends EntityRocketBase
implements INetworkEntity,
IModularInventory,
IProgressBar,
IButtonInventory,
ISelectionNotify,
IPlanetDefiner {
    private static final int DESCENT_TIMER = 40;
    private Vec3d poscorrection;
    private Vec3d velcorrection;
    boolean last_was_in_orbit = false;
    boolean reset_position = true;
    boolean reset_motion = true;
    private static final int BUTTON_ID_OFFSET = 25;
    private static final int STATION_LOC_OFFSET = 50;
    private static final int ENGINE_IGNITION_CNT = 100;
    private static final DataParameter<Integer> fuelLevelMonopropellant = EntityDataManager.func_187226_a(EntityRocket.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> fuelLevelBipropellant = EntityDataManager.func_187226_a(EntityRocket.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> fuelLevelOxidizer = EntityDataManager.func_187226_a(EntityRocket.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> fuelLevelNuclearWorkingFluid = EntityDataManager.func_187226_a(EntityRocket.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> INFLIGHT = EntityDataManager.func_187226_a(EntityRocket.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> INORBIT = EntityDataManager.func_187226_a(EntityRocket.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> INSPACEFLIGHT = EntityDataManager.func_187226_a(EntityRocket.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> RCS_MODE = EntityDataManager.func_187226_a(EntityRocket.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> LAUNCH_COUNTER = EntityDataManager.func_187226_a(EntityRocket.class, (DataSerializer)DataSerializers.field_187192_b);
    private static long ERROR_DISPLAY_TIME = 100L;
    private final int tilebuttonOffset = 3;
    public StorageChunk storage;
    protected long lastWorldTickTicked;
    protected int destinationDimId;
    protected ModulePlanetSelector container;
    boolean acceptedPacket = false;
    SpacePosition spacePosition;
    private boolean isInOrbit = false;
    private boolean isInFlight;
    private int lastDimensionFrom = 0;
    private boolean turningLeft;
    private boolean turningRight;
    private boolean turningUp;
    private boolean turningDownforWhat;
    private String errorStr;
    private long lastErrorTime = Long.MIN_VALUE;
    private ModuleText landingPadDisplayText;
    private SatelliteBase satellite;
    private int autoDescendTimer;
    private int rcs_mode_counter = 0;
    private boolean rcs_mode = false;

    public EntityRocket(World p_i1582_1_) {
        super(p_i1582_1_);
        this.poscorrection = new Vec3d(0.0, 0.0, 0.0);
        this.velcorrection = new Vec3d(0.0, 0.0, 0.0);
        this.stats = new StatsRocket();
        this.isInFlight = false;
        this.connectedInfrastructure = new LinkedList();
        this.infrastructureCoords = new HashSet();
        this.lastWorldTickTicked = p_i1582_1_.func_82737_E();
        this.autoDescendTimer = 5000;
        this.landingPadDisplayText = new ModuleText(256, 16, "", 65280, 2.0f);
        this.landingPadDisplayText.setColor(65280);
        this.spacePosition = new SpacePosition();
        this.spacePosition.star = DimensionManager.getInstance().getStar(0);
    }

    public EntityRocket(World world, StorageChunk storage, StatsRocket stats, double x, double y, double z) {
        this(world);
        this.stats = stats;
        this.func_70107_b(x, y, z);
        this.storage = storage;
        this.storage.setEntity(this);
        this.initFromBounds();
        this.isInFlight = false;
        this.lastWorldTickTicked = world.func_82737_E();
        this.autoDescendTimer = 5000;
        this.landingPadDisplayText = new ModuleText(256, 16, "", 65280, 2.0f);
        this.landingPadDisplayText.setColor(65280);
    }

    private static IBlockState getDamagedBlock(IBlockState blockState) {
        ItemStack stack = new ItemStack(blockState.func_177230_c(), 1, blockState.func_177230_c().func_176201_c(blockState));
        if (ZUtils.isItemInOreDict((ItemStack)stack, (String)"stone") || blockState.func_177230_c() == Blocks.field_150417_aV || ZUtils.isItemInOreDict((ItemStack)stack, (String)"bricksStone")) {
            return Blocks.field_150347_e.func_176223_P();
        }
        if (ZUtils.isItemInOreDict((ItemStack)stack, (String)"cobblestone") || ZUtils.isItemInOreDict((ItemStack)stack, (String)"gravel")) {
            return AdvancedRocketryBlocks.blockBasalt.func_176223_P();
        }
        if (blockState.func_177230_c() == AdvancedRocketryBlocks.blockBasalt) {
            return Blocks.field_189877_df.func_176223_P();
        }
        if (blockState.func_177230_c() == Blocks.field_150424_aL) {
            return Blocks.field_189877_df.func_176223_P();
        }
        if (blockState.func_177230_c() == Blocks.field_189877_df) {
            return Blocks.field_150353_l.func_176223_P();
        }
        if (blockState.func_185904_a() == Material.field_151577_b) {
            return Blocks.field_150346_d.func_176223_P();
        }
        if (blockState.func_185904_a() == Material.field_151578_c && !(blockState.func_177230_c() instanceof BlockRegolith)) {
            return Blocks.field_150354_m.func_176223_P();
        }
        if (blockState.func_177230_c() instanceof BlockSand || blockState.func_177230_c() instanceof BlockRegolith || ZUtils.isItemInOreDict((ItemStack)stack, (String)"regolith") || ZUtils.isItemInOreDict((ItemStack)stack, (String)"sandstone")) {
            return Blocks.field_150359_w.func_176223_P();
        }
        if (blockState.func_185904_a() == Material.field_151588_w || blockState.func_185904_a() == Material.field_151598_x || (blockState.func_185904_a() == Material.field_151597_y || blockState.func_185904_a() == Material.field_151596_z) && blockState.func_177230_c() != Blocks.field_150431_aC) {
            return Blocks.field_150355_j.func_176223_P();
        }
        if (blockState.func_185904_a() == Material.field_151586_h || blockState.func_177230_c() == Blocks.field_150431_aC) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (blockState.func_185904_a() == Material.field_151575_d || blockState.func_185904_a() == Material.field_151584_j || blockState.func_185904_a() == Material.field_151585_k || blockState.func_185904_a() == Material.field_151572_C || blockState.func_185904_a() == Material.field_151569_G || blockState.func_185904_a() == Material.field_151580_n || blockState.func_185904_a() == Material.field_151593_r || blockState.func_185904_a() == Material.field_151570_A || blockState.func_185904_a() == Material.field_151583_m) {
            return Blocks.field_150480_ab.func_176223_P();
        }
        return null;
    }

    public void toggleRCS() {
        if (DimensionManager.getInstance().getDimensionProperties(this.field_70170_p.field_73011_w.getDimension()).isAsteroid()) {
            this.rcs_mode = !this.rcs_mode;
            this.setRCS(this.rcs_mode);
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        } else {
            this.rcs_mode = false;
            this.setRCS(false);
        }
    }

    public boolean getRCS() {
        return (Boolean)this.field_70180_af.func_187225_a(RCS_MODE);
    }

    private void setRCS(boolean status) {
        this.field_70180_af.func_187227_b(RCS_MODE, (Object)status);
    }

    public boolean getInSpaceFlight() {
        return (Boolean)this.field_70180_af.func_187225_a(INSPACEFLIGHT);
    }

    private void setInSpaceFlight(boolean status) {
        this.field_70180_af.func_187227_b(INSPACEFLIGHT, (Object)status);
    }

    public int getRCSRotateProgress() {
        return this.rcs_mode_counter;
    }

    public AxisAlignedBB func_174813_aQ() {
        if (this.storage != null) {
            return super.func_174813_aQ();
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    public void func_174826_a(AxisAlignedBB bb) {
        super.func_174826_a(bb);
    }

    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    public SpacePosition getSpacePosition() {
        return this.spacePosition;
    }

    public void disconnectInfrastructure(IInfrastructure infrastructure) {
        infrastructure.unlinkRocket();
        this.infrastructureCoords.remove(new HashedBlockPosition(((TileEntity)infrastructure).func_174877_v()));
        if (!this.field_70170_p.field_72995_K) {
            int[] pos = new int[]{((TileEntity)infrastructure).func_174877_v().func_177958_n(), ((TileEntity)infrastructure).func_174877_v().func_177956_o(), ((TileEntity)infrastructure).func_174877_v().func_177952_p()};
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74783_a("pos", pos);
        }
    }

    @Override
    public void linkInfrastructure(IInfrastructure tile) {
        super.linkInfrastructure(tile);
        if (tile instanceof TileEntity) {
            this.infrastructureCoords.add(new HashedBlockPosition(((TileEntity)tile).func_174877_v()));
        }
    }

    @Override
    public String getTextOverlay() {
        ERROR_DISPLAY_TIME = 100L;
        if (this.field_70170_p.func_82737_E() < this.lastErrorTime + ERROR_DISPLAY_TIME) {
            return this.errorStr;
        }
        String displayStr = LibVulpes.proxy.getLocalizedString("msg.na");
        if (this.storage != null) {
            int dimid = this.storage.getDestinationDimId(this.field_70170_p.field_73011_w.getDimension(), (int)this.field_70165_t, (int)this.field_70161_v);
            if (dimid == ARConfiguration.getCurrentConfig().spaceDimId) {
                ISpaceObject spaceObject;
                Vector3F<Float> vec = this.storage.getDestinationCoordinates(dimid, false);
                if (vec != null && (spaceObject = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(new BlockPos((double)((Float)vec.x).floatValue(), (double)((Float)vec.y).floatValue(), (double)((Float)vec.z).floatValue()))) != null) {
                    displayStr = LibVulpes.proxy.getLocalizedString("msg.entity.rocket.station") + spaceObject.getId();
                    StationLandingLocation location = this.storage.getGuidanceComputer().getLandingLocation(spaceObject.getId());
                    if (location != null) {
                        displayStr = displayStr + "\n" + LibVulpes.proxy.getLocalizedString("msg.entity.rocket.pad") + location;
                    }
                }
            } else if (dimid != -2147483647 && dimid != Integer.MIN_VALUE) {
                boolean goingToOrbit;
                boolean bl = goingToOrbit = ARConfiguration.getCurrentConfig().experimentalSpaceFlight && this.storage.getGuidanceComputer().func_191420_l();
                if (goingToOrbit) {
                    displayStr = "Orbit";
                } else {
                    displayStr = DimensionManager.getInstance().getDimensionProperties(dimid).getName();
                    Vector3F<Float> loc = this.storage.getDestinationCoordinates(dimid, false);
                    if (loc != null) {
                        String name = this.storage.getDestinationName(dimid);
                        if (!name.isEmpty()) {
                            displayStr = displayStr + String.format("\n%s: %s", LibVulpes.proxy.getLocalizedString("msg.label.destName"), name);
                        }
                        displayStr = displayStr + String.format("\n%s: %.0f, %.0f", LibVulpes.proxy.getLocalizedString("msg.label.coords"), loc.x, loc.z);
                    } else {
                        displayStr = displayStr + "\nCoords: ???, ???";
                    }
                }
            }
        }
        if ((Integer)this.field_70180_af.func_187225_a(LAUNCH_COUNTER) >= 0) {
            return LibVulpes.proxy.getLocalizedString("msg.entity.rocket.launch") + (Integer)this.field_70180_af.func_187225_a(LAUNCH_COUNTER) / 20 + "\n" + LibVulpes.proxy.getLocalizedString("msg.entity.rocket.launch2");
        }
        if (DimensionManager.getInstance().getDimensionProperties(this.field_70170_p.field_73011_w.getDimension()).isAsteroid()) {
            if (this.getRCS()) {
                return LibVulpes.proxy.getLocalizedString("msg.entity.rocket.rcs") + ": " + this.getRCS();
            }
            displayStr = displayStr + "\n" + LibVulpes.proxy.getLocalizedString("msg.entity.rocket.rcs") + ": " + this.getRCS();
        }
        if (this.isInOrbit() && !this.isInFlight()) {
            return super.getTextOverlay();
        }
        if (!this.isInFlight()) {
            return LibVulpes.proxy.getLocalizedString("msg.entity.rocket.ascend.1") + "\n" + LibVulpes.proxy.getLocalizedString("msg.entity.rocket.ascend.2") + displayStr;
        }
        return super.getTextOverlay();
    }

    private void setError(String error) {
        this.errorStr = error;
        this.lastErrorTime = this.field_70170_p.func_82737_E();
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
        if (this.storage != null) {
            if (this.getRCS()) {
                float sizeX = (float)this.storage.getSizeX() / 2.0f;
                float sizeY = (float)this.storage.getSizeY() / 2.0f;
                float sizeZ = this.storage.getSizeZ();
                this.func_174826_a(new AxisAlignedBB(x - (double)sizeX, y - this.func_70033_W() + (double)sizeZ * 0.5 + 0.5, z - (double)sizeY, x + (double)sizeX, y + (double)sizeZ * 1.5 + 0.5 - this.func_70033_W(), z + (double)sizeY));
            } else {
                float sizeX = (float)this.storage.getSizeX() / 2.0f;
                float sizeY = this.storage.getSizeY();
                float sizeZ = (float)this.storage.getSizeZ() / 2.0f;
                this.func_174826_a(new AxisAlignedBB(x - (double)sizeX, y - this.func_70033_W(), z - (double)sizeZ, x + (double)sizeX, y + (double)sizeY - this.func_70033_W(), z + (double)sizeZ));
            }
        }
    }

    public void func_174829_m() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        if (this.storage != null && this.getRCS()) {
            float sizeX = (float)this.storage.getSizeX() / 2.0f;
            float sizeY = (float)this.storage.getSizeY() / 2.0f;
            float sizeZ = this.storage.getSizeZ();
            this.field_70165_t = (axisalignedbb.field_72340_a + axisalignedbb.field_72336_d) / 2.0;
            this.field_70163_u = axisalignedbb.field_72338_b - (double)sizeZ * 0.5 - 0.5;
            this.field_70161_v = (axisalignedbb.field_72339_c + axisalignedbb.field_72334_f) / 2.0;
        } else {
            super.func_174829_m();
        }
    }

    @Override
    public int getFuelAmount(@Nullable FuelRegistry.FuelType fuelType) {
        if (fuelType != null) {
            int amount;
            switch (fuelType) {
                case LIQUID_MONOPROPELLANT: {
                    amount = (Integer)this.field_70180_af.func_187225_a(fuelLevelMonopropellant);
                    break;
                }
                case LIQUID_BIPROPELLANT: {
                    amount = (Integer)this.field_70180_af.func_187225_a(fuelLevelBipropellant);
                    break;
                }
                case LIQUID_OXIDIZER: {
                    amount = (Integer)this.field_70180_af.func_187225_a(fuelLevelOxidizer);
                    break;
                }
                case NUCLEAR_WORKING_FLUID: {
                    amount = (Integer)this.field_70180_af.func_187225_a(fuelLevelNuclearWorkingFluid);
                    break;
                }
                default: {
                    return 0;
                }
            }
            this.stats.setFuelAmount(fuelType, amount);
            return amount;
        }
        return 0;
    }

    @Override
    public int addFuelAmount(@Nonnull FuelRegistry.FuelType fuelType, int amount) {
        int ret = this.stats.addFuelAmount(fuelType, amount);
        this.setFuelAmount(fuelType, this.stats.getFuelAmount(fuelType));
        return ret;
    }

    @Override
    public void setFuelAmount(@Nonnull FuelRegistry.FuelType fuelType, int amt) {
        if (fuelType == FuelRegistry.FuelType.LIQUID_MONOPROPELLANT) {
            this.field_70180_af.func_187227_b(fuelLevelMonopropellant, (Object)amt);
            this.field_70180_af.func_187217_b(fuelLevelMonopropellant);
        } else if (fuelType == FuelRegistry.FuelType.LIQUID_BIPROPELLANT) {
            this.field_70180_af.func_187227_b(fuelLevelBipropellant, (Object)amt);
            this.field_70180_af.func_187217_b(fuelLevelBipropellant);
        } else if (fuelType == FuelRegistry.FuelType.LIQUID_OXIDIZER) {
            this.field_70180_af.func_187227_b(fuelLevelOxidizer, (Object)amt);
            this.field_70180_af.func_187217_b(fuelLevelOxidizer);
        } else if (fuelType == FuelRegistry.FuelType.NUCLEAR_WORKING_FLUID) {
            this.field_70180_af.func_187227_b(fuelLevelNuclearWorkingFluid, (Object)amt);
            this.field_70180_af.func_187217_b(fuelLevelNuclearWorkingFluid);
        }
    }

    @Override
    public void setFuelConsumptionRate(@Nonnull FuelRegistry.FuelType fuelType, int rate) {
        this.stats.setFuelRate(fuelType, rate);
    }

    @Override
    public int getFuelCapacity(@Nullable FuelRegistry.FuelType fuelType) {
        return this.stats.getFuelCapacity(fuelType);
    }

    @Override
    public int getFuelConsumptionRate(@Nullable FuelRegistry.FuelType fuelType) {
        return this.stats.getFuelRate(fuelType);
    }

    @Override
    @Nullable
    public FuelRegistry.FuelType getRocketFuelType() {
        if (this.getFuelCapacity(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT) > 0) {
            return FuelRegistry.FuelType.LIQUID_MONOPROPELLANT;
        }
        if (this.getFuelCapacity(FuelRegistry.FuelType.LIQUID_BIPROPELLANT) > 0) {
            return FuelRegistry.FuelType.LIQUID_BIPROPELLANT;
        }
        if (this.getFuelCapacity(FuelRegistry.FuelType.NUCLEAR_WORKING_FLUID) > 0) {
            return FuelRegistry.FuelType.NUCLEAR_WORKING_FLUID;
        }
        return null;
    }

    public void func_145769_d(int id) {
        super.func_145769_d(id);
        if (this.field_70170_p.field_72995_K) {
            PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.REQUESTNBT.ordinal()));
        }
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean isInFlight() {
        if (!this.field_70170_p.field_72995_K) {
            return this.isInFlight;
        }
        return (Boolean)this.field_70180_af.func_187225_a(INFLIGHT);
    }

    public void setInFlight(boolean inFlight) {
        this.isInFlight = inFlight;
        this.field_70180_af.func_187227_b(INFLIGHT, (Object)inFlight);
        this.field_70180_af.func_187217_b(INFLIGHT);
    }

    public boolean isInOrbit() {
        if (!this.field_70170_p.field_72995_K) {
            return this.isInOrbit;
        }
        return (Boolean)this.field_70180_af.func_187225_a(INORBIT);
    }

    public void setInOrbit(boolean inOrbit) {
        this.isInOrbit = inOrbit;
        this.field_70180_af.func_187227_b(INORBIT, (Object)inOrbit);
        this.field_70180_af.func_187217_b(INORBIT);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(INFLIGHT, (Object)false);
        this.field_70180_af.func_187214_a(fuelLevelMonopropellant, (Object)0);
        this.field_70180_af.func_187214_a(fuelLevelBipropellant, (Object)0);
        this.field_70180_af.func_187214_a(fuelLevelOxidizer, (Object)0);
        this.field_70180_af.func_187214_a(fuelLevelNuclearWorkingFluid, (Object)0);
        this.field_70180_af.func_187214_a(INORBIT, (Object)false);
        this.field_70180_af.func_187214_a(RCS_MODE, (Object)false);
        this.field_70180_af.func_187214_a(LAUNCH_COUNTER, (Object)-1);
        this.field_70180_af.func_187214_a(INSPACEFLIGHT, (Object)false);
    }

    public void initFromBounds() {
        if (this.storage != null) {
            this.func_70105_a(Math.max(this.storage.getSizeX(), this.storage.getSizeZ()), this.storage.getSizeY());
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    protected boolean interact(@Nonnull EntityPlayer player) {
        ItemStack heldItem = player.func_184586_b(EnumHand.MAIN_HAND);
        boolean isHoldingFluidItemOrLinker = false;
        if (!heldItem.func_190926_b()) {
            FluidStack fluidStack;
            if (heldItem.func_77973_b() instanceof ItemLinker) {
                isHoldingFluidItemOrLinker = true;
                if (ItemLinker.isSet((ItemStack)heldItem)) {
                    TileEntity tile = this.field_70170_p.func_175625_s(ItemLinker.getMasterCoords((ItemStack)heldItem));
                    if (tile instanceof IInfrastructure) {
                        IInfrastructure infrastructure = (IInfrastructure)tile;
                        if (this.func_70011_f(ItemLinker.getMasterCoords((ItemStack)heldItem).func_177958_n(), this.field_70163_u, ItemLinker.getMasterCoords((ItemStack)heldItem).func_177952_p()) < (double)(infrastructure.getMaxLinkDistance() + Math.max(this.storage.getSizeX(), this.storage.getSizeZ()))) {
                            if (!this.connectedInfrastructure.contains(tile)) {
                                this.linkInfrastructure(infrastructure);
                                if (!this.field_70170_p.field_72995_K) {
                                    player.func_145747_a((ITextComponent)new TextComponentString("Linked successfully"));
                                }
                                ItemLinker.resetPosition((ItemStack)heldItem);
                                return true;
                            }
                            if (!this.field_70170_p.field_72995_K) {
                                player.func_145747_a((ITextComponent)new TextComponentString("Already linked!"));
                            }
                        } else if (!this.field_70170_p.field_72995_K) {
                            player.func_145747_a((ITextComponent)new TextComponentString("The object you are trying to link is too far away"));
                        }
                    } else if (!this.field_70170_p.field_72995_K) {
                        player.func_145747_a((ITextComponent)new TextComponentString("This cannot be linked to a rocket!"));
                    }
                } else if (!this.field_70170_p.field_72995_K) {
                    player.func_145747_a((ITextComponent)new TextComponentString("Nothing to be linked"));
                }
                return false;
            }
            if (FluidUtils.containsFluid((ItemStack)heldItem) && FluidUtils.getFluidForItem((ItemStack)heldItem) != null && ARConfiguration.getCurrentConfig().canBeFueledByHand && this.canRocketFitFluid(fluidStack = FluidUtils.getFluidForItem((ItemStack)heldItem))) {
                isHoldingFluidItemOrLinker = true;
                FuelRegistry.FuelType type = this.getRocketFuelType();
                if (type == null) {
                    return false;
                }
                if (this.getRocketFuelType() == FuelRegistry.FuelType.LIQUID_BIPROPELLANT && FuelRegistry.instance.isFuel(FuelRegistry.FuelType.LIQUID_OXIDIZER, fluidStack.getFluid())) {
                    type = FuelRegistry.FuelType.LIQUID_OXIDIZER;
                }
                this.stats.setFuelRate(type, (int)((float)this.stats.getBaseFuelRate(type) * FuelRegistry.instance.getMultiplier(type, fluidStack.getFluid())));
                FluidTank rocketFakeTank = new FluidTank(this.getFuelCapacity(type) - this.getFuelAmount(type));
                FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)EnumHand.MAIN_HAND, (IFluidHandler)rocketFakeTank);
                this.addFuelAmount(type, rocketFakeTank.getFluidAmount());
            }
        }
        if (player.func_70093_af() || !this.stats.hasSeat() && !isHoldingFluidItemOrLinker) {
            this.openGui(player);
        } else if (this.stats.hasSeat() && this.func_184188_bt().size() < this.stats.getNumPassengerSeats() && !this.field_70170_p.field_72995_K) {
            player.func_184220_m((Entity)this);
        }
        return true;
    }

    protected boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().size() < this.stats.getNumPassengerSeats();
    }

    public boolean canRocketFitFluid(FluidStack fluidStack) {
        if (FuelRegistry.instance.isFuel(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT, fluidStack.getFluid())) {
            boolean isCorrectFluid;
            boolean bl = isCorrectFluid = this.stats.getFuelFluid().equals("null") || fluidStack.getFluid() == FluidRegistry.getFluid((String)this.stats.getFuelFluid());
            if (this.stats.getFuelFluid().equals("null") && isCorrectFluid) {
                this.stats.setFuelFluid(fluidStack.getFluid().getName());
            }
            return isCorrectFluid;
        }
        if (FuelRegistry.instance.isFuel(FuelRegistry.FuelType.LIQUID_BIPROPELLANT, fluidStack.getFluid())) {
            boolean isCorrectFluid;
            boolean bl = isCorrectFluid = this.stats.getFuelFluid().equals("null") || fluidStack.getFluid() == FluidRegistry.getFluid((String)this.stats.getFuelFluid());
            if (this.stats.getFuelFluid().equals("null") && isCorrectFluid) {
                this.stats.setFuelFluid(fluidStack.getFluid().getName());
            }
            return isCorrectFluid;
        }
        if (FuelRegistry.instance.isFuel(FuelRegistry.FuelType.LIQUID_OXIDIZER, fluidStack.getFluid())) {
            boolean isCorrectFluid;
            boolean bl = isCorrectFluid = this.stats.getOxidizerFluid().equals("null") || fluidStack.getFluid() == FluidRegistry.getFluid((String)this.stats.getOxidizerFluid());
            if (this.stats.getOxidizerFluid().equals("null") && isCorrectFluid) {
                this.stats.setOxidizerFluid(fluidStack.getFluid().getName());
            }
            return isCorrectFluid;
        }
        return false;
    }

    public void openGui(EntityPlayer player) {
        player.openGui((Object)LibVulpes.instance, GuiHandler.guiId.MODULAR.ordinal(), player.field_70170_p, this.func_145782_y(), -1, 0);
        if (!this.field_70170_p.field_72995_K) {
            RocketInventoryHelper.addPlayerToInventoryBypass(player);
        }
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (this.field_70170_p.field_72995_K) {
            PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.SENDINTERACT.ordinal()));
            return this.interact(player);
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isBurningFuel() {
        FuelRegistry.FuelType fuelType = this.getRocketFuelType();
        if (!(fuelType != FuelRegistry.FuelType.LIQUID_BIPROPELLANT ? this.getFuelAmount(fuelType) > 0 : this.getFuelAmount(fuelType) > 0 && this.getFuelAmount(FuelRegistry.FuelType.LIQUID_OXIDIZER) > 0)) {
            if (ARConfiguration.getCurrentConfig().rocketRequireFuel) return false;
        }
        if (!this.func_184188_bt().isEmpty()) {
            if (this.getPassengerMovingForward() > 0.0f) return true;
        }
        if (this.isInOrbit()) return false;
        return true;
    }

    public float getPassengerMovingForward() {
        for (Entity entity : this.func_184188_bt()) {
            if (!(entity instanceof EntityPlayer)) continue;
            return ((EntityPlayer)entity).field_191988_bg;
        }
        return 0.0f;
    }

    private boolean hasHumanPassenger() {
        for (Entity entity : this.func_184188_bt()) {
            if (!(entity instanceof EntityPlayer)) continue;
            return true;
        }
        return false;
    }

    public boolean isDescentPhase() {
        int ch = this.field_70170_p.func_189649_b((int)this.field_70165_t, (int)this.field_70161_v);
        return ARConfiguration.getCurrentConfig().automaticRetroRockets && this.isInOrbit() && (this.field_70163_u < (double)(ch + 300) && (this.field_70181_x < -0.5 || this.field_70170_p.field_72995_K) || this.field_70163_u < (double)(ch + 150) && (this.field_70181_x < (double)-0.4f || this.field_70170_p.field_72995_K) || this.field_70163_u < (double)(ch + 100) && (this.field_70181_x < (double)-0.3f || this.field_70170_p.field_72995_K) || this.field_70163_u < (double)(ch + 70) && (this.field_70181_x < (double)-0.2f || this.field_70170_p.field_72995_K) || this.field_70163_u < (double)(ch + 50) && (this.field_70181_x < (double)-0.14f || this.field_70170_p.field_72995_K) || this.field_70163_u < (double)(ch + 20) && (this.field_70181_x < -0.5 || this.field_70170_p.field_72995_K) || this.field_70163_u < (double)(ch + 10) && (this.field_70181_x < (double)-0.05f || this.field_70170_p.field_72995_K));
    }

    public boolean isStartupPhase() {
        return (Integer)this.field_70180_af.func_187225_a(LAUNCH_COUNTER) < 100 && (Integer)this.field_70180_af.func_187225_a(LAUNCH_COUNTER) != -1;
    }

    public float getEnginePower() {
        float mult = 1.0f;
        int countdown = (Integer)this.field_70180_af.func_187225_a(LAUNCH_COUNTER);
        if (countdown > -1 && this.isStartupPhase()) {
            mult = (float)(100 - countdown) / 100.0f;
        }
        if (this.areEnginesRunning()) {
            return mult * Math.max(DimensionManager.getInstance().getDimensionProperties(this.field_70170_p.field_73011_w.getDimension()).getAtmosphereDensityAtHeight(this.field_70163_u), 0.05f);
        }
        return 0.0f;
    }

    public boolean areEnginesRunning() {
        return this.field_70181_x > 0.0 || this.isDescentPhase() || this.getPassengerMovingForward() > 0.0f || this.isStartupPhase();
    }

    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        if (this.last_was_in_orbit != (Boolean)this.field_70180_af.func_187225_a(INORBIT)) {
            this.last_was_in_orbit = (Boolean)this.field_70180_af.func_187225_a(INORBIT);
            this.reset_motion = true;
            this.reset_position = true;
        }
        if (this.reset_position) {
            this.func_70107_b(x, y, z);
            this.reset_position = false;
        } else {
            Vec3d new_pos = new Vec3d(x, y, z);
            this.poscorrection = new_pos.func_178786_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    private void runEngines() {
        int max_engine_for_smoke = 16;
        int engineNum = this.stats.getEngineLocations().size();
        if (this.field_70170_p.field_72995_K && this.areEnginesRunning()) {
            for (Vector3F<Float> vec : this.stats.getEngineLocations()) {
                AtmosphereHandler handler = AtmosphereHandler.getOxygenHandler(this.field_70170_p.field_73011_w.getDimension());
                IAtmosphere atmosphere = null;
                if (handler != null) {
                    atmosphere = handler.getAtmosphereType(this);
                }
                boolean can_smoke = true;
                if (engineNum > max_engine_for_smoke) {
                    boolean bl = can_smoke = this.field_70146_Z.nextInt(engineNum) <= max_engine_for_smoke;
                }
                if (Minecraft.func_71410_x().field_71474_y.field_74362_aa < 2 && can_smoke && Minecraft.func_71410_x().field_71474_y.field_74362_aa < 1 && (handler == null || atmosphere != null && atmosphere.allowsCombustion())) {
                    for (int i = 0; i < 3; ++i) {
                        double yo = 1.0f + this.field_70146_Z.nextFloat();
                        float xzv = 16.0f;
                        if (this.field_70181_x > 0.0) {
                            xzv = 32.0f;
                        }
                        double motionz = this.field_70146_Z.nextFloat() - 0.5f;
                        double motionx = this.field_70146_Z.nextFloat() - 0.5f;
                        double speed = this.field_70146_Z.nextFloat() / xzv;
                        double speedxz = Math.sqrt(motionx * motionx + motionz * motionz);
                        AdvancedRocketry.proxy.spawnDynamicRocketSmoke(this.field_70170_p, this.field_70165_t + (double)((Float)vec.x).floatValue(), this.field_70163_u + (double)((Float)vec.y).floatValue() - yo, this.field_70161_v + (double)((Float)vec.z).floatValue(), motionx *= speed / speedxz, -0.75 - (double)this.field_70146_Z.nextFloat() / 6.0, motionz *= speed / speedxz, engineNum);
                    }
                }
                for (float i = 0.0f; i < 15.0f; i += 1.0f) {
                    AdvancedRocketry.proxy.spawnDynamicRocketFlame(this.field_70170_p, this.field_70165_t + (double)((Float)vec.x).floatValue(), this.field_70163_u + (double)((Float)vec.y).floatValue() - 0.9 - (double)(i * 0.1f), this.field_70161_v + (double)((Float)vec.z).floatValue(), (this.field_70146_Z.nextFloat() - 0.5f) / 6.0f, -0.75, (this.field_70146_Z.nextFloat() - 0.5f) / 6.0f, engineNum);
                }
            }
        }
    }

    private BlockPos getTopBlock(BlockPos pos) {
        Chunk chunk = this.field_70170_p.func_175726_f(pos);
        BlockPos blockpos = new BlockPos(pos.func_177958_n(), chunk.func_76625_h() + 16, pos.func_177952_p());
        while (blockpos.func_177956_o() >= 0) {
            BlockPos blockpos1 = blockpos.func_177977_b();
            if (!this.field_70170_p.func_175623_d(blockpos)) break;
            blockpos = blockpos1;
        }
        return blockpos;
    }

    private Vec3d calculatePullFromPlanets() {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double gravityMultiplier = 0.01;
        if (this.spacePosition.world != null) {
            SpacePosition planetSpacePosition = new SpacePosition();
            double acceleration = 100.0 * gravityMultiplier;
            double distanceSq = planetSpacePosition.distanceToSpacePosition2(this.spacePosition);
            double shipAcceleration = acceleration / distanceSq;
            Vec3d vector = this.spacePosition.getNormalVectorTo(planetSpacePosition);
            if (distanceSq > 0.0) {
                x += shipAcceleration * vector.field_72450_a;
                y += shipAcceleration * vector.field_72448_b;
                z += shipAcceleration * vector.field_72449_c;
            }
        } else if (this.spacePosition.star != null) {
            for (IDimensionProperties planet : this.spacePosition.star.getPlanets()) {
                SpacePosition planetSpacePosition = planet.getSpacePosition();
                double acceleration = (double)(planet.getGravitationalMultiplier() * 9.81f) * gravityMultiplier;
                double distanceSq = planet.getSpacePosition().distanceToSpacePosition2(this.spacePosition);
                double shipAcceleration = acceleration / distanceSq;
                Vec3d vector = this.spacePosition.getNormalVectorTo(planetSpacePosition);
                x += shipAcceleration * vector.field_72450_a;
                y += shipAcceleration * vector.field_72448_b;
                z += shipAcceleration * vector.field_72449_c;
            }
            SpacePosition planetSpacePosition = new SpacePosition();
            double acceleration = 100.0 * gravityMultiplier;
            double distanceSq = planetSpacePosition.distanceToSpacePosition2(this.spacePosition);
            double shipAcceleration = acceleration / distanceSq;
            Vec3d vector = this.spacePosition.getNormalVectorTo(planetSpacePosition);
            if (distanceSq > 0.0) {
                x += shipAcceleration * vector.field_72450_a;
                y += shipAcceleration * vector.field_72448_b;
                z += shipAcceleration * vector.field_72449_c;
            }
        }
        return new Vec3d(x, y, z);
    }

    public void func_70015_d(int seconds) {
    }

    private void syncRocket() {
        NBTTagCompound nbtdata = new NBTTagCompound();
        this.func_189511_e(nbtdata);
        PacketHandler.sendToNearby((BasePacket)new PacketEntity((INetworkEntity)this, 0, nbtdata), (int)this.field_70170_p.field_73011_w.getDimension(), (BlockPos)new BlockPos((Entity)this), (double)64.0);
    }

    public void func_70016_h(double x, double y, double z) {
        if (this.reset_motion) {
            this.velcorrection = new Vec3d(0.0, 0.0, 0.0);
            this.field_70159_w = x;
            this.field_70181_x = y;
            this.field_70179_y = z;
            this.reset_motion = false;
        } else {
            Vec3d new_vel = new Vec3d(x, y, z);
            this.velcorrection = new_vel.func_178786_a(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        long deltaTime = this.field_70170_p.func_82737_E() - this.lastWorldTickTicked;
        this.lastWorldTickTicked = this.field_70170_p.func_82737_E();
        if (this.field_70170_p.field_72995_K) {
            double ct = 50.0;
            if (!((Boolean)this.field_70180_af.func_187225_a(INORBIT)).booleanValue() && this.poscorrection.field_72448_b < -0.01) {
                ct = 1.0;
            }
            double cx = this.poscorrection.field_72450_a / ct;
            double cy = this.poscorrection.field_72448_b / ct;
            double cz = this.poscorrection.field_72449_c / ct;
            this.poscorrection = this.poscorrection.func_178786_a(cx, cy, cz);
            this.func_70107_b(this.field_70165_t + cx, this.field_70163_u + cy, this.field_70161_v + cz);
            double ct2 = 10.0;
            double vx = this.velcorrection.field_72450_a / ct2;
            double vy = this.velcorrection.field_72448_b / ct2;
            double vz = this.velcorrection.field_72449_c / ct2;
            this.velcorrection = this.velcorrection.func_178786_a(vx, vy, vz);
            this.field_70159_w += vx;
            this.field_70181_x += vy;
            this.field_70179_y += vz;
        }
        if (this.field_70173_aa == 20) {
            for (HashedBlockPosition temp : new LinkedList(this.infrastructureCoords)) {
                TileEntity tile = this.field_70170_p.func_175625_s(new BlockPos(temp.x, (int)temp.y, temp.z));
                if (!(tile instanceof IInfrastructure)) continue;
                this.linkInfrastructure((IInfrastructure)tile);
            }
            if (this.field_70170_p.field_72995_K) {
                LibVulpes.proxy.playSound((Object)new SoundRocketEngine(AudioRegistry.combustionRocket, SoundCategory.NEUTRAL, this));
            } else {
                int z;
                int rocketSizeX = this.storage.getSizeX() / 2 + 1;
                int rocketSizeZ = this.storage.getSizeZ() / 2 + 1;
                int bufferSize = 3;
                boolean safeLanding = false;
                int x = (int)this.field_70165_t - rocketSizeX;
                while ((double)x < this.field_70165_t + (double)rocketSizeX && !safeLanding) {
                    z = (int)this.field_70161_v - rocketSizeZ;
                    while ((double)z < this.field_70161_v + (double)rocketSizeZ && !safeLanding) {
                        BlockPos pos = new BlockPos((double)x, this.field_70163_u, (double)z);
                        safeLanding = !this.field_70170_p.func_180495_p(pos = this.getTopBlock(pos)).func_185904_a().func_76224_d() || this.field_70170_p.func_180495_p(pos).func_177230_c() == AdvancedRocketryBlocks.blockRocketFire;
                        ++z;
                    }
                    ++x;
                }
                if (!safeLanding) {
                    x = (int)this.field_70165_t - rocketSizeX - 3;
                    while ((double)x < this.field_70165_t + (double)rocketSizeX + 3.0) {
                        z = (int)this.field_70161_v - rocketSizeZ - 3;
                        while ((double)z < this.field_70161_v + (double)rocketSizeZ + 3.0) {
                            BlockPos pos = new BlockPos((double)x, this.field_70163_u, (double)z);
                            pos = this.getTopBlock(pos);
                            this.field_70170_p.func_175656_a(pos, AdvancedRocketryBlocks.blockLandingFloat.func_176223_P());
                            ++z;
                        }
                        ++x;
                    }
                }
            }
        }
        if (this.field_70173_aa > 40 && this.isInOrbit() && !this.isInFlight()) {
            this.setInFlight(true);
        }
        if (!this.field_70170_p.field_72995_K && (this.isInFlight() || this.isInOrbit()) && this.field_70173_aa == 20) {
            MinecraftForge.EVENT_BUS.post((Event)new RocketEvent.RocketDeOrbitingEvent(this));
            PacketHandler.sendToNearby((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.ROCKETLANDEVENT.ordinal()), (int)this.field_70170_p.field_73011_w.getDimension(), (int)((int)this.field_70165_t), (int)((int)this.field_70163_u), (int)((int)this.field_70161_v), (double)64.0);
            for (Entity riddenByEntity : this.func_184188_bt()) {
                if (!(riddenByEntity instanceof EntityPlayer)) continue;
                EntityPlayer player = (EntityPlayer)riddenByEntity;
                PacketHandler.sendToPlayer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.FORCEMOUNT.ordinal()), (EntityPlayer)player);
            }
        }
        if (this.getRCS() && this.rcs_mode_counter < 100) {
            ++this.rcs_mode_counter;
        } else if (!this.getRCS() && this.rcs_mode_counter > 0) {
            --this.rcs_mode_counter;
            this.field_70177_z = 0.0f;
        }
        int launchCount = (Integer)this.field_70180_af.func_187225_a(LAUNCH_COUNTER);
        if (launchCount >= 0) {
            if (launchCount == 0) {
                this.launch();
            }
            this.field_70180_af.func_187227_b(LAUNCH_COUNTER, (Object)(--launchCount));
            if (ARConfiguration.getCurrentConfig().launchingDestroysBlocks && launchCount <= 100 && launchCount != 0 && this.getFuelCapacity(this.getRocketFuelType()) > 0) {
                this.damageGroundBelowRocket(this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, (int)Math.pow(this.stats.getThrust(), 0.4));
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            for (Entity entity : this.func_184188_bt()) {
                entity.field_70143_R = 0.0f;
            }
            this.field_70143_R = 0.0f;
        }
        if (this.getInSpaceFlight()) {
            double distanceFromPlanetToLeaveOrbitMult = 16.0;
            this.field_70177_z += (float)((this.turningRight ? 5 : 0) - (this.turningLeft ? 5 : 0));
            double acc = (double)(10.0f * this.getPassengerMovingForward()) * 0.2;
            float yawAngle = (float)((double)this.field_70177_z * Math.PI / 180.0);
            Vec3d planetPull = Vec3d.field_186680_a;
            this.field_70159_w += acc * (double)MathHelper.func_76126_a((float)(-yawAngle)) + planetPull.field_72450_a;
            this.field_70181_x += (this.turningUp ? 0.02 : 0.0) - (this.turningDownforWhat ? 0.02 : 0.0) + planetPull.field_72448_b;
            this.field_70179_y += acc * (double)MathHelper.func_76134_b((float)(-yawAngle)) + planetPull.field_72449_c;
            if (acc == 0.0) {
                this.field_70159_w *= 0.98;
                this.field_70181_x *= 0.98;
                this.field_70179_y *= 0.98;
            }
            this.spacePosition.x += this.field_70159_w;
            this.spacePosition.y += this.field_70181_x;
            this.spacePosition.z += this.field_70179_y;
            if (this.spacePosition.world == null && this.spacePosition.star != null) {
                for (IDimensionProperties properties : this.spacePosition.star.getPlanets()) {
                    SpacePosition worldSpacePosition = properties.getSpacePosition();
                    double distanceSq = this.spacePosition.distanceToSpacePosition2(worldSpacePosition);
                    if (!(distanceSq < (double)(properties.getRenderSizeSolarView() * properties.getRenderSizeSolarView() * 8.0f))) continue;
                    this.spacePosition.world = (DimensionProperties)properties;
                    double radius = -properties.getRenderSizePlanetView() * 16.0f;
                    SpacePosition planetPosition = new SpacePosition();
                    double theta = Math.atan2(this.field_70179_y, this.field_70159_w);
                    this.spacePosition.x = planetPosition.x + Math.cos(theta) * radius;
                    this.spacePosition.y = planetPosition.y;
                    this.spacePosition.z = planetPosition.z + Math.sin(theta) * radius;
                    PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.SENDSPACEPOS.ordinal()));
                    break;
                }
            } else if (this.spacePosition.world != null) {
                double distanceSq = this.spacePosition.distanceToSpacePosition2(new SpacePosition());
                if (!this.field_70170_p.field_72995_K) {
                    this.storage.damageParts();
                    this.syncRocket();
                    if (distanceSq < (double)(0.5f * this.spacePosition.world.getRenderSizePlanetView() * this.spacePosition.world.getRenderSizePlanetView())) {
                        this.destinationDimId = this.spacePosition.world.getId();
                        this.setRCS(false);
                        this.field_70159_w = 0.0;
                        this.field_70179_y = 0.0;
                        this.field_70181_x = 1.0;
                        this.field_70177_z = 0.0f;
                        this.rcs_mode = false;
                        this.reachSpaceManned();
                        this.setInSpaceFlight(false);
                    } else {
                        for (int subId : this.spacePosition.world.getChildPlanets()) {
                            List<ISpaceObject> stations;
                            DimensionProperties subPlanetProperties = DimensionManager.getInstance().getDimensionProperties(subId);
                            distanceSq = this.spacePosition.distanceToSpacePosition2(subPlanetProperties.getSpacePosition());
                            if (distanceSq < (double)(0.5f * subPlanetProperties.getRenderSizePlanetView() * subPlanetProperties.getRenderSizePlanetView())) {
                                this.destinationDimId = subPlanetProperties.getId();
                                this.setRCS(false);
                                this.rcs_mode = false;
                                this.field_70177_z = 0.0f;
                                this.reachSpaceManned();
                                this.setInSpaceFlight(false);
                            }
                            if ((stations = SpaceObjectManager.getSpaceManager().getSpaceStationsOrbitingPlanet(subId)) == null) continue;
                            for (ISpaceObject station : stations) {
                                distanceSq = this.spacePosition.distanceToSpacePosition2(((SpaceStationObject)station).getSpacePosition());
                                if (!(distanceSq < 10000.0)) continue;
                                this.destinationDimId = ARConfiguration.getCurrentConfig().spaceDimId;
                                this.storage.getGuidanceComputer().overrideLandingStation(station);
                                this.setRCS(false);
                                this.field_70177_z = 0.0f;
                                this.rcs_mode = false;
                                this.reachSpaceManned();
                                this.setInSpaceFlight(false);
                            }
                        }
                    }
                    List<ISpaceObject> stations = SpaceObjectManager.getSpaceManager().getSpaceStationsOrbitingPlanet(this.spacePosition.world.getId());
                    if (stations != null) {
                        for (ISpaceObject station : stations) {
                            distanceSq = this.spacePosition.distanceToSpacePosition2(((SpaceStationObject)station).getSpacePosition());
                            if (!(distanceSq < 10000.0)) continue;
                            this.destinationDimId = ARConfiguration.getCurrentConfig().spaceDimId;
                            this.storage.getGuidanceComputer().overrideLandingStation(station);
                            this.setRCS(false);
                            this.rcs_mode = false;
                            this.reachSpaceManned();
                            this.setInSpaceFlight(false);
                        }
                    }
                } else if (distanceSq > (double)(this.spacePosition.world.getRenderSizePlanetView() * this.spacePosition.world.getRenderSizePlanetView()) * distanceFromPlanetToLeaveOrbitMult * distanceFromPlanetToLeaveOrbitMult) {
                    double radius = this.spacePosition.world.getRenderSizeSolarView() * 10.0f;
                    SpacePosition planetPosition = this.spacePosition.world.getSpacePosition();
                    this.spacePosition.world = null;
                    double theta = Math.atan2(this.field_70179_y, this.field_70159_w);
                    this.spacePosition.x = planetPosition.x + Math.cos(theta) * radius;
                    this.spacePosition.y = planetPosition.y;
                    this.spacePosition.z = planetPosition.z + Math.sin(theta) * radius;
                    this.field_70159_w *= 0.0;
                    this.field_70181_x *= 0.0;
                    this.field_70179_y *= 0.0;
                }
            }
            if (this.field_70170_p.field_72995_K && this.field_70170_p.func_82737_E() % 20L == 0L) {
                PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.SENDSPACEPOS.ordinal()));
            }
        } else if (this.isInFlight()) {
            boolean burningFuel = this.isBurningFuel();
            boolean descentPhase = this.isDescentPhase();
            if (burningFuel || descentPhase) {
                if (!this.field_70170_p.field_72995_K && !descentPhase) {
                    this.setFuelAmount(this.getRocketFuelType(), this.getFuelAmount(this.getRocketFuelType()) - this.getFuelConsumptionRate(this.getRocketFuelType()));
                    if (this.getRocketFuelType() == FuelRegistry.FuelType.LIQUID_BIPROPELLANT) {
                        this.setFuelAmount(FuelRegistry.FuelType.LIQUID_OXIDIZER, this.getFuelAmount(FuelRegistry.FuelType.LIQUID_OXIDIZER) - this.getFuelConsumptionRate(FuelRegistry.FuelType.LIQUID_OXIDIZER));
                    }
                    if (this.getFuelAmount(this.getRocketFuelType()) == 0) {
                        this.stats.setFuelFluid("null");
                        this.stats.setWorkingFluid("null");
                    }
                    if (this.getRocketFuelType() == FuelRegistry.FuelType.LIQUID_BIPROPELLANT && this.getFuelAmount(FuelRegistry.FuelType.LIQUID_OXIDIZER) == 0) {
                        this.stats.setOxidizerFluid("null");
                    }
                }
                this.runEngines();
            }
            if (!this.field_70170_p.field_72995_K) {
                boolean landedOnGround;
                if (this.isInOrbit() && descentPhase) {
                    this.field_70181_x -= this.field_70181_x / 120.0;
                    this.field_70133_I = true;
                } else if (this.isInOrbit() || !burningFuel) {
                    this.field_70181_x -= 0.049049998903647064 * (double)DimensionManager.getInstance().getDimensionProperties(this.field_70170_p.field_73011_w.getDimension()).getGravitationalMultiplier();
                    this.field_70181_x = Math.max(-2.0, this.field_70181_x);
                    this.field_70133_I = true;
                } else {
                    this.field_70181_x += (double)(this.stats.getAcceleration(DimensionManager.getInstance().getDimensionProperties(this.field_70170_p.field_73011_w.getDimension()).getGravitationalMultiplier()) * (float)deltaTime);
                    this.field_70133_I = true;
                }
                if (this.isInOrbit() && descentPhase) {
                    this.field_70181_x -= this.field_70181_x / 120.0;
                    this.field_70133_I = true;
                }
                double lastPosY = this.field_70163_u;
                double prevMotion = this.field_70181_x;
                this.func_70091_d(MoverType.SELF, 0.0, prevMotion * (double)deltaTime, 0.0);
                boolean landedInSpace = DimensionManager.getInstance().getDimensionProperties(this.field_70170_p.field_73011_w.getDimension()).isAsteroid() && this.field_70163_u < 64.0;
                boolean bl = landedOnGround = lastPosY + prevMotion != this.field_70163_u && this.field_70163_u < 256.0;
                if ((this.isInOrbit() || !burningFuel) && this.isInFlight() && (landedOnGround || landedInSpace)) {
                    PacketHandler.sendToPlayersTrackingEntity((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.ROCKETLANDEVENT.ordinal()), (Entity)this);
                    MinecraftForge.EVENT_BUS.post((Event)new RocketEvent.RocketLandedEvent(this));
                    this.field_70181_x = 0.0;
                    this.setInFlight(false);
                    this.setInOrbit(false);
                }
                if (!this.isInOrbit() && this.field_70163_u > (double)this.stats.orbitHeight) {
                    this.onOrbitReached();
                }
                if (this.field_70163_u < 0.0) {
                    int dimId = this.field_70170_p.field_73011_w.getDimension();
                    if (dimId == ARConfiguration.getCurrentConfig().spaceDimId) {
                        ISpaceObject spaceObject = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.func_180425_c());
                        if (spaceObject != null) {
                            int targetDimID = spaceObject.getOrbitingPlanetId();
                            Vector3F<Float> pos = this.storage.getDestinationCoordinates(targetDimID, true);
                            if (pos != null) {
                                this.setInOrbit(true);
                                this.setInFlight(false);
                                this.changeDimension(targetDimID, ((Float)pos.x).floatValue(), this.getEntryHeight(targetDimID), ((Float)pos.z).floatValue());
                            } else {
                                this.func_70106_y();
                            }
                        } else {
                            Vector3F<Float> pos = this.storage.getDestinationCoordinates(0, true);
                            if (pos != null) {
                                this.setInOrbit(true);
                                this.setInFlight(false);
                                this.changeDimension(this.lastDimensionFrom, ((Float)pos.x).floatValue(), this.getEntryHeight(this.lastDimensionFrom), ((Float)pos.z).floatValue());
                            } else {
                                this.func_70106_y();
                            }
                        }
                    } else {
                        this.func_70106_y();
                    }
                }
            } else {
                this.func_70091_d(MoverType.SELF, 0.0, this.field_70181_x * (double)deltaTime, 0.0);
            }
        } else if (DimensionManager.getInstance().getDimensionProperties(this.field_70170_p.field_73011_w.getDimension()).isAsteroid() && this.getRCS()) {
            this.field_70177_z += (float)((this.turningRight ? 5 : 0) - (this.turningLeft ? 5 : 0));
            double acc = (double)this.getPassengerMovingForward() * 0.02;
            float yawAngle = (float)((double)this.field_70177_z * Math.PI / 180.0);
            this.field_70159_w += acc * (double)MathHelper.func_76126_a((float)(-yawAngle));
            this.field_70181_x += (this.turningUp ? 0.02 : 0.0) - (this.turningDownforWhat ? 0.02 : 0.0);
            this.field_70179_y += acc * (double)MathHelper.func_76134_b((float)(-yawAngle));
            this.field_70159_w *= 0.9;
            this.field_70181_x *= 0.9;
            this.field_70179_y *= 0.9;
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        } else if (this.isStartupPhase()) {
            this.runEngines();
        }
        if (this.field_70163_u < (double)(this.getTopBlock(this.func_180425_c()).func_177956_o() + 5) && this.field_70165_t > (double)this.getTopBlock(this.func_180425_c()).func_177956_o() && ARConfiguration.getCurrentConfig().launchingDestroysBlocks && this.field_70181_x < -0.1) {
            this.damageGroundBelowRocket(this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u - 1, (int)this.field_70161_v, (int)Math.pow(this.stats.getThrust(), 0.4));
        }
    }

    public void onTurnRight(boolean state) {
        this.turningRight = state;
        PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.TURNUPDATE.ordinal()));
    }

    public void onTurnLeft(boolean state) {
        this.turningLeft = state;
        PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.TURNUPDATE.ordinal()));
    }

    public void onUp(boolean state) {
        this.turningUp = state;
        PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.TURNUPDATE.ordinal()));
    }

    public void onDown(boolean state) {
        this.turningDownforWhat = state;
        PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.TURNUPDATE.ordinal()));
    }

    public List<SatelliteBase> getSatellites() {
        ArrayList<SatelliteBase> satellites = new ArrayList<SatelliteBase>();
        for (TileSatelliteHatch tile : this.storage.getSatelliteHatches()) {
            SatelliteBase satellite = tile.getSatellite();
            if (satellite == null) continue;
            satellites.add(satellite);
        }
        return satellites;
    }

    @Override
    public void onOrbitReached() {
        long targetSatellite;
        super.onOrbitReached();
        if (this.storage.getGuidanceComputer() != null && (targetSatellite = this.storage.getGuidanceComputer().getTargetSatellite()) != -1L) {
            SatelliteBase sat = DimensionManager.getInstance().getSatellite(targetSatellite);
            for (TileEntity tile : this.storage.getTileEntityList()) {
                if (!(tile instanceof TileSatelliteHatch) || !((IInventory)tile).func_70301_a(0).func_190926_b()) continue;
                ((IInventory)tile).func_70299_a(0, sat.getItemStackFromSatellite());
                DimensionManager.getInstance().getDimensionProperties(sat.getDimensionId()).removeSatellite(targetSatellite);
                break;
            }
            this.field_70181_x = -2.0;
            this.setInOrbit(true);
        } else if (!this.stats.hasSeat()) {
            this.reachSpaceUnmanned();
        } else {
            this.reachSpaceManned();
        }
    }

    private int getEntryHeight(int entryLocationDimID) {
        if (entryLocationDimID == ARConfiguration.getCurrentConfig().spaceDimId) {
            return ARConfiguration.getCurrentConfig().stationClearanceHeight;
        }
        return ARConfiguration.getCurrentConfig().orbit;
    }

    private void reachSpaceUnmanned() {
        TileGuidanceComputer computer = this.storage.getGuidanceComputer();
        if (computer != null && computer.func_70301_a(0).func_77973_b() instanceof ItemAsteroidChip) {
            float drillingPower = this.stats.getDrillingPower();
            float asteroidDrillingMult = 1.0f;
            ItemStack stack = this.storage.getGuidanceComputer().func_70301_a(0);
            Asteroid asteroid = ARConfiguration.getCurrentConfig().asteroidTypes.get(((ItemAsteroidChip)stack.func_77973_b()).getType(stack));
            if (asteroid != null) {
                asteroidDrillingMult = asteroid.timeMultiplier;
            }
            MissionOreMining miningMission = new MissionOreMining((long)((double)asteroidDrillingMult * ARConfiguration.getCurrentConfig().asteroidMiningTimeMult * (double)(drillingPower == 0.0f ? 36000.0f : 360.0f / this.stats.getDrillingPower())), this, this.connectedInfrastructure);
            DimensionProperties properties = DimensionManager.getEffectiveDimId(this.field_70170_p, this.func_180425_c());
            miningMission.setDimensionId(this.field_70170_p);
            properties.addSatellite(miningMission, this.field_70170_p);
            if (!this.field_70170_p.field_72995_K) {
                PacketHandler.sendToAll((BasePacket)new PacketSatellite(miningMission));
            }
            for (IInfrastructure i : this.connectedInfrastructure) {
                i.linkMission(miningMission);
            }
            this.func_70106_y();
        } else {
            this.unpackSatellites();
        }
        this.destinationDimId = this.storage.getDestinationDimId(this.field_70170_p.field_73011_w.getDimension(), (int)this.field_70165_t, (int)this.field_70161_v);
        if (this.destinationDimId == this.field_70170_p.field_73011_w.getDimension()) {
            Vector3F<Float> pos = this.storage.getDestinationCoordinates(this.destinationDimId, true);
            this.storage.setDestinationCoordinates((Vector3F<Float>)new Vector3F((Object)Float.valueOf((float)this.field_70165_t), (Object)Float.valueOf((float)this.field_70163_u), (Object)Float.valueOf((float)this.field_70161_v)), this.field_70170_p.field_73011_w.getDimension());
            if (pos != null) {
                this.setInOrbit(true);
                this.field_70181_x = -2.0;
                Iterator connectedTiles = this.connectedInfrastructure.iterator();
                while (connectedTiles.hasNext()) {
                    ((IInfrastructure)connectedTiles.next()).unlinkRocket();
                    connectedTiles.remove();
                }
                this.func_70634_a(((Float)pos.x).floatValue(), this.getEntryHeight(this.destinationDimId), ((Float)pos.z).floatValue());
            } else {
                if (this.hasHumanPassenger()) {
                    this.setInFlight(false);
                    this.func_70634_a(this.field_70165_t, this.getEntryHeight(this.destinationDimId), this.field_70161_v);
                }
                this.setInOrbit(true);
                this.field_70181_x = -2.0;
                Iterator connectedTiles = this.connectedInfrastructure.iterator();
                while (connectedTiles.hasNext()) {
                    ((IInfrastructure)connectedTiles.next()).unlinkRocket();
                    connectedTiles.remove();
                }
                this.func_70634_a(this.field_70165_t, this.getEntryHeight(this.destinationDimId), this.field_70161_v);
            }
        } else if (DimensionManager.getInstance().canTravelTo(this.destinationDimId)) {
            Vector3F<Float> pos = this.storage.getDestinationCoordinates(this.destinationDimId, true);
            this.storage.setDestinationCoordinates((Vector3F<Float>)new Vector3F((Object)Float.valueOf((float)this.field_70165_t), (Object)Float.valueOf((float)this.field_70163_u), (Object)Float.valueOf((float)this.field_70161_v)), this.field_70170_p.field_73011_w.getDimension());
            if (pos != null) {
                this.setInOrbit(true);
                this.field_70181_x = -2.0;
                this.changeDimension(this.destinationDimId, ((Float)pos.x).floatValue(), this.getEntryHeight(this.destinationDimId), ((Float)pos.z).floatValue());
            } else {
                if (this.hasHumanPassenger()) {
                    this.setInFlight(false);
                    this.func_70634_a(this.field_70165_t, this.getEntryHeight(this.destinationDimId), this.field_70161_v);
                }
                this.setInOrbit(true);
                this.field_70181_x = -2.0;
                this.changeDimension(this.destinationDimId, this.field_70165_t, this.getEntryHeight(this.destinationDimId), this.field_70161_v);
            }
        } else {
            int offX = this.field_70170_p.field_73012_v.nextInt() % 256 - 128;
            int offZ = this.field_70170_p.field_73012_v.nextInt() % 256 - 128;
            this.setInOrbit(true);
            this.field_70181_x = -2.0;
            this.func_70107_b(this.field_70165_t + (double)offX, this.field_70163_u, this.field_70161_v + (double)offZ);
            Iterator connectedTiles = this.connectedInfrastructure.iterator();
            while (connectedTiles.hasNext()) {
                ((IInfrastructure)connectedTiles.next()).unlinkRocket();
                connectedTiles.remove();
            }
        }
    }

    private void reachSpaceManned() {
        this.unpackSatellites();
        Vector3F destPos = new Vector3F((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
        if (ARConfiguration.getCurrentConfig().experimentalSpaceFlight && this.storage.getGuidanceComputer().func_191420_l() && this.hasHumanPassenger() && !this.getInSpaceFlight()) {
            DimensionProperties currentDim = DimensionManager.getEffectiveDimId(this.field_70170_p, this.func_180425_c());
            while (currentDim.isMoon()) {
                currentDim = currentDim.getParentProperties();
            }
            SpacePosition planetSpacePos = currentDim.getSpacePosition();
            SpacePosition modifiedPosition = new SpacePosition().getFromSpherical((double)currentDim.getRenderSizePlanetView() * 1.1, 0.0);
            this.spacePosition.x = modifiedPosition.x;
            this.spacePosition.y = modifiedPosition.y;
            this.spacePosition.z = modifiedPosition.z;
            this.spacePosition.star = planetSpacePos.star;
            this.spacePosition.world = planetSpacePos.world;
            this.setInSpaceFlight(true);
            this.setRCS(true);
            this.setInOrbit(true);
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            this.destinationDimId = ARConfiguration.getCurrentConfig().spaceDimId;
            destPos.x = Float.valueOf(0.0f);
            destPos.y = Float.valueOf(this.getEntryHeight(this.destinationDimId));
            destPos.z = Float.valueOf(0.0f);
            for (Entity e : this.func_184188_bt()) {
                if (!(e instanceof EntityPlayer)) continue;
                PacketHandler.sendToPlayer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.SENDSPACEPOS.ordinal()), (EntityPlayer)((EntityPlayer)e));
            }
        } else {
            this.field_70181_x = -2.0;
            this.setInOrbit(true);
            if ((this.destinationDimId == ARConfiguration.getCurrentConfig().spaceDimId || this.field_70170_p.field_73011_w.getDimension() == ARConfiguration.getCurrentConfig().spaceDimId && !this.getInSpaceFlight()) && this.field_70170_p.field_73011_w.getDimension() != this.destinationDimId) {
                Vector3F<Float> pos = this.storage.getDestinationCoordinates(this.destinationDimId, true);
                this.storage.setDestinationCoordinates((Vector3F<Float>)new Vector3F((Object)Float.valueOf((float)this.field_70165_t), (Object)Float.valueOf((float)this.field_70163_u), (Object)Float.valueOf((float)this.field_70161_v)), this.field_70170_p.field_73011_w.getDimension());
                if (pos != null) {
                    if (this.hasHumanPassenger()) {
                        this.setInFlight(false);
                        pos.y = Float.valueOf(this.getEntryHeight(this.destinationDimId));
                    }
                    this.changeDimension(this.destinationDimId, ((Float)pos.x).floatValue(), ((Float)pos.y).floatValue(), ((Float)pos.z).floatValue());
                    return;
                }
            }
            if ((destPos = this.storage.getDestinationCoordinates(this.destinationDimId, true)) == null) {
                destPos = new Vector3F((Object)Float.valueOf((float)this.field_70165_t), (Object)Float.valueOf(this.getEntryHeight(this.destinationDimId)), (Object)Float.valueOf((float)this.field_70161_v));
            }
            if (this.hasHumanPassenger()) {
                this.setInFlight(false);
                if (DimensionManager.getInstance().getDimensionProperties(this.destinationDimId).getName().equals("Luna")) {
                    for (Entity player : this.func_184188_bt()) {
                        if (!(player instanceof EntityPlayer)) continue;
                        ARAdvancements.MOON_LANDING.trigger((EntityPlayerMP)player);
                        if (DimensionManager.hasReachedMoon) continue;
                        ARAdvancements.ONE_SMALL_STEP.trigger((EntityPlayerMP)player);
                    }
                    DimensionManager.hasReachedMoon = true;
                }
            }
            destPos.y = Float.valueOf(this.getEntryHeight(this.destinationDimId));
        }
        this.setOverriddenCoords(-1, 0.0f, 0.0f, 0.0f);
        if (this.destinationDimId != this.field_70170_p.field_73011_w.getDimension()) {
            this.changeDimension(!DimensionManager.getInstance().isDimensionCreated(this.field_70170_p.field_73011_w.getDimension()) ? 0 : this.destinationDimId, ((Float)destPos.x).floatValue(), this.getEntryHeight(this.destinationDimId), ((Float)destPos.z).floatValue());
        } else {
            List eList = this.func_184188_bt();
            for (Entity e : eList) {
                e.func_184210_p();
                e.func_70634_a((double)((Float)destPos.x).floatValue(), (double)((Float)destPos.y).floatValue(), (double)((Float)destPos.z).floatValue());
            }
            this.func_70634_a(((Float)destPos.x).floatValue(), ((Float)destPos.y).floatValue(), ((Float)destPos.z).floatValue());
            this.field_70173_aa = 0;
            ((WorldServer)this.field_70170_p).func_82742_i();
            for (Entity e : eList) {
                e.func_184205_a((Entity)this, true);
            }
        }
    }

    private void unpackSatellites() {
        List<TileSatelliteHatch> satelliteHatches = this.storage.getSatelliteHatches();
        for (TileSatelliteHatch tile : satelliteHatches) {
            SatelliteBase satellite = tile.getSatellite();
            if (satellite == null) {
                ItemStack stack = tile.func_70301_a(0);
                if (stack.func_190926_b() || stack.func_77973_b() != AdvancedRocketryItems.itemSpaceStation) continue;
                StorageChunk storage = ((ItemPackedStructure)stack.func_77973_b()).getStructure(stack);
                ISpaceObject spaceObject = SpaceObjectManager.getSpaceManager().getSpaceStation(ItemStationChip.getUUID(stack));
                if (spaceObject == null) {
                    tile.func_70299_a(0, ItemStack.field_190927_a);
                    continue;
                }
                SpaceObjectManager.getSpaceManager().moveStationToBody(spaceObject, DimensionManager.getEffectiveDimId(this.field_70170_p.field_73011_w.getDimension(), this.func_180425_c()).getId());
                spaceObject.onModuleUnpack(storage);
                tile.func_70299_a(0, ItemStack.field_190927_a);
                continue;
            }
            int destinationId = this.storage.getDestinationDimId(this.field_70170_p.field_73011_w.getDimension(), (int)this.field_70165_t, (int)this.field_70161_v);
            DimensionProperties properties = DimensionManager.getEffectiveDimId_byID(destinationId, this.func_180425_c());
            int world2 = destinationId == ARConfiguration.getCurrentConfig().spaceDimId || destinationId == -2147483647 ? properties.getId() : destinationId;
            properties.addSatellite(satellite, world2, this.field_70170_p.field_72995_K);
            tile.func_70299_a(0, ItemStack.field_190927_a);
        }
    }

    @Override
    public void prepareLaunch() {
        if ((Integer)this.field_70180_af.func_187225_a(LAUNCH_COUNTER) > 0) {
            this.field_70180_af.func_187227_b(LAUNCH_COUNTER, (Object)-1);
            if (this.field_70170_p.field_72995_K) {
                PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.ABORTLAUNCH.ordinal()));
            }
            return;
        }
        if (this.isInOrbit()) {
            this.setInFlight(true);
            return;
        }
        RocketEvent.RocketPreLaunchEvent event = new RocketEvent.RocketPreLaunchEvent(this);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (!event.isCanceled()) {
            if (this.field_70170_p.field_72995_K) {
                PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.LAUNCH.ordinal()));
            }
            this.field_70180_af.func_187227_b(LAUNCH_COUNTER, (Object)200);
        }
    }

    private double gauss(double mean, double div) {
        Random rand = this.field_70170_p.field_73012_v;
        return mean + (rand.nextDouble() - 0.5) * 2.0 * div;
    }

    public void explode() {
        if (this.field_70170_p.field_72995_K && Minecraft.func_71410_x().field_71474_y.field_74362_aa < 2) {
            int i;
            AxisAlignedBB bb = this.func_70046_E();
            double meanX = (bb.field_72336_d + bb.field_72340_a) / 2.0;
            double meanY = (bb.field_72337_e + bb.field_72338_b) / 2.0;
            double meanZ = (bb.field_72334_f + bb.field_72339_c) / 2.0;
            double divX = (bb.field_72336_d - bb.field_72340_a) / 1.2;
            double divY = (bb.field_72337_e - bb.field_72338_b) / 1.2;
            double divZ = (bb.field_72334_f - bb.field_72339_c) / 1.2;
            if (Minecraft.func_71410_x().field_71474_y.field_74362_aa < 1) {
                for (i = 0; i < 10; ++i) {
                    AdvancedRocketry.proxy.spawnParticle("rocketSmoke", this.field_70170_p, this.gauss(meanX, divX), this.gauss(meanY, divY), this.gauss(meanZ, divZ), (this.field_70146_Z.nextFloat() - 0.5f) / 4.0f, (this.field_70146_Z.nextFloat() - 0.5f) / 4.0f, (this.field_70146_Z.nextFloat() - 0.5f) / 4.0f);
                }
            }
            for (i = 0; i < 50; ++i) {
                AdvancedRocketry.proxy.spawnParticle("rocketFlame", this.field_70170_p, this.gauss(meanX, divX), this.gauss(meanY, divY), this.gauss(meanZ, divZ), (this.field_70146_Z.nextFloat() - 0.5f) / 4.0f, (this.field_70146_Z.nextFloat() - 0.5f) / 4.0f, (this.field_70146_Z.nextFloat() - 0.5f) / 4.0f);
            }
        }
        this.func_70106_y();
    }

    public void recalculateStats() {
        this.storage.recalculateStats(this.stats);
    }

    @Override
    public void launch() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.isInFlight()) {
            return;
        }
        boolean allowLaunch = false;
        this.storage.recalculateStats(this.stats);
        NBTTagCompound nbtdata = new NBTTagCompound();
        this.func_189511_e(nbtdata);
        PacketHandler.sendToNearby((BasePacket)new PacketEntity((INetworkEntity)this, 0, nbtdata), (int)this.field_70170_p.field_73011_w.getDimension(), (BlockPos)this.func_180425_c(), (double)64.0);
        if (ARConfiguration.getCurrentConfig().advancedWeightSystem) {
            this.stats.setWeight(this.storage.recalculateWeight());
            for (HashedBlockPosition pos : this.infrastructureCoords) {
                TileEntity te = this.field_70170_p.func_175625_s(pos.getBlockPos());
                if (!(te instanceof TileRocketAssemblingMachine)) continue;
            }
        }
        if (ARConfiguration.getCurrentConfig().partsWearSystem && this.storage.shouldBreak()) {
            this.explode();
            return;
        }
        if (ARConfiguration.getCurrentConfig().experimentalSpaceFlight && this.storage.getGuidanceComputer() != null && this.storage.getGuidanceComputer().func_191420_l()) {
            allowLaunch = true;
        } else {
            ISpaceObject spaceObject;
            this.destinationDimId = this.storage.getDestinationDimId(this.field_70170_p.field_73011_w.getDimension(), (int)this.field_70165_t, (int)this.field_70161_v);
            if (!(DimensionManager.getInstance().canTravelTo(this.destinationDimId) || this.destinationDimId == -2147483647 && this.storage.getSatelliteHatches().size() != 0)) {
                this.setError(LibVulpes.proxy.getLocalizedString("error.rocket.cannotGetThere"));
                return;
            }
            int finalDest = this.destinationDimId;
            if (this.destinationDimId == ARConfiguration.getCurrentConfig().spaceDimId) {
                ISpaceObject spaceObject2 = null;
                Vector3F<Float> vec = this.storage.getDestinationCoordinates(this.destinationDimId, false);
                if (vec != null) {
                    spaceObject2 = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(new BlockPos((double)((Float)vec.x).floatValue(), (double)((Float)vec.y).floatValue(), (double)((Float)vec.z).floatValue()));
                }
                if (spaceObject2 != null) {
                    finalDest = spaceObject2.getOrbitingPlanetId();
                } else {
                    this.setError(LibVulpes.proxy.getLocalizedString("error.rocket.destinationNotExist"));
                    return;
                }
            }
            int thisDimId = this.field_70170_p.field_73011_w.getDimension();
            if (this.field_70170_p.field_73011_w.getDimension() == ARConfiguration.getCurrentConfig().spaceDimId && (spaceObject = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.func_180425_c())) != null) {
                thisDimId = spaceObject.getProperties().getParentProperties().getId();
            }
            if (!(finalDest == -2147483647 || this.stats.isNuclear() && DimensionManager.getInstance().getDimensionProperties(finalDest).getStarId() == DimensionManager.getInstance().getDimensionProperties(thisDimId).getStarId() || PlanetaryTravelHelper.isTravelAnywhereInPlanetarySystem(finalDest, thisDimId))) {
                this.setError(LibVulpes.proxy.getLocalizedString("error.rocket.notSameSystem"));
                return;
            }
        }
        if (this.stats.getWeight() >= (float)this.stats.getThrust()) {
            allowLaunch = false;
        }
        int n = this.stats.orbitHeight = this.storage.getGuidanceComputer() == null ? this.getEntryHeight(this.field_70170_p.field_73011_w.getDimension()) : this.storage.getGuidanceComputer().getLaunchSequence(this.field_70170_p.field_73011_w.getDimension(), this.func_180425_c());
        if (allowLaunch || !this.stats.hasSeat() || DimensionManager.getInstance().isDimensionCreated(this.destinationDimId) || this.destinationDimId == ARConfiguration.getCurrentConfig().spaceDimId || this.destinationDimId == 0) {
            this.setInFlight(true);
            Iterator connectedTiles = this.connectedInfrastructure.iterator();
            MinecraftForge.EVENT_BUS.post((Event)new RocketEvent.RocketLaunchEvent(this));
            while (connectedTiles.hasNext()) {
                IInfrastructure i = (IInfrastructure)connectedTiles.next();
                if (!i.disconnectOnLiftOff()) continue;
                this.disconnectInfrastructure(i);
                connectedTiles.remove();
            }
        }
    }

    private void damageGroundBelowRocket(World world, int x, int y, int z, int radius) {
        BlockPos center = new BlockPos(x - 1, y, z);
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                for (int k = -3; k < radius / 12; ++k) {
                    BlockPos blockAbove;
                    BlockPos position = center.func_177982_a(i, k, j);
                    if (!(center.func_177951_i((Vec3i)position) <= (double)(radius * radius))) continue;
                    if (this.field_70146_Z.nextInt(80) == 0 && EntityRocket.getDamagedBlock(world.func_180495_p(position)) != null) {
                        world.func_175656_a(position, EntityRocket.getDamagedBlock(world.func_180495_p(position)));
                    }
                    if (!world.func_180495_p(blockAbove = position.func_177982_a(0, 1, 0)).func_177230_c().isAir(world.func_180495_p(blockAbove), (IBlockAccess)world, blockAbove)) continue;
                    world.func_175656_a(blockAbove, AdvancedRocketryBlocks.blockRocketFire.func_176223_P());
                }
            }
        }
    }

    @Override
    public void deconstructRocket() {
        super.deconstructRocket();
        for (IInfrastructure infrastructure : this.connectedInfrastructure) {
            infrastructure.unlinkRocket();
        }
        this.storage.pasteInWorld(this.field_70170_p, (int)(this.field_70165_t - (double)((float)this.storage.getSizeX() / 2.0f)), (int)this.field_70163_u, (int)(this.field_70161_v - (double)((float)this.storage.getSizeZ() / 2.0f)));
        this.func_70106_y();
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.storage != null && this.storage.world.displayListIndex != -1) {
            GLAllocation.func_74523_b((int)this.storage.world.displayListIndex);
        }
        Iterator connectedTiles = this.connectedInfrastructure.iterator();
        while (connectedTiles.hasNext()) {
            ((IInfrastructure)connectedTiles.next()).unlinkRocket();
            connectedTiles.remove();
        }
    }

    public void setOverriddenCoords(int dimId, float x, float y, float z) {
        TileGuidanceComputer tile = this.storage.getGuidanceComputer();
        if (tile != null) {
            tile.setFallbackDestination(dimId, (Vector3F<Float>)new Vector3F((Object)Float.valueOf(x), (Object)Float.valueOf(y), (Object)Float.valueOf(z)));
        }
    }

    public Entity func_184204_a(int newDimId) {
        return this.changeDimension(newDimId, this.field_70165_t, this.getEntryHeight(newDimId), this.field_70161_v);
    }

    @Nullable
    public Entity changeDimension(int dimensionIn, double posX, double y, double posZ) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            if (!DimensionManager.getInstance().canTravelTo(dimensionIn)) {
                AdvancedRocketry.logger.warn("Rocket trying to travel from Dim" + this.field_70170_p.field_73011_w.getDimension() + " to Dim " + dimensionIn + ".  target not accessible by rocket from launch dim");
                return null;
            }
            this.lastDimensionFrom = this.field_70170_p.field_73011_w.getDimension();
            List passengers = this.func_184188_bt();
            int i = this.field_71093_bK;
            MinecraftServer minecraftserver = this.func_184102_h();
            WorldServer worldserver = minecraftserver.func_71218_a(i);
            WorldServer worldserver1 = minecraftserver.func_71218_a(dimensionIn);
            this.func_70107_b(posX, y, posZ);
            TeleporterNoPortal teleporter = new TeleporterNoPortal(worldserver1);
            Entity entity = this.changeDimension(dimensionIn, (ITeleporter)teleporter);
            if (entity == null) {
                return null;
            }
            entity.func_174828_a(new BlockPos(posX, y, posZ), 0.0f, 0.0f);
            int timeOffset = 1;
            for (Entity e : passengers) {
                PlanetEventHandler.addDelayedTransition(new TransitionEntity(worldserver.func_82737_E() + (long)(++timeOffset), e, dimensionIn, new BlockPos(posX, y, posZ), entity));
            }
            return entity;
        }
        return null;
    }

    public void func_180432_n(Entity entityIn) {
        NBTTagCompound nbttagcompound = entityIn.func_189511_e(new NBTTagCompound());
        nbttagcompound.func_82580_o("Dimension");
        nbttagcompound.func_82580_o("Passengers");
        this.func_70020_e(nbttagcompound);
        this.field_71088_bW = entityIn.field_71088_bW;
    }

    protected void readNetworkableNBT(NBTTagCompound nbt) {
        this.func_70037_a(nbt);
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.isInOrbit = nbt.func_74767_n("orbit");
        this.setInOrbit(this.isInOrbit);
        this.rcs_mode_counter = nbt.func_74762_e("rcs_mode_cnt");
        this.setInSpaceFlight(nbt.func_74767_n("inSpaceFlight"));
        this.rcs_mode = nbt.func_74767_n("rcs_mode") || this.getInSpaceFlight();
        this.setRCS(this.rcs_mode);
        this.stats.readFromNBT(nbt);
        FuelRegistry.FuelType fuelType = this.getRocketFuelType();
        if (fuelType != null) {
            this.setFuelAmount(fuelType, this.stats.getFuelAmount(fuelType));
            if (this.getRocketFuelType() == FuelRegistry.FuelType.LIQUID_BIPROPELLANT) {
                this.setFuelAmount(FuelRegistry.FuelType.LIQUID_OXIDIZER, this.stats.getFuelAmount(FuelRegistry.FuelType.LIQUID_OXIDIZER));
            }
        }
        this.isInFlight = nbt.func_74767_n("flight");
        this.setInFlight(this.isInFlight);
        this.field_70159_w = nbt.func_74769_h("motionX");
        this.field_70181_x = nbt.func_74769_h("motionY");
        this.field_70179_y = nbt.func_74769_h("motionZ");
        this.readMissionPersistentNBT(nbt);
        if (nbt.func_74764_b("data")) {
            if (this.storage == null) {
                this.storage = new StorageChunk();
            }
            this.storage.readFromNBT(nbt.func_74775_l("data"));
            this.storage.setEntity(this);
            this.func_70105_a(Math.max(this.storage.getSizeX(), this.storage.getSizeZ()), this.storage.getSizeY());
        }
        if (nbt.func_74764_b("infrastructure")) {
            NBTTagList tagList = nbt.func_150295_c("infrastructure", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                int[] coords = tagList.func_150305_b(i).func_74759_k("loc");
                this.infrastructureCoords.add(new HashedBlockPosition(coords[0], coords[1], coords[2]));
            }
        }
        this.destinationDimId = nbt.func_74762_e("destinationDimId");
        this.lastDimensionFrom = nbt.func_74762_e("lastDimensionFrom");
        if (nbt.func_74764_b("satallite")) {
            NBTTagCompound satelliteNBT = nbt.func_74775_l("satallite");
            this.satellite = SatelliteRegistry.createFromNBT(satelliteNBT);
        }
        this.spacePosition.readFromNBT(nbt);
    }

    protected void writeNetworkableNBT(NBTTagCompound nbt) {
        this.writeMissionPersistentNBT(nbt);
        nbt.func_74757_a("orbit", this.isInOrbit());
        nbt.func_74757_a("flight", this.isInFlight());
        nbt.func_74757_a("rcs_mode", this.rcs_mode);
        nbt.func_74768_a("rcs_mode_cnt", this.rcs_mode_counter);
        nbt.func_74757_a("inSpaceFlight", this.getInSpaceFlight());
        nbt.func_74780_a("motionX", this.field_70159_w);
        nbt.func_74780_a("motionY", this.field_70181_x);
        nbt.func_74780_a("motionZ", this.field_70179_y);
        this.stats.writeToNBT(nbt);
        if (!this.infrastructureCoords.isEmpty()) {
            NBTTagList itemList = new NBTTagList();
            for (HashedBlockPosition inf : this.infrastructureCoords) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74783_a("loc", new int[]{inf.x, inf.y, inf.z});
                itemList.func_74742_a((NBTBase)tag);
            }
            nbt.func_74782_a("infrastructure", (NBTBase)itemList);
        }
        nbt.func_74768_a("destinationDimId", this.destinationDimId);
        if (this.satellite != null) {
            NBTTagCompound satelliteNBT = new NBTTagCompound();
            this.satellite.writeToNBT(satelliteNBT);
            satelliteNBT.func_74778_a("DataType", SatelliteRegistry.getKey(this.satellite.getClass()));
            nbt.func_74782_a("satallite", (NBTBase)satelliteNBT);
        }
        this.spacePosition.writeToNBT(nbt);
    }

    public void writeMissionPersistentNBT(NBTTagCompound nbt) {
    }

    public void readMissionPersistentNBT(NBTTagCompound nbt) {
    }

    protected void func_70014_b(@Nonnull NBTTagCompound nbt) {
        this.writeNetworkableNBT(nbt);
        if (this.storage != null) {
            NBTTagCompound blocks = new NBTTagCompound();
            this.storage.writeToNBT(blocks);
            nbt.func_74782_a("data", (NBTBase)blocks);
        }
        nbt.func_74768_a("lastDimensionFrom", this.lastDimensionFrom);
    }

    public void readDataFromNetwork(ByteBuf in, byte packetId, NBTTagCompound nbt) {
        if (packetId == 3 && this.storage != null) {
            this.storage.readtiles(in);
        }
        if (packetId == PacketType.RECIEVENBT.ordinal()) {
            this.storage = new StorageChunk();
            this.storage.setEntity(this);
            this.storage.readFromNetwork(in);
        } else if (packetId == PacketType.SENDPLANETDATA.ordinal()) {
            nbt.func_74768_a("selection", in.readInt());
        } else if (packetId == PacketType.TURNUPDATE.ordinal()) {
            nbt.func_74757_a("left", in.readBoolean());
            nbt.func_74757_a("right", in.readBoolean());
            nbt.func_74757_a("up", in.readBoolean());
            nbt.func_74757_a("down", in.readBoolean());
        } else if (packetId == PacketType.SENDSPACEPOS.ordinal()) {
            boolean hasStar;
            SpacePosition position = new SpacePosition();
            position.x = in.readDouble();
            position.y = in.readDouble();
            position.z = in.readDouble();
            boolean hasWorld = in.readBoolean();
            if (hasWorld) {
                position.world = DimensionManager.getInstance().getDimensionProperties(in.readInt());
            }
            if (hasStar = in.readBoolean()) {
                position.star = DimensionManager.getInstance().getStar(in.readInt());
            }
            position.writeToNBT(nbt);
        }
    }

    public void writeDataToNetwork(ByteBuf out, byte id) {
        if (id == 3 && this.storage != null) {
            this.storage.writetiles(out);
        }
        if (id == PacketType.RECIEVENBT.ordinal()) {
            this.storage.writeToNetwork(out);
        } else if (id == PacketType.SENDPLANETDATA.ordinal()) {
            ItemStack stack;
            if (this.field_70170_p.field_72995_K) {
                out.writeInt(this.container.getSelectedSystem());
            } else if (this.storage.getGuidanceComputer() != null && !(stack = this.storage.getGuidanceComputer().func_70301_a(0)).func_190926_b() && stack.func_77973_b() == AdvancedRocketryItems.itemPlanetIdChip) {
                out.writeInt(((ItemPlanetIdentificationChip)AdvancedRocketryItems.itemPlanetIdChip).getDimensionId(stack));
            }
        } else if (id == PacketType.TURNUPDATE.ordinal()) {
            out.writeBoolean(this.turningLeft);
            out.writeBoolean(this.turningRight);
            out.writeBoolean(this.turningUp);
            out.writeBoolean(this.turningDownforWhat);
        } else if (id == PacketType.SENDSPACEPOS.ordinal()) {
            out.writeDouble(this.spacePosition.x);
            out.writeDouble(this.spacePosition.y);
            out.writeDouble(this.spacePosition.z);
            boolean hasWorld = this.spacePosition.world != null;
            boolean hasStar = this.spacePosition.star != null;
            out.writeBoolean(hasWorld);
            if (hasWorld) {
                out.writeInt(this.spacePosition.world.getId());
            }
            out.writeBoolean(hasStar);
            if (hasStar) {
                out.writeInt(this.spacePosition.star.getId());
            }
        }
    }

    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt) {
        if (id != 3) {
            if (id == PacketType.RECIEVENBT.ordinal()) {
                this.func_70037_a(nbt);
                this.initFromBounds();
            } else if (id == PacketType.DECONSTRUCT.ordinal()) {
                this.deconstructRocket();
            } else if (id == PacketType.SENDINTERACT.ordinal()) {
                this.interact(player);
            } else if (id == PacketType.OPENGUI.ordinal()) {
                if (player.func_184187_bx() == this) {
                    this.openGui(player);
                }
            } else if (id == PacketType.REQUESTNBT.ordinal()) {
                if (this.storage != null) {
                    NBTTagCompound nbtdata = new NBTTagCompound();
                    this.writeNetworkableNBT(nbtdata);
                    PacketHandler.sendToPlayer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.RECIEVENBT.ordinal(), nbtdata), (EntityPlayer)player);
                }
            } else if (id == PacketType.FORCEMOUNT.ordinal()) {
                if (!this.acceptedPacket) {
                    this.acceptedPacket = true;
                    player.func_70080_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, player.field_70177_z, player.field_70125_A);
                    player.func_184220_m((Entity)this);
                    MinecraftForge.EVENT_BUS.post((Event)new RocketEvent.RocketDeOrbitingEvent(this));
                }
            } else if (id == PacketType.LAUNCH.ordinal()) {
                if (this.func_184188_bt().contains(player)) {
                    this.prepareLaunch();
                }
            } else if (id == PacketType.CHANGEWORLD.ordinal()) {
                AdvancedRocketry.proxy.changeClientPlayerWorld(this.storage.world);
            } else if (id == PacketType.REVERTWORLD.ordinal()) {
                AdvancedRocketry.proxy.changeClientPlayerWorld(this.field_70170_p);
            } else if (id == PacketType.OPENPLANETSELECTION.ordinal()) {
                player.openGui((Object)LibVulpes.instance, GuiHandler.guiId.MODULARFULLSCREEN.ordinal(), player.field_70170_p, this.func_145782_y(), -1, 0);
            } else if (id == PacketType.SENDPLANETDATA.ordinal()) {
                ItemStack stack = this.storage.getGuidanceComputer().func_70301_a(0);
                if (!stack.func_190926_b() && stack.func_77973_b() == AdvancedRocketryItems.itemPlanetIdChip) {
                    ((ItemPlanetIdentificationChip)AdvancedRocketryItems.itemPlanetIdChip).setDimensionId(stack, nbt.func_74762_e("selection"));
                    if (!this.field_70170_p.field_72995_K) {
                        PacketHandler.sendToPlayersTrackingEntity((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.SENDPLANETDATA.ordinal()), (Entity)this);
                    }
                }
            } else if (id == PacketType.DISCONNECTINFRASTRUCTURE.ordinal()) {
                int[] pos = nbt.func_74759_k("pos");
                this.connectedInfrastructure.remove(new HashedBlockPosition(pos[0], pos[1], pos[2]));
                TileEntity tile = this.field_70170_p.func_175625_s(new BlockPos(pos[0], pos[1], pos[2]));
                if (tile instanceof IInfrastructure) {
                    ((IInfrastructure)tile).unlinkRocket();
                    this.connectedInfrastructure.remove(tile);
                }
            } else if (id == PacketType.ROCKETLANDEVENT.ordinal() && this.field_70170_p.field_72995_K) {
                MinecraftForge.EVENT_BUS.post((Event)new RocketEvent.RocketLandedEvent(this));
            } else if (id == PacketType.DISMOUNTCLIENT.ordinal() && this.field_70170_p.field_72995_K) {
                player.func_184210_p();
            } else if (id == PacketType.TOGGLE_RCS.ordinal() && !this.field_70170_p.field_72995_K) {
                this.toggleRCS();
            } else if (id == PacketType.TURNUPDATE.ordinal()) {
                this.turningLeft = nbt.func_74767_n("left");
                this.turningRight = nbt.func_74767_n("right");
                this.turningUp = nbt.func_74767_n("up");
                this.turningDownforWhat = nbt.func_74767_n("down");
            } else if (id == PacketType.ABORTLAUNCH.ordinal()) {
                this.field_70180_af.func_187227_b(LAUNCH_COUNTER, (Object)-1);
            } else if (id == PacketType.SENDSPACEPOS.ordinal()) {
                this.spacePosition.readFromNBT(nbt);
            } else if (id >= 75) {
                int id2 = id - 75 - 1;
                this.setDestLandingPad(id2);
                if (!this.field_70170_p.field_72995_K) {
                    PacketHandler.sendToPlayersTrackingEntity((BasePacket)new PacketEntity((INetworkEntity)this, id), (Entity)this);
                }
            } else if (id > 25) {
                TileEntity tile = this.storage.getGUITiles().get(id - 25 - 3);
                PacketHandler.sendToPlayer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.CHANGEWORLD.ordinal()), (EntityPlayer)player);
                this.storage.func_180495_p(tile.func_174877_v()).func_177230_c().func_180639_a((World)this.storage.world, tile.func_174877_v(), this.storage.func_180495_p(tile.func_174877_v()), player, EnumHand.MAIN_HAND, EnumFacing.DOWN, 0.0f, 0.0f, 0.0f);
                PacketHandler.sendToPlayer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.REVERTWORLD.ordinal()), (EntityPlayer)player);
            }
        }
    }

    private void setDestLandingPad(int padIndex) {
        int uuid;
        ItemStack slot0 = this.storage.getGuidanceComputer().func_70301_a(0);
        if (!slot0.func_190926_b() && slot0.func_77973_b() instanceof ItemStationChip && (uuid = ItemStationChip.getUUID(slot0)) != 0) {
            StationLandingLocation location;
            ISpaceObject spaceObject = SpaceObjectManager.getSpaceManager().getSpaceStation(uuid);
            if (spaceObject instanceof SpaceStationObject) {
                if (padIndex == -1) {
                    this.storage.getGuidanceComputer().setLandingLocation(uuid, null);
                } else {
                    location = ((SpaceStationObject)spaceObject).getLandingPads().get(padIndex);
                    if (location != null && !location.getOccupied()) {
                        this.storage.getGuidanceComputer().setLandingLocation(uuid, location);
                    }
                }
            }
            this.landingPadDisplayText.setText((location = this.storage.getGuidanceComputer().getLandingLocation(uuid)) != null ? location.toString() : "None Selected");
        }
    }

    public void func_184232_k(@Nonnull Entity entity) {
        if (this.storage != null) {
            try {
                HashedBlockPosition seatPos = this.stats.getPassengerSeat(this.func_184188_bt().indexOf(entity));
                float xOffset = this.storage.getSizeX() % 2 == 0 ? 0.5f : 0.0f;
                float zOffset = this.storage.getSizeZ() % 2 == 0 ? 0.5f : 0.0f;
                double xPos = (float)seatPos.x + xOffset;
                double yPos = (float)seatPos.y - 0.5f;
                double zPos = (float)seatPos.z + zOffset;
                float angle = (float)((double)((float)this.getRCSRotateProgress() * 0.9f) * Math.PI / 180.0);
                double yNew = yPos * (double)MathHelper.func_76134_b((float)angle) + (-zPos - 0.5) * (double)MathHelper.func_76126_a((float)angle);
                double zNew = zPos * (double)MathHelper.func_76134_b((float)angle) + (yPos + 1.0) * (double)MathHelper.func_76126_a((float)angle);
                yPos = yNew + this.field_70163_u;
                zPos = zNew;
                float yawAngle = (float)((double)this.field_70177_z * Math.PI / 180.0);
                double xNew = xPos * (double)MathHelper.func_76134_b((float)(-yawAngle)) + zPos * (double)MathHelper.func_76126_a((float)(-yawAngle));
                zNew = zPos * (double)MathHelper.func_76134_b((float)yawAngle) + xPos * (double)MathHelper.func_76126_a((float)yawAngle);
                xPos = this.field_70165_t + xNew;
                zPos = this.field_70161_v + zNew;
                entity.func_70107_b(xPos, yPos, zPos);
            }
            catch (IndexOutOfBoundsException e) {
                entity.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            }
        } else {
            entity.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    public List<ModuleBase> getModules(int ID, EntityPlayer player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        if (ID == GuiHandler.guiId.MODULAR.ordinal()) {
            if (this.field_70170_p.field_72995_K) {
                modules.add((ModuleBase)new ModuleImage(173, 0, new IconResource(128, 0, 48, 86, CommonResources.genericBackground)));
                modules.add((ModuleBase)new ModuleImage(173, 86, new IconResource(98, 0, 78, 83, CommonResources.genericBackground)));
                modules.add((ModuleBase)new ModuleImage(173, 168, new IconResource(98, 168, 78, 3, CommonResources.genericBackground)));
            }
            if (this.storage.hasServiceMonitor()) {
                ArrayList<ModuleBrokenPart> serviceMonitorList = new ArrayList<ModuleBrokenPart>();
                int ii = 0;
                for (TileBrokenPart part : this.storage.getBrokenBlocks()) {
                    serviceMonitorList.add(new ModuleBrokenPart(ii % 5 * 18, ii / 5 * 18, part.getDrop()));
                    ++ii;
                }
                modules.add((ModuleBase)new ModuleContainerPanYOnly(88, 17, serviceMonitorList, new ArrayList(), null, 50, 45));
                modules.add((ModuleBase)new ModuleText(80, 5, LibVulpes.proxy.getLocalizedString("msg.serviceStation.destroyProb") + ": " + (int)(this.storage.getBreakingProbability() * 100.0f) + "%", 0));
            }
            List<TileEntity> tiles = this.storage.getGUITiles();
            ArrayList<ModuleSlotButton> panModules = new ArrayList<ModuleSlotButton>();
            for (int i = 0; i < tiles.size(); ++i) {
                TileEntity tile = tiles.get(i);
                IBlockState state = this.storage.func_180495_p(tile.func_174877_v());
                try {
                    panModules.add(new ModuleSlotButton(18 * (i % 4), 18 * (i / 4), i + 3, (IButtonInventory)this, new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state)), this.field_70170_p));
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            modules.add((ModuleBase)new ModuleContainerPanYOnly(8, 17, panModules, new LinkedList(), null, 65, 45, 0, 0));
            modules.add((ModuleBase)new ModuleProgress(192, 7, 0, new ProgressBarImage(2, 173, 12, 71, 17, 6, 3, 69, 1, 1, EnumFacing.UP, zmaster587.advancedRocketry.inventory.TextureResources.rocketHud), (IProgressBar)this));
            modules.add((ModuleBase)new ModuleButton(180, 140, 0, LibVulpes.proxy.getLocalizedString("msg.entity.rocket.disass"), (IButtonInventory)this, TextureResources.buttonBuild, 64, 20));
            modules.add((ModuleBase)new ModuleButton(180, 114, 1, LibVulpes.proxy.getLocalizedString("msg.entity.rocket.seldst"), (IButtonInventory)this, TextureResources.buttonBuild, 64, 20));
        } else {
            int uuid;
            ItemStack slot0;
            ItemStack itemStack = slot0 = this.storage.getGuidanceComputer() != null ? this.storage.getGuidanceComputer().func_70301_a(0) : ItemStack.field_190927_a;
            if (!slot0.func_190926_b() && slot0.func_77973_b() instanceof ItemStationChip && (uuid = ItemStationChip.getUUID(slot0)) != 0) {
                ISpaceObject spaceObject = SpaceObjectManager.getSpaceManager().getSpaceStation(uuid);
                modules.add(new ModuleStellarBackground(0, 0, TextureResources.starryBG));
                if (spaceObject == null) {
                    return modules;
                }
                LinkedList<ModuleButton> list2 = new LinkedList<ModuleButton>();
                ModuleButton button = new ModuleButton(0, 0, 50, LibVulpes.proxy.getLocalizedString("msg.entity.rocket.clear"), (IButtonInventory)this, zmaster587.advancedRocketry.inventory.TextureResources.buttonGeneric, 72, 18);
                list2.add(button);
                int i = 1;
                for (StationLandingLocation pos : ((SpaceStationObject)spaceObject).getLandingPads()) {
                    button = new ModuleButton(0, i * 18, i + 50, pos.toString(), (IButtonInventory)this, zmaster587.advancedRocketry.inventory.TextureResources.buttonGeneric, 72, 18);
                    list2.add(button);
                    if (pos.getOccupied()) {
                        button.setColor(0xFF0000);
                    }
                    ++i;
                }
                ModuleContainerPan pan = new ModuleContainerPan(25, 25, list2, new LinkedList(), null, 256, 256, 0, -48, 258, 256);
                modules.add((ModuleBase)pan);
                StationLandingLocation location = this.storage.getGuidanceComputer().getLandingLocation(uuid);
                this.landingPadDisplayText.setText(location != null ? location.toString() : LibVulpes.proxy.getLocalizedString("msg.entity.rocket.none"));
                modules.add((ModuleBase)this.landingPadDisplayText);
            } else {
                DimensionProperties properties = DimensionManager.getEffectiveDimId(this.field_70170_p, this.func_180425_c());
                while (properties.getParentProperties() != null) {
                    properties = properties.getParentProperties();
                }
                this.container = this.stats.isNuclear() ? new ModulePlanetSelector(properties.getStarId(), TextureResources.starryBG, this, this, true) : new ModulePlanetSelector(properties.getId(), TextureResources.starryBG, this, false);
                this.container.setOffset(1000, 1000);
                modules.add((ModuleBase)this.container);
            }
        }
        return modules;
    }

    public String getModularInventoryName() {
        return "Rocket";
    }

    public float getNormallizedProgress(int id) {
        FuelRegistry.FuelType fuelType = this.getRocketFuelType();
        if (id == 0 && fuelType != null) {
            switch (fuelType) {
                case LIQUID_MONOPROPELLANT: 
                case LIQUID_BIPROPELLANT: 
                case NUCLEAR_WORKING_FLUID: {
                    return (float)this.getFuelAmount(fuelType) / (float)this.getFuelCapacity(fuelType);
                }
            }
        }
        return 0.0f;
    }

    public double getRelativeHeightFraction() {
        return (this.field_70163_u - (double)this.getTopBlock(this.func_180425_c()).func_177956_o()) / (double)(this.getEntryHeight(this.field_71093_bK) - this.getTopBlock(this.func_180425_c()).func_177956_o());
    }

    public double getPreviousRelativeHeightFraction() {
        return (this.field_70167_r - (double)this.getTopBlock(this.func_180425_c()).func_177956_o()) / (double)(this.getEntryHeight(this.field_71093_bK) - this.getTopBlock(this.func_180425_c()).func_177956_o());
    }

    public void setProgress(int id, int progress) {
    }

    public int getProgress(int id) {
        return 0;
    }

    public int getTotalProgress(int id) {
        return 0;
    }

    public void setTotalProgress(int id, int progress) {
    }

    @SideOnly(value=Side.CLIENT)
    public void onInventoryButtonPressed(int buttonId) {
        switch (buttonId) {
            case 0: {
                PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.DECONSTRUCT.ordinal()));
                break;
            }
            case 1: {
                PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.OPENPLANETSELECTION.ordinal()));
                break;
            }
            default: {
                PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)(buttonId + 25)));
                if (buttonId >= 50) break;
                TileEntity tile = this.storage.getGUITiles().get(buttonId - 3);
                this.storage.func_180495_p(tile.func_174877_v()).func_177230_c().func_180639_a((World)this.storage.world, tile.func_174877_v(), this.storage.func_180495_p(tile.func_174877_v()), (EntityPlayer)Minecraft.func_71410_x().field_71439_g, EnumHand.MAIN_HAND, EnumFacing.DOWN, 0.0f, 0.0f, 0.0f);
            }
        }
    }

    public boolean canInteractWithContainer(EntityPlayer entity) {
        boolean ret;
        boolean bl = ret = !this.field_70128_L && this.func_70032_d((Entity)entity) < 64.0f;
        if (!ret) {
            RocketInventoryHelper.removePlayerFromInventoryBypass(entity);
        }
        RocketInventoryHelper.updateTime(entity, this.field_70170_p.func_72820_D());
        return ret;
    }

    @Override
    public StatsRocket getRocketStats() {
        return this.stats;
    }

    public void onSelected(Object sender) {
    }

    public void onSelectionConfirmed(Object sender) {
        PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.SENDPLANETDATA.ordinal()));
    }

    public void onSystemFocusChanged(Object sender) {
    }

    public LinkedList<IInfrastructure> getConnectedInfrastructure() {
        return this.connectedInfrastructure;
    }

    @Override
    public boolean isPlanetKnown(IDimensionProperties properties) {
        return !ARConfiguration.getCurrentConfig().planetsMustBeDiscovered || DimensionManager.getInstance().knownPlanets.contains(properties.getId());
    }

    @Override
    public boolean isStarKnown(StellarBody body) {
        return true;
    }

    public static enum PacketType {
        RECIEVENBT,
        SENDINTERACT,
        REQUESTNBT,
        FORCEMOUNT,
        LAUNCH,
        DECONSTRUCT,
        OPENGUI,
        CHANGEWORLD,
        REVERTWORLD,
        OPENPLANETSELECTION,
        SENDPLANETDATA,
        DISCONNECTINFRASTRUCTURE,
        CONNECTINFRASTRUCTURE,
        ROCKETLANDEVENT,
        MENU_CHANGE,
        UPDATE_ATM,
        UPDATE_ORBIT,
        UPDATE_FLIGHT,
        DISMOUNTCLIENT,
        TOGGLE_RCS,
        TURNUPDATE,
        ABORTLAUNCH,
        SENDSPACEPOS;

    }
}

