/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.satellite;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.DataStorage;
import zmaster587.advancedRocketry.api.SatelliteRegistry;
import zmaster587.advancedRocketry.api.satellite.IDataHandler;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.advancedRocketry.api.satellite.SatelliteProperties;
import zmaster587.advancedRocketry.util.IDataInventory;
import zmaster587.libVulpes.util.ZUtils;

public abstract class SatelliteData
extends SatelliteBase {
    public DataStorage data;
    long lastActionTime;
    long prevLastActionTime;
    int collectionTime;
    int powerConsumption = this.getPowerPerTick();
    World world;

    public SatelliteData() {
        this.collectionTime = (int)(200.0 / Math.sqrt(0.1 * (double)this.powerConsumption));
    }

    @Override
    public String getInfo(World world) {
        return "Power: " + this.battery.getUniversalEnergyStored() + "/" + this.battery.getMaxEnergyStored() + "\nData Storage: " + ZUtils.formatNumber((int)this.data.getMaxData()) + "\nData: " + ZUtils.formatNumber((int)this.data.getData());
    }

    @Override
    public boolean acceptsItemInConstruction(@Nonnull ItemStack item) {
        int flag = SatelliteRegistry.getSatelliteProperty(item).getPropertyFlag();
        return super.acceptsItemInConstruction(item) || SatelliteProperties.Property.DATA.isOfType(flag);
    }

    @Override
    public void setProperties(@Nonnull ItemStack satelliteProperties) {
        super.setProperties(satelliteProperties);
        this.data.setMaxData(this.satelliteProperties.getMaxDataStorage());
        this.powerConsumption = this.getPowerPerTick();
        this.collectionTime = (int)(200.0 / Math.sqrt(0.1 * (double)this.powerConsumption));
    }

    @Override
    public boolean performAction(EntityPlayer player, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IDataHandler) {
            IDataInventory dataInv = (IDataInventory)tile;
            this.data.removeData(dataInv.addData(this.data.getData(), this.data.getDataType(), EnumFacing.DOWN, true), true);
        }
        return false;
    }

    private int getDataCreated() {
        if (this.collectionTime == 0) {
            this.collectionTime = 200;
        }
        int r = 0;
        if (this.data.getMaxData() >= this.data.getData()) {
            this.battery.extractEnergy(this.powerConsumption, false);
            if (AdvancedRocketry.proxy.getWorldTimeUniversal(0) % (long)this.collectionTime == 0L) {
                ++r;
            }
        }
        return r;
    }

    @Override
    public void tickEntity() {
        super.tickEntity();
        this.data.addData(this.getDataCreated(), this.data.getDataType(), true);
    }

    @Override
    public void setDimensionId(World world) {
        super.setDimensionId(world);
        this.world = world;
        this.lastActionTime = world.func_82737_E();
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.data.readFromNBT(nbt.func_74775_l("data"));
        this.lastActionTime = nbt.func_74763_f("lastActionTime");
        this.collectionTime = nbt.func_74762_e("collectionMultiplier");
        this.powerConsumption = this.getPowerPerTick();
        this.collectionTime = (int)(200.0 / Math.sqrt(0.1 * (double)this.powerConsumption));
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        NBTTagCompound data = new NBTTagCompound();
        this.data.writeToNBT(data);
        nbt.func_74782_a("data", (NBTBase)data);
        nbt.func_74772_a("lastActionTime", this.lastActionTime);
        nbt.func_74768_a("collectionMultiplier", this.collectionTime);
    }

    @Override
    public int numberChangesToSend() {
        return 4;
    }

    @Override
    public void onChangeReceived(int slot, int value) {
        this.lastActionTime = this.lastActionTime & (65535L << slot * 16 ^ 0xFFFFFFFFFFFFFFFFL) | (long)value << slot * 16;
    }

    @Override
    public void sendChanges(Container container, IContainerListener crafter, int variableId, int localId) {
        crafter.func_71112_a(container, variableId, (int)((short)(this.lastActionTime >>> localId * 16 & 0xFFFFL)));
        if (localId == 3) {
            this.prevLastActionTime = this.lastActionTime;
        }
    }

    @Override
    public boolean isUpdateRequired(int localId) {
        return this.lastActionTime != this.prevLastActionTime;
    }
}

