/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.infrastructure;

import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.EntityRocketBase;
import zmaster587.advancedRocketry.api.IInfrastructure;
import zmaster587.advancedRocketry.api.IMission;
import zmaster587.advancedRocketry.api.fuel.FuelRegistry;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.entity.EntityRocket;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.client.util.IndicatorBarImage;
import zmaster587.libVulpes.client.util.ProgressBarImage;
import zmaster587.libVulpes.interfaces.ILinkableTile;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.IProgressBar;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.inventory.modules.ModuleProgress;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.items.ItemLinker;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.tile.IComparatorOverride;
import zmaster587.libVulpes.util.IAdjBlockUpdate;
import zmaster587.libVulpes.util.INetworkMachine;

public class TileRocketMonitoringStation
extends TileEntity
implements IModularInventory,
ITickable,
IAdjBlockUpdate,
IInfrastructure,
ILinkableTile,
INetworkMachine,
IButtonInventory,
IProgressBar,
IComparatorOverride {
    EntityRocketBase linkedRocket;
    IMission mission = null;
    ModuleText missionText = new ModuleText(20, 90, LibVulpes.proxy.getLocalizedString("msg.monitoringStation.missionProgressNA"), 0x2B2B2B);
    boolean was_powered = false;
    int rocketHeight;
    int velocity;
    int fuelLevel;
    int maxFuelLevel;
    int oxidizerFuelLevel;

    public void func_145843_s() {
        super.func_145843_s();
        if (this.linkedRocket != null) {
            this.linkedRocket.unlinkInfrastructure(this);
            this.unlinkRocket();
        }
        if (this.mission != null) {
            this.mission.unlinkInfrastructure(this);
            this.unlinkMission();
        }
    }

    public boolean getEquivalentPower() {
        boolean state2 = this.field_145850_b.func_175687_A(this.field_174879_c) > 0;
        return state2;
    }

    public void onAdjacentBlockUpdated() {
    }

    @Override
    public int getMaxLinkDistance() {
        return 300000;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.linkedRocket instanceof EntityRocket) {
                if ((int)(15.0 * ((EntityRocket)this.linkedRocket).getRelativeHeightFraction()) != (int)(15.0 * ((EntityRocket)this.linkedRocket).getPreviousRelativeHeightFraction())) {
                    this.func_70296_d();
                }
                if (this.getEquivalentPower() && this.linkedRocket != null && !this.was_powered) {
                    System.out.println("prepare launch (redstone powered)");
                    this.linkedRocket.prepareLaunch();
                    this.was_powered = true;
                }
            }
            if (!this.getEquivalentPower()) {
                this.was_powered = false;
            }
        }
    }

    public boolean onLinkStart(@Nonnull ItemStack item, TileEntity entity, EntityPlayer player, World world) {
        ItemLinker.setMasterCoords((ItemStack)item, (BlockPos)this.func_174877_v());
        if (this.linkedRocket != null) {
            this.linkedRocket.unlinkInfrastructure(this);
            this.unlinkRocket();
        }
        if (this.mission != null) {
            this.mission.unlinkInfrastructure(this);
            this.unlinkMission();
        }
        if (player.field_70170_p.field_72995_K) {
            Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TextComponentTranslation("%s %s", new Object[]{new TextComponentTranslation("msg.monitoringStation.link", new Object[0]), ": " + this.func_174877_v().func_177958_n() + " " + this.func_174877_v().func_177956_o() + " " + this.func_174877_v().func_177952_p()}));
        }
        return true;
    }

    public boolean onLinkComplete(@Nonnull ItemStack item, TileEntity entity, EntityPlayer player, World world) {
        if (player.field_70170_p.field_72995_K) {
            Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TextComponentTranslation("msg.linker.error.firstMachine", new Object[0]));
        }
        return false;
    }

    @Override
    public void unlinkRocket() {
        this.linkedRocket = null;
    }

    @Override
    public boolean disconnectOnLiftOff() {
        return false;
    }

    @Override
    public boolean linkRocket(EntityRocketBase rocket) {
        this.linkedRocket = rocket;
        return true;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.was_powered = nbt.func_74767_n("was_powered");
        if (nbt.func_74764_b("missionID")) {
            long id = nbt.func_74763_f("missionID");
            int dimid = nbt.func_74762_e("missionDimId");
            SatelliteBase sat = DimensionManager.getInstance().getSatellite(id);
            if (sat instanceof IMission) {
                this.mission = (IMission)((Object)sat);
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("was_powered", this.was_powered);
        if (this.mission != null) {
            nbt.func_74772_a("missionID", this.mission.getMissionId());
            nbt.func_74768_a("missionDimId", this.mission.getOriginatingDimension());
        }
        return nbt;
    }

    public void writeDataToNetwork(ByteBuf out, byte id) {
        if (id == 1) {
            out.writeLong(this.mission == null ? -1L : this.mission.getMissionId());
        }
    }

    public void readDataFromNetwork(ByteBuf in, byte packetId, NBTTagCompound nbt) {
        if (packetId == 1) {
            nbt.func_74772_a("id", in.readLong());
        } else if (packetId == 2) {
            nbt.func_74774_a("state", in.readByte());
        }
    }

    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt) {
        if (id == 1) {
            long idNum = nbt.func_74763_f("id");
            if (idNum == -1L) {
                this.mission = null;
                this.setMissionText();
            } else {
                SatelliteBase base = DimensionManager.getInstance().getSatellite(idNum);
                if (base instanceof IMission) {
                    this.mission = (IMission)((Object)base);
                    this.setMissionText();
                }
            }
        } else if (id == 2) {
            // empty if block
        }
        if (id == 100 && this.linkedRocket != null) {
            this.linkedRocket.prepareLaunch();
        }
    }

    public List<ModuleBase> getModules(int ID, EntityPlayer player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        modules.add((ModuleBase)new ModuleButton(20, 40, 0, "Launch!", (IButtonInventory)this, zmaster587.libVulpes.inventory.TextureResources.buttonBuild));
        modules.add((ModuleBase)new ModuleProgress(98, 4, 0, (ProgressBarImage)new IndicatorBarImage(2, 7, 12, 81, 17, 0, 6, 6, 1, 0, EnumFacing.UP, TextureResources.rocketHud), (IProgressBar)this));
        modules.add((ModuleBase)new ModuleProgress(120, 14, 1, (ProgressBarImage)new IndicatorBarImage(2, 95, 12, 71, 17, 0, 6, 6, 1, 0, EnumFacing.UP, TextureResources.rocketHud), (IProgressBar)this));
        modules.add((ModuleBase)new ModuleProgress(142, 14, 2, new ProgressBarImage(2, 173, 12, 71, 17, 6, 3, 69, 1, 1, EnumFacing.UP, TextureResources.rocketHud), (IProgressBar)this));
        modules.add((ModuleBase)new ModuleProgress(148, 14, 6, new ProgressBarImage(2, 173, 12, 71, 17, 75, 3, 69, 1, 1, EnumFacing.UP, TextureResources.rocketHud), (IProgressBar)this));
        this.setMissionText();
        modules.add((ModuleBase)this.missionText);
        modules.add((ModuleBase)new ModuleProgress(30, 110, 3, TextureResources.progressToMission, (IProgressBar)this));
        modules.add((ModuleBase)new ModuleProgress(30, 120, 4, TextureResources.workMission, (IProgressBar)this));
        modules.add((ModuleBase)new ModuleProgress(30, 130, 5, TextureResources.progressFromMission, (IProgressBar)this));
        if (!this.field_145850_b.field_72995_K) {
            PacketHandler.sendToPlayer((BasePacket)new PacketMachine((INetworkMachine)this, 1), (EntityPlayer)player);
        }
        return modules;
    }

    private void setMissionText() {
        if (this.mission != null) {
            int time = this.mission.getTimeRemainingInSeconds();
            int seconds = time % 60;
            int minutes = time / 60 % 60;
            int hours = time / 3600;
            this.missionText.setText(((SatelliteBase)((Object)this.mission)).getName() + LibVulpes.proxy.getLocalizedString("msg.monitoringStation.progress") + String.format("\n%02dhr:%02dm:%02ds", hours, minutes, seconds));
        } else {
            this.missionText.setText(LibVulpes.proxy.getLocalizedString("msg.monitoringStation.missionProgressNA"));
        }
    }

    public void onInventoryButtonPressed(int buttonId) {
        if (buttonId != -1) {
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, (byte)(buttonId + 100)));
        } else {
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 2));
        }
    }

    public String getModularInventoryName() {
        return "container.monitoringstation";
    }

    public float getNormallizedProgress(int id) {
        if (id == 1) {
            return Math.max(Math.min(0.5f + (float)this.getProgress(id) / (float)this.getTotalProgress(id), 1.0f), 0.0f);
        }
        if (id == 3) {
            if (this.mission == null) {
                return 0.0f;
            }
            return (float)Math.min(3.0 * this.mission.getProgress(this.field_145850_b), 1.0);
        }
        if (id == 4) {
            if (this.mission == null) {
                return 0.0f;
            }
            return (float)Math.min(Math.max(3.0 * (this.mission.getProgress(this.field_145850_b) - (double)0.333f), 0.0), 1.0);
        }
        if (id == 5) {
            if (this.mission == null) {
                return 0.0f;
            }
            return (float)Math.min(Math.max(3.0 * (this.mission.getProgress(this.field_145850_b) - (double)0.666f), 0.0), 1.0);
        }
        if (this.field_145850_b.field_72995_K && this.mission != null) {
            this.setMissionText();
        }
        return Math.min((float)this.getProgress(id) / (float)this.getTotalProgress(id), 1.0f);
    }

    public void setProgress(int id, int progress) {
        if (id == 0) {
            this.rocketHeight = progress;
        } else if (id == 1) {
            this.velocity = progress;
        } else if (id == 2) {
            this.fuelLevel = progress;
        } else if (id == 6) {
            this.oxidizerFuelLevel = progress;
        }
    }

    public int getProgress(int id) {
        if (this.field_145850_b.field_72995_K) {
            if (this.mission != null && id == 0) {
                return this.getTotalProgress(id);
            }
            if (id == 0) {
                return this.rocketHeight;
            }
            if (id == 1) {
                return this.velocity;
            }
            if (id == 2) {
                return this.fuelLevel;
            }
            if (id == 6) {
                return this.oxidizerFuelLevel;
            }
        }
        if (this.linkedRocket == null) {
            return 0;
        }
        if (id == 0) {
            return (int)this.linkedRocket.field_70163_u;
        }
        if (id == 1) {
            return (int)(this.linkedRocket.field_70181_x * 100.0);
        }
        if (id == 2) {
            return this.linkedRocket.getFuelAmount(this.linkedRocket.getRocketFuelType());
        }
        if (id == 6) {
            return this.linkedRocket.getFuelAmount(FuelRegistry.FuelType.LIQUID_OXIDIZER);
        }
        return 0;
    }

    public int getTotalProgress(int id) {
        if (id == 0) {
            return ARConfiguration.getCurrentConfig().orbit;
        }
        if (id == 1) {
            return 1000;
        }
        if (id == 2) {
            if (this.field_145850_b.field_72995_K) {
                return this.maxFuelLevel;
            }
            if (this.linkedRocket == null) {
                return 0;
            }
            return this.linkedRocket.getFuelCapacity(this.linkedRocket.getRocketFuelType());
        }
        if (id == 6) {
            if (this.field_145850_b.field_72995_K) {
                return this.maxFuelLevel;
            }
            if (this.linkedRocket == null) {
                return 0;
            }
            return this.linkedRocket.getFuelCapacity(FuelRegistry.FuelType.LIQUID_OXIDIZER);
        }
        return 1;
    }

    public void setTotalProgress(int id, int progress) {
        if (id == 2 || id == 6) {
            this.maxFuelLevel = progress;
        }
    }

    public boolean canInteractWithContainer(EntityPlayer entity) {
        return true;
    }

    @Override
    public boolean linkMission(IMission mission) {
        this.mission = mission;
        PacketHandler.sendToNearby((BasePacket)new PacketMachine((INetworkMachine)this, 1), (int)this.field_145850_b.field_73011_w.getDimension(), (BlockPos)this.func_174877_v(), (double)16.0);
        return true;
    }

    @Override
    public void unlinkMission() {
        this.mission = null;
        this.setMissionText();
        PacketHandler.sendToNearby((BasePacket)new PacketMachine((INetworkMachine)this, 1), (int)this.field_145850_b.field_73011_w.getDimension(), (BlockPos)this.func_174877_v(), (double)16.0);
    }

    @Override
    public boolean canRenderConnection() {
        return false;
    }

    public int getComparatorOverride() {
        if (this.linkedRocket instanceof EntityRocket) {
            return (int)(15.0 * ((EntityRocket)this.linkedRocket).getRelativeHeightFraction());
        }
        return 0;
    }
}

