/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.infrastructure;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.EntityRocketBase;
import zmaster587.advancedRocketry.api.IFuelTank;
import zmaster587.advancedRocketry.api.IInfrastructure;
import zmaster587.advancedRocketry.api.IMission;
import zmaster587.advancedRocketry.block.BlockBipropellantRocketMotor;
import zmaster587.advancedRocketry.block.BlockRocketMotor;
import zmaster587.advancedRocketry.block.BlockSeat;
import zmaster587.advancedRocketry.entity.EntityRocket;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.tile.TileBrokenPart;
import zmaster587.advancedRocketry.tile.multiblock.machine.TilePrecisionAssembler;
import zmaster587.advancedRocketry.util.IBrokenPartBlock;
import zmaster587.advancedRocketry.util.InventoryUtil;
import zmaster587.advancedRocketry.util.StorageChunk;
import zmaster587.advancedRocketry.util.nbt.NBTHelper;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.IUniversalEnergy;
import zmaster587.libVulpes.block.BlockTile;
import zmaster587.libVulpes.interfaces.ILinkableTile;
import zmaster587.libVulpes.interfaces.INetworkEntity;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.IProgressBar;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.inventory.modules.ModulePower;
import zmaster587.libVulpes.inventory.modules.ModuleProgress;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.items.ItemLinker;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketEntity;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.tile.IComparatorOverride;
import zmaster587.libVulpes.tile.TileEntityRFConsumer;
import zmaster587.libVulpes.util.IAdjBlockUpdate;
import zmaster587.libVulpes.util.INetworkMachine;

public class TileRocketServiceStation
extends TileEntityRFConsumer
implements IModularInventory,
ITickable,
IAdjBlockUpdate,
IInfrastructure,
ILinkableTile,
INetworkMachine,
IButtonInventory,
IProgressBar,
IComparatorOverride {
    EntityRocketBase linkedRocket;
    ModuleText destroyProbText;
    ModuleText destroyProgressText;
    ModuleText wornMotorsText;
    ModuleText wornSeatsText;
    ModuleText wornTanksText;
    ModuleText wornMotorsCount;
    ModuleText wornSeatsCount;
    ModuleText wornTanksCount;
    boolean was_powered = false;
    List<TilePrecisionAssembler> assemblers = new ArrayList<TilePrecisionAssembler>();
    List<BlockPos> assemblerPoses = new ArrayList<BlockPos>();
    TileBrokenPart[] partsProcessing = new TileBrokenPart[0];
    IBlockState[] statesProcessing = new IBlockState[0];
    int initialPartToRepairCount;
    List<TileBrokenPart> partsToRepair = new LinkedList<TileBrokenPart>();
    List<IBlockState> statesToRepair = new LinkedList<IBlockState>();

    public TileRocketServiceStation() {
        super(10000);
        this.destroyProbText = new ModuleText(90, 30, LibVulpes.proxy.getLocalizedString("msg.serviceStation.destroyProbNA"), 0x2B2B2B, true);
        this.wornMotorsText = new ModuleText(40, 60, LibVulpes.proxy.getLocalizedString("msg.serviceStation.wornMotorsText"), 0x2B2B2B, true);
        this.wornSeatsText = new ModuleText(90, 60, LibVulpes.proxy.getLocalizedString("msg.serviceStation.wornSeatsText"), 0x2B2B2B, true);
        this.wornTanksText = new ModuleText(140, 60, LibVulpes.proxy.getLocalizedString("msg.serviceStation.wornTanksText"), 0x2B2B2B, true);
        this.destroyProgressText = new ModuleText(90, 120, LibVulpes.proxy.getLocalizedString("msg.serviceStation.serviceProgressNA"), 0x2B2B2B, true);
        this.wornMotorsCount = new ModuleText(40, 70, "0", 0x2B2B2B, true);
        this.wornSeatsCount = new ModuleText(90, 70, "0", 0x2B2B2B, true);
        this.wornTanksCount = new ModuleText(140, 70, "0", 0x2B2B2B, true);
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.linkedRocket != null) {
            this.linkedRocket.unlinkInfrastructure(this);
            this.unlinkRocket();
        }
    }

    public boolean getEquivalentPower() {
        boolean state2 = this.field_145850_b.func_175687_A(this.field_174879_c) > 0;
        return state2;
    }

    public void onAdjacentBlockUpdated() {
    }

    @Override
    public int getMaxLinkDistance() {
        return 3000;
    }

    public void updateRepairList() {
        this.updateRepairList(true);
    }

    private void updateRepairList(boolean initial) {
        EntityRocket rocket = (EntityRocket)this.linkedRocket;
        this.partsToRepair = new LinkedList<TileBrokenPart>();
        this.statesToRepair = new LinkedList<IBlockState>();
        for (TileEntity te : rocket.storage.getTileEntityList()) {
            TileBrokenPart part;
            if (!(te instanceof TileBrokenPart) || (part = (TileBrokenPart)te).getStage() <= 0) continue;
            this.partsToRepair.add(part);
            this.statesToRepair.add(rocket.storage.func_180495_p(te.func_174877_v()));
        }
        if (initial) {
            this.initialPartToRepairCount = this.partsToRepair.size();
        }
    }

    private void scanForAssemblers() {
        this.assemblers = new ArrayList<TilePrecisionAssembler>();
        int size = 5;
        for (int x = this.func_174877_v().func_177958_n() - size; x < this.func_174877_v().func_177958_n() + size; ++x) {
            for (int y = this.func_174877_v().func_177956_o() - size; y < this.func_174877_v().func_177956_o() + size; ++y) {
                for (int z = this.func_174877_v().func_177952_p() - size; z < this.func_174877_v().func_177952_p() + size; ++z) {
                    TileEntity te = this.field_145850_b.func_175625_s(new BlockPos(x, y, z));
                    if (!(te instanceof TilePrecisionAssembler)) continue;
                    this.assemblers.add((TilePrecisionAssembler)te);
                }
            }
        }
        this.statesProcessing = new IBlockState[this.assemblers.size()];
        this.partsProcessing = new TileBrokenPart[this.assemblers.size()];
    }

    private boolean processAssemblerResult(int index) {
        StorageChunk storage = ((EntityRocket)this.linkedRocket).storage;
        TilePrecisionAssembler assembler = this.assemblers.get(index);
        if (InventoryUtil.hasItemInInventories(assembler.getItemOutPorts(), "rocket", true)) {
            IBlockState state = this.statesProcessing[index];
            TileBrokenPart te = this.partsProcessing[index];
            if (te == null) {
                AdvancedRocketry.logger.warn("Rocket service station at " + this.func_174877_v() + " is out of sync with connected assemblers! Repairing part lost");
                return false;
            }
            te.setStage(0);
            storage.addTileEntity(te);
            storage.setBlockState(te.func_174877_v(), state);
            this.statesProcessing[index] = null;
            this.partsProcessing[index] = null;
            assembler.func_70296_d();
            return true;
        }
        return false;
    }

    private void syncRocket() {
        NBTTagCompound nbtdata = new NBTTagCompound();
        this.linkedRocket.func_189511_e(nbtdata);
        PacketHandler.sendToNearby((BasePacket)new PacketEntity((INetworkEntity)((EntityRocket)this.linkedRocket), 0, nbtdata), (int)this.linkedRocket.field_70170_p.field_73011_w.getDimension(), (BlockPos)this.field_174879_c, (double)64.0);
    }

    private void consumePartToRepair(int assemblerIndex) {
        StorageChunk storage = ((EntityRocket)this.linkedRocket).storage;
        TilePrecisionAssembler assembler = this.assemblers.get(assemblerIndex);
        TileBrokenPart part = this.partsToRepair.get(0);
        IBlockState state = this.statesToRepair.get(0);
        if (!(part.func_145838_q() instanceof IBrokenPartBlock)) {
            AdvancedRocketry.logger.warn("Rocket part at " + part.func_174877_v() + " is out of sync with its block! Removing");
            this.statesToRepair.remove(0);
            this.partsToRepair.remove(0);
            return;
        }
        IBrokenPartBlock partBlock = (IBrokenPartBlock)part.func_145838_q();
        this.statesProcessing[assemblerIndex] = state;
        this.partsProcessing[assemblerIndex] = part;
        ItemStack resultingStack = partBlock.getDropItem(this.statesToRepair.get(0), this.field_145850_b, part);
        if (!InventoryUtil.addItemToOneOfTheInventories(assembler.getItemInPorts(), resultingStack)) {
            AdvancedRocketry.logger.error("Precision assembler at " + assembler.func_174877_v() + " overflows. Repaired part lost");
        }
        this.statesToRepair.remove(0);
        this.partsToRepair.remove(0);
        storage.getTileEntityList().remove((Object)part);
        storage.setBlockState(part.func_174877_v(), Blocks.field_150350_a.func_176223_P());
        assembler.onInventoryUpdated();
    }

    private void giveWorkToAssemblers() {
        boolean dirty = false;
        for (int i = 0; i < this.assemblers.size(); ++i) {
            if (this.assemblers.get(i).func_145837_r()) {
                this.assemblers.set(i, null);
                this.partsProcessing[i] = null;
                this.statesProcessing[i] = null;
                continue;
            }
            dirty = dirty || this.processAssemblerResult(i);
            TilePrecisionAssembler assembler = this.assemblers.get(i);
            if (InventoryUtil.hasItemInInventories(assembler.getItemInPorts(), "motor", false) || this.partsToRepair.isEmpty() || this.statesProcessing[i] != null) continue;
            this.consumePartToRepair(i);
            dirty = true;
        }
        if (dirty) {
            this.syncRocket();
        }
    }

    public void performFunction() {
        if (this.linkedRocket instanceof EntityRocket) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (!((Boolean)state.func_177229_b((IProperty)BlockTile.STATE)).booleanValue()) {
                this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)BlockTile.STATE, (Comparable)Boolean.valueOf(true)));
            }
            if (this.getEquivalentPower() && this.linkedRocket != null) {
                if (!this.was_powered) {
                    this.scanForAssemblers();
                    this.was_powered = true;
                } else if (this.assemblerPoses != null) {
                    this.assemblers = this.assemblerPoses.stream().map(pos -> (TilePrecisionAssembler)this.field_145850_b.func_175625_s(pos)).collect(Collectors.toList());
                    this.assemblerPoses = null;
                    this.statesProcessing = new IBlockState[this.assemblers.size()];
                    this.partsProcessing = new TileBrokenPart[this.assemblers.size()];
                    this.updateRepairList(false);
                }
                this.giveWorkToAssemblers();
            }
        }
        if (!this.getEquivalentPower()) {
            this.was_powered = false;
        }
    }

    public boolean canPerformFunction() {
        boolean hasWork;
        if (this.field_145850_b.field_72995_K || this.field_145850_b.func_72820_D() % 20L != 0L) {
            return false;
        }
        boolean bl = hasWork = this.partsToRepair.size() > 0 || Arrays.stream(this.partsProcessing).anyMatch(Objects::nonNull);
        if (hasWork) {
            return true;
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (((Boolean)state.func_177229_b((IProperty)BlockTile.STATE)).booleanValue()) {
            this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)BlockTile.STATE, (Comparable)Boolean.valueOf(false)));
        }
        return false;
    }

    public int getPowerPerOperation() {
        return 10;
    }

    public boolean onLinkStart(@Nonnull ItemStack item, TileEntity entity, EntityPlayer player, World world) {
        ItemLinker.setMasterCoords((ItemStack)item, (BlockPos)this.func_174877_v());
        if (this.linkedRocket != null) {
            this.linkedRocket.unlinkInfrastructure(this);
            this.unlinkRocket();
        }
        if (player.field_70170_p.field_72995_K) {
            Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TextComponentTranslation("%s %s", new Object[]{new TextComponentTranslation("msg.serviceStation.link", new Object[0]), ": " + this.func_174877_v().func_177958_n() + " " + this.func_174877_v().func_177956_o() + " " + this.func_174877_v().func_177952_p()}));
        }
        return true;
    }

    public boolean onLinkComplete(@Nonnull ItemStack item, TileEntity entity, EntityPlayer player, World world) {
        if (player.field_70170_p.field_72995_K) {
            Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TextComponentTranslation("msg.linker.error.firstMachine", new Object[0]));
        }
        return false;
    }

    @Override
    public void unlinkRocket() {
        this.linkedRocket = null;
        this.dropRepairStats();
    }

    public void dropRepairStats() {
        this.partsToRepair = new LinkedList<TileBrokenPart>();
        this.statesToRepair = new LinkedList<IBlockState>();
        this.initialPartToRepairCount = 0;
    }

    @Override
    public boolean disconnectOnLiftOff() {
        return true;
    }

    @Override
    public boolean linkRocket(EntityRocketBase rocket) {
        this.linkedRocket = rocket;
        if (rocket instanceof EntityRocket) {
            this.updateRepairList();
        }
        return true;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.was_powered = nbt.func_74767_n("was_powered");
        this.initialPartToRepairCount = nbt.func_74762_e("initialPartToRepairCount");
        this.assemblerPoses = NBTHelper.readCollection("assemblerPoses", nbt, ArrayList::new, NBTHelper::readBlockPos);
        this.partsProcessing = NBTHelper.readCollection("partsProcessing", nbt, ArrayList::new, NBTHelper::readTileEntity).toArray(new TileBrokenPart[0]);
        this.statesProcessing = NBTHelper.readCollection("statesProcessing", nbt, ArrayList::new, NBTHelper::readState).toArray(new IBlockState[0]);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("was_powered", this.was_powered);
        nbt.func_74768_a("initialPartToRepairCount", this.initialPartToRepairCount);
        NBTHelper.writeCollection("assemblerPoses", nbt, this.assemblers, te -> NBTHelper.writeBlockPos(te.func_174877_v()));
        NBTHelper.writeCollection("partsProcessing", nbt, Arrays.asList(this.partsProcessing), NBTHelper::writeTileEntity);
        NBTHelper.writeCollection("statesProcessing", nbt, Arrays.asList(this.statesProcessing), NBTHelper::writeState);
        return nbt;
    }

    public void writeDataToNetwork(ByteBuf out, byte id) {
    }

    public void readDataFromNetwork(ByteBuf in, byte packetId, NBTTagCompound nbt) {
    }

    public List<ModuleBase> getModules(int ID, EntityPlayer player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        modules.add((ModuleBase)new ModulePower(10, 20, (IUniversalEnergy)this.energy));
        modules.add((ModuleBase)new ModuleButton(37, 100, 0, LibVulpes.proxy.getLocalizedString("msg.serviceStation.assemblerScan"), (IButtonInventory)this, zmaster587.libVulpes.inventory.TextureResources.buttonBuild, 104, 16));
        this.updateText();
        modules.add((ModuleBase)this.destroyProbText);
        modules.add((ModuleBase)this.wornMotorsText);
        modules.add((ModuleBase)this.wornSeatsText);
        modules.add((ModuleBase)this.wornTanksText);
        modules.add((ModuleBase)this.destroyProgressText);
        modules.add((ModuleBase)this.wornMotorsCount);
        modules.add((ModuleBase)this.wornSeatsCount);
        modules.add((ModuleBase)this.wornTanksCount);
        modules.add((ModuleBase)new ModuleProgress(32, 133, 0, TextureResources.progressToMission, (IProgressBar)this));
        if (!this.field_145850_b.field_72995_K) {
            PacketHandler.sendToPlayer((BasePacket)new PacketMachine((INetworkMachine)this, 1), (EntityPlayer)player);
        }
        return modules;
    }

    private void updateText() {
        if (this.linkedRocket != null) {
            if (!(this.linkedRocket instanceof EntityRocket)) {
                this.destroyProbText.setText(LibVulpes.proxy.getLocalizedString("msg.serviceStation.destroyProbNA"));
                return;
            }
            EntityRocket rocket = (EntityRocket)this.linkedRocket;
            this.destroyProbText.setText(LibVulpes.proxy.getLocalizedString("msg.serviceStation.destroyProb") + ": " + rocket.storage.getBreakingProbability());
            List<TileBrokenPart> brokenParts = rocket.storage.getBrokenBlocks();
            long motorsCount = brokenParts.stream().filter(te -> te.getStage() > 0 && (te.func_145838_q() instanceof BlockRocketMotor || te.func_145838_q() instanceof BlockBipropellantRocketMotor)).count();
            long seatsCount = brokenParts.stream().filter(te -> te.getStage() > 0 && te.func_145838_q() instanceof BlockSeat).count();
            long tanksCount = brokenParts.stream().filter(te -> te.getStage() > 0 && te.func_145838_q() instanceof IFuelTank).count();
            this.wornMotorsCount.setText(String.valueOf(motorsCount));
            this.wornSeatsCount.setText(String.valueOf(seatsCount));
            this.wornTanksCount.setText(String.valueOf(tanksCount));
        } else {
            this.destroyProbText.setText(LibVulpes.proxy.getLocalizedString("msg.serviceStation.destroyProbNA"));
        }
    }

    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt) {
        if (id == 0) {
            this.scanForAssemblers();
        }
    }

    public void onInventoryButtonPressed(int buttonId) {
        if (buttonId == 0) {
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 0));
        }
    }

    public String getModularInventoryName() {
        return "container.servicestation";
    }

    public float getNormallizedProgress(int id) {
        if (id == 1) {
            return Math.max(Math.min(0.5f + (float)this.getProgress(id) / (float)this.getTotalProgress(id), 1.0f), 0.0f);
        }
        if (this.field_145850_b.field_72995_K) {
            this.updateText();
        }
        return Math.min((float)this.getProgress(id) / (float)this.getTotalProgress(id), 1.0f);
    }

    public void setProgress(int id, int progress) {
    }

    public int getProgress(int id) {
        if (this.field_145850_b.field_72995_K && id == 0) {
            if (!(this.linkedRocket instanceof EntityRocket)) {
                return 0;
            }
            return this.initialPartToRepairCount - this.partsToRepair.size() - (int)Arrays.stream(this.partsProcessing).filter(Objects::nonNull).count();
        }
        return 0;
    }

    public int getTotalProgress(int id) {
        if (id == 0) {
            return this.initialPartToRepairCount;
        }
        return 0;
    }

    public void setTotalProgress(int id, int progress) {
    }

    public boolean canInteractWithContainer(EntityPlayer entity) {
        return true;
    }

    @Override
    public boolean linkMission(IMission mission) {
        return false;
    }

    @Override
    public void unlinkMission() {
        this.updateText();
    }

    @Override
    public boolean canRenderConnection() {
        return false;
    }

    public int getComparatorOverride() {
        return 0;
    }
}

