/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.multiblock;

import io.netty.buffer.ByteBuf;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.fml.relauncher.Side;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.entity.EntityItemAbducted;
import zmaster587.advancedRocketry.util.AudioRegistry;
import zmaster587.advancedRocketry.util.PlanetaryTravelHelper;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.LibVulpesBlocks;
import zmaster587.libVulpes.block.RotatableBlock;
import zmaster587.libVulpes.interfaces.ILinkableTile;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IGuiCallback;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleNumericTextbox;
import zmaster587.libVulpes.inventory.modules.ModuleRedstoneOutputButton;
import zmaster587.libVulpes.inventory.modules.ModuleSlotArray;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.items.ItemLinker;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.tile.multiblock.TileMultiPowerConsumer;
import zmaster587.libVulpes.util.EmbeddedInventory;
import zmaster587.libVulpes.util.INetworkMachine;
import zmaster587.libVulpes.util.ZUtils;

public class TileRailgun
extends TileMultiPowerConsumer
implements IInventory,
ILinkableTile,
IGuiCallback {
    static final Object[][][] structure = new Object[][][]{{{null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, "coilCopper", null, null, null, null}, {null, null, null, "coilCopper", LibVulpesBlocks.blockStructureBlock, "coilCopper", null, null, null}, {null, null, null, null, "coilCopper", null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}}, {{null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, "coilCopper", null, null, null, null}, {null, null, null, "coilCopper", LibVulpesBlocks.blockStructureBlock, "coilCopper", null, null, null}, {null, null, null, null, "coilCopper", null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}}, {{null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, "coilCopper", null, null, null, null}, {null, null, null, "coilCopper", LibVulpesBlocks.blockStructureBlock, "coilCopper", null, null, null}, {null, null, null, null, "coilCopper", null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}}, {{null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, "coilCopper", null, null, null, null}, {null, null, null, "coilCopper", LibVulpesBlocks.blockStructureBlock, "coilCopper", null, null, null}, {null, null, null, null, "coilCopper", null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}}, {{null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, "coilCopper", null, null, null, null}, {null, null, null, "coilCopper", LibVulpesBlocks.blockStructureBlock, "coilCopper", null, null, null}, {null, null, null, null, "coilCopper", null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}}, {{null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, "coilCopper", null, null, null, null}, {null, null, null, "coilCopper", LibVulpesBlocks.blockStructureBlock, "coilCopper", null, null, null}, {null, null, null, null, "coilCopper", null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}}, {{null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, "coilCopper", null, null, null, null}, {null, null, null, "coilCopper", LibVulpesBlocks.blockStructureBlock, "coilCopper", null, null, null}, {null, null, null, null, "coilCopper", null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}}, {{null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, "coilCopper", null, null, null, null}, {null, null, null, "coilCopper", LibVulpesBlocks.blockStructureBlock, "coilCopper", null, null, null}, {null, null, null, null, "coilCopper", null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}}, {{null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, "coilCopper", null, null, null, null}, {null, null, null, "coilCopper", LibVulpesBlocks.blockStructureBlock, "coilCopper", null, null, null}, {null, null, null, null, "coilCopper", null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}}, {{null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, "blockSteel", null, null, null, null}, {null, null, null, LibVulpesBlocks.blockAdvStructureBlock, "blockTitanium", LibVulpesBlocks.blockAdvStructureBlock, null, null, null}, {null, null, "blockSteel", "blockTitanium", "blockTitanium", "blockTitanium", "blockSteel", null, null}, {null, null, null, LibVulpesBlocks.blockAdvStructureBlock, "blockTitanium", LibVulpesBlocks.blockAdvStructureBlock, null, null, null}, {null, null, null, null, "blockSteel", null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}}, {{"blockSteel", null, null, "slab", "slab", "slab", null, null, "blockSteel"}, {null, LibVulpesBlocks.blockAdvStructureBlock, "slab", Character.valueOf('I'), Character.valueOf('c'), Character.valueOf('O'), "slab", LibVulpesBlocks.blockAdvStructureBlock, null}, {null, "slab", LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, "slab", null}, {"slab", "slab", LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, "slab", "slab"}, {"slab", "slab", LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.motors, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, "slab", "slab"}, {"slab", "slab", LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, "slab", "slab"}, {null, "slab", LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, "slab", null}, {null, LibVulpesBlocks.blockAdvStructureBlock, "slab", Character.valueOf('P'), Character.valueOf('P'), Character.valueOf('P'), "slab", LibVulpesBlocks.blockAdvStructureBlock, null}, {"blockSteel", null, null, "slab", "slab", "slab", null, null, "blockSteel"}}};
    public long recoil;
    private EmbeddedInventory inv = new EmbeddedInventory(1);
    private ForgeChunkManager.Ticket ticket;
    private int minStackTransferSize = 1;
    private ModuleNumericTextbox textBox;
    private ZUtils.RedstoneState state;
    private ModuleRedstoneOutputButton redstoneControl;

    public TileRailgun() {
        this.powerPerTick = 100000;
        this.redstoneControl = new ModuleRedstoneOutputButton(174, 4, -1, "", (IButtonInventory)this);
        this.state = ZUtils.RedstoneState.OFF;
        this.redstoneControl.setRedstoneState(this.state);
    }

    protected int requiredPowerPerTick() {
        BlockPos pos = this.getDestPosition();
        if (pos != null) {
            int distance = (int)Math.sqrt(Math.pow(pos.func_177958_n() - this.field_174879_c.func_177958_n(), 2.0) + Math.pow(pos.func_177952_p() - this.field_174879_c.func_177952_p(), 2.0));
            if (this.getDestDimId() == this.field_145850_b.field_73011_w.getDimension()) {
                distance = distance * 10 + 50000;
            }
            return Math.min(distance, super.requiredPowerPerTick());
        }
        return super.requiredPowerPerTick();
    }

    public boolean shouldHideBlock(World world, BlockPos pos, IBlockState tile) {
        return true;
    }

    private int getDestDimId() {
        ItemStack stack = this.inv.func_70301_a(0);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemLinker) {
            return ItemLinker.getDimId((ItemStack)stack);
        }
        return -2147483647;
    }

    private BlockPos getDestPosition() {
        ItemStack stack = this.inv.func_70301_a(0);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemLinker && ItemLinker.isSet((ItemStack)stack)) {
            return ItemLinker.getMasterCoords((ItemStack)stack);
        }
        return null;
    }

    public Object[][][] getStructure() {
        return structure;
    }

    public List<ModuleBase> getModules(int ID, EntityPlayer player) {
        List modules = super.getModules(ID, player);
        modules.add(new ModuleSlotArray(40, 40, (IInventory)this, 0, 1));
        if (this.field_145850_b.field_72995_K) {
            this.textBox = new ModuleNumericTextbox((IGuiCallback)this, 80, 40, 32, 12, 2);
            this.textBox.setText(String.valueOf(this.minStackTransferSize));
            modules.add(new ModuleText(60, 25, LibVulpes.proxy.getLocalizedString("msg.railgun.transfermin"), 0x2B2B2B));
            modules.add(this.textBox);
        }
        modules.add(this.redstoneControl);
        return modules;
    }

    public void onLoad() {
        if (this.ticket == null) {
            this.ticket = ForgeChunkManager.requestTicket((Object)AdvancedRocketry.instance, (World)this.field_145850_b, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
            if (this.ticket != null) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkPos)new ChunkPos(this.func_174877_v().func_177958_n() / 16 - (this.func_174877_v().func_177958_n() < 0 ? 1 : 0), this.func_174877_v().func_177952_p() / 16 - (this.func_174877_v().func_177952_p() < 0 ? 1 : 0)));
            }
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticket);
    }

    public void onInventoryUpdated() {
        if (this.itemInPorts.isEmpty()) {
            this.attemptCompleteStructure(this.field_145850_b.func_180495_p(this.field_174879_c));
        }
    }

    public void onInventoryButtonPressed(int buttonId) {
        super.onInventoryButtonPressed(buttonId);
        if (buttonId == -1) {
            this.state = this.redstoneControl.getState();
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 5));
        }
    }

    protected void onRunningPoweredTick() {
    }

    public void useEnergy(int amt) {
        if (!this.field_145850_b.field_72995_K && this.enabled && this.isRedstoneStateSatisfied() && this.attemptCargoTransfer()) {
            super.useEnergy(amt);
        }
    }

    public boolean isRunning() {
        return this.isComplete();
    }

    private boolean isRedstoneStateSatisfied() {
        if (this.state == ZUtils.RedstoneState.OFF) {
            return true;
        }
        boolean powered = this.field_145850_b.func_175687_A(this.field_174879_c) > 0;
        return this.state == ZUtils.RedstoneState.ON && powered || !powered && this.state == ZUtils.RedstoneState.INVERTED;
    }

    private boolean attemptCargoTransfer() {
        TileEntity tile;
        WorldServer world;
        int dimId;
        BlockPos pos;
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        ItemStack tfrStack = ItemStack.field_190927_a;
        IInventory inv2 = null;
        int index = 0;
        block0: for (IInventory inv : this.itemInPorts) {
            for (int i = inv.func_70302_i_() - 1; i >= 0; --i) {
                tfrStack = inv.func_70301_a(i);
                if (!tfrStack.func_190926_b() && inv.func_70301_a(i).func_190916_E() >= this.minStackTransferSize) {
                    inv2 = inv;
                    index = i;
                    break block0;
                }
                tfrStack = ItemStack.field_190927_a;
            }
        }
        if (!tfrStack.func_190926_b() && (pos = this.getDestPosition()) != null && (dimId = this.getDestDimId()) != -2147483647 && (world = net.minecraftforge.common.DimensionManager.getWorld((int)dimId)) != null && (tile = world.func_175625_s(pos)) instanceof TileRailgun && ((TileRailgun)tile).canReceiveCargo(tfrStack) && (PlanetaryTravelHelper.isTravelAnywhereInPlanetarySystem(this.field_145850_b.field_73011_w.getDimension(), DimensionManager.getEffectiveDimId((World)world, pos).getId()) || DimensionManager.getEffectiveDimId((World)world, pos).getId() == DimensionManager.getEffectiveDimId(this.field_145850_b, this.field_174879_c).getId())) {
            ((TileRailgun)tile).onReceiveCargo(tfrStack);
            inv2.func_70299_a(index, ItemStack.field_190927_a);
            inv2.func_70296_d();
            world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 2);
            EnumFacing dir = RotatableBlock.getFront((IBlockState)world.func_180495_p(pos));
            EntityItemAbducted ent = new EntityItemAbducted(this.field_145850_b, (float)(this.field_174879_c.func_177958_n() - 2 * dir.func_82601_c()) + 0.5f, this.field_174879_c.func_177956_o() + 5, (float)(this.field_174879_c.func_177952_p() - 2 * dir.func_82599_e()) + 0.5f, tfrStack);
            this.field_145850_b.func_72838_d((Entity)ent);
            PacketHandler.sendToNearby((BasePacket)new PacketMachine((INetworkMachine)this, 3), (int)this.field_145850_b.field_73011_w.getDimension(), (int)(this.field_174879_c.func_177958_n() - dir.func_82601_c()), (int)(this.field_174879_c.func_177956_o() + 5), (int)(this.field_174879_c.func_177952_p() - dir.func_82599_e()), (double)64.0);
            return true;
        }
        return false;
    }

    public boolean canReceiveCargo(@Nonnull ItemStack stack) {
        for (IInventory inv : this.itemOutPorts) {
            if (ZUtils.numEmptySlots((IInventory)inv) <= 0) continue;
            return true;
        }
        return false;
    }

    public void onReceiveCargo(@Nonnull ItemStack stack) {
        for (IInventory inv : this.itemOutPorts) {
            if (!ZUtils.doesInvHaveRoom((ItemStack)stack, (IInventory)inv)) continue;
            ZUtils.mergeInventory((ItemStack)stack, (IInventory)inv);
            break;
        }
    }

    public String getMachineName() {
        return AdvancedRocketryBlocks.blockRailgun.func_149732_F();
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 5), (double)this.field_174879_c.func_177956_o(), (double)(this.field_174879_c.func_177952_p() - 5), (double)(this.field_174879_c.func_177958_n() + 5), (double)(this.field_174879_c.func_177956_o() + 10), (double)(this.field_174879_c.func_177952_p() + 5));
    }

    public int func_70302_i_() {
        return 1;
    }

    @Nonnull
    public ItemStack func_70301_a(int i) {
        return this.inv.func_70301_a(i);
    }

    @Nonnull
    public ItemStack func_70298_a(int i, int j) {
        return this.inv.func_70298_a(i, j);
    }

    public void func_70299_a(int i, @Nonnull ItemStack j) {
        this.inv.func_70299_a(i, j);
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(@Nullable EntityPlayer player) {
        return true;
    }

    public boolean func_191420_l() {
        return this.inv.func_191420_l();
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int i, @Nonnull ItemStack stack) {
        return stack.func_190926_b() || stack.func_77973_b() instanceof ItemLinker;
    }

    public boolean onLinkStart(@Nonnull ItemStack item, TileEntity entity, EntityPlayer player, World world) {
        ItemLinker.setMasterCoords((ItemStack)item, (BlockPos)this.func_174877_v());
        ItemLinker.setDimId((ItemStack)item, (int)world.field_73011_w.getDimension());
        if (!world.field_72995_K) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("msg.linker.program", new Object[0]));
        }
        return true;
    }

    public boolean onLinkComplete(@Nonnull ItemStack item, TileEntity entity, EntityPlayer player, World world) {
        return false;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.inv.writeToNBT(nbt);
        nbt.func_74768_a("minTfrSize", this.minStackTransferSize);
        nbt.func_74774_a("redstoneState", (byte)this.state.ordinal());
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inv.readFromNBT(nbt);
        this.minStackTransferSize = nbt.func_74762_e("minTfrSize");
        this.state = ZUtils.RedstoneState.values()[nbt.func_74771_c("redstoneState")];
        this.redstoneControl.setRedstoneState(this.state);
    }

    public void writeDataToNetwork(ByteBuf out, byte id) {
        if (id == 4) {
            out.writeInt(this.minStackTransferSize);
        } else if (id == 5) {
            out.writeByte(this.state.ordinal());
        } else {
            super.writeDataToNetwork(out, id);
        }
    }

    public void readDataFromNetwork(ByteBuf in, byte packetId, NBTTagCompound nbt) {
        if (packetId == 4) {
            nbt.func_74768_a("minTransferSize", in.readInt());
        } else if (packetId == 5) {
            nbt.func_74774_a("state", in.readByte());
        } else {
            super.readDataFromNetwork(in, packetId, nbt);
        }
    }

    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt) {
        if (side.isClient()) {
            if (id == 3) {
                EnumFacing dir = RotatableBlock.getFront((IBlockState)this.field_145850_b.func_180495_p(this.field_174879_c));
                LibVulpes.proxy.playSound(this.field_145850_b, this.field_174879_c, AudioRegistry.railgunFire, SoundCategory.BLOCKS, Minecraft.func_71410_x().field_71474_y.func_186711_a(SoundCategory.BLOCKS), 0.975f + this.field_145850_b.field_73012_v.nextFloat() * 0.05f);
                this.recoil = this.field_145850_b.func_82737_E();
            }
        } else if (id == 4) {
            this.minStackTransferSize = nbt.func_74762_e("minTransferSize");
        } else if (id == 5) {
            this.state = ZUtils.RedstoneState.values()[nbt.func_74771_c("state")];
        } else {
            super.useNetworkData(player, side, id, nbt);
        }
    }

    public void onModuleUpdated(ModuleBase module) {
        if (module == this.textBox) {
            this.minStackTransferSize = this.textBox.getText().isEmpty() ? 1 : MathHelper.func_76125_a((int)Integer.parseInt(this.textBox.getText()), (int)1, (int)64);
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 4));
        }
    }

    protected void writeNetworkData(NBTTagCompound nbt) {
        super.writeNetworkData(nbt);
        nbt.func_74774_a("state", (byte)this.state.ordinal());
        nbt.func_74768_a("minTfrSize", this.minStackTransferSize);
    }

    protected void readNetworkData(NBTTagCompound nbt) {
        super.readNetworkData(nbt);
        this.state = ZUtils.RedstoneState.values()[nbt.func_74771_c("redstoneState")];
        this.redstoneControl.setRedstoneState(this.state);
        this.minStackTransferSize = nbt.func_74762_e("minTfrSize");
    }

    @Nonnull
    public String func_70005_c_() {
        return this.getMachineName();
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Nonnull
    public ItemStack func_70304_b(int index) {
        return this.inv.func_70304_b(index);
    }

    public int func_174887_a_(int id) {
        return this.inv.func_174887_a_(id);
    }

    public void func_174885_b(int id, int value) {
        this.inv.func_174885_b(id, value);
    }

    public int func_174890_g() {
        return this.inv.func_174890_g();
    }

    public void func_174888_l() {
        this.inv.func_174888_l();
    }
}

