/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.satellite;

import io.netty.buffer.ByteBuf;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraftforge.fml.relauncher.Side;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.AdvancedRocketryItems;
import zmaster587.advancedRocketry.api.SatelliteRegistry;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.inventory.modules.ModuleSatellite;
import zmaster587.advancedRocketry.item.ItemBiomeChanger;
import zmaster587.advancedRocketry.item.ItemSatelliteIdentificationChip;
import zmaster587.advancedRocketry.satellite.SatelliteBiomeChanger;
import zmaster587.advancedRocketry.util.BiomeHandler;
import zmaster587.advancedRocketry.util.TerraformingHelper;
import zmaster587.advancedRocketry.world.ChunkManagerPlanet;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.IUniversalEnergy;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.tile.TileInventoriedRFConsumer;
import zmaster587.libVulpes.util.INetworkMachine;

public class TileTerraformingTerminal
extends TileInventoriedRFConsumer
implements INetworkMachine,
IModularInventory,
IButtonInventory {
    private ModuleText moduleText;
    public boolean was_enabled_last_tick = false;
    private ModuleButton buttonstopall;
    private int sat_power_per_tick = 0;
    private float randomblocks_per_tick = 0.0f;

    public TileTerraformingTerminal() {
        super(1, 1);
    }

    @Nonnull
    public int[] func_180463_a(@Nullable EnumFacing side) {
        return new int[0];
    }

    public String getModularInventoryName() {
        return AdvancedRocketryBlocks.blockSatelliteControlCenter.func_149732_F();
    }

    public boolean func_94041_b(int slot, @Nonnull ItemStack stack) {
        return true;
    }

    public boolean canPerformFunction() {
        return true;
    }

    public int getPowerPerOperation() {
        return 0;
    }

    public void performFunction() {
        if (this.field_145850_b.field_72995_K) {
            this.updateInventoryInfo();
        }
    }

    public void writeDataToNetwork(ByteBuf out, byte packetId) {
        if (packetId == 22) {
            out.writeInt(this.sat_power_per_tick);
            out.writeFloat(this.randomblocks_per_tick);
        }
    }

    public void readDataFromNetwork(ByteBuf in, byte packetId, NBTTagCompound nbt) {
        if (packetId == 22) {
            nbt.func_74768_a("powergen", in.readInt());
            nbt.func_74776_a("blockpertick", in.readFloat());
        }
    }

    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt) {
        if (id == 22) {
            this.sat_power_per_tick = nbt.func_74762_e("powergen");
            this.randomblocks_per_tick = nbt.func_74760_g("blockpertick");
            this.updateInventoryInfo();
        }
    }

    public void func_70299_a(int slot, @Nonnull ItemStack stack) {
        super.func_70299_a(slot, stack);
        this.updateInventoryInfo();
    }

    public void func_73660_a() {
        SatelliteBiomeChanger sat;
        Item biomeChanger;
        super.func_73660_a();
        boolean has_redstone = this.field_145850_b.func_175687_A(this.func_174877_v()) != 0;
        int powerrequired = 80;
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                PacketHandler.sendToNearby((BasePacket)new PacketMachine((INetworkMachine)this, 22), (int)this.field_145850_b.field_73011_w.getDimension(), (BlockPos)this.field_174879_c, (double)16.0);
            }
            if (this.hasValidBiomeChanger() && has_redstone) {
                if (!this.was_enabled_last_tick) {
                    this.was_enabled_last_tick = true;
                    biomeChanger = this.func_70301_a(0).func_77973_b();
                    if (biomeChanger instanceof ItemBiomeChanger) {
                        sat = (SatelliteBiomeChanger)ItemSatelliteIdentificationChip.getSatellite(this.func_70301_a(0));
                        this.sat_power_per_tick = sat.getPowerPerTick();
                        this.randomblocks_per_tick = (float)this.sat_power_per_tick / (float)powerrequired;
                    }
                    this.func_70296_d();
                }
            } else if (this.was_enabled_last_tick) {
                this.was_enabled_last_tick = false;
                this.func_70296_d();
            }
        }
        if (!this.field_145850_b.field_72995_K && this.was_enabled_last_tick && ARConfiguration.getCurrentConfig().enableTerraforming && (biomeChanger = this.func_70301_a(0).func_77973_b()) instanceof ItemBiomeChanger) {
            sat = (SatelliteBiomeChanger)ItemSatelliteIdentificationChip.getSatellite(this.func_70301_a(0));
            IUniversalEnergy battery = sat.getBattery();
            for (int i = 0; i < 1000 && battery.getUniversalEnergyStored() > powerrequired; ++i) {
                try {
                    TerraformingHelper t = DimensionProperties.proxylists.gethelper(this.field_145850_b.field_73011_w.getDimension());
                    if (t == null) {
                        DimensionManager.getInstance().getDimensionProperties(this.field_145850_b.field_73011_w.getDimension()).load_terraforming_helper(false);
                        t = DimensionProperties.proxylists.gethelper(this.field_145850_b.field_73011_w.getDimension());
                    }
                    BiomeProvider chunkmgr = t.chunkMgrTerraformed;
                    BlockPos next_block_pos = t.get_next_position_biomechanging(true);
                    if (next_block_pos == null) break;
                    battery.extractEnergy(powerrequired, false);
                    BiomeHandler.terraform_biomes(this.field_145850_b, ((ChunkManagerPlanet)chunkmgr).getBiomeGenAt(next_block_pos.func_177958_n(), next_block_pos.func_177952_p()), next_block_pos, this.field_145850_b.field_73011_w.getDimension());
                    continue;
                }
                catch (NoClassDefFoundError e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void updateInventoryInfo() {
        if (this.moduleText != null) {
            if (this.hasValidBiomeChanger() && this.field_145850_b.func_175687_A(this.func_174877_v()) != 0) {
                BigDecimal bd = new BigDecimal(this.randomblocks_per_tick);
                bd = bd.setScale(2, RoundingMode.HALF_UP);
                this.moduleText.setText("terraforming planet...\n\nPower generation:" + this.sat_power_per_tick + "\nBlocks per tick:" + bd);
            } else if (this.hasValidBiomeChanger()) {
                this.moduleText.setText("provide redstone signal\nto start the process");
            } else {
                this.moduleText.setText("place a biome remote here\nto make the satellite terraform\nthe entire planet");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasValidBiomeChanger() {
        ItemStack biomeChanger = this.func_70301_a(0);
        if (biomeChanger.func_190926_b()) return false;
        if (!(biomeChanger.func_77973_b() instanceof ItemBiomeChanger)) return false;
        if (SatelliteRegistry.getSatellite(biomeChanger) == null) return false;
        ItemSatelliteIdentificationChip cfr_ignored_0 = (ItemSatelliteIdentificationChip)AdvancedRocketryItems.itemBiomeChanger;
        SatelliteBase satellite = ItemSatelliteIdentificationChip.getSatellite(biomeChanger);
        if (satellite.getDimensionId() != this.field_145850_b.field_73011_w.getDimension()) return false;
        if (!(satellite instanceof SatelliteBiomeChanger)) return false;
        return true;
    }

    public List<ModuleBase> getModules(int ID, EntityPlayer player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        ModuleSatellite moduleSatellite = new ModuleSatellite(152, 10, (IInventory)this, 0);
        modules.add((ModuleBase)moduleSatellite);
        this.moduleText = new ModuleText(5, 20, LibVulpes.proxy.getLocalizedString("msg.satctrlcenter.nolink"), 0x404040);
        modules.add((ModuleBase)this.moduleText);
        this.updateInventoryInfo();
        return modules;
    }

    public void onInventoryButtonPressed(int buttonId) {
        PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, (byte)buttonId));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
    }

    public boolean canInteractWithContainer(EntityPlayer entity) {
        return true;
    }
}

