/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.block.BlockBipropellantRocketMotor;
import zmaster587.advancedRocketry.block.BlockFuelTank;
import zmaster587.advancedRocketry.block.BlockPressurizedFluidTank;
import zmaster587.advancedRocketry.block.BlockRocketMotor;

public enum WeightEngine {
    INSTANCE("config/advRocketry/weights.json");

    private final String file;
    private Map<String, Double> weights;

    private WeightEngine(String file) {
        this.file = file;
        this.load();
    }

    public float getWeight(ItemStack stack) {
        if (stack.func_190926_b() || stack.func_77973_b().getRegistryName() == null) {
            return 0.0f;
        }
        double weight = this.weights.getOrDefault(stack.func_77973_b().getRegistryName().toString(), -1.0) * (double)stack.func_190916_E();
        if (weight >= 0.0) {
            return (float)weight;
        }
        double tankWeight = 0.2;
        double motorWeight = 2.0;
        double guidanceComputerWeight = 1.8;
        double pressureTankWeight = 5.0;
        double satelliteHatchWeight = 5.0;
        if (stack.func_77973_b() instanceof ItemBlock) {
            Block block = ((ItemBlock)stack.func_77973_b()).func_179223_d();
            if (block instanceof BlockFuelTank) {
                this.weights.put(stack.func_77973_b().getRegistryName().toString(), tankWeight);
                return (float)tankWeight;
            }
            if (block instanceof BlockRocketMotor || block instanceof BlockBipropellantRocketMotor) {
                this.weights.put(stack.func_77973_b().getRegistryName().toString(), motorWeight);
                return (float)motorWeight;
            }
            if (block instanceof BlockPressurizedFluidTank) {
                this.weights.put(stack.func_77973_b().getRegistryName().toString(), pressureTankWeight);
                return (float)pressureTankWeight;
            }
            if (stack.func_77973_b().getRegistryName().toString().equals("advancedrocketry:guidancecomputer")) {
                this.weights.put(stack.func_77973_b().getRegistryName().toString(), guidanceComputerWeight);
                return (float)guidanceComputerWeight;
            }
            if (stack.func_77973_b().getRegistryName().toString().equals("advancedrocketry:loader")) {
                this.weights.put(stack.func_77973_b().getRegistryName().toString(), satelliteHatchWeight);
                return (float)satelliteHatchWeight;
            }
        }
        this.weights.put(stack.func_77973_b().getRegistryName().toString(), 0.1);
        return 0.1f;
    }

    public float getWeight(Collection<ItemStack> stacks) {
        return stacks.stream().map(this::getWeight).reduce(Float.valueOf(0.0f), Float::sum).floatValue();
    }

    public float getWeight(World world, BlockPos pos) {
        return this.getWeight(world.func_175625_s(pos), world.func_180495_p(pos).func_177230_c());
    }

    public float getWeight(FluidStack stack) {
        return this.getWeight(stack.getFluid(), stack.amount);
    }

    public float getWeight(Fluid fluid, float amount) {
        double weight = this.weights.getOrDefault(fluid.getUnlocalizedName(), -1.0) * (double)amount;
        if (weight >= 0.0) {
            return (float)weight;
        }
        weight = 0.001 * (double)amount;
        this.weights.put(fluid.getUnlocalizedName(), 0.001);
        return (float)weight;
    }

    public float getTEWeight(TileEntity te) {
        IFluidHandler fluidHandler;
        if (!ARConfiguration.getCurrentConfig().advancedWeightSystemInventories) {
            return 0.0f;
        }
        float weight = 0.0f;
        if (te == null) {
            return weight;
        }
        IItemHandler capability = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (capability != null) {
            for (int i = 0; i < capability.getSlots(); ++i) {
                weight += this.getWeight(capability.getStackInSlot(i));
            }
        }
        if ((fluidHandler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) != null) {
            for (IFluidTankProperties info : fluidHandler.getTankProperties()) {
                if (info == null || info.getContents() == null) continue;
                weight += this.getWeight(info.getContents());
            }
        }
        return weight;
    }

    public float getWeight(TileEntity te, Block blk) {
        if (blk == null) {
            blk = te.func_145838_q();
        }
        float weight = this.getWeight(new ItemStack(blk));
        return weight + this.getTEWeight(te);
    }

    public float getWeight(World world, Collection<BlockPos> poses) {
        return poses.stream().map(pos -> Float.valueOf(this.getWeight(world, (BlockPos)pos))).reduce(Float.valueOf(0.0f), Float::sum).floatValue();
    }

    public void load() {
        File f = new File(this.file);
        if (!f.exists()) {
            this.weights = new HashMap<String, Double>();
            return;
        }
        try (FileReader r = new FileReader(this.file);){
            Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
            JsonObject root = (JsonObject)GSON.fromJson((Reader)r, JsonObject.class);
            this.weights = (Map)GSON.fromJson((JsonElement)root.getAsJsonObject("individual"), HashMap.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void save() {
        try (FileWriter w = new FileWriter(this.file);){
            Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
            JsonObject json = new JsonObject();
            json.add("individual", GSON.toJsonTree(this.weights));
            w.write(GSON.toJson((JsonElement)json));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

