/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.util;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.minecraft.block.Block;
import net.minecraft.util.math.MathHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.util.OreGenProperties;
import zmaster587.libVulpes.util.HashedBlockPosition;
import zmaster587.libVulpes.util.SingleEntry;

public class XMLOreLoader {
    private Document doc = null;

    public static OreGenProperties loadOre(Node rootNode) {
        OreGenProperties oreGen = new OreGenProperties();
        Node childNode = rootNode.getFirstChild();
        while (childNode != null) {
            if (childNode.getNodeType() != 1 || !childNode.getNodeName().equals("ore")) {
                childNode = childNode.getNextSibling();
                continue;
            }
            if (childNode.hasAttributes()) {
                int chancePerChunk;
                int clumpSize;
                int maxHeight;
                int minHeight;
                String block;
                int meta;
                block23: {
                    Node node;
                    NamedNodeMap att;
                    block22: {
                        block21: {
                            block20: {
                                meta = 0;
                                att = childNode.getAttributes();
                                node = att.getNamedItem("block");
                                if (node == null) {
                                    AdvancedRocketry.logger.warn("Missing \"block\" attribute from ore node");
                                    childNode = childNode.getNextSibling();
                                    continue;
                                }
                                block = node.getTextContent();
                                node = att.getNamedItem("meta");
                                if (node != null) {
                                    try {
                                        meta = Integer.parseInt(node.getTextContent());
                                    }
                                    catch (NumberFormatException e) {
                                        AdvancedRocketry.logger.warn("Invalid \"meta\" attribute from ore node");
                                        childNode = childNode.getNextSibling();
                                        continue;
                                    }
                                }
                                if ((node = att.getNamedItem("minHeight")) != null) {
                                    try {
                                        minHeight = Math.max(Integer.parseInt(node.getTextContent()), 1);
                                        break block20;
                                    }
                                    catch (NumberFormatException e) {
                                        AdvancedRocketry.logger.warn("Invalid \"minHeight\" attribute from ore node");
                                        childNode = childNode.getNextSibling();
                                        continue;
                                    }
                                }
                                AdvancedRocketry.logger.warn("Missing \"minHeight\" attribute from ore node");
                                childNode = childNode.getNextSibling();
                                continue;
                            }
                            node = att.getNamedItem("maxHeight");
                            if (node != null) {
                                try {
                                    maxHeight = MathHelper.func_76125_a((int)Integer.parseInt(node.getTextContent()), (int)minHeight, (int)255);
                                    break block21;
                                }
                                catch (NumberFormatException e) {
                                    AdvancedRocketry.logger.warn("Invalid \"maxHeight\" attribute from ore node");
                                    childNode = childNode.getNextSibling();
                                    continue;
                                }
                            }
                            AdvancedRocketry.logger.warn("Missing \"maxHeight\" attribute from ore node");
                            childNode = childNode.getNextSibling();
                            continue;
                        }
                        node = att.getNamedItem("clumpSize");
                        if (node != null) {
                            try {
                                clumpSize = MathHelper.func_76125_a((int)Integer.parseInt(node.getTextContent()), (int)1, (int)255);
                                break block22;
                            }
                            catch (NumberFormatException e) {
                                AdvancedRocketry.logger.warn("Invalid \"clumpSize\" attribute from ore node");
                                childNode = childNode.getNextSibling();
                                continue;
                            }
                        }
                        AdvancedRocketry.logger.warn("Missing \"clumpSize\" attribute from ore node");
                        childNode = childNode.getNextSibling();
                        continue;
                    }
                    node = att.getNamedItem("chancePerChunk");
                    if (node != null) {
                        try {
                            chancePerChunk = MathHelper.func_76125_a((int)Integer.parseInt(node.getTextContent()), (int)1, (int)255);
                            break block23;
                        }
                        catch (NumberFormatException e) {
                            AdvancedRocketry.logger.warn("Invalid \"chancePerChunk\" attribute from ore node");
                            childNode = childNode.getNextSibling();
                            continue;
                        }
                    }
                    AdvancedRocketry.logger.warn("Missing \"chancePerChunk\" attribute from ore node");
                    childNode = childNode.getNextSibling();
                    continue;
                }
                Block block2 = Block.func_149684_b((String)block);
                if (block2 == null) {
                    AdvancedRocketry.logger.warn(block + " is not a valid name for ore");
                    childNode = childNode.getNextSibling();
                    continue;
                }
                oreGen.addEntry(block2.func_176203_a(meta), minHeight, maxHeight, clumpSize, chancePerChunk);
            }
            childNode = childNode.getNextSibling();
        }
        return oreGen.getOreEntries().isEmpty() ? null : oreGen;
    }

    public static String writeXML(OreGenProperties gen, int numTabs) {
        StringBuilder tabLen = new StringBuilder();
        for (int i = 0; i < numTabs; ++i) {
            tabLen.append("\t");
        }
        String outputString = tabLen + "<oreGen ";
        return outputString;
    }

    private static Node createTextNode(Document doc, String nodeName, double nodeText) {
        return XMLOreLoader.createTextNode(doc, nodeName, Double.toString(nodeText));
    }

    private static Node createTextNode(Document doc, String nodeName, boolean nodeText) {
        return XMLOreLoader.createTextNode(doc, nodeName, Boolean.toString(nodeText));
    }

    private static Node createTextNode(Document doc, String nodeName, int nodeText) {
        return XMLOreLoader.createTextNode(doc, nodeName, Integer.toString(nodeText));
    }

    private static Node createTextNode(Document doc, String nodeName, String nodeText) {
        Element element = doc.createElement(nodeName);
        element.appendChild(doc.createTextNode(nodeText));
        return element;
    }

    public static Node writeOreEntryXML(Document doc, OreGenProperties gen) {
        Element oreGen = doc.createElement("oreGen");
        for (OreGenProperties.OreEntry ore : gen.getOreEntries()) {
            int meta = ore.getBlockState().func_177230_c().func_176201_c(ore.getBlockState());
            Element oreElement = doc.createElement("ore");
            oreElement.appendChild(XMLOreLoader.createTextNode(doc, "block", ore.getBlockState().func_177230_c().getRegistryName().toString()));
            oreElement.appendChild(XMLOreLoader.createTextNode(doc, "minHeight", ore.getMinHeight()));
            oreElement.appendChild(XMLOreLoader.createTextNode(doc, "maxHeight", ore.getMaxHeight()));
            oreElement.appendChild(XMLOreLoader.createTextNode(doc, "clumpSize", ore.getClumpSize()));
            oreElement.appendChild(XMLOreLoader.createTextNode(doc, "chancePerChunk", ore.getClumpSize()));
            if (meta == 0) continue;
            oreElement.appendChild(XMLOreLoader.createTextNode(doc, "meta", meta));
        }
        return oreGen;
    }

    public static String writeOreEntryXML(OreGenProperties gen, int numTabs) {
        StringBuilder outputString = new StringBuilder();
        StringBuilder tabLen = new StringBuilder();
        for (int i = 0; i < numTabs; ++i) {
            tabLen.append("\t");
        }
        for (OreGenProperties.OreEntry ore : gen.getOreEntries()) {
            int meta = ore.getBlockState().func_177230_c().func_176201_c(ore.getBlockState());
            outputString.append((CharSequence)tabLen).append("<ore block=\"").append(ore.getBlockState().func_177230_c().getRegistryName()).append(meta == 0 ? "" : "\" meta=\"" + meta).append("\" minHeight=\"").append(ore.getMinHeight()).append("\" maxHeight=\"").append(ore.getMaxHeight()).append("\" clumpSize=\"").append(ore.getClumpSize()).append("\"").append(" chancePerChunk=\"").append(ore.getChancePerChunk()).append("\" />\n");
        }
        return outputString.toString();
    }

    public boolean loadFile(File xmlFile) throws IOException {
        DocumentBuilder docBuilder;
        this.doc = null;
        try {
            docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            return false;
        }
        try {
            this.doc = docBuilder.parse(xmlFile);
        }
        catch (SAXException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public List<SingleEntry<HashedBlockPosition, OreGenProperties>> loadPropertyFile() {
        Node childNode;
        for (childNode = this.doc.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
            if (childNode.getNodeName().equalsIgnoreCase("oreconfig")) continue;
            childNode = childNode.getFirstChild();
            break;
        }
        LinkedList<SingleEntry<HashedBlockPosition, OreGenProperties>> mapping = new LinkedList<SingleEntry<HashedBlockPosition, OreGenProperties>>();
        while (childNode != null) {
            if (childNode.getNodeType() != 1 || !childNode.getNodeName().equals("oreGen")) {
                childNode = childNode.getNextSibling();
                continue;
            }
            if (!childNode.hasAttributes()) continue;
            int pressure = -1;
            int temp = -1;
            NamedNodeMap att = childNode.getAttributes();
            Node node = att.getNamedItem("pressure");
            if (node != null) {
                try {
                    pressure = MathHelper.func_76125_a((int)Integer.parseInt(node.getTextContent()), (int)0, (int)DimensionProperties.AtmosphereTypes.values().length);
                }
                catch (NumberFormatException e) {
                    AdvancedRocketry.logger.warn("Invalid format for pressure: \"" + node.getTextContent() + "\" Only numbers are allowed(" + this.doc.getDocumentURI() + ")");
                    childNode = childNode.getNextSibling();
                    continue;
                }
            }
            if ((node = att.getNamedItem("temp")) != null) {
                try {
                    temp = MathHelper.func_76125_a((int)Integer.parseInt(node.getTextContent()), (int)0, (int)DimensionProperties.Temps.values().length);
                }
                catch (NumberFormatException e) {
                    AdvancedRocketry.logger.warn("Invalid format for temp: \"" + node.getTextContent() + "\" Only numbers are allowed(" + this.doc.getDocumentURI() + ")");
                    childNode = childNode.getNextSibling();
                    continue;
                }
            }
            if (pressure == -1 && temp == -1) {
                AdvancedRocketry.logger.warn("Invalid format for temp: \"" + node.getTextContent() + "\" Only numbers are allowed(" + this.doc.getDocumentURI() + ")");
                childNode = childNode.getNextSibling();
                continue;
            }
            OreGenProperties properties = XMLOreLoader.loadOre(childNode);
            if (properties == null) {
                childNode = childNode.getNextSibling();
                continue;
            }
            if (temp != pressure) {
                if (pressure == -1) {
                    mapping.add((SingleEntry<HashedBlockPosition, OreGenProperties>)new SingleEntry((Object)new HashedBlockPosition(-1, temp, 0), (Object)properties));
                } else if (temp == -1) {
                    mapping.add((SingleEntry<HashedBlockPosition, OreGenProperties>)new SingleEntry((Object)new HashedBlockPosition(pressure, -1, 0), (Object)properties));
                }
            } else {
                mapping.add((SingleEntry<HashedBlockPosition, OreGenProperties>)new SingleEntry((Object)new HashedBlockPosition(pressure, temp, 0), (Object)properties));
            }
            childNode = childNode.getNextSibling();
        }
        return mapping;
    }
}

